/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.ui.updatecard;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.lifecycle.viewmodel.InitializerViewModelFactoryBuilder;
import com.stripe.android.CardBrandFilter;
import com.stripe.android.DefaultCardBrandFilter;
import com.stripe.android.core.Logger;
import com.stripe.android.link.account.LinkAccountManager;
import com.stripe.android.link.injection.NativeLinkComponent;
import com.stripe.android.link.model.LinkAccount;
import com.stripe.android.link.ui.updatecard.UpdateCardScreenState;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.ConsumerPaymentDetails;
import com.stripe.android.paymentsheet.CardUpdateParams;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.ui.DefaultEditCardDetailsInteractor;
import com.stripe.android.paymentsheet.ui.EditCardDetailsInteractor;
import com.stripe.android.paymentsheet.ui.EditCardPayload;
import com.stripe.android.uicore.navigation.NavigationManager;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 %2\u00020\u0001:\u0001%B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lcom/stripe/android/link/ui/updatecard/UpdateCardScreenViewModel;", "Landroidx/lifecycle/ViewModel;", "logger", "Lcom/stripe/android/core/Logger;", "linkAccountManager", "Lcom/stripe/android/link/account/LinkAccountManager;", "navigationManager", "Lcom/stripe/android/uicore/navigation/NavigationManager;", "paymentDetailsId", "", "<init>", "(Lcom/stripe/android/core/Logger;Lcom/stripe/android/link/account/LinkAccountManager;Lcom/stripe/android/uicore/navigation/NavigationManager;Ljava/lang/String;)V", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/android/link/ui/updatecard/UpdateCardScreenState;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "interactor", "Lcom/stripe/android/paymentsheet/ui/EditCardDetailsInteractor;", "getInteractor", "()Lcom/stripe/android/paymentsheet/ui/EditCardDetailsInteractor;", "setInteractor", "(Lcom/stripe/android/paymentsheet/ui/EditCardDetailsInteractor;)V", "onUpdateClicked", "", "onCancelClicked", "initializeInteractor", "cardPaymentDetails", "Lcom/stripe/android/model/ConsumerPaymentDetails$Card;", "onCardUpdateParamsChanged", "cardUpdateParams", "Lcom/stripe/android/paymentsheet/CardUpdateParams;", "onBrandChoiceChanged", "cardBrand", "Lcom/stripe/android/model/CardBrand;", "Companion", "paymentsheet_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nUpdateCardScreenViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateCardScreenViewModel.kt\ncom/stripe/android/link/ui/updatecard/UpdateCardScreenViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,111:1\n295#2,2:112\n230#3,5:114\n230#3,5:119\n230#3,5:124\n*S KotlinDebug\n*F\n+ 1 UpdateCardScreenViewModel.kt\ncom/stripe/android/link/ui/updatecard/UpdateCardScreenViewModel\n*L\n42#1:112,2\n47#1:114,5\n86#1:119,5\n90#1:124,5\n*E\n"})
public final class UpdateCardScreenViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final LinkAccountManager linkAccountManager;
    @NotNull
    private final NavigationManager navigationManager;
    @NotNull
    private final MutableStateFlow<UpdateCardScreenState> _state;
    @NotNull
    private final StateFlow<UpdateCardScreenState> state;
    @Nullable
    private EditCardDetailsInteractor interactor;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    @Inject
    public UpdateCardScreenViewModel(@NotNull Logger logger, @NotNull LinkAccountManager linkAccountManager, @NotNull NavigationManager navigationManager, @NotNull String paymentDetailsId) {
        block8: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)linkAccountManager, (String)"linkAccountManager");
            Intrinsics.checkNotNullParameter((Object)navigationManager, (String)"navigationManager");
            Intrinsics.checkNotNullParameter((Object)paymentDetailsId, (String)"paymentDetailsId");
            this.logger = logger;
            this.linkAccountManager = linkAccountManager;
            this.navigationManager = navigationManager;
            this._state = StateFlowKt.MutableStateFlow((Object)new UpdateCardScreenState(paymentDetailsId, false, null, null, 14, null));
            this.state = FlowKt.asStateFlow(this._state);
            Object object2 = this;
            try {
                UpdateCardScreenState it;
                UpdateCardScreenState nextValue$iv;
                Object prevValue$iv;
                ConsumerPaymentDetails.PaymentDetails paymentDetails;
                ConsumerPaymentDetails.PaymentDetails paymentDetails2;
                List list;
                UpdateCardScreenViewModel $this$_init__u24lambda_u243 = object2;
                boolean bl = false;
                ConsumerPaymentDetails consumerPaymentDetails = (ConsumerPaymentDetails)$this$_init__u24lambda_u243.linkAccountManager.getConsumerPaymentDetails().getValue();
                if (consumerPaymentDetails != null && (list = consumerPaymentDetails.getPaymentDetails()) != null) {
                    Object v0;
                    block7: {
                        void $this$firstOrNull$iv;
                        Iterable iterable = list;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            ConsumerPaymentDetails.PaymentDetails it2 = (ConsumerPaymentDetails.PaymentDetails)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it2.getId(), (Object)paymentDetailsId)) continue;
                            v0 = element$iv;
                            break block7;
                        }
                        v0 = null;
                    }
                    paymentDetails2 = v0;
                } else {
                    paymentDetails2 = paymentDetails = null;
                }
                if (!(paymentDetails instanceof ConsumerPaymentDetails.Card)) {
                    boolean $i$a$-require-UpdateCardScreenViewModel$1$22 = false;
                    String $i$a$-require-UpdateCardScreenViewModel$1$22 = "Payment details with id " + paymentDetailsId + " is not a card";
                    throw new IllegalArgumentException($i$a$-require-UpdateCardScreenViewModel$1$22.toString());
                }
                MutableStateFlow<UpdateCardScreenState> $this$update$iv = $this$_init__u24lambda_u243._state;
                boolean $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    it = (UpdateCardScreenState)prevValue$iv;
                    boolean bl3 = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = UpdateCardScreenState.copy$default(it, paymentDetailsId, ((ConsumerPaymentDetails.Card)paymentDetails).isDefault(), null, null, 12, null))));
                $this$_init__u24lambda_u243.interactor = $this$_init__u24lambda_u243.initializeInteractor((ConsumerPaymentDetails.Card)paymentDetails);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block8;
            Object it = object = throwable;
            boolean bl = false;
            this.logger.error("Failed to render payment update screen", (Throwable)it);
            this.navigationManager.tryNavigateBack();
        }
    }

    @NotNull
    public final StateFlow<UpdateCardScreenState> getState() {
        return this.state;
    }

    @Nullable
    public final EditCardDetailsInteractor getInteractor() {
        return this.interactor;
    }

    public final void setInteractor(@Nullable EditCardDetailsInteractor editCardDetailsInteractor) {
        this.interactor = editCardDetailsInteractor;
    }

    public final void onUpdateClicked() {
        this.logger.info("Update button clicked");
    }

    public final void onCancelClicked() {
        this.logger.info("Cancel button clicked");
    }

    private final EditCardDetailsInteractor initializeInteractor(ConsumerPaymentDetails.Card cardPaymentDetails) {
        DefaultEditCardDetailsInteractor.Factory factory = new DefaultEditCardDetailsInteractor.Factory();
        CoroutineScope coroutineScope = ViewModelKt.getViewModelScope((ViewModel)this);
        DefaultCardBrandFilter defaultCardBrandFilter = DefaultCardBrandFilter.INSTANCE;
        LinkAccount linkAccount = (LinkAccount)this.linkAccountManager.getLinkAccount().getValue();
        EditCardPayload editCardPayload = EditCardPayload.Companion.create(cardPaymentDetails, linkAccount != null ? linkAccount.getUnredactedPhoneNumber() : null);
        PaymentSheet.BillingDetailsCollectionConfiguration.AddressCollectionMode addressCollectionMode = PaymentSheet.BillingDetailsCollectionConfiguration.AddressCollectionMode.Automatic;
        KFunction kFunction = (KFunction)new Function1<CardUpdateParams, Unit>((Object)this){

            public final void invoke(CardUpdateParams p0) {
                UpdateCardScreenViewModel.access$onCardUpdateParamsChanged((UpdateCardScreenViewModel)((Object)this.receiver), p0);
            }
        };
        boolean bl = cardPaymentDetails.getAvailableNetworks().size() > 1;
        KFunction kFunction2 = (KFunction)new Function1<CardBrand, Unit>((Object)this){

            public final void invoke(CardBrand p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                UpdateCardScreenViewModel.access$onBrandChoiceChanged((UpdateCardScreenViewModel)((Object)this.receiver), p0);
            }
        };
        return factory.create(coroutineScope, bl, true, (CardBrandFilter)defaultCardBrandFilter, editCardPayload, addressCollectionMode, (Function1<? super CardBrand, Unit>)((Function1)kFunction2), (Function1<? super CardUpdateParams, Unit>)((Function1)kFunction));
    }

    private final void onCardUpdateParamsChanged(CardUpdateParams cardUpdateParams) {
        UpdateCardScreenState it;
        UpdateCardScreenState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<UpdateCardScreenState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (UpdateCardScreenState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = UpdateCardScreenState.copy$default(it, null, false, cardUpdateParams, null, 11, null))));
    }

    private final void onBrandChoiceChanged(CardBrand cardBrand) {
        UpdateCardScreenState it;
        UpdateCardScreenState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<UpdateCardScreenState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (UpdateCardScreenState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = UpdateCardScreenState.copy$default(it, null, false, null, cardBrand, 7, null))));
    }

    public static final /* synthetic */ void access$onCardUpdateParamsChanged(UpdateCardScreenViewModel $this, CardUpdateParams cardUpdateParams) {
        $this.onCardUpdateParamsChanged(cardUpdateParams);
    }

    public static final /* synthetic */ void access$onBrandChoiceChanged(UpdateCardScreenViewModel $this, CardBrand cardBrand) {
        $this.onBrandChoiceChanged(cardBrand);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/link/ui/updatecard/UpdateCardScreenViewModel$Companion;", "", "<init>", "()V", "factory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "parentComponent", "Lcom/stripe/android/link/injection/NativeLinkComponent;", "paymentDetailsId", "", "paymentsheet_release"})
    @SourceDebugExtension(value={"SMAP\nUpdateCardScreenViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateCardScreenViewModel.kt\ncom/stripe/android/link/ui/updatecard/UpdateCardScreenViewModel$Companion\n+ 2 InitializerViewModelFactory.kt\nandroidx/lifecycle/viewmodel/InitializerViewModelFactoryKt\n*L\n1#1,111:1\n35#2:112\n77#2,2:113\n*S KotlinDebug\n*F\n+ 1 UpdateCardScreenViewModel.kt\ncom/stripe/android/link/ui/updatecard/UpdateCardScreenViewModel$Companion\n*L\n98#1:112\n99#1:113,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ViewModelProvider.Factory factory(@NotNull NativeLinkComponent parentComponent, @NotNull String paymentDetailsId) {
            void $this$initializer$iv;
            InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder;
            Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
            Intrinsics.checkNotNullParameter((Object)paymentDetailsId, (String)"paymentDetailsId");
            boolean $i$f$viewModelFactory = false;
            InitializerViewModelFactoryBuilder $this$factory_u24lambda_u241 = initializerViewModelFactoryBuilder = new InitializerViewModelFactoryBuilder();
            boolean bl = false;
            InitializerViewModelFactoryBuilder initializerViewModelFactoryBuilder2 = $this$factory_u24lambda_u241;
            Function1 initializer$iv = arg_0 -> Companion.factory$lambda$1$lambda$0(parentComponent, paymentDetailsId, arg_0);
            boolean $i$f$initializer = false;
            $this$initializer$iv.addInitializer(Reflection.getOrCreateKotlinClass(UpdateCardScreenViewModel.class), initializer$iv);
            return initializerViewModelFactoryBuilder.build();
        }

        private static final UpdateCardScreenViewModel factory$lambda$1$lambda$0(NativeLinkComponent $parentComponent, String $paymentDetailsId, CreationExtras $this$initializer) {
            Intrinsics.checkNotNullParameter((Object)$this$initializer, (String)"$this$initializer");
            return new UpdateCardScreenViewModel($parentComponent.getLogger(), $parentComponent.getLinkAccountManager(), $parentComponent.getNavigationManager(), $paymentDetailsId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

