/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.lpmfoundations.paymentmethod;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.CardBrandFilter;
import com.stripe.android.common.configuration.ConfigurationDefaults;
import com.stripe.android.common.model.CommonConfiguration;
import com.stripe.android.customersheet.CustomerSheet;
import com.stripe.android.link.LinkConfiguration;
import com.stripe.android.lpmfoundations.FormHeaderInformation;
import com.stripe.android.lpmfoundations.luxe.SupportedPaymentMethod;
import com.stripe.android.lpmfoundations.paymentmethod.CustomerMetadata;
import com.stripe.android.lpmfoundations.paymentmethod.DisplayableCustomPaymentMethod;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodDefinition;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodDefinitionKt;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadataKtxKt;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodRegistry;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodSaveConsentBehavior;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentSheetCardBrandFilter;
import com.stripe.android.lpmfoundations.paymentmethod.UiDefinitionFactory;
import com.stripe.android.lpmfoundations.paymentmethod.definitions.CustomPaymentMethodUiDefinitionFactory;
import com.stripe.android.lpmfoundations.paymentmethod.definitions.ExternalPaymentMethodUiDefinitionFactory;
import com.stripe.android.lpmfoundations.paymentmethod.definitions.LinkCardBrandDefinition;
import com.stripe.android.lpmfoundations.paymentmethod.link.LinkInlineConfiguration;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.ElementsSession;
import com.stripe.android.model.LinkConsumerIncentive;
import com.stripe.android.model.LinkMode;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.payments.financialconnections.FinancialConnectionsAvailability;
import com.stripe.android.payments.financialconnections.GetFinancialConnectionsAvailability;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.addresselement.AddressDetails;
import com.stripe.android.paymentsheet.model.PaymentMethodIncentive;
import com.stripe.android.paymentsheet.model.PaymentMethodIncentiveKt;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.state.LinkState;
import com.stripe.android.ui.core.Amount;
import com.stripe.android.ui.core.cbc.CardBrandChoiceEligibility;
import com.stripe.android.ui.core.elements.ExternalPaymentMethodSpec;
import com.stripe.android.ui.core.elements.SharedDataSpec;
import com.stripe.android.uicore.elements.FormElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b/\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0081\b\u0018\u0000 \u009d\u00012\u00020\u0001:\u0002\u009d\u0001B\u00e7\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\n\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\n\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u0007\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\b\u0010\"\u001a\u0004\u0018\u00010#\u0012\b\u0010$\u001a\u0004\u0018\u00010%\u0012\b\u0010&\u001a\u0004\u0018\u00010'\u0012\b\u0010(\u001a\u0004\u0018\u00010)\u0012\u0006\u0010*\u001a\u00020+\u0012\u0006\u0010,\u001a\u00020\u000b\u00a2\u0006\u0004\b-\u0010.J\u0006\u0010V\u001a\u00020\u0007J\u000e\u0010W\u001a\u00020\u00072\u0006\u0010X\u001a\u00020\u000bJ\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020[0\nJ\u0010\u0010\\\u001a\u0004\u0018\u00010]2\u0006\u0010^\u001a\u00020\u000bJ\f\u0010_\u001a\b\u0012\u0004\u0012\u00020]0\nJ\u000e\u0010`\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u001e\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020c0b*\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010d\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010f\u001a\u00020\u00072\u0006\u0010^\u001a\u00020\u000bJ\u000e\u0010g\u001a\u00020\u00072\u0006\u0010^\u001a\u00020\u000bJ\u0012\u0010h\u001a\u0004\u0018\u00010i2\u0006\u0010^\u001a\u00020\u000bH\u0002J\u0012\u0010j\u001a\u0004\u0018\u00010i2\u0006\u0010^\u001a\u00020\u000bH\u0002J\u000e\u0010k\u001a\b\u0012\u0004\u0012\u00020l0\nH\u0002J\b\u0010m\u001a\u0004\u0018\u00010nJ\u0018\u0010o\u001a\u0004\u0018\u00010p2\u0006\u0010^\u001a\u00020\u000b2\u0006\u0010q\u001a\u00020\u0007J\u001e\u0010r\u001a\n\u0012\u0004\u0012\u00020s\u0018\u00010\n2\u0006\u0010^\u001a\u00020\u000b2\u0006\u0010t\u001a\u00020uJ\u000e\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020yJ\t\u0010z\u001a\u00020\u0003H\u00c6\u0003J\t\u0010{\u001a\u00020\u0005H\u00c6\u0003J\t\u0010|\u001a\u00020\u0007H\u00c6\u0003J\t\u0010}\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010~\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\t\u0010\u007f\u001a\u00020\rH\u00c6\u0003J\n\u0010\u0080\u0001\u001a\u00020\u000bH\u00c6\u0003J\f\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\f\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\u0010\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020\u00140\nH\u00c6\u0003J\u0010\u0010\u0084\u0001\u001a\b\u0012\u0004\u0012\u00020\u00160\nH\u00c6\u0003J\u0010\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u00020\u00180\nH\u00c6\u0003J\f\u0010\u0086\u0001\u001a\u0004\u0018\u00010\u001aH\u00c6\u0003J\n\u0010\u0087\u0001\u001a\u00020\u0007H\u00c6\u0003J\n\u0010\u0088\u0001\u001a\u00020\u001dH\u00c6\u0003J\f\u0010\u0089\u0001\u001a\u0004\u0018\u00010\u001fH\u00c6\u0003J\n\u0010\u008a\u0001\u001a\u00020!H\u00c6\u0003J\f\u0010\u008b\u0001\u001a\u0004\u0018\u00010#H\u00c6\u0003J\f\u0010\u008c\u0001\u001a\u0004\u0018\u00010%H\u00c6\u0003J\f\u0010\u008d\u0001\u001a\u0004\u0018\u00010'H\u00c6\u0003J\f\u0010\u008e\u0001\u001a\u0004\u0018\u00010)H\u00c6\u0003J\n\u0010\u008f\u0001\u001a\u00020+H\u00c6\u0003J\n\u0010\u0090\u0001\u001a\u00020\u000bH\u00c6\u0003J\u0098\u0002\u0010\u0091\u0001\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\n2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\n2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u00072\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)2\b\b\u0002\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020\u000bH\u00c6\u0001J\u0007\u0010\u0092\u0001\u001a\u00020cJ\u0016\u0010\u0093\u0001\u001a\u00020\u00072\n\u0010\u0094\u0001\u001a\u0005\u0018\u00010\u0095\u0001H\u00d6\u0003J\n\u0010\u0096\u0001\u001a\u00020cH\u00d6\u0001J\n\u0010\u0097\u0001\u001a\u00020\u000bH\u00d6\u0001J\u001b\u0010\u0098\u0001\u001a\u00030\u0099\u00012\b\u0010\u009a\u0001\u001a\u00030\u009b\u00012\u0007\u0010\u009c\u0001\u001a\u00020cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00104R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u00107R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\n\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u00107R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\n\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u00107R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u0011\u0010\u001b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u00104R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u0013\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u0013\u0010$\u001a\u0004\u0018\u00010%\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010NR\u0013\u0010&\u001a\u0004\u0018\u00010'\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u0013\u0010(\u001a\u0004\u0018\u00010)\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010RR\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010TR\u0011\u0010,\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010;\u00a8\u0006\u009e\u0001"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "Landroid/os/Parcelable;", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "billingDetailsCollectionConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "allowsDelayedPaymentMethods", "", "allowsPaymentMethodsRequiringShippingAddress", "paymentMethodOrder", "", "", "cbcEligibility", "Lcom/stripe/android/ui/core/cbc/CardBrandChoiceEligibility;", "merchantName", "defaultBillingDetails", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "shippingDetails", "Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;", "sharedDataSpecs", "Lcom/stripe/android/ui/core/elements/SharedDataSpec;", "displayableCustomPaymentMethods", "Lcom/stripe/android/lpmfoundations/paymentmethod/DisplayableCustomPaymentMethod;", "externalPaymentMethodSpecs", "Lcom/stripe/android/ui/core/elements/ExternalPaymentMethodSpec;", "customerMetadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/CustomerMetadata;", "isGooglePayReady", "linkConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$LinkConfiguration;", "linkInlineConfiguration", "Lcom/stripe/android/lpmfoundations/paymentmethod/link/LinkInlineConfiguration;", "paymentMethodSaveConsentBehavior", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodSaveConsentBehavior;", "linkMode", "Lcom/stripe/android/model/LinkMode;", "linkState", "Lcom/stripe/android/paymentsheet/state/LinkState;", "paymentMethodIncentive", "Lcom/stripe/android/paymentsheet/model/PaymentMethodIncentive;", "financialConnectionsAvailability", "Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;", "cardBrandFilter", "Lcom/stripe/android/CardBrandFilter;", "elementsSessionId", "<init>", "(Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;ZZLjava/util/List;Lcom/stripe/android/ui/core/cbc/CardBrandChoiceEligibility;Ljava/lang/String;Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/stripe/android/lpmfoundations/paymentmethod/CustomerMetadata;ZLcom/stripe/android/paymentsheet/PaymentSheet$LinkConfiguration;Lcom/stripe/android/lpmfoundations/paymentmethod/link/LinkInlineConfiguration;Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodSaveConsentBehavior;Lcom/stripe/android/model/LinkMode;Lcom/stripe/android/paymentsheet/state/LinkState;Lcom/stripe/android/paymentsheet/model/PaymentMethodIncentive;Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;Lcom/stripe/android/CardBrandFilter;Ljava/lang/String;)V", "getStripeIntent", "()Lcom/stripe/android/model/StripeIntent;", "getBillingDetailsCollectionConfiguration", "()Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "getAllowsDelayedPaymentMethods", "()Z", "getAllowsPaymentMethodsRequiringShippingAddress", "getPaymentMethodOrder", "()Ljava/util/List;", "getCbcEligibility", "()Lcom/stripe/android/ui/core/cbc/CardBrandChoiceEligibility;", "getMerchantName", "()Ljava/lang/String;", "getDefaultBillingDetails", "()Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "getShippingDetails", "()Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;", "getSharedDataSpecs", "getDisplayableCustomPaymentMethods", "getExternalPaymentMethodSpecs", "getCustomerMetadata", "()Lcom/stripe/android/lpmfoundations/paymentmethod/CustomerMetadata;", "getLinkConfiguration", "()Lcom/stripe/android/paymentsheet/PaymentSheet$LinkConfiguration;", "getLinkInlineConfiguration", "()Lcom/stripe/android/lpmfoundations/paymentmethod/link/LinkInlineConfiguration;", "getPaymentMethodSaveConsentBehavior", "()Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodSaveConsentBehavior;", "getLinkMode", "()Lcom/stripe/android/model/LinkMode;", "getLinkState", "()Lcom/stripe/android/paymentsheet/state/LinkState;", "getPaymentMethodIncentive", "()Lcom/stripe/android/paymentsheet/model/PaymentMethodIncentive;", "getFinancialConnectionsAvailability", "()Lcom/stripe/android/payments/financialconnections/FinancialConnectionsAvailability;", "getCardBrandFilter", "()Lcom/stripe/android/CardBrandFilter;", "getElementsSessionId", "hasIntentToSetup", "requiresMandate", "paymentMethodCode", "supportedPaymentMethodTypes", "supportedSavedPaymentMethodTypes", "Lcom/stripe/android/model/PaymentMethod$Type;", "supportedPaymentMethodForCode", "Lcom/stripe/android/lpmfoundations/luxe/SupportedPaymentMethod;", "code", "sortedSupportedPaymentMethods", "orderedPaymentMethodTypes", "mapOrderToIndex", "", "", "externalPaymentMethodTypes", "customPaymentMethodIds", "isExternalPaymentMethod", "isCustomPaymentMethod", "getUiDefinitionFactoryForCustomPaymentMethod", "Lcom/stripe/android/lpmfoundations/paymentmethod/UiDefinitionFactory$Simple;", "getUiDefinitionFactoryForExternalPaymentMethod", "supportedPaymentMethodDefinitions", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodDefinition;", "amount", "Lcom/stripe/android/ui/core/Amount;", "formHeaderInformationForCode", "Lcom/stripe/android/lpmfoundations/FormHeaderInformation;", "customerHasSavedPaymentMethods", "formElementsForCode", "Lcom/stripe/android/uicore/elements/FormElement;", "uiDefinitionFactoryArgumentsFactory", "Lcom/stripe/android/lpmfoundations/paymentmethod/UiDefinitionFactory$Arguments$Factory;", "allowRedisplay", "Lcom/stripe/android/model/PaymentMethod$AllowRedisplay;", "customerRequestedSave", "Lcom/stripe/android/paymentsheet/model/PaymentSelection$CustomerRequestedSave;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component20", "component21", "component22", "component23", "copy", "describeContents", "equals", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Companion", "paymentsheet_release"})
@Parcelize
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPaymentMethodMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentMethodMetadata.kt\ncom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,406:1\n1557#2:407\n1628#2,3:408\n1053#2:411\n774#2:412\n865#2,2:413\n1557#2:415\n1628#2,3:416\n295#2,2:419\n1611#2,9:421\n1863#2:430\n1864#2:432\n1620#2:433\n1567#2:434\n1598#2,4:435\n1557#2:439\n1628#2,3:440\n1557#2:443\n1628#2,3:444\n295#2,2:447\n295#2,2:449\n1611#2,9:451\n1863#2:460\n1864#2:462\n1620#2:463\n774#2:464\n865#2,2:465\n774#2:467\n865#2,2:468\n827#2:470\n855#2,2:471\n774#2:473\n865#2,2:474\n295#2,2:476\n295#2,2:478\n1#3:431\n1#3:461\n*S KotlinDebug\n*F\n+ 1 PaymentMethodMetadata.kt\ncom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata\n*L\n81#1:407\n81#1:408,3\n89#1:411\n97#1:412\n97#1:413,2\n99#1:415\n99#1:416,3\n112#1:419,2\n118#1:421,9\n118#1:430\n118#1:432\n118#1:433\n142#1:434\n142#1:435,4\n148#1:439\n148#1:440,3\n152#1:443\n152#1:444,3\n164#1:447,2\n172#1:449,2\n177#1:451,9\n177#1:460\n177#1:462\n177#1:463\n179#1:464\n179#1:465,2\n183#1:467\n183#1:468,2\n189#1:470\n189#1:471,2\n192#1:473\n192#1:474,2\n222#1:476,2\n248#1:478,2\n118#1:431\n177#1:461\n*E\n"})
public final class PaymentMethodMetadata
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StripeIntent stripeIntent;
    @NotNull
    private final PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration;
    private final boolean allowsDelayedPaymentMethods;
    private final boolean allowsPaymentMethodsRequiringShippingAddress;
    @NotNull
    private final List<String> paymentMethodOrder;
    @NotNull
    private final CardBrandChoiceEligibility cbcEligibility;
    @NotNull
    private final String merchantName;
    @Nullable
    private final PaymentSheet.BillingDetails defaultBillingDetails;
    @Nullable
    private final AddressDetails shippingDetails;
    @NotNull
    private final List<SharedDataSpec> sharedDataSpecs;
    @NotNull
    private final List<DisplayableCustomPaymentMethod> displayableCustomPaymentMethods;
    @NotNull
    private final List<ExternalPaymentMethodSpec> externalPaymentMethodSpecs;
    @Nullable
    private final CustomerMetadata customerMetadata;
    private final boolean isGooglePayReady;
    @NotNull
    private final PaymentSheet.LinkConfiguration linkConfiguration;
    @Nullable
    private final LinkInlineConfiguration linkInlineConfiguration;
    @NotNull
    private final PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior;
    @Nullable
    private final LinkMode linkMode;
    @Nullable
    private final LinkState linkState;
    @Nullable
    private final PaymentMethodIncentive paymentMethodIncentive;
    @Nullable
    private final FinancialConnectionsAvailability financialConnectionsAvailability;
    @NotNull
    private final CardBrandFilter cardBrandFilter;
    @NotNull
    private final String elementsSessionId;
    @NotNull
    public static final Parcelable.Creator<PaymentMethodMetadata> CREATOR;
    public static final int $stable;

    public PaymentMethodMetadata(@NotNull StripeIntent stripeIntent, @NotNull PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, boolean allowsDelayedPaymentMethods, boolean allowsPaymentMethodsRequiringShippingAddress, @NotNull List<String> paymentMethodOrder, @NotNull CardBrandChoiceEligibility cbcEligibility, @NotNull String merchantName, @Nullable PaymentSheet.BillingDetails defaultBillingDetails, @Nullable AddressDetails shippingDetails, @NotNull List<SharedDataSpec> sharedDataSpecs, @NotNull List<DisplayableCustomPaymentMethod> displayableCustomPaymentMethods, @NotNull List<ExternalPaymentMethodSpec> externalPaymentMethodSpecs, @Nullable CustomerMetadata customerMetadata, boolean isGooglePayReady2, @NotNull PaymentSheet.LinkConfiguration linkConfiguration, @Nullable LinkInlineConfiguration linkInlineConfiguration, @NotNull PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior, @Nullable LinkMode linkMode, @Nullable LinkState linkState2, @Nullable PaymentMethodIncentive paymentMethodIncentive, @Nullable FinancialConnectionsAvailability financialConnectionsAvailability, @NotNull CardBrandFilter cardBrandFilter, @NotNull String elementsSessionId) {
        Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
        Intrinsics.checkNotNullParameter((Object)billingDetailsCollectionConfiguration, (String)"billingDetailsCollectionConfiguration");
        Intrinsics.checkNotNullParameter(paymentMethodOrder, (String)"paymentMethodOrder");
        Intrinsics.checkNotNullParameter((Object)cbcEligibility, (String)"cbcEligibility");
        Intrinsics.checkNotNullParameter((Object)merchantName, (String)"merchantName");
        Intrinsics.checkNotNullParameter(sharedDataSpecs, (String)"sharedDataSpecs");
        Intrinsics.checkNotNullParameter(displayableCustomPaymentMethods, (String)"displayableCustomPaymentMethods");
        Intrinsics.checkNotNullParameter(externalPaymentMethodSpecs, (String)"externalPaymentMethodSpecs");
        Intrinsics.checkNotNullParameter((Object)linkConfiguration, (String)"linkConfiguration");
        Intrinsics.checkNotNullParameter((Object)paymentMethodSaveConsentBehavior, (String)"paymentMethodSaveConsentBehavior");
        Intrinsics.checkNotNullParameter((Object)cardBrandFilter, (String)"cardBrandFilter");
        Intrinsics.checkNotNullParameter((Object)elementsSessionId, (String)"elementsSessionId");
        this.stripeIntent = stripeIntent;
        this.billingDetailsCollectionConfiguration = billingDetailsCollectionConfiguration;
        this.allowsDelayedPaymentMethods = allowsDelayedPaymentMethods;
        this.allowsPaymentMethodsRequiringShippingAddress = allowsPaymentMethodsRequiringShippingAddress;
        this.paymentMethodOrder = paymentMethodOrder;
        this.cbcEligibility = cbcEligibility;
        this.merchantName = merchantName;
        this.defaultBillingDetails = defaultBillingDetails;
        this.shippingDetails = shippingDetails;
        this.sharedDataSpecs = sharedDataSpecs;
        this.displayableCustomPaymentMethods = displayableCustomPaymentMethods;
        this.externalPaymentMethodSpecs = externalPaymentMethodSpecs;
        this.customerMetadata = customerMetadata;
        this.isGooglePayReady = isGooglePayReady2;
        this.linkConfiguration = linkConfiguration;
        this.linkInlineConfiguration = linkInlineConfiguration;
        this.paymentMethodSaveConsentBehavior = paymentMethodSaveConsentBehavior;
        this.linkMode = linkMode;
        this.linkState = linkState2;
        this.paymentMethodIncentive = paymentMethodIncentive;
        this.financialConnectionsAvailability = financialConnectionsAvailability;
        this.cardBrandFilter = cardBrandFilter;
        this.elementsSessionId = elementsSessionId;
    }

    @NotNull
    public final StripeIntent getStripeIntent() {
        return this.stripeIntent;
    }

    @NotNull
    public final PaymentSheet.BillingDetailsCollectionConfiguration getBillingDetailsCollectionConfiguration() {
        return this.billingDetailsCollectionConfiguration;
    }

    public final boolean getAllowsDelayedPaymentMethods() {
        return this.allowsDelayedPaymentMethods;
    }

    public final boolean getAllowsPaymentMethodsRequiringShippingAddress() {
        return this.allowsPaymentMethodsRequiringShippingAddress;
    }

    @NotNull
    public final List<String> getPaymentMethodOrder() {
        return this.paymentMethodOrder;
    }

    @NotNull
    public final CardBrandChoiceEligibility getCbcEligibility() {
        return this.cbcEligibility;
    }

    @NotNull
    public final String getMerchantName() {
        return this.merchantName;
    }

    @Nullable
    public final PaymentSheet.BillingDetails getDefaultBillingDetails() {
        return this.defaultBillingDetails;
    }

    @Nullable
    public final AddressDetails getShippingDetails() {
        return this.shippingDetails;
    }

    @NotNull
    public final List<SharedDataSpec> getSharedDataSpecs() {
        return this.sharedDataSpecs;
    }

    @NotNull
    public final List<DisplayableCustomPaymentMethod> getDisplayableCustomPaymentMethods() {
        return this.displayableCustomPaymentMethods;
    }

    @NotNull
    public final List<ExternalPaymentMethodSpec> getExternalPaymentMethodSpecs() {
        return this.externalPaymentMethodSpecs;
    }

    @Nullable
    public final CustomerMetadata getCustomerMetadata() {
        return this.customerMetadata;
    }

    public final boolean isGooglePayReady() {
        return this.isGooglePayReady;
    }

    @NotNull
    public final PaymentSheet.LinkConfiguration getLinkConfiguration() {
        return this.linkConfiguration;
    }

    @Nullable
    public final LinkInlineConfiguration getLinkInlineConfiguration() {
        return this.linkInlineConfiguration;
    }

    @NotNull
    public final PaymentMethodSaveConsentBehavior getPaymentMethodSaveConsentBehavior() {
        return this.paymentMethodSaveConsentBehavior;
    }

    @Nullable
    public final LinkMode getLinkMode() {
        return this.linkMode;
    }

    @Nullable
    public final LinkState getLinkState() {
        return this.linkState;
    }

    @Nullable
    public final PaymentMethodIncentive getPaymentMethodIncentive() {
        return this.paymentMethodIncentive;
    }

    @Nullable
    public final FinancialConnectionsAvailability getFinancialConnectionsAvailability() {
        return this.financialConnectionsAvailability;
    }

    @NotNull
    public final CardBrandFilter getCardBrandFilter() {
        return this.cardBrandFilter;
    }

    @NotNull
    public final String getElementsSessionId() {
        return this.elementsSessionId;
    }

    public final boolean hasIntentToSetup() {
        boolean bl;
        StripeIntent stripeIntent = this.stripeIntent;
        if (stripeIntent instanceof PaymentIntent) {
            bl = ((PaymentIntent)this.stripeIntent).getSetupFutureUsage() != null;
        } else if (stripeIntent instanceof SetupIntent) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public final boolean requiresMandate(@NotNull String paymentMethodCode) {
        Intrinsics.checkNotNullParameter((Object)paymentMethodCode, (String)"paymentMethodCode");
        PaymentMethodDefinition paymentMethodDefinition = PaymentMethodRegistry.INSTANCE.getDefinitionsByCode().get(paymentMethodCode);
        return paymentMethodDefinition != null ? paymentMethodDefinition.requiresMandate(this) : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> supportedPaymentMethodTypes() {
        List list;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.supportedPaymentMethodDefinitions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void paymentMethodDefinition;
            PaymentMethodDefinition paymentMethodDefinition2 = (PaymentMethodDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(paymentMethodDefinition.getType().code);
        }
        List $this$supportedPaymentMethodTypes_u24lambda_u242 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.externalPaymentMethodTypes()), (Iterable)this.customPaymentMethodIds());
        boolean bl = false;
        if (this.paymentMethodOrder.isEmpty()) {
            list = $this$supportedPaymentMethodTypes_u24lambda_u242;
        } else {
            Map<String, Integer> orderedPaymentMethodTypes = this.mapOrderToIndex(this.orderedPaymentMethodTypes());
            Iterable $this$sortedBy$iv = $this$supportedPaymentMethodTypes_u24lambda_u242;
            boolean $i$f$sortedBy = false;
            list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(orderedPaymentMethodTypes){
                final /* synthetic */ Map $orderedPaymentMethodTypes$inlined;
                {
                    this.$orderedPaymentMethodTypes$inlined = map2;
                }

                public final int compare(T a, T b) {
                    String code = (String)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)this.$orderedPaymentMethodTypes$inlined.get(code);
                    code = (String)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)this.$orderedPaymentMethodTypes$inlined.get(code)));
                }
            });
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PaymentMethod.Type> supportedSavedPaymentMethodTypes() {
        void $this$mapTo$iv$iv;
        PaymentMethodDefinition paymentMethodDefinition;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.supportedPaymentMethodDefinitions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            paymentMethodDefinition = (PaymentMethodDefinition)element$iv$iv;
            boolean bl = false;
            if (!paymentMethodDefinition.getSupportedAsSavedPaymentMethod()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            paymentMethodDefinition = (PaymentMethodDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final SupportedPaymentMethod supportedPaymentMethodForCode(@NotNull String code) {
        SupportedPaymentMethod supportedPaymentMethod;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        if (this.isExternalPaymentMethod(code)) {
            UiDefinitionFactory.Simple simple = this.getUiDefinitionFactoryForExternalPaymentMethod(code);
            supportedPaymentMethod = simple != null ? simple.createSupportedPaymentMethod() : null;
        } else if (this.isCustomPaymentMethod(code)) {
            UiDefinitionFactory.Simple simple = this.getUiDefinitionFactoryForCustomPaymentMethod(code);
            supportedPaymentMethod = simple != null ? simple.createSupportedPaymentMethod() : null;
        } else {
            Object v3;
            block6: {
                Iterable $this$firstOrNull$iv = this.supportedPaymentMethodDefinitions();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PaymentMethodDefinition it = (PaymentMethodDefinition)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType().code, (Object)code)) continue;
                    v3 = element$iv;
                    break block6;
                }
                v3 = null;
            }
            PaymentMethodDefinition paymentMethodDefinition = v3;
            if (paymentMethodDefinition == null) {
                return null;
            }
            PaymentMethodDefinition definition = paymentMethodDefinition;
            supportedPaymentMethod = definition.uiDefinitionFactory().supportedPaymentMethod(this, definition, this.sharedDataSpecs);
        }
        return supportedPaymentMethod;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SupportedPaymentMethod> sortedSupportedPaymentMethods() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.supportedPaymentMethodTypes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SupportedPaymentMethod it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.supportedPaymentMethodForCode(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> orderedPaymentMethodTypes() {
        List originalOrderedTypes = CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.stripeIntent.getPaymentMethodTypes(), (Iterable)this.externalPaymentMethodTypes()), (Iterable)this.customPaymentMethodIds()));
        List result2 = new ArrayList();
        for (String pm : this.paymentMethodOrder) {
            if (!originalOrderedTypes.contains(pm)) continue;
            ((Collection)result2).add(pm);
            originalOrderedTypes.remove(pm);
        }
        result2.addAll(originalOrderedTypes);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Integer> mapOrderToIndex(List<String> $this$mapOrderToIndex) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = $this$mapOrderToIndex;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void s;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)s, (Object)((int)index)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> externalPaymentMethodTypes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.externalPaymentMethodSpecs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExternalPaymentMethodSpec externalPaymentMethodSpec = (ExternalPaymentMethodSpec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> customPaymentMethodIds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.displayableCustomPaymentMethods;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DisplayableCustomPaymentMethod displayableCustomPaymentMethod = (DisplayableCustomPaymentMethod)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    public final boolean isExternalPaymentMethod(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return this.externalPaymentMethodTypes().contains(code);
    }

    public final boolean isCustomPaymentMethod(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return this.customPaymentMethodIds().contains(code);
    }

    private final UiDefinitionFactory.Simple getUiDefinitionFactoryForCustomPaymentMethod(String code) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.displayableCustomPaymentMethods;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DisplayableCustomPaymentMethod it = (DisplayableCustomPaymentMethod)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)code)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        DisplayableCustomPaymentMethod displayableCustomPaymentMethod = v0;
        if (displayableCustomPaymentMethod == null) {
            return null;
        }
        DisplayableCustomPaymentMethod displayableCustomPaymentMethodForCode = displayableCustomPaymentMethod;
        return new CustomPaymentMethodUiDefinitionFactory(displayableCustomPaymentMethodForCode);
    }

    private final UiDefinitionFactory.Simple getUiDefinitionFactoryForExternalPaymentMethod(String code) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.externalPaymentMethodSpecs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ExternalPaymentMethodSpec it = (ExternalPaymentMethodSpec)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)code)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        ExternalPaymentMethodSpec externalPaymentMethodSpec = v0;
        if (externalPaymentMethodSpec == null) {
            return null;
        }
        ExternalPaymentMethodSpec externalPaymentMethodSpecForCode = externalPaymentMethodSpec;
        return new ExternalPaymentMethodUiDefinitionFactory(externalPaymentMethodSpecForCode);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PaymentMethodDefinition> supportedPaymentMethodDefinitions() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterNotTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.stripeIntent.getPaymentMethodTypes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PaymentMethodDefinition it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (PaymentMethodRegistry.INSTANCE.getDefinitionsByCode().get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv2 = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            PaymentMethodDefinition it = (PaymentMethodDefinition)element$iv$iv;
            boolean bl = false;
            if (!PaymentMethodDefinitionKt.isSupported(it, this)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List supportedPaymentMethodTypes = (List)destination$iv$iv;
        Iterable $this$filter$iv3 = CollectionsKt.listOf((Object)LinkCardBrandDefinition.INSTANCE);
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv3;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            LinkCardBrandDefinition it = (LinkCardBrandDefinition)element$iv$iv;
            boolean bl = false;
            if (!PaymentMethodDefinitionKt.isSupported(it, this)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List syntheticPaymentMethodTypes = (List)destination$iv$iv2;
        List paymentMethodTypes = CollectionsKt.plus((Collection)supportedPaymentMethodTypes, (Iterable)syntheticPaymentMethodTypes);
        Iterable $this$filterNot$iv = paymentMethodTypes;
        boolean $i$f$filterNot = false;
        destination$iv$iv2 = $this$filterNot$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PaymentMethodDefinition it = (PaymentMethodDefinition)element$iv$iv;
            boolean bl = false;
            if (this.stripeIntent.isLiveMode() && this.stripeIntent.getUnactivatedPaymentMethods().contains(it.getType().code)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv3;
        boolean $i$f$filter3 = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PaymentMethodDefinition paymentMethodDefinition = (PaymentMethodDefinition)element$iv$iv;
            boolean bl = false;
            if (!paymentMethodDefinition.uiDefinitionFactory().canBeDisplayedInUi(paymentMethodDefinition, this.sharedDataSpecs)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        return (List)destination$iv$iv3;
    }

    @Nullable
    public final Amount amount() {
        if (this.stripeIntent instanceof PaymentIntent) {
            Long l = ((PaymentIntent)this.stripeIntent).getAmount();
            if (l == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            String string3 = ((PaymentIntent)this.stripeIntent).getCurrency();
            if (string3 == null) {
                String string4 = "Required value was null.";
                throw new IllegalArgumentException(string4.toString());
            }
            return new Amount(((Number)l).longValue(), string3);
        }
        return null;
    }

    @Nullable
    public final FormHeaderInformation formHeaderInformationForCode(@NotNull String code, boolean customerHasSavedPaymentMethods) {
        FormHeaderInformation formHeaderInformation;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        if (this.isExternalPaymentMethod(code)) {
            UiDefinitionFactory.Simple simple = this.getUiDefinitionFactoryForExternalPaymentMethod(code);
            formHeaderInformation = simple != null ? simple.createFormHeaderInformation(customerHasSavedPaymentMethods, null) : null;
        } else if (this.isCustomPaymentMethod(code)) {
            UiDefinitionFactory.Simple simple = this.getUiDefinitionFactoryForCustomPaymentMethod(code);
            formHeaderInformation = simple != null ? simple.createFormHeaderInformation(customerHasSavedPaymentMethods, null) : null;
        } else {
            Object v3;
            block6: {
                Iterable $this$firstOrNull$iv = this.supportedPaymentMethodDefinitions();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PaymentMethodDefinition it = (PaymentMethodDefinition)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType().code, (Object)code)) continue;
                    v3 = element$iv;
                    break block6;
                }
                v3 = null;
            }
            PaymentMethodDefinition paymentMethodDefinition = v3;
            if (paymentMethodDefinition == null) {
                return null;
            }
            PaymentMethodDefinition definition = paymentMethodDefinition;
            UiDefinitionFactory uiDefinitionFactory = definition.uiDefinitionFactory();
            List<SharedDataSpec> list = this.sharedDataSpecs;
            formHeaderInformation = uiDefinitionFactory.formHeaderInformation(definition, this, list, customerHasSavedPaymentMethods);
        }
        return formHeaderInformation;
    }

    @Nullable
    public final List<FormElement> formElementsForCode(@NotNull String code, @NotNull UiDefinitionFactory.Arguments.Factory uiDefinitionFactoryArgumentsFactory) {
        List<Object> list;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)uiDefinitionFactoryArgumentsFactory, (String)"uiDefinitionFactoryArgumentsFactory");
        if (this.isExternalPaymentMethod(code)) {
            UiDefinitionFactory.Simple simple = this.getUiDefinitionFactoryForExternalPaymentMethod(code);
            list = simple != null ? simple.createFormElements(this, uiDefinitionFactoryArgumentsFactory.create(this, false)) : null;
        } else if (this.isCustomPaymentMethod(code)) {
            UiDefinitionFactory.Simple simple = this.getUiDefinitionFactoryForCustomPaymentMethod(code);
            list = simple != null ? simple.createFormElements(this, uiDefinitionFactoryArgumentsFactory.create(this, false)) : null;
        } else {
            Object v3;
            block6: {
                Iterable $this$firstOrNull$iv = this.supportedPaymentMethodDefinitions();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PaymentMethodDefinition it = (PaymentMethodDefinition)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType().code, (Object)code)) continue;
                    v3 = element$iv;
                    break block6;
                }
                v3 = null;
            }
            PaymentMethodDefinition paymentMethodDefinition = v3;
            if (paymentMethodDefinition == null) {
                return null;
            }
            PaymentMethodDefinition definition = paymentMethodDefinition;
            UiDefinitionFactory uiDefinitionFactory = definition.uiDefinitionFactory();
            List<SharedDataSpec> list2 = this.sharedDataSpecs;
            UiDefinitionFactory.Arguments arguments = uiDefinitionFactoryArgumentsFactory.create(this, definition.requiresMandate(this));
            list = uiDefinitionFactory.formElements(definition, this, list2, arguments);
        }
        return list;
    }

    @NotNull
    public final PaymentMethod.AllowRedisplay allowRedisplay(@NotNull PaymentSelection.CustomerRequestedSave customerRequestedSave) {
        Intrinsics.checkNotNullParameter((Object)((Object)customerRequestedSave), (String)"customerRequestedSave");
        return this.paymentMethodSaveConsentBehavior.allowRedisplay(this.hasIntentToSetup(), customerRequestedSave);
    }

    public final void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeParcelable((Parcelable)this.stripeIntent, flags);
        this.billingDetailsCollectionConfiguration.writeToParcel(dest, flags);
        dest.writeInt(this.allowsDelayedPaymentMethods ? 1 : 0);
        dest.writeInt(this.allowsPaymentMethodsRequiringShippingAddress ? 1 : 0);
        dest.writeStringList(this.paymentMethodOrder);
        dest.writeParcelable((Parcelable)this.cbcEligibility, flags);
        dest.writeString(this.merchantName);
        Object object = this.defaultBillingDetails;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((PaymentSheet.BillingDetails)object).writeToParcel(dest, flags);
        }
        object = this.shippingDetails;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((AddressDetails)object).writeToParcel(dest, flags);
        }
        object = this.sharedDataSpecs;
        dest.writeInt(object.size());
        Iterator<Object> iterator = object.iterator();
        while (iterator.hasNext()) {
            dest.writeParcelable((Parcelable)iterator.next(), flags);
        }
        object = this.displayableCustomPaymentMethods;
        dest.writeInt(object.size());
        iterator = object.iterator();
        while (iterator.hasNext()) {
            ((DisplayableCustomPaymentMethod)iterator.next()).writeToParcel(dest, flags);
        }
        object = this.externalPaymentMethodSpecs;
        dest.writeInt(object.size());
        iterator = object.iterator();
        while (iterator.hasNext()) {
            dest.writeParcelable((Parcelable)iterator.next(), flags);
        }
        object = this.customerMetadata;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((CustomerMetadata)object).writeToParcel(dest, flags);
        }
        dest.writeInt(this.isGooglePayReady ? 1 : 0);
        this.linkConfiguration.writeToParcel(dest, flags);
        object = this.linkInlineConfiguration;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((LinkInlineConfiguration)object).writeToParcel(dest, flags);
        }
        dest.writeParcelable((Parcelable)this.paymentMethodSaveConsentBehavior, flags);
        object = this.linkMode;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeString(object.name());
        }
        object = this.linkState;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((LinkState)object).writeToParcel(dest, flags);
        }
        object = this.paymentMethodIncentive;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((PaymentMethodIncentive)object).writeToParcel(dest, flags);
        }
        object = this.financialConnectionsAvailability;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeString(object.name());
        }
        dest.writeParcelable((Parcelable)this.cardBrandFilter, flags);
        dest.writeString(this.elementsSessionId);
    }

    public final int describeContents() {
        return 0;
    }

    @NotNull
    public final StripeIntent component1() {
        return this.stripeIntent;
    }

    @NotNull
    public final PaymentSheet.BillingDetailsCollectionConfiguration component2() {
        return this.billingDetailsCollectionConfiguration;
    }

    public final boolean component3() {
        return this.allowsDelayedPaymentMethods;
    }

    public final boolean component4() {
        return this.allowsPaymentMethodsRequiringShippingAddress;
    }

    @NotNull
    public final List<String> component5() {
        return this.paymentMethodOrder;
    }

    @NotNull
    public final CardBrandChoiceEligibility component6() {
        return this.cbcEligibility;
    }

    @NotNull
    public final String component7() {
        return this.merchantName;
    }

    @Nullable
    public final PaymentSheet.BillingDetails component8() {
        return this.defaultBillingDetails;
    }

    @Nullable
    public final AddressDetails component9() {
        return this.shippingDetails;
    }

    @NotNull
    public final List<SharedDataSpec> component10() {
        return this.sharedDataSpecs;
    }

    @NotNull
    public final List<DisplayableCustomPaymentMethod> component11() {
        return this.displayableCustomPaymentMethods;
    }

    @NotNull
    public final List<ExternalPaymentMethodSpec> component12() {
        return this.externalPaymentMethodSpecs;
    }

    @Nullable
    public final CustomerMetadata component13() {
        return this.customerMetadata;
    }

    public final boolean component14() {
        return this.isGooglePayReady;
    }

    @NotNull
    public final PaymentSheet.LinkConfiguration component15() {
        return this.linkConfiguration;
    }

    @Nullable
    public final LinkInlineConfiguration component16() {
        return this.linkInlineConfiguration;
    }

    @NotNull
    public final PaymentMethodSaveConsentBehavior component17() {
        return this.paymentMethodSaveConsentBehavior;
    }

    @Nullable
    public final LinkMode component18() {
        return this.linkMode;
    }

    @Nullable
    public final LinkState component19() {
        return this.linkState;
    }

    @Nullable
    public final PaymentMethodIncentive component20() {
        return this.paymentMethodIncentive;
    }

    @Nullable
    public final FinancialConnectionsAvailability component21() {
        return this.financialConnectionsAvailability;
    }

    @NotNull
    public final CardBrandFilter component22() {
        return this.cardBrandFilter;
    }

    @NotNull
    public final String component23() {
        return this.elementsSessionId;
    }

    @NotNull
    public final PaymentMethodMetadata copy(@NotNull StripeIntent stripeIntent, @NotNull PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, boolean allowsDelayedPaymentMethods, boolean allowsPaymentMethodsRequiringShippingAddress, @NotNull List<String> paymentMethodOrder, @NotNull CardBrandChoiceEligibility cbcEligibility, @NotNull String merchantName, @Nullable PaymentSheet.BillingDetails defaultBillingDetails, @Nullable AddressDetails shippingDetails, @NotNull List<SharedDataSpec> sharedDataSpecs, @NotNull List<DisplayableCustomPaymentMethod> displayableCustomPaymentMethods, @NotNull List<ExternalPaymentMethodSpec> externalPaymentMethodSpecs, @Nullable CustomerMetadata customerMetadata, boolean isGooglePayReady2, @NotNull PaymentSheet.LinkConfiguration linkConfiguration, @Nullable LinkInlineConfiguration linkInlineConfiguration, @NotNull PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior, @Nullable LinkMode linkMode, @Nullable LinkState linkState2, @Nullable PaymentMethodIncentive paymentMethodIncentive, @Nullable FinancialConnectionsAvailability financialConnectionsAvailability, @NotNull CardBrandFilter cardBrandFilter, @NotNull String elementsSessionId) {
        Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
        Intrinsics.checkNotNullParameter((Object)billingDetailsCollectionConfiguration, (String)"billingDetailsCollectionConfiguration");
        Intrinsics.checkNotNullParameter(paymentMethodOrder, (String)"paymentMethodOrder");
        Intrinsics.checkNotNullParameter((Object)cbcEligibility, (String)"cbcEligibility");
        Intrinsics.checkNotNullParameter((Object)merchantName, (String)"merchantName");
        Intrinsics.checkNotNullParameter(sharedDataSpecs, (String)"sharedDataSpecs");
        Intrinsics.checkNotNullParameter(displayableCustomPaymentMethods, (String)"displayableCustomPaymentMethods");
        Intrinsics.checkNotNullParameter(externalPaymentMethodSpecs, (String)"externalPaymentMethodSpecs");
        Intrinsics.checkNotNullParameter((Object)linkConfiguration, (String)"linkConfiguration");
        Intrinsics.checkNotNullParameter((Object)paymentMethodSaveConsentBehavior, (String)"paymentMethodSaveConsentBehavior");
        Intrinsics.checkNotNullParameter((Object)cardBrandFilter, (String)"cardBrandFilter");
        Intrinsics.checkNotNullParameter((Object)elementsSessionId, (String)"elementsSessionId");
        return new PaymentMethodMetadata(stripeIntent, billingDetailsCollectionConfiguration, allowsDelayedPaymentMethods, allowsPaymentMethodsRequiringShippingAddress, paymentMethodOrder, cbcEligibility, merchantName, defaultBillingDetails, shippingDetails, sharedDataSpecs, displayableCustomPaymentMethods, externalPaymentMethodSpecs, customerMetadata, isGooglePayReady2, linkConfiguration, linkInlineConfiguration, paymentMethodSaveConsentBehavior, linkMode, linkState2, paymentMethodIncentive, financialConnectionsAvailability, cardBrandFilter, elementsSessionId);
    }

    public static /* synthetic */ PaymentMethodMetadata copy$default(PaymentMethodMetadata paymentMethodMetadata, StripeIntent stripeIntent, PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, boolean bl, boolean bl2, List list, CardBrandChoiceEligibility cardBrandChoiceEligibility, String string2, PaymentSheet.BillingDetails billingDetails, AddressDetails addressDetails, List list2, List list3, List list4, CustomerMetadata customerMetadata, boolean bl3, PaymentSheet.LinkConfiguration linkConfiguration, LinkInlineConfiguration linkInlineConfiguration, PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior, LinkMode linkMode, LinkState linkState2, PaymentMethodIncentive paymentMethodIncentive, FinancialConnectionsAvailability financialConnectionsAvailability, CardBrandFilter cardBrandFilter, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            stripeIntent = paymentMethodMetadata.stripeIntent;
        }
        if ((n & 2) != 0) {
            billingDetailsCollectionConfiguration = paymentMethodMetadata.billingDetailsCollectionConfiguration;
        }
        if ((n & 4) != 0) {
            bl = paymentMethodMetadata.allowsDelayedPaymentMethods;
        }
        if ((n & 8) != 0) {
            bl2 = paymentMethodMetadata.allowsPaymentMethodsRequiringShippingAddress;
        }
        if ((n & 0x10) != 0) {
            list = paymentMethodMetadata.paymentMethodOrder;
        }
        if ((n & 0x20) != 0) {
            cardBrandChoiceEligibility = paymentMethodMetadata.cbcEligibility;
        }
        if ((n & 0x40) != 0) {
            string2 = paymentMethodMetadata.merchantName;
        }
        if ((n & 0x80) != 0) {
            billingDetails = paymentMethodMetadata.defaultBillingDetails;
        }
        if ((n & 0x100) != 0) {
            addressDetails = paymentMethodMetadata.shippingDetails;
        }
        if ((n & 0x200) != 0) {
            list2 = paymentMethodMetadata.sharedDataSpecs;
        }
        if ((n & 0x400) != 0) {
            list3 = paymentMethodMetadata.displayableCustomPaymentMethods;
        }
        if ((n & 0x800) != 0) {
            list4 = paymentMethodMetadata.externalPaymentMethodSpecs;
        }
        if ((n & 0x1000) != 0) {
            customerMetadata = paymentMethodMetadata.customerMetadata;
        }
        if ((n & 0x2000) != 0) {
            bl3 = paymentMethodMetadata.isGooglePayReady;
        }
        if ((n & 0x4000) != 0) {
            linkConfiguration = paymentMethodMetadata.linkConfiguration;
        }
        if ((n & 0x8000) != 0) {
            linkInlineConfiguration = paymentMethodMetadata.linkInlineConfiguration;
        }
        if ((n & 0x10000) != 0) {
            paymentMethodSaveConsentBehavior = paymentMethodMetadata.paymentMethodSaveConsentBehavior;
        }
        if ((n & 0x20000) != 0) {
            linkMode = paymentMethodMetadata.linkMode;
        }
        if ((n & 0x40000) != 0) {
            linkState2 = paymentMethodMetadata.linkState;
        }
        if ((n & 0x80000) != 0) {
            paymentMethodIncentive = paymentMethodMetadata.paymentMethodIncentive;
        }
        if ((n & 0x100000) != 0) {
            financialConnectionsAvailability = paymentMethodMetadata.financialConnectionsAvailability;
        }
        if ((n & 0x200000) != 0) {
            cardBrandFilter = paymentMethodMetadata.cardBrandFilter;
        }
        if ((n & 0x400000) != 0) {
            string3 = paymentMethodMetadata.elementsSessionId;
        }
        return paymentMethodMetadata.copy(stripeIntent, billingDetailsCollectionConfiguration, bl, bl2, list, cardBrandChoiceEligibility, string2, billingDetails, addressDetails, list2, list3, list4, customerMetadata, bl3, linkConfiguration, linkInlineConfiguration, paymentMethodSaveConsentBehavior, linkMode, linkState2, paymentMethodIncentive, financialConnectionsAvailability, cardBrandFilter, string3);
    }

    @NotNull
    public String toString() {
        return "PaymentMethodMetadata(stripeIntent=" + this.stripeIntent + ", billingDetailsCollectionConfiguration=" + this.billingDetailsCollectionConfiguration + ", allowsDelayedPaymentMethods=" + this.allowsDelayedPaymentMethods + ", allowsPaymentMethodsRequiringShippingAddress=" + this.allowsPaymentMethodsRequiringShippingAddress + ", paymentMethodOrder=" + this.paymentMethodOrder + ", cbcEligibility=" + this.cbcEligibility + ", merchantName=" + this.merchantName + ", defaultBillingDetails=" + this.defaultBillingDetails + ", shippingDetails=" + this.shippingDetails + ", sharedDataSpecs=" + this.sharedDataSpecs + ", displayableCustomPaymentMethods=" + this.displayableCustomPaymentMethods + ", externalPaymentMethodSpecs=" + this.externalPaymentMethodSpecs + ", customerMetadata=" + this.customerMetadata + ", isGooglePayReady=" + this.isGooglePayReady + ", linkConfiguration=" + this.linkConfiguration + ", linkInlineConfiguration=" + this.linkInlineConfiguration + ", paymentMethodSaveConsentBehavior=" + this.paymentMethodSaveConsentBehavior + ", linkMode=" + this.linkMode + ", linkState=" + this.linkState + ", paymentMethodIncentive=" + this.paymentMethodIncentive + ", financialConnectionsAvailability=" + this.financialConnectionsAvailability + ", cardBrandFilter=" + this.cardBrandFilter + ", elementsSessionId=" + this.elementsSessionId + ")";
    }

    public int hashCode() {
        int result2 = this.stripeIntent.hashCode();
        result2 = result2 * 31 + this.billingDetailsCollectionConfiguration.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.allowsDelayedPaymentMethods);
        result2 = result2 * 31 + Boolean.hashCode(this.allowsPaymentMethodsRequiringShippingAddress);
        result2 = result2 * 31 + ((Object)this.paymentMethodOrder).hashCode();
        result2 = result2 * 31 + this.cbcEligibility.hashCode();
        result2 = result2 * 31 + this.merchantName.hashCode();
        result2 = result2 * 31 + (this.defaultBillingDetails == null ? 0 : this.defaultBillingDetails.hashCode());
        result2 = result2 * 31 + (this.shippingDetails == null ? 0 : this.shippingDetails.hashCode());
        result2 = result2 * 31 + ((Object)this.sharedDataSpecs).hashCode();
        result2 = result2 * 31 + ((Object)this.displayableCustomPaymentMethods).hashCode();
        result2 = result2 * 31 + ((Object)this.externalPaymentMethodSpecs).hashCode();
        result2 = result2 * 31 + (this.customerMetadata == null ? 0 : this.customerMetadata.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.isGooglePayReady);
        result2 = result2 * 31 + this.linkConfiguration.hashCode();
        result2 = result2 * 31 + (this.linkInlineConfiguration == null ? 0 : this.linkInlineConfiguration.hashCode());
        result2 = result2 * 31 + this.paymentMethodSaveConsentBehavior.hashCode();
        result2 = result2 * 31 + (this.linkMode == null ? 0 : this.linkMode.hashCode());
        result2 = result2 * 31 + (this.linkState == null ? 0 : this.linkState.hashCode());
        result2 = result2 * 31 + (this.paymentMethodIncentive == null ? 0 : this.paymentMethodIncentive.hashCode());
        result2 = result2 * 31 + (this.financialConnectionsAvailability == null ? 0 : this.financialConnectionsAvailability.hashCode());
        result2 = result2 * 31 + this.cardBrandFilter.hashCode();
        result2 = result2 * 31 + this.elementsSessionId.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PaymentMethodMetadata)) {
            return false;
        }
        PaymentMethodMetadata paymentMethodMetadata = (PaymentMethodMetadata)other;
        if (!Intrinsics.areEqual((Object)this.stripeIntent, (Object)paymentMethodMetadata.stripeIntent)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.billingDetailsCollectionConfiguration, (Object)paymentMethodMetadata.billingDetailsCollectionConfiguration)) {
            return false;
        }
        if (this.allowsDelayedPaymentMethods != paymentMethodMetadata.allowsDelayedPaymentMethods) {
            return false;
        }
        if (this.allowsPaymentMethodsRequiringShippingAddress != paymentMethodMetadata.allowsPaymentMethodsRequiringShippingAddress) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paymentMethodOrder, paymentMethodMetadata.paymentMethodOrder)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cbcEligibility, (Object)paymentMethodMetadata.cbcEligibility)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.merchantName, (Object)paymentMethodMetadata.merchantName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultBillingDetails, (Object)paymentMethodMetadata.defaultBillingDetails)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shippingDetails, (Object)paymentMethodMetadata.shippingDetails)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.sharedDataSpecs, paymentMethodMetadata.sharedDataSpecs)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.displayableCustomPaymentMethods, paymentMethodMetadata.displayableCustomPaymentMethods)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.externalPaymentMethodSpecs, paymentMethodMetadata.externalPaymentMethodSpecs)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.customerMetadata, (Object)paymentMethodMetadata.customerMetadata)) {
            return false;
        }
        if (this.isGooglePayReady != paymentMethodMetadata.isGooglePayReady) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.linkConfiguration, (Object)paymentMethodMetadata.linkConfiguration)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.linkInlineConfiguration, (Object)paymentMethodMetadata.linkInlineConfiguration)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.paymentMethodSaveConsentBehavior, (Object)paymentMethodMetadata.paymentMethodSaveConsentBehavior)) {
            return false;
        }
        if (this.linkMode != paymentMethodMetadata.linkMode) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.linkState, (Object)paymentMethodMetadata.linkState)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.paymentMethodIncentive, (Object)paymentMethodMetadata.paymentMethodIncentive)) {
            return false;
        }
        if (this.financialConnectionsAvailability != paymentMethodMetadata.financialConnectionsAvailability) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cardBrandFilter, (Object)paymentMethodMetadata.cardBrandFilter)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.elementsSessionId, (Object)paymentMethodMetadata.elementsSessionId);
    }

    static {
        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<PaymentMethodMetadata> {
            public final PaymentMethodMetadata[] newArray(int size) {
                return new PaymentMethodMetadata[size];
            }

            public final PaymentMethodMetadata createFromParcel(Parcel parcel) {
                int n;
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n2 = parcel.readInt();
                ArrayList<Object> arrayList = new ArrayList<Object>(n2);
                AddressDetails addressDetails = (AddressDetails)(parcel.readInt() == 0 ? null : AddressDetails.CREATOR.createFromParcel(parcel));
                PaymentSheet.BillingDetails billingDetails = (PaymentSheet.BillingDetails)(parcel.readInt() == 0 ? null : PaymentSheet.BillingDetails.CREATOR.createFromParcel(parcel));
                String string2 = parcel.readString();
                CardBrandChoiceEligibility cardBrandChoiceEligibility = (CardBrandChoiceEligibility)parcel.readParcelable(PaymentMethodMetadata.class.getClassLoader());
                List list = parcel.createStringArrayList();
                boolean bl = parcel.readInt() != 0;
                boolean bl2 = parcel.readInt() != 0;
                PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = (PaymentSheet.BillingDetailsCollectionConfiguration)PaymentSheet.BillingDetailsCollectionConfiguration.CREATOR.createFromParcel(parcel);
                StripeIntent stripeIntent = (StripeIntent)parcel.readParcelable(PaymentMethodMetadata.class.getClassLoader());
                for (n = 0; n != n2; ++n) {
                    arrayList.add(parcel.readParcelable(PaymentMethodMetadata.class.getClassLoader()));
                }
                List list2 = arrayList;
                n2 = parcel.readInt();
                arrayList = new ArrayList(n2);
                List list3 = list2;
                for (n = 0; n != n2; ++n) {
                    arrayList.add(DisplayableCustomPaymentMethod.CREATOR.createFromParcel(parcel));
                }
                List list4 = arrayList;
                n2 = parcel.readInt();
                arrayList = new ArrayList(n2);
                List list5 = list4;
                for (n = 0; n != n2; ++n) {
                    arrayList.add(parcel.readParcelable(PaymentMethodMetadata.class.getClassLoader()));
                }
                String string3 = parcel.readString();
                CardBrandFilter cardBrandFilter = (CardBrandFilter)parcel.readParcelable(PaymentMethodMetadata.class.getClassLoader());
                FinancialConnectionsAvailability financialConnectionsAvailability = parcel.readInt() == 0 ? null : FinancialConnectionsAvailability.valueOf((String)parcel.readString());
                PaymentMethodIncentive paymentMethodIncentive = (PaymentMethodIncentive)(parcel.readInt() == 0 ? null : PaymentMethodIncentive.CREATOR.createFromParcel(parcel));
                LinkState linkState2 = (LinkState)(parcel.readInt() == 0 ? null : LinkState.CREATOR.createFromParcel(parcel));
                LinkMode linkMode = parcel.readInt() == 0 ? null : LinkMode.valueOf((String)parcel.readString());
                PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior = (PaymentMethodSaveConsentBehavior)parcel.readParcelable(PaymentMethodMetadata.class.getClassLoader());
                LinkInlineConfiguration linkInlineConfiguration = (LinkInlineConfiguration)(parcel.readInt() == 0 ? null : LinkInlineConfiguration.CREATOR.createFromParcel(parcel));
                PaymentSheet.LinkConfiguration linkConfiguration = (PaymentSheet.LinkConfiguration)PaymentSheet.LinkConfiguration.CREATOR.createFromParcel(parcel);
                boolean bl3 = parcel.readInt() != 0;
                CustomerMetadata customerMetadata = (CustomerMetadata)(parcel.readInt() == 0 ? null : CustomerMetadata.CREATOR.createFromParcel(parcel));
                List list6 = arrayList;
                List list7 = list5;
                List list8 = list3;
                AddressDetails addressDetails2 = addressDetails;
                PaymentSheet.BillingDetails billingDetails2 = billingDetails;
                String string4 = string2;
                CardBrandChoiceEligibility cardBrandChoiceEligibility2 = cardBrandChoiceEligibility;
                List list9 = list;
                boolean bl4 = bl;
                boolean bl5 = bl2;
                PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration2 = billingDetailsCollectionConfiguration;
                StripeIntent stripeIntent2 = stripeIntent;
                return new PaymentMethodMetadata(stripeIntent2, billingDetailsCollectionConfiguration2, bl5, bl4, list9, cardBrandChoiceEligibility2, string4, billingDetails2, addressDetails2, list8, list7, list6, customerMetadata, bl3, linkConfiguration, linkInlineConfiguration, paymentMethodSaveConsentBehavior, linkMode, linkState2, paymentMethodIncentive, financialConnectionsAvailability, cardBrandFilter, string3);
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JU\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0002\b\u0015JC\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001bJ\u0015\u0010\u001c\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006 "}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata$Companion;", "", "<init>", "()V", "createForPaymentElement", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "elementsSession", "Lcom/stripe/android/model/ElementsSession;", "configuration", "Lcom/stripe/android/common/model/CommonConfiguration;", "sharedDataSpecs", "", "Lcom/stripe/android/ui/core/elements/SharedDataSpec;", "externalPaymentMethodSpecs", "Lcom/stripe/android/ui/core/elements/ExternalPaymentMethodSpec;", "isGooglePayReady", "", "linkInlineConfiguration", "Lcom/stripe/android/lpmfoundations/paymentmethod/link/LinkInlineConfiguration;", "linkState", "Lcom/stripe/android/paymentsheet/state/LinkState;", "createForPaymentElement$paymentsheet_release", "createForCustomerSheet", "Lcom/stripe/android/customersheet/CustomerSheet$Configuration;", "paymentMethodSaveConsentBehavior", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodSaveConsentBehavior;", "isPaymentMethodSyncDefaultEnabled", "createForCustomerSheet$paymentsheet_release", "createForNativeLink", "Lcom/stripe/android/link/LinkConfiguration;", "createForNativeLink$paymentsheet_release", "getDefaultPaymentMethodsEnabled", "paymentsheet_release"})
    @SourceDebugExtension(value={"SMAP\nPaymentMethodMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentMethodMetadata.kt\ncom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,406:1\n1557#2:407\n1628#2,3:408\n*S KotlinDebug\n*F\n+ 1 PaymentMethodMetadata.kt\ncom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata$Companion\n*L\n371#1:407\n371#1:408,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PaymentMethodMetadata createForPaymentElement$paymentsheet_release(@NotNull ElementsSession elementsSession, @NotNull CommonConfiguration configuration, @NotNull List<SharedDataSpec> sharedDataSpecs, @NotNull List<ExternalPaymentMethodSpec> externalPaymentMethodSpecs, boolean isGooglePayReady2, @Nullable LinkInlineConfiguration linkInlineConfiguration, @Nullable LinkState linkState2) {
            Intrinsics.checkNotNullParameter((Object)elementsSession, (String)"elementsSession");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter(sharedDataSpecs, (String)"sharedDataSpecs");
            Intrinsics.checkNotNullParameter(externalPaymentMethodSpecs, (String)"externalPaymentMethodSpecs");
            ElementsSession.LinkSettings linkSettings = elementsSession.getLinkSettings();
            CustomerMetadata customerMetadata = new CustomerMetadata(configuration.getCustomer() != null, this.getDefaultPaymentMethodsEnabled(elementsSession));
            StripeIntent stripeIntent = elementsSession.getStripeIntent();
            PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = configuration.getBillingDetailsCollectionConfiguration();
            boolean bl = configuration.getAllowsDelayedPaymentMethods();
            boolean bl2 = configuration.getAllowsPaymentMethodsRequiringShippingAddress();
            List<String> list = configuration.getPaymentMethodOrder();
            ElementsSession.CardBrandChoice cardBrandChoice = elementsSession.getCardBrandChoice();
            CardBrandChoiceEligibility cardBrandChoiceEligibility = CardBrandChoiceEligibility.Companion.create(cardBrandChoice != null ? cardBrandChoice.getEligible() : false, configuration.getPreferredNetworks());
            String string2 = configuration.getMerchantDisplayName();
            PaymentSheet.BillingDetails billingDetails = configuration.getDefaultBillingDetails();
            AddressDetails addressDetails = configuration.getShippingDetails();
            PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior = PaymentMethodMetadataKtxKt.toPaymentSheetSaveConsentBehavior(elementsSession);
            PaymentSheet.LinkConfiguration linkConfiguration = configuration.getLink();
            ElementsSession.LinkSettings linkSettings2 = linkSettings;
            LinkMode linkMode = linkSettings2 != null ? linkSettings2.getLinkMode() : null;
            ElementsSession.LinkSettings linkSettings3 = linkSettings;
            PaymentMethodIncentive paymentMethodIncentive = linkSettings3 != null && (linkSettings3 = linkSettings3.getLinkConsumerIncentive()) != null ? PaymentMethodIncentiveKt.toPaymentMethodIncentive((LinkConsumerIncentive)linkSettings3) : null;
            List<DisplayableCustomPaymentMethod> list2 = PaymentMethodMetadataKtxKt.toDisplayableCustomPaymentMethods(elementsSession, configuration);
            PaymentSheetCardBrandFilter paymentSheetCardBrandFilter = new PaymentSheetCardBrandFilter(configuration.getCardBrandAcceptance());
            FinancialConnectionsAvailability financialConnectionsAvailability = GetFinancialConnectionsAvailability.invoke$default((GetFinancialConnectionsAvailability)GetFinancialConnectionsAvailability.INSTANCE, (ElementsSession)elementsSession, null, (int)2, null);
            String string3 = elementsSession.getElementsSessionId();
            return new PaymentMethodMetadata(stripeIntent, billingDetailsCollectionConfiguration, bl, bl2, list, cardBrandChoiceEligibility, string2, billingDetails, addressDetails, sharedDataSpecs, list2, externalPaymentMethodSpecs, customerMetadata, isGooglePayReady2, linkConfiguration, linkInlineConfiguration, paymentMethodSaveConsentBehavior, linkMode, linkState2, paymentMethodIncentive, financialConnectionsAvailability, paymentSheetCardBrandFilter, string3);
        }

        @NotNull
        public final PaymentMethodMetadata createForCustomerSheet$paymentsheet_release(@NotNull ElementsSession elementsSession, @NotNull CustomerSheet.Configuration configuration, @NotNull PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior, @NotNull List<SharedDataSpec> sharedDataSpecs, boolean isGooglePayReady2, boolean isPaymentMethodSyncDefaultEnabled) {
            Intrinsics.checkNotNullParameter((Object)elementsSession, (String)"elementsSession");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)paymentMethodSaveConsentBehavior, (String)"paymentMethodSaveConsentBehavior");
            Intrinsics.checkNotNullParameter(sharedDataSpecs, (String)"sharedDataSpecs");
            StripeIntent stripeIntent = elementsSession.getStripeIntent();
            PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = configuration.getBillingDetailsCollectionConfiguration();
            List<String> list = configuration.getPaymentMethodOrder$paymentsheet_release();
            ElementsSession.CardBrandChoice cardBrandChoice = elementsSession.getCardBrandChoice();
            CardBrandChoiceEligibility cardBrandChoiceEligibility = CardBrandChoiceEligibility.Companion.create(cardBrandChoice != null ? cardBrandChoice.getEligible() : false, configuration.getPreferredNetworks());
            String string2 = configuration.getMerchantDisplayName();
            PaymentSheet.BillingDetails billingDetails = configuration.getDefaultBillingDetails();
            CustomerMetadata customerMetadata = new CustomerMetadata(true, isPaymentMethodSyncDefaultEnabled);
            PaymentSheet.LinkConfiguration linkConfiguration = new PaymentSheet.LinkConfiguration(null, 1, null);
            ElementsSession.LinkSettings linkSettings = elementsSession.getLinkSettings();
            LinkMode linkMode = linkSettings != null ? linkSettings.getLinkMode() : null;
            List list2 = CollectionsKt.emptyList();
            List list3 = CollectionsKt.emptyList();
            PaymentSheetCardBrandFilter paymentSheetCardBrandFilter = new PaymentSheetCardBrandFilter(configuration.getCardBrandAcceptance$paymentsheet_release());
            String string3 = elementsSession.getElementsSessionId();
            FinancialConnectionsAvailability financialConnectionsAvailability = GetFinancialConnectionsAvailability.invoke$default((GetFinancialConnectionsAvailability)GetFinancialConnectionsAvailability.INSTANCE, (ElementsSession)elementsSession, null, (int)2, null);
            return new PaymentMethodMetadata(stripeIntent, billingDetailsCollectionConfiguration, true, false, list, cardBrandChoiceEligibility, string2, billingDetails, null, sharedDataSpecs, list3, list2, customerMetadata, isGooglePayReady2, linkConfiguration, null, paymentMethodSaveConsentBehavior, linkMode, null, null, financialConnectionsAvailability, paymentSheetCardBrandFilter, string3);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PaymentMethodMetadata createForNativeLink$paymentsheet_release(@NotNull LinkConfiguration configuration) {
            List list;
            List list2;
            String string2;
            PaymentMethodSaveConsentBehavior.Disabled disabled;
            Iterable iterable;
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            StripeIntent stripeIntent = configuration.getStripeIntent();
            PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = ConfigurationDefaults.INSTANCE.getBillingDetailsCollectionConfiguration();
            List<String> list3 = ConfigurationDefaults.INSTANCE.getPaymentMethodOrder();
            CardBrandChoiceEligibility.Companion companion = CardBrandChoiceEligibility.Companion;
            LinkConfiguration.CardBrandChoice cardBrandChoice = configuration.getCardBrandChoice();
            boolean bl = cardBrandChoice != null ? cardBrandChoice.getEligible() : false;
            Object object = configuration.getCardBrandChoice();
            if (object != null && (object = ((LinkConfiguration.CardBrandChoice)object).getPreferredNetworks()) != null) {
                Collection<CardBrand> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                iterable = (Iterable)object;
                boolean bl2 = bl;
                CardBrandChoiceEligibility.Companion companion2 = companion;
                boolean $i$f$map = false;
                disabled = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void code;
                    string2 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(CardBrand.Companion.fromCode((String)code));
                }
                collection = (List)destination$iv$iv;
                companion = companion2;
                bl = bl2;
                list2 = collection;
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            CardBrandChoiceEligibility cardBrandChoiceEligibility = companion.create(bl, list);
            String string3 = configuration.getMerchantName();
            CustomerMetadata customerMetadata = new CustomerMetadata(true, false);
            iterable = CollectionsKt.emptyList();
            List list4 = CollectionsKt.emptyList();
            disabled = new PaymentMethodSaveConsentBehavior.Disabled(null);
            PaymentSheet.LinkConfiguration linkConfiguration = new PaymentSheet.LinkConfiguration(null, 1, null);
            List list5 = CollectionsKt.emptyList();
            PaymentSheetCardBrandFilter paymentSheetCardBrandFilter = new PaymentSheetCardBrandFilter(PaymentSheet.CardBrandAcceptance.Companion.all());
            String string4 = configuration.getElementsSessionId();
            string2 = GetFinancialConnectionsAvailability.invoke$default((GetFinancialConnectionsAvailability)GetFinancialConnectionsAvailability.INSTANCE, null, null, (int)2, null);
            return new PaymentMethodMetadata(stripeIntent, billingDetailsCollectionConfiguration, false, false, list3, cardBrandChoiceEligibility, string3, null, null, (List<SharedDataSpec>)iterable, list5, list4, customerMetadata, false, linkConfiguration, null, disabled, null, null, null, (FinancialConnectionsAvailability)string2, paymentSheetCardBrandFilter, string4);
        }

        private final boolean getDefaultPaymentMethodsEnabled(ElementsSession elementsSession) {
            ElementsSession.Customer.Components.MobilePaymentElement.Enabled mobilePaymentElement;
            ElementsSession.Customer customer2 = elementsSession.getCustomer();
            ElementsSession.Customer.Components.MobilePaymentElement mobilePaymentElement2 = customer2 != null && (customer2 = customer2.getSession()) != null && (customer2 = customer2.getComponents()) != null ? customer2.getMobilePaymentElement() : null;
            ElementsSession.Customer.Components.MobilePaymentElement.Enabled enabled = mobilePaymentElement = mobilePaymentElement2 instanceof ElementsSession.Customer.Components.MobilePaymentElement.Enabled ? (ElementsSession.Customer.Components.MobilePaymentElement.Enabled)mobilePaymentElement2 : null;
            return enabled != null ? enabled.isPaymentMethodSetAsDefaultEnabled() : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

