/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.lpmfoundations.paymentmethod;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.CardBrandFilter;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentSheetCardBrandFilterKt;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.PaymentSheet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\t\u0010\f\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0013\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentSheetCardBrandFilter;", "Lcom/stripe/android/CardBrandFilter;", "cardBrandAcceptance", "Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;", "<init>", "(Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;)V", "isAccepted", "", "cardBrand", "Lcom/stripe/android/model/CardBrand;", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "component1", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
@Parcelize
@StabilityInferred(parameters=0)
public final class PaymentSheetCardBrandFilter
implements CardBrandFilter {
    @NotNull
    private final PaymentSheet.CardBrandAcceptance cardBrandAcceptance;
    @NotNull
    public static final Parcelable.Creator<PaymentSheetCardBrandFilter> CREATOR;
    public static final int $stable;

    public PaymentSheetCardBrandFilter(@NotNull PaymentSheet.CardBrandAcceptance cardBrandAcceptance) {
        Intrinsics.checkNotNullParameter((Object)cardBrandAcceptance, (String)"cardBrandAcceptance");
        this.cardBrandAcceptance = cardBrandAcceptance;
    }

    public boolean isAccepted(@NotNull CardBrand cardBrand) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)cardBrand, (String)"cardBrand");
        PaymentSheet.CardBrandAcceptance.BrandCategory brandCategory = PaymentSheetCardBrandFilterKt.toBrandCategory(cardBrand);
        PaymentSheet.CardBrandAcceptance cardBrandAcceptance = this.cardBrandAcceptance;
        if (cardBrandAcceptance instanceof PaymentSheet.CardBrandAcceptance.All) {
            bl = true;
        } else if (cardBrandAcceptance instanceof PaymentSheet.CardBrandAcceptance.Allowed) {
            boolean isAllowed;
            bl = isAllowed = brandCategory != null && ((PaymentSheet.CardBrandAcceptance.Allowed)this.cardBrandAcceptance).getBrands().contains((Object)brandCategory);
        } else if (cardBrandAcceptance instanceof PaymentSheet.CardBrandAcceptance.Disallowed) {
            boolean isDisallowed;
            boolean bl2 = isDisallowed = brandCategory != null && ((PaymentSheet.CardBrandAcceptance.Disallowed)this.cardBrandAcceptance).getBrands().contains((Object)brandCategory);
            bl = !isDisallowed;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public final boolean isAccepted(@NotNull PaymentMethod paymentMethod) {
        Object object;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
                object = paymentMethod.card;
                if (object == null || (object = object.displayBrand) == null) break block3;
                Object displayBrand = object;
                boolean bl = false;
                CardBrand cardBrand = CardBrand.Companion.fromCode((String)displayBrand);
                CardBrand cardBrand2 = cardBrand == CardBrand.Unknown ? null : cardBrand;
                object = cardBrand2;
                if (cardBrand2 != null) break block4;
            }
            PaymentMethod.Card card = paymentMethod.card;
            object = card != null ? card.brand : CardBrand.Unknown;
        }
        Object brand = object;
        return paymentMethod.type != PaymentMethod.Type.Card || this.isAccepted((CardBrand)brand);
    }

    public final void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeParcelable((Parcelable)this.cardBrandAcceptance, flags);
    }

    public final int describeContents() {
        return 0;
    }

    private final PaymentSheet.CardBrandAcceptance component1() {
        return this.cardBrandAcceptance;
    }

    @NotNull
    public final PaymentSheetCardBrandFilter copy(@NotNull PaymentSheet.CardBrandAcceptance cardBrandAcceptance) {
        Intrinsics.checkNotNullParameter((Object)cardBrandAcceptance, (String)"cardBrandAcceptance");
        return new PaymentSheetCardBrandFilter(cardBrandAcceptance);
    }

    public static /* synthetic */ PaymentSheetCardBrandFilter copy$default(PaymentSheetCardBrandFilter paymentSheetCardBrandFilter, PaymentSheet.CardBrandAcceptance cardBrandAcceptance, int n, Object object) {
        if ((n & 1) != 0) {
            cardBrandAcceptance = paymentSheetCardBrandFilter.cardBrandAcceptance;
        }
        return paymentSheetCardBrandFilter.copy(cardBrandAcceptance);
    }

    @NotNull
    public String toString() {
        return "PaymentSheetCardBrandFilter(cardBrandAcceptance=" + this.cardBrandAcceptance + ")";
    }

    public int hashCode() {
        return this.cardBrandAcceptance.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PaymentSheetCardBrandFilter)) {
            return false;
        }
        PaymentSheetCardBrandFilter paymentSheetCardBrandFilter = (PaymentSheetCardBrandFilter)other;
        return Intrinsics.areEqual((Object)this.cardBrandAcceptance, (Object)paymentSheetCardBrandFilter.cardBrandAcceptance);
    }

    static {
        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<PaymentSheetCardBrandFilter> {
            public final PaymentSheetCardBrandFilter[] newArray(int size) {
                return new PaymentSheetCardBrandFilter[size];
            }

            public final PaymentSheetCardBrandFilter createFromParcel(Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new PaymentSheetCardBrandFilter((PaymentSheet.CardBrandAcceptance)parcel.readParcelable(PaymentSheetCardBrandFilter.class.getClassLoader()));
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }
}

