/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentelement.confirmation.epms;

import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.common.exception.ExceptionKtKt;
import com.stripe.android.paymentelement.callbacks.PaymentElementCallbackIdentifier;
import com.stripe.android.paymentelement.confirmation.ConfirmationDefinition;
import com.stripe.android.paymentelement.confirmation.ConfirmationHandler;
import com.stripe.android.paymentelement.confirmation.epms.ExternalPaymentMethodConfirmationOption;
import com.stripe.android.paymentelement.confirmation.intent.DeferredIntentConfirmationType;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import com.stripe.android.payments.paymentlauncher.PaymentResult;
import com.stripe.android.paymentsheet.ExternalPaymentMethodConfirmHandler;
import com.stripe.android.paymentsheet.ExternalPaymentMethodContract;
import com.stripe.android.paymentsheet.ExternalPaymentMethodInput;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001B+\b\u0007\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001aJ*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00050\u001fH\u0016J3\u0010 \u001a\u00020\u00052\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010#J*\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u0006H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Lcom/stripe/android/paymentelement/confirmation/epms/ExternalPaymentMethodConfirmationDefinition;", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition;", "Lcom/stripe/android/paymentelement/confirmation/epms/ExternalPaymentMethodConfirmationOption;", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/paymentsheet/ExternalPaymentMethodInput;", "", "Lcom/stripe/android/payments/paymentlauncher/PaymentResult;", "paymentElementCallbackIdentifier", "", "externalPaymentMethodConfirmHandlerProvider", "Ljavax/inject/Provider;", "Lcom/stripe/android/paymentsheet/ExternalPaymentMethodConfirmHandler;", "errorReporter", "Lcom/stripe/android/payments/core/analytics/ErrorReporter;", "<init>", "(Ljava/lang/String;Ljavax/inject/Provider;Lcom/stripe/android/payments/core/analytics/ErrorReporter;)V", "key", "getKey", "()Ljava/lang/String;", "option", "confirmationOption", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler$Option;", "action", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Action;", "confirmationParameters", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Parameters;", "(Lcom/stripe/android/paymentelement/confirmation/epms/ExternalPaymentMethodConfirmationOption;Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Parameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createLauncher", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "onResult", "Lkotlin/Function1;", "launch", "launcher", "arguments", "(Landroidx/activity/result/ActivityResultLauncher;Lkotlin/Unit;Lcom/stripe/android/paymentelement/confirmation/epms/ExternalPaymentMethodConfirmationOption;Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Parameters;)V", "toResult", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Result;", "deferredIntentConfirmationType", "Lcom/stripe/android/paymentelement/confirmation/intent/DeferredIntentConfirmationType;", "result", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class ExternalPaymentMethodConfirmationDefinition
implements ConfirmationDefinition<ExternalPaymentMethodConfirmationOption, ActivityResultLauncher<ExternalPaymentMethodInput>, Unit, PaymentResult> {
    @NotNull
    private final String paymentElementCallbackIdentifier;
    @NotNull
    private final Provider<ExternalPaymentMethodConfirmHandler> externalPaymentMethodConfirmHandlerProvider;
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    private final String key;
    public static final int $stable = 8;

    @Inject
    public ExternalPaymentMethodConfirmationDefinition(@PaymentElementCallbackIdentifier @NotNull String paymentElementCallbackIdentifier, @NotNull Provider<ExternalPaymentMethodConfirmHandler> externalPaymentMethodConfirmHandlerProvider, @NotNull ErrorReporter errorReporter) {
        Intrinsics.checkNotNullParameter((Object)paymentElementCallbackIdentifier, (String)"paymentElementCallbackIdentifier");
        Intrinsics.checkNotNullParameter(externalPaymentMethodConfirmHandlerProvider, (String)"externalPaymentMethodConfirmHandlerProvider");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        this.paymentElementCallbackIdentifier = paymentElementCallbackIdentifier;
        this.externalPaymentMethodConfirmHandlerProvider = externalPaymentMethodConfirmHandlerProvider;
        this.errorReporter = errorReporter;
        this.key = "ExternalPaymentMethod";
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public ExternalPaymentMethodConfirmationOption option(@NotNull ConfirmationHandler.Option confirmationOption2) {
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        return confirmationOption2 instanceof ExternalPaymentMethodConfirmationOption ? (ExternalPaymentMethodConfirmationOption)confirmationOption2 : null;
    }

    @Override
    @Nullable
    public Object action(@NotNull ExternalPaymentMethodConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters, @NotNull Continuation<? super ConfirmationDefinition.Action<Unit>> $completion) {
        ConfirmationDefinition.Action action2;
        String externalPaymentMethodType = confirmationOption2.getType();
        ExternalPaymentMethodConfirmHandler externalPaymentMethodConfirmHandler = (ExternalPaymentMethodConfirmHandler)this.externalPaymentMethodConfirmHandlerProvider.get();
        if (externalPaymentMethodConfirmHandler == null) {
            ErrorReporter.DefaultImpls.report$default((ErrorReporter)this.errorReporter, (ErrorReporter.ErrorEvent)((ErrorReporter.ErrorEvent)ErrorReporter.ExpectedErrorEvent.EXTERNAL_PAYMENT_METHOD_CONFIRM_HANDLER_NULL), null, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"external_payment_method_type", (Object)externalPaymentMethodType)), (int)2, null);
            IllegalStateException error = new IllegalStateException("externalPaymentMethodConfirmHandler is null. Cannot process payment for payment selection: " + externalPaymentMethodType);
            action2 = new ConfirmationDefinition.Action.Fail(error, ExceptionKtKt.stripeErrorMessage(error), ConfirmationHandler.Result.Failed.ErrorType.ExternalPaymentMethod.INSTANCE);
        } else {
            Unit unit = Unit.INSTANCE;
            action2 = new ConfirmationDefinition.Action.Launch<Unit>(unit, false, null);
        }
        return action2;
    }

    @Override
    @NotNull
    public ActivityResultLauncher<ExternalPaymentMethodInput> createLauncher(@NotNull ActivityResultCaller activityResultCaller, @NotNull Function1<? super PaymentResult, Unit> onResult2) {
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        Intrinsics.checkNotNullParameter(onResult2, (String)"onResult");
        return activityResultCaller.registerForActivityResult((ActivityResultContract)new ExternalPaymentMethodContract(this.errorReporter), new ActivityResultCallback(onResult2){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onActivityResult(Object result2) {
                this.function.invoke(result2);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof ActivityResultCallback ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
    }

    @Override
    public void launch(@NotNull ActivityResultLauncher<ExternalPaymentMethodInput> launcher, @NotNull Unit arguments, @NotNull ExternalPaymentMethodConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters) {
        Intrinsics.checkNotNullParameter(launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        Intrinsics.checkNotNullParameter((Object)confirmationParameters, (String)"confirmationParameters");
        ErrorReporter.DefaultImpls.report$default((ErrorReporter)this.errorReporter, (ErrorReporter.ErrorEvent)((ErrorReporter.ErrorEvent)ErrorReporter.SuccessEvent.EXTERNAL_PAYMENT_METHODS_LAUNCH_SUCCESS), null, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"external_payment_method_type", (Object)confirmationOption2.getType())), (int)2, null);
        launcher.launch((Object)new ExternalPaymentMethodInput(this.paymentElementCallbackIdentifier, confirmationOption2.getType(), confirmationOption2.getBillingDetails()));
    }

    @Override
    @NotNull
    public ConfirmationDefinition.Result toResult(@NotNull ExternalPaymentMethodConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters, @Nullable DeferredIntentConfirmationType deferredIntentConfirmationType, @NotNull PaymentResult result2) {
        ConfirmationDefinition.Result result3;
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        Intrinsics.checkNotNullParameter((Object)confirmationParameters, (String)"confirmationParameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PaymentResult paymentResult = result2;
        if (paymentResult instanceof PaymentResult.Completed) {
            result3 = new ConfirmationDefinition.Result.Succeeded(confirmationParameters.getIntent(), null);
        } else if (paymentResult instanceof PaymentResult.Failed) {
            result3 = new ConfirmationDefinition.Result.Failed(((PaymentResult.Failed)result2).getThrowable(), ExceptionKtKt.stripeErrorMessage(((PaymentResult.Failed)result2).getThrowable()), ConfirmationHandler.Result.Failed.ErrorType.ExternalPaymentMethod.INSTANCE);
        } else if (paymentResult instanceof PaymentResult.Canceled) {
            result3 = new ConfirmationDefinition.Result.Canceled(ConfirmationHandler.Result.Canceled.Action.None);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result3;
    }

    @Override
    public boolean canConfirm(@NotNull ExternalPaymentMethodConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters) {
        return ConfirmationDefinition.DefaultImpls.canConfirm(this, (ConfirmationHandler.Option)confirmationOption2, confirmationParameters);
    }

    @Override
    public void unregister(@NotNull ActivityResultLauncher<ExternalPaymentMethodInput> launcher) {
        ConfirmationDefinition.DefaultImpls.unregister(this, launcher);
    }
}

