/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentelement.confirmation.gpay;

import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.R;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.core.utils.UserFacingLogger;
import com.stripe.android.googlepaylauncher.GooglePayEnvironment;
import com.stripe.android.googlepaylauncher.GooglePayPaymentMethodLauncher;
import com.stripe.android.googlepaylauncher.GooglePayPaymentMethodLauncherContractV2;
import com.stripe.android.googlepaylauncher.injection.GooglePayPaymentMethodLauncherFactory;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentelement.confirmation.ConfirmationDefinition;
import com.stripe.android.paymentelement.confirmation.ConfirmationHandler;
import com.stripe.android.paymentelement.confirmation.PaymentMethodConfirmationOption;
import com.stripe.android.paymentelement.confirmation.gpay.GooglePayConfirmationOption;
import com.stripe.android.paymentelement.confirmation.intent.DeferredIntentConfirmationType;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.state.PaymentElementLoader;
import javax.inject.Inject;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00050\u001dH\u0016J3\u0010\u001e\u001a\u00020\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010!J*\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0006H\u0016J&\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010-\u001a\u0004\u0018\u00010.*\u00020/H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u00100\u001a\u000201*\u0002028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00103\u00a8\u00064"}, d2={"Lcom/stripe/android/paymentelement/confirmation/gpay/GooglePayConfirmationDefinition;", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition;", "Lcom/stripe/android/paymentelement/confirmation/gpay/GooglePayConfirmationOption;", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherContractV2$Args;", "", "Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncher$Result;", "googlePayPaymentMethodLauncherFactory", "Lcom/stripe/android/googlepaylauncher/injection/GooglePayPaymentMethodLauncherFactory;", "userFacingLogger", "Lcom/stripe/android/core/utils/UserFacingLogger;", "<init>", "(Lcom/stripe/android/googlepaylauncher/injection/GooglePayPaymentMethodLauncherFactory;Lcom/stripe/android/core/utils/UserFacingLogger;)V", "key", "", "getKey", "()Ljava/lang/String;", "option", "confirmationOption", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler$Option;", "action", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Action;", "confirmationParameters", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Parameters;", "(Lcom/stripe/android/paymentelement/confirmation/gpay/GooglePayConfirmationOption;Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Parameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createLauncher", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "onResult", "Lkotlin/Function1;", "launch", "launcher", "arguments", "(Landroidx/activity/result/ActivityResultLauncher;Lkotlin/Unit;Lcom/stripe/android/paymentelement/confirmation/gpay/GooglePayConfirmationOption;Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Parameters;)V", "toResult", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Result;", "deferredIntentConfirmationType", "Lcom/stripe/android/paymentelement/confirmation/intent/DeferredIntentConfirmationType;", "result", "createGooglePayLauncher", "Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncher;", "factory", "activityLauncher", "config", "Lcom/stripe/android/paymentelement/confirmation/gpay/GooglePayConfirmationOption$Config;", "asPaymentIntent", "Lcom/stripe/android/model/PaymentIntent;", "Lcom/stripe/android/model/StripeIntent;", "isProcessingPayment", "", "Lcom/stripe/android/paymentsheet/state/PaymentElementLoader$InitializationMode;", "(Lcom/stripe/android/paymentsheet/state/PaymentElementLoader$InitializationMode;)Z", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class GooglePayConfirmationDefinition
implements ConfirmationDefinition<GooglePayConfirmationOption, ActivityResultLauncher<GooglePayPaymentMethodLauncherContractV2.Args>, Unit, GooglePayPaymentMethodLauncher.Result> {
    @NotNull
    private final GooglePayPaymentMethodLauncherFactory googlePayPaymentMethodLauncherFactory;
    @Nullable
    private final UserFacingLogger userFacingLogger;
    @NotNull
    private final String key;
    public static final int $stable = 8;

    @Inject
    public GooglePayConfirmationDefinition(@NotNull GooglePayPaymentMethodLauncherFactory googlePayPaymentMethodLauncherFactory, @Nullable UserFacingLogger userFacingLogger) {
        Intrinsics.checkNotNullParameter((Object)googlePayPaymentMethodLauncherFactory, (String)"googlePayPaymentMethodLauncherFactory");
        this.googlePayPaymentMethodLauncherFactory = googlePayPaymentMethodLauncherFactory;
        this.userFacingLogger = userFacingLogger;
        this.key = "GooglePay";
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public GooglePayConfirmationOption option(@NotNull ConfirmationHandler.Option confirmationOption2) {
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        return confirmationOption2 instanceof GooglePayConfirmationOption ? (GooglePayConfirmationOption)confirmationOption2 : null;
    }

    @Override
    @Nullable
    public Object action(@NotNull GooglePayConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters, @NotNull Continuation<? super ConfirmationDefinition.Action<Unit>> $completion) {
        if (confirmationOption2.getConfig().getMerchantCurrencyCode() == null && !this.isProcessingPayment(confirmationParameters.getInitializationMode())) {
            String message = "GooglePayConfig.currencyCode is required in order to use Google Pay when processing a Setup Intent";
            UserFacingLogger userFacingLogger = this.userFacingLogger;
            if (userFacingLogger != null) {
                userFacingLogger.logWarningWithoutPii(message);
            }
            return new ConfirmationDefinition.Action.Fail(new IllegalStateException(message), ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_something_went_wrong), ConfirmationHandler.Result.Failed.ErrorType.MerchantIntegration.INSTANCE);
        }
        return new ConfirmationDefinition.Action.Launch<Unit>(Unit.INSTANCE, true, null);
    }

    @Override
    @NotNull
    public ActivityResultLauncher<GooglePayPaymentMethodLauncherContractV2.Args> createLauncher(@NotNull ActivityResultCaller activityResultCaller, @NotNull Function1<? super GooglePayPaymentMethodLauncher.Result, Unit> onResult2) {
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        Intrinsics.checkNotNullParameter(onResult2, (String)"onResult");
        return activityResultCaller.registerForActivityResult((ActivityResultContract)new GooglePayPaymentMethodLauncherContractV2(), new ActivityResultCallback(onResult2){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onActivityResult(Object result2) {
                this.function.invoke(result2);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof ActivityResultCallback ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
    }

    @Override
    public void launch(@NotNull ActivityResultLauncher<GooglePayPaymentMethodLauncherContractV2.Args> launcher, @NotNull Unit arguments, @NotNull GooglePayConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters) {
        long l;
        StripeIntent stripeIntent;
        Intrinsics.checkNotNullParameter(launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        Intrinsics.checkNotNullParameter((Object)confirmationParameters, (String)"confirmationParameters");
        GooglePayConfirmationOption.Config config = confirmationOption2.getConfig();
        StripeIntent intent = confirmationParameters.getIntent();
        GooglePayPaymentMethodLauncher googlePayLauncher = this.createGooglePayLauncher(this.googlePayPaymentMethodLauncherFactory, launcher, confirmationOption2.getConfig());
        Object object = this.asPaymentIntent(intent);
        if ((object == null || (object = object.getCurrency()) == null) && (object = config.getMerchantCurrencyCode()) == null) {
            object = "";
        }
        if ((stripeIntent = intent) instanceof PaymentIntent) {
            Long l2 = ((PaymentIntent)intent).getAmount();
            l = l2 != null ? l2 : 0L;
        } else if (stripeIntent instanceof SetupIntent) {
            Long l3 = config.getCustomAmount();
            l = l3 != null ? l3 : 0L;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        googlePayLauncher.present((String)object, l, intent.getId(), config.getCustomLabel());
    }

    @Override
    @NotNull
    public ConfirmationDefinition.Result toResult(@NotNull GooglePayConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters, @Nullable DeferredIntentConfirmationType deferredIntentConfirmationType, @NotNull GooglePayPaymentMethodLauncher.Result result2) {
        ConfirmationDefinition.Result result3;
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        Intrinsics.checkNotNullParameter((Object)confirmationParameters, (String)"confirmationParameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        GooglePayPaymentMethodLauncher.Result result4 = result2;
        if (result4 instanceof GooglePayPaymentMethodLauncher.Result.Completed) {
            PaymentMethodConfirmationOption.Saved nextConfirmationOption = new PaymentMethodConfirmationOption.Saved(((GooglePayPaymentMethodLauncher.Result.Completed)result2).getPaymentMethod(), null);
            result3 = new ConfirmationDefinition.Result.NextStep(nextConfirmationOption, confirmationParameters);
        } else if (result4 instanceof GooglePayPaymentMethodLauncher.Result.Failed) {
            result3 = new ConfirmationDefinition.Result.Failed(((GooglePayPaymentMethodLauncher.Result.Failed)result2).getError(), ((GooglePayPaymentMethodLauncher.Result.Failed)result2).getErrorCode() == 3 ? ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_failure_connection_error) : ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_internal_error), new ConfirmationHandler.Result.Failed.ErrorType.GooglePay(((GooglePayPaymentMethodLauncher.Result.Failed)result2).getErrorCode()));
        } else if (result4 instanceof GooglePayPaymentMethodLauncher.Result.Canceled) {
            result3 = new ConfirmationDefinition.Result.Canceled(ConfirmationHandler.Result.Canceled.Action.InformCancellation);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result3;
    }

    private final GooglePayPaymentMethodLauncher createGooglePayLauncher(GooglePayPaymentMethodLauncherFactory factory, ActivityResultLauncher<GooglePayPaymentMethodLauncherContractV2.Args> activityLauncher, GooglePayConfirmationOption.Config config) {
        PaymentSheet.GooglePayConfiguration.Environment environment = config.getEnvironment();
        return factory.create(CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), new GooglePayPaymentMethodLauncher.Config((environment == null ? -1 : WhenMappings.$EnumSwitchMapping$0[environment.ordinal()]) == 1 ? GooglePayEnvironment.Production : GooglePayEnvironment.Test, config.getMerchantCountryCode(), config.getMerchantName(), config.getBillingDetailsCollectionConfiguration().getCollectsEmail$paymentsheet_release(), config.getBillingDetailsCollectionConfiguration().toBillingAddressConfig$paymentsheet_release(), false, false, 96, null), GooglePayConfirmationDefinition::createGooglePayLauncher$lambda$0, activityLauncher, true, config.getCardBrandFilter());
    }

    private final PaymentIntent asPaymentIntent(StripeIntent $this$asPaymentIntent) {
        return $this$asPaymentIntent instanceof PaymentIntent ? (PaymentIntent)$this$asPaymentIntent : null;
    }

    private final boolean isProcessingPayment(PaymentElementLoader.InitializationMode $this$isProcessingPayment) {
        boolean bl;
        PaymentElementLoader.InitializationMode initializationMode = $this$isProcessingPayment;
        if (initializationMode instanceof PaymentElementLoader.InitializationMode.PaymentIntent) {
            bl = true;
        } else if (initializationMode instanceof PaymentElementLoader.InitializationMode.SetupIntent) {
            bl = false;
        } else if (initializationMode instanceof PaymentElementLoader.InitializationMode.DeferredIntent) {
            bl = ((PaymentElementLoader.InitializationMode.DeferredIntent)$this$isProcessingPayment).getIntentConfiguration().getMode() instanceof PaymentSheet.IntentConfiguration.Mode.Payment;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public boolean canConfirm(@NotNull GooglePayConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters) {
        return ConfirmationDefinition.DefaultImpls.canConfirm(this, (ConfirmationHandler.Option)confirmationOption2, confirmationParameters);
    }

    @Override
    public void unregister(@NotNull ActivityResultLauncher<GooglePayPaymentMethodLauncherContractV2.Args> launcher) {
        ConfirmationDefinition.DefaultImpls.unregister(this, launcher);
    }

    private static final void createGooglePayLauncher$lambda$0(boolean it) {
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaymentSheet.GooglePayConfiguration.Environment.values().length];
            try {
                nArray[PaymentSheet.GooglePayConfiguration.Environment.Production.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

