/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentelement.confirmation.intent;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/paymentelement/confirmation/intent/InvalidClientSecretException;", "Lcom/stripe/android/core/exception/StripeException;", "clientSecret", "", "intent", "Lcom/stripe/android/model/StripeIntent;", "<init>", "(Ljava/lang/String;Lcom/stripe/android/model/StripeIntent;)V", "getClientSecret", "()Ljava/lang/String;", "getIntent", "()Lcom/stripe/android/model/StripeIntent;", "intentType", "analyticsValue", "message", "getMessage", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class InvalidClientSecretException
extends StripeException {
    @NotNull
    private final String clientSecret;
    @NotNull
    private final StripeIntent intent;
    @NotNull
    private final String intentType;
    @NotNull
    private final String message;
    public static final int $stable = 8;

    public InvalidClientSecretException(@NotNull String clientSecret, @NotNull StripeIntent intent) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        super(null, null, 0, null, null, 31, null);
        this.clientSecret = clientSecret;
        StripeIntent stripeIntent = this.intent = intent;
        if (stripeIntent instanceof PaymentIntent) {
            string2 = "PaymentIntent";
        } else if (stripeIntent instanceof SetupIntent) {
            string2 = "SetupIntent";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.intentType = string2;
        this.message = StringsKt.trimIndent((String)("\n        Encountered an invalid client secret \"" + this.clientSecret + "\" for intent type \"" + this.intentType + "\"\n    "));
    }

    @NotNull
    public final String getClientSecret() {
        return this.clientSecret;
    }

    @NotNull
    public final StripeIntent getIntent() {
        return this.intent;
    }

    @NotNull
    public String analyticsValue() {
        return "invalidClientSecretProvided";
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }
}

