/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import android.app.Application;
import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateHandleSupport;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.stripe.android.analytics.SessionSavedStateHandler;
import com.stripe.android.cards.CardAccountRangeRepository;
import com.stripe.android.core.injection.IOContext;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.utils.CreationExtrasKtxKt;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadata;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.paymentsheet.CustomerStateHolder;
import com.stripe.android.paymentsheet.LinkHandler;
import com.stripe.android.paymentsheet.NewPaymentOptionSelection;
import com.stripe.android.paymentsheet.PaymentOptionContract;
import com.stripe.android.paymentsheet.PaymentOptionResult;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.injection.DaggerPaymentOptionsViewModelFactoryComponent;
import com.stripe.android.paymentsheet.injection.PaymentOptionsViewModelSubcomponent;
import com.stripe.android.paymentsheet.model.GooglePayButtonType;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.navigation.PaymentSheetScreen;
import com.stripe.android.paymentsheet.repositories.CustomerRepository;
import com.stripe.android.paymentsheet.state.WalletsProcessingState;
import com.stripe.android.paymentsheet.state.WalletsState;
import com.stripe.android.paymentsheet.ui.AddPaymentMethodInteractor;
import com.stripe.android.paymentsheet.ui.DefaultAddPaymentMethodInteractor;
import com.stripe.android.paymentsheet.ui.DefaultSelectSavedPaymentMethodsInteractor;
import com.stripe.android.paymentsheet.ui.PrimaryButton;
import com.stripe.android.paymentsheet.ui.SelectSavedPaymentMethodsInteractor;
import com.stripe.android.paymentsheet.verticalmode.VerticalModeInitialScreenFactory;
import com.stripe.android.paymentsheet.viewmodels.BaseSheetViewModel;
import com.stripe.android.paymentsheet.viewmodels.PrimaryButtonUiStateMapper;
import com.stripe.android.ui.core.Amount;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001CBC\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u00101\u001a\u000202H\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0002J\u000e\u00105\u001a\u0004\u0018\u000106*\u000206H\u0002J\u0012\u00107\u001a\u0002022\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0016J\u0006\u00108\u001a\u000202J\u0012\u00109\u001a\u0002022\b\u0010:\u001a\u0004\u0018\u000104H\u0016J\b\u0010;\u001a\u000202H\u0016J\u001e\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010!R\u001c\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010&0\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010!R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010!\u00a8\u0006D"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel;", "Lcom/stripe/android/paymentsheet/viewmodels/BaseSheetViewModel;", "args", "Lcom/stripe/android/paymentsheet/PaymentOptionContract$Args;", "eventReporter", "Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "customerRepository", "Lcom/stripe/android/paymentsheet/repositories/CustomerRepository;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "linkHandler", "Lcom/stripe/android/paymentsheet/LinkHandler;", "cardAccountRangeRepositoryFactory", "Lcom/stripe/android/cards/CardAccountRangeRepository$Factory;", "<init>", "(Lcom/stripe/android/paymentsheet/PaymentOptionContract$Args;Lcom/stripe/android/paymentsheet/analytics/EventReporter;Lcom/stripe/android/paymentsheet/repositories/CustomerRepository;Lkotlin/coroutines/CoroutineContext;Landroidx/lifecycle/SavedStateHandle;Lcom/stripe/android/paymentsheet/LinkHandler;Lcom/stripe/android/cards/CardAccountRangeRepository$Factory;)V", "primaryButtonUiStateMapper", "Lcom/stripe/android/paymentsheet/viewmodels/PrimaryButtonUiStateMapper;", "_paymentOptionResult", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/stripe/android/paymentsheet/PaymentOptionResult;", "paymentOptionResult", "Lkotlinx/coroutines/flow/SharedFlow;", "getPaymentOptionResult$paymentsheet_release", "()Lkotlinx/coroutines/flow/SharedFlow;", "_error", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/android/core/strings/ResolvableString;", "error", "Lkotlinx/coroutines/flow/StateFlow;", "getError", "()Lkotlinx/coroutines/flow/StateFlow;", "walletsProcessingState", "Lcom/stripe/android/paymentsheet/state/WalletsProcessingState;", "getWalletsProcessingState", "walletsState", "Lcom/stripe/android/paymentsheet/state/WalletsState;", "getWalletsState", "newPaymentSelection", "Lcom/stripe/android/paymentsheet/NewPaymentOptionSelection;", "getNewPaymentSelection", "()Lcom/stripe/android/paymentsheet/NewPaymentOptionSelection;", "setNewPaymentSelection", "(Lcom/stripe/android/paymentsheet/NewPaymentOptionSelection;)V", "primaryButtonUiState", "Lcom/stripe/android/paymentsheet/ui/PrimaryButton$UIState;", "getPrimaryButtonUiState", "onUserCancel", "", "determinePaymentSelectionUponCancel", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "takeIfStillValid", "Lcom/stripe/android/paymentsheet/model/PaymentSelection$Saved;", "onError", "onUserSelection", "handlePaymentMethodSelected", "selection", "clearErrorMessages", "determineInitialBackStack", "", "Lcom/stripe/android/paymentsheet/navigation/PaymentSheetScreen;", "paymentMethodMetadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "customerStateHolder", "Lcom/stripe/android/paymentsheet/CustomerStateHolder;", "Factory", "paymentsheet_release"})
@JvmSuppressWildcards
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPaymentOptionsViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentOptionsViewModel.kt\ncom/stripe/android/paymentsheet/PaymentOptionsViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,276:1\n295#2,2:277\n*S KotlinDebug\n*F\n+ 1 PaymentOptionsViewModel.kt\ncom/stripe/android/paymentsheet/PaymentOptionsViewModel\n*L\n167#1:277,2\n*E\n"})
public final class PaymentOptionsViewModel
extends BaseSheetViewModel {
    @NotNull
    private final PaymentOptionContract.Args args;
    @NotNull
    private final PrimaryButtonUiStateMapper primaryButtonUiStateMapper;
    @NotNull
    private final MutableSharedFlow<PaymentOptionResult> _paymentOptionResult;
    @NotNull
    private final SharedFlow<PaymentOptionResult> paymentOptionResult;
    @NotNull
    private final MutableStateFlow<ResolvableString> _error;
    @NotNull
    private final StateFlow<ResolvableString> error;
    @NotNull
    private final StateFlow<WalletsProcessingState> walletsProcessingState;
    @NotNull
    private final StateFlow<WalletsState> walletsState;
    @Nullable
    private NewPaymentOptionSelection newPaymentSelection;
    @NotNull
    private final StateFlow<PrimaryButton.UIState> primaryButtonUiState;
    public static final int $stable = 8;

    @Inject
    public PaymentOptionsViewModel(@NotNull PaymentOptionContract.Args args, @NotNull EventReporter eventReporter, @NotNull CustomerRepository customerRepository, @IOContext @NotNull CoroutineContext workContext, @NotNull SavedStateHandle savedStateHandle, @NotNull LinkHandler linkHandler, @NotNull CardAccountRangeRepository.Factory cardAccountRangeRepositoryFactory) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)eventReporter, (String)"eventReporter");
        Intrinsics.checkNotNullParameter((Object)customerRepository, (String)"customerRepository");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)linkHandler, (String)"linkHandler");
        Intrinsics.checkNotNullParameter((Object)cardAccountRangeRepositoryFactory, (String)"cardAccountRangeRepositoryFactory");
        super(args.getConfiguration(), eventReporter, customerRepository, workContext, savedStateHandle, linkHandler, cardAccountRangeRepositoryFactory, false);
        this.args = args;
        this.primaryButtonUiStateMapper = new PrimaryButtonUiStateMapper(this.getConfig(), this.args.getState().getStripeIntent() instanceof PaymentIntent, this.getNavigationHandler().getCurrentScreen(), this.getButtonsEnabled(), (StateFlow<Amount>)StateFlowsKt.stateFlowOf((Object)this.args.getState().getPaymentMethodMetadata().amount()), this.getSelection$paymentsheet_release(), (StateFlow<PrimaryButton.UIState>)((StateFlow)this.getCustomPrimaryButtonUiState()), this.getCvcRecollectionCompleteFlow$paymentsheet_release(), (Function0<Unit>)((Function0)() -> PaymentOptionsViewModel.primaryButtonUiStateMapper$lambda$0(eventReporter, this)));
        this._paymentOptionResult = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        this.paymentOptionResult = (SharedFlow)this._paymentOptionResult;
        this._error = StateFlowKt.MutableStateFlow(null);
        this.error = (StateFlow)this._error;
        this.walletsProcessingState = FlowKt.asStateFlow((MutableStateFlow)StateFlowKt.MutableStateFlow(null));
        this.walletsState = StateFlowsKt.combineAsStateFlow(linkHandler.isLinkEnabled(), linkHandler.getLinkConfigurationCoordinator().getEmailFlow(), this.getButtonsEnabled(), (arg_0, arg_1, arg_2) -> PaymentOptionsViewModel.walletsState$lambda$3(this, arg_0, arg_1, arg_2));
        PaymentSelection selection = this.args.getState().getPaymentSelection();
        this.newPaymentSelection = selection instanceof PaymentSelection.New ? (NewPaymentOptionSelection)new NewPaymentOptionSelection.New((PaymentSelection.New)selection) : (selection instanceof PaymentSelection.CustomPaymentMethod ? (NewPaymentOptionSelection)new NewPaymentOptionSelection.Custom((PaymentSelection.CustomPaymentMethod)selection) : (selection instanceof PaymentSelection.ExternalPaymentMethod ? (NewPaymentOptionSelection)new NewPaymentOptionSelection.External((PaymentSelection.ExternalPaymentMethod)selection) : null));
        this.primaryButtonUiState = this.primaryButtonUiStateMapper.forCustomFlow();
        SessionSavedStateHandler.INSTANCE.attachTo((ViewModel)this, savedStateHandle);
        linkHandler.setupLink(this.args.getState().getPaymentMethodMetadata().getLinkState());
        if (this.getPaymentMethodMetadata$paymentsheet_release().getValue() == null) {
            this.setPaymentMethodMetadata(this.args.getState().getPaymentMethodMetadata());
        }
        this.getCustomerStateHolder().setCustomerState(this.args.getState().getCustomer());
        this.updateSelection(this.args.getState().getPaymentSelection());
        this.getNavigationHandler().resetTo(this.determineInitialBackStack(this.args.getState().getPaymentMethodMetadata(), this.getCustomerStateHolder()));
    }

    @NotNull
    public final SharedFlow<PaymentOptionResult> getPaymentOptionResult$paymentsheet_release() {
        return this.paymentOptionResult;
    }

    @Override
    @NotNull
    public StateFlow<ResolvableString> getError() {
        return this.error;
    }

    @Override
    @NotNull
    public StateFlow<WalletsProcessingState> getWalletsProcessingState() {
        return this.walletsProcessingState;
    }

    @Override
    @NotNull
    public StateFlow<WalletsState> getWalletsState() {
        return this.walletsState;
    }

    @Override
    @Nullable
    public NewPaymentOptionSelection getNewPaymentSelection() {
        return this.newPaymentSelection;
    }

    @Override
    public void setNewPaymentSelection(@Nullable NewPaymentOptionSelection newPaymentOptionSelection) {
        this.newPaymentSelection = newPaymentOptionSelection;
    }

    @Override
    @NotNull
    public StateFlow<PrimaryButton.UIState> getPrimaryButtonUiState() {
        return this.primaryButtonUiState;
    }

    @Override
    public void onUserCancel() {
        this.getEventReporter().onDismiss();
        this._paymentOptionResult.tryEmit((Object)new PaymentOptionResult.Canceled(null, this.determinePaymentSelectionUponCancel(), (List)this.getCustomerStateHolder().getPaymentMethods().getValue()));
    }

    private final PaymentSelection determinePaymentSelectionUponCancel() {
        PaymentSelection initialSelection = this.args.getState().getPaymentSelection();
        return initialSelection instanceof PaymentSelection.Saved ? (PaymentSelection)this.takeIfStillValid((PaymentSelection.Saved)initialSelection) : initialSelection;
    }

    private final PaymentSelection.Saved takeIfStillValid(PaymentSelection.Saved $this$takeIfStillValid) {
        PaymentSelection.Saved saved;
        PaymentMethod paymentMethod;
        Object v0;
        block3: {
            List paymentMethods = (List)this.getCustomerStateHolder().getPaymentMethods().getValue();
            Iterable $this$firstOrNull$iv = paymentMethods;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PaymentMethod it = (PaymentMethod)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.id, (Object)$this$takeIfStillValid.getPaymentMethod().id)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PaymentMethod paymentMethod2 = paymentMethod = (PaymentMethod)v0;
        if (paymentMethod2 != null) {
            PaymentMethod it = paymentMethod2;
            boolean bl = false;
            saved = PaymentSelection.Saved.copy$default($this$takeIfStillValid, it, null, null, 6, null);
        } else {
            saved = null;
        }
        return saved;
    }

    @Override
    public void onError(@Nullable ResolvableString error) {
        this._error.setValue((Object)error);
    }

    public final void onUserSelection() {
        block0: {
            this.clearErrorMessages();
            PaymentSelection paymentSelection2 = (PaymentSelection)this.getSelection$paymentsheet_release().getValue();
            if (paymentSelection2 == null) break block0;
            PaymentSelection paymentSelection3 = paymentSelection2;
            boolean bl = false;
            this.getEventReporter().onSelectPaymentOption(paymentSelection3);
            this._paymentOptionResult.tryEmit((Object)new PaymentOptionResult.Succeeded(paymentSelection3, (List)this.getCustomerStateHolder().getPaymentMethods().getValue()));
        }
    }

    @Override
    public void handlePaymentMethodSelected(@Nullable PaymentSelection selection) {
        this.updateSelection(selection);
        PaymentSelection paymentSelection2 = selection;
        if (!(paymentSelection2 != null ? paymentSelection2.getRequiresConfirmation() : false)) {
            this.onUserSelection();
        }
    }

    @Override
    public void clearErrorMessages() {
        this._error.setValue(null);
    }

    private final List<PaymentSheetScreen> determineInitialBackStack(PaymentMethodMetadata paymentMethodMetadata, CustomerStateHolder customerStateHolder) {
        List list;
        PaymentSheetScreen paymentSheetScreen;
        Object interactor;
        if (this.getConfig().getPaymentMethodLayout$paymentsheet_release() != PaymentSheet.PaymentMethodLayout.Horizontal) {
            return VerticalModeInitialScreenFactory.INSTANCE.create(this, paymentMethodMetadata, customerStateHolder);
        }
        if (this.args.getState().getShowSavedPaymentMethods()) {
            interactor = DefaultSelectSavedPaymentMethodsInteractor.Companion.create(this, paymentMethodMetadata, customerStateHolder, this.getSavedPaymentMethodMutator());
            paymentSheetScreen = new PaymentSheetScreen.SelectSavedPaymentMethods((SelectSavedPaymentMethodsInteractor)interactor, null, 2, null);
        } else {
            interactor = DefaultAddPaymentMethodInteractor.Companion.create(this, paymentMethodMetadata);
            paymentSheetScreen = new PaymentSheetScreen.AddFirstPaymentMethod((AddPaymentMethodInteractor)interactor);
        }
        PaymentSheetScreen target = paymentSheetScreen;
        List $this$determineInitialBackStack_u24lambda_u247 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$determineInitialBackStack_u24lambda_u247.add(target);
        if (target instanceof PaymentSheetScreen.SelectSavedPaymentMethods && this.getNewPaymentSelection() != null) {
            AddPaymentMethodInteractor interactor2 = DefaultAddPaymentMethodInteractor.Companion.create(this, paymentMethodMetadata);
            $this$determineInitialBackStack_u24lambda_u247.add(new PaymentSheetScreen.AddAnotherPaymentMethod(interactor2));
        }
        return CollectionsKt.build((List)list);
    }

    private static final Unit primaryButtonUiStateMapper$lambda$0(EventReporter $eventReporter, PaymentOptionsViewModel this$0) {
        $eventReporter.onPressConfirmButton((PaymentSelection)this$0.getSelection$paymentsheet_release().getValue());
        this$0.onUserSelection();
        return Unit.INSTANCE;
    }

    private static final Unit walletsState$lambda$3$lambda$1(PaymentOptionsViewModel this$0) {
        this$0.updateSelection(PaymentSelection.GooglePay.INSTANCE);
        this$0.onUserSelection();
        return Unit.INSTANCE;
    }

    private static final Unit walletsState$lambda$3$lambda$2(PaymentOptionsViewModel this$0) {
        this$0.updateSelection(new PaymentSelection.Link(false, 1, null));
        this$0.onUserSelection();
        return Unit.INSTANCE;
    }

    private static final WalletsState walletsState$lambda$3(PaymentOptionsViewModel this$0, Boolean isLinkAvailable, String linkEmail, boolean buttonsEnabled) {
        PaymentMethodMetadata paymentMethodMetadata = this$0.args.getState().getPaymentMethodMetadata();
        WalletsState.Companion companion = WalletsState.Companion;
        boolean bl = paymentMethodMetadata.isGooglePayReady();
        List<String> list = paymentMethodMetadata.supportedPaymentMethodTypes();
        GooglePayButtonType googlePayButtonType = GooglePayButtonType.Pay;
        boolean bl2 = paymentMethodMetadata.getStripeIntent() instanceof SetupIntent;
        return companion.create(isLinkAvailable, linkEmail, bl, googlePayButtonType, buttonsEnabled, list, null, (Function0<Unit>)((Function0)() -> PaymentOptionsViewModel.walletsState$lambda$3$lambda$1(this$0)), (Function0<Unit>)((Function0)() -> PaymentOptionsViewModel.walletsState$lambda$3$lambda$2(this$0)), bl2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J-\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/paymentsheet/PaymentOptionsViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "starterArgsSupplier", "Lkotlin/Function0;", "Lcom/stripe/android/paymentsheet/PaymentOptionContract$Args;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "extras", "Landroidx/lifecycle/viewmodel/CreationExtras;", "(Ljava/lang/Class;Landroidx/lifecycle/viewmodel/CreationExtras;)Landroidx/lifecycle/ViewModel;", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static final class Factory
    implements ViewModelProvider.Factory {
        @NotNull
        private final Function0<PaymentOptionContract.Args> starterArgsSupplier;
        public static final int $stable;

        public Factory(@NotNull Function0<PaymentOptionContract.Args> starterArgsSupplier) {
            Intrinsics.checkNotNullParameter(starterArgsSupplier, (String)"starterArgsSupplier");
            this.starterArgsSupplier = starterArgsSupplier;
        }

        @NotNull
        public <T extends ViewModel> T create(@NotNull Class<T> modelClass, @NotNull CreationExtras extras) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
            Application application = CreationExtrasKtxKt.requireApplication((CreationExtras)extras);
            SavedStateHandle savedStateHandle = SavedStateHandleSupport.createSavedStateHandle((CreationExtras)extras);
            PaymentOptionContract.Args starterArgs = (PaymentOptionContract.Args)this.starterArgsSupplier.invoke();
            PaymentOptionsViewModelSubcomponent component = DaggerPaymentOptionsViewModelFactoryComponent.builder().application(application).context((Context)application).productUsage(starterArgs.getProductUsage()).savedStateHandle(savedStateHandle).paymentElementCallbackIdentifier(starterArgs.getPaymentElementCallbackIdentifier()).build().getPaymentOptionsViewModelSubcomponentBuilder().application(application).args(starterArgs).build();
            PaymentOptionsViewModel paymentOptionsViewModel = component.getViewModel();
            Intrinsics.checkNotNull((Object)((Object)paymentOptionsViewModel), (String)"null cannot be cast to non-null type T of com.stripe.android.paymentsheet.PaymentOptionsViewModel.Factory.create");
            return (T)((Object)paymentOptionsViewModel);
        }
    }
}

