/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.flowcontroller;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.app.ActivityOptionsCompat;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.stripe.android.common.exception.ExceptionKtKt;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentelement.callbacks.PaymentElementCallbackIdentifier;
import com.stripe.android.paymentelement.callbacks.PaymentElementCallbackReferences;
import com.stripe.android.paymentelement.confirmation.ConfirmationHandler;
import com.stripe.android.paymentelement.confirmation.ConfirmationOptionKtxKt;
import com.stripe.android.paymentelement.confirmation.intent.DeferredIntentConfirmationType;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import com.stripe.android.payments.paymentlauncher.PaymentResult;
import com.stripe.android.paymentsheet.InitializedViaCompose;
import com.stripe.android.paymentsheet.LinkHandler;
import com.stripe.android.paymentsheet.PaymentOptionCallback;
import com.stripe.android.paymentsheet.PaymentOptionContract;
import com.stripe.android.paymentsheet.PaymentOptionResult;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.PaymentSheetResult;
import com.stripe.android.paymentsheet.PaymentSheetResultCallback;
import com.stripe.android.paymentsheet.PrefsRepository;
import com.stripe.android.paymentsheet.addresselement.AddressDetails;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.analytics.PaymentSheetConfirmationError;
import com.stripe.android.paymentsheet.flowcontroller.FlowControllerComponent;
import com.stripe.android.paymentsheet.flowcontroller.FlowControllerConfigurationHandler;
import com.stripe.android.paymentsheet.flowcontroller.FlowControllerScope;
import com.stripe.android.paymentsheet.flowcontroller.FlowControllerStateComponent;
import com.stripe.android.paymentsheet.flowcontroller.FlowControllerViewModel;
import com.stripe.android.paymentsheet.model.PaymentOption;
import com.stripe.android.paymentsheet.model.PaymentOptionFactory;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.model.PaymentSelectionKt;
import com.stripe.android.paymentsheet.state.CustomerState;
import com.stripe.android.paymentsheet.state.LinkState;
import com.stripe.android.paymentsheet.state.PaymentElementLoader;
import com.stripe.android.paymentsheet.state.PaymentSheetState;
import com.stripe.android.paymentsheet.ui.SepaMandateContract;
import com.stripe.android.paymentsheet.ui.SepaMandateResult;
import com.stripe.android.paymentsheet.utils.ConfirmationReportingUtilsKt;
import com.stripe.android.paymentsheet.utils.SelectionUtilsKt;
import com.stripe.android.uicore.utils.AnimationConstants;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@FlowControllerScope
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 z2\u00020\u0001:\u0003xyzB\u00ba\u0001\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0019\u0010\f\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\b\b\u0001\u0010\u001d\u001a\u00020\u001e\u0012\u000e\b\u0001\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \u0012\u0006\u0010\"\u001a\u00020#\u0012\u0006\u0010$\u001a\u00020%\u0012\b\b\u0001\u0010&\u001a\u00020\u001e\u0012\b\b\u0001\u0010'\u001a\u00020!\u00a2\u0006\u0004\b(\u0010)J\"\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020!2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020FH\u0016J\"\u0010G\u001a\u00020A2\u0006\u0010H\u001a\u00020!2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020FH\u0016J\"\u0010I\u001a\u00020A2\u0006\u0010J\u001a\u00020K2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020FH\u0016J \u0010L\u001a\u00020A2\u0006\u0010M\u001a\u0002062\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0002J\n\u0010N\u001a\u0004\u0018\u00010OH\u0016J\u0015\u0010P\u001a\b\u0012\u0004\u0012\u00020R0QH\u0002\u00a2\u0006\u0004\bS\u0010TJ\b\u0010U\u001a\u00020AH\u0016J\b\u0010V\u001a\u00020AH\u0016J(\u0010W\u001a\u00020A2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]2\u0006\u00105\u001a\u000206H\u0002J*\u0010^\u001a\u00020A2\b\u0010X\u001a\u0004\u0018\u00010_2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]2\u0006\u00105\u001a\u000206H\u0007J\u0017\u0010`\u001a\u00020A2\b\u0010a\u001a\u0004\u0018\u00010bH\u0000\u00a2\u0006\u0002\bcJ\u0010\u0010d\u001a\u00020A2\u0006\u0010e\u001a\u00020fH\u0002J\u0010\u0010g\u001a\u00020A2\u0006\u0010h\u001a\u00020iH\u0002J+\u0010j\u001a\u00020A2\u0006\u0010k\u001a\u00020l2\n\b\u0002\u0010m\u001a\u0004\u0018\u00010n2\b\b\u0002\u0010o\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\bpJ\u0015\u0010q\u001a\u00020A2\u0006\u0010r\u001a\u00020sH\u0000\u00a2\u0006\u0002\btJ\u001c\u0010u\u001a\u00020A2\b\u0010k\u001a\u0004\u0018\u00010l2\b\u0010m\u001a\u0004\u0018\u00010nH\u0002J\f\u0010v\u001a\u00020w*\u00020lH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020.0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u000200X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0016\u00105\u001a\u0004\u0018\u0001068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R(\u0010;\u001a\u0004\u0018\u00010:2\b\u00109\u001a\u0004\u0018\u00010:8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?\u00a8\u0006{"}, d2={"Lcom/stripe/android/paymentsheet/flowcontroller/DefaultFlowController;", "Lcom/stripe/android/paymentsheet/PaymentSheet$FlowController;", "viewModelScope", "Lkotlinx/coroutines/CoroutineScope;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "paymentOptionFactory", "Lcom/stripe/android/paymentsheet/model/PaymentOptionFactory;", "paymentOptionCallback", "Lcom/stripe/android/paymentsheet/PaymentOptionCallback;", "paymentResultCallback", "Lcom/stripe/android/paymentsheet/PaymentSheetResultCallback;", "prefsRepositoryFactory", "Lkotlin/Function1;", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerConfiguration;", "Lcom/stripe/android/paymentsheet/PrefsRepository;", "Lkotlin/jvm/JvmSuppressWildcards;", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "context", "Landroid/content/Context;", "eventReporter", "Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "viewModel", "Lcom/stripe/android/paymentsheet/flowcontroller/FlowControllerViewModel;", "confirmationHandler", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler;", "linkHandler", "Lcom/stripe/android/paymentsheet/LinkHandler;", "enableLogging", "", "productUsage", "", "", "configurationHandler", "Lcom/stripe/android/paymentsheet/flowcontroller/FlowControllerConfigurationHandler;", "errorReporter", "Lcom/stripe/android/payments/core/analytics/ErrorReporter;", "initializedViaCompose", "paymentElementCallbackIdentifier", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Landroidx/lifecycle/LifecycleOwner;Lcom/stripe/android/paymentsheet/model/PaymentOptionFactory;Lcom/stripe/android/paymentsheet/PaymentOptionCallback;Lcom/stripe/android/paymentsheet/PaymentSheetResultCallback;Lkotlin/jvm/functions/Function1;Landroidx/activity/result/ActivityResultCaller;Landroid/content/Context;Lcom/stripe/android/paymentsheet/analytics/EventReporter;Lcom/stripe/android/paymentsheet/flowcontroller/FlowControllerViewModel;Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler;Lcom/stripe/android/paymentsheet/LinkHandler;ZLjava/util/Set;Lcom/stripe/android/paymentsheet/flowcontroller/FlowControllerConfigurationHandler;Lcom/stripe/android/payments/core/analytics/ErrorReporter;ZLjava/lang/String;)V", "paymentOptionActivityLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/paymentsheet/PaymentOptionContract$Args;", "sepaMandateActivityLauncher", "Lcom/stripe/android/paymentsheet/ui/SepaMandateContract$Args;", "flowControllerComponent", "Lcom/stripe/android/paymentsheet/flowcontroller/FlowControllerComponent;", "getFlowControllerComponent", "()Lcom/stripe/android/paymentsheet/flowcontroller/FlowControllerComponent;", "setFlowControllerComponent", "(Lcom/stripe/android/paymentsheet/flowcontroller/FlowControllerComponent;)V", "initializationMode", "Lcom/stripe/android/paymentsheet/state/PaymentElementLoader$InitializationMode;", "getInitializationMode", "()Lcom/stripe/android/paymentsheet/state/PaymentElementLoader$InitializationMode;", "value", "Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;", "shippingDetails", "getShippingDetails", "()Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;", "setShippingDetails", "(Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;)V", "configureWithPaymentIntent", "", "paymentIntentClientSecret", "configuration", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "callback", "Lcom/stripe/android/paymentsheet/PaymentSheet$FlowController$ConfigCallback;", "configureWithSetupIntent", "setupIntentClientSecret", "configureWithIntentConfiguration", "intentConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$IntentConfiguration;", "configure", "mode", "getPaymentOption", "Lcom/stripe/android/paymentsheet/model/PaymentOption;", "currentStateForPresenting", "Lkotlin/Result;", "Lcom/stripe/android/paymentsheet/flowcontroller/DefaultFlowController$State;", "currentStateForPresenting-d1pmJ48", "()Ljava/lang/Object;", "presentPaymentOptions", "confirm", "confirmSavedPaymentMethod", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection$Saved;", "state", "Lcom/stripe/android/paymentsheet/state/PaymentSheetState$Full;", "appearance", "Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;", "confirmPaymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "onPaymentOptionResult", "paymentOptionResult", "Lcom/stripe/android/paymentsheet/PaymentOptionResult;", "onPaymentOptionResult$paymentsheet_release", "onIntentResult", "result", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler$Result;", "handleCancellation", "canceled", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler$Result$Canceled;", "onPaymentResult", "paymentResult", "Lcom/stripe/android/payments/paymentlauncher/PaymentResult;", "deferredIntentConfirmationType", "Lcom/stripe/android/paymentelement/confirmation/intent/DeferredIntentConfirmationType;", "shouldLog", "onPaymentResult$paymentsheet_release", "onSepaMandateResult", "sepaMandateResult", "Lcom/stripe/android/paymentsheet/ui/SepaMandateResult;", "onSepaMandateResult$paymentsheet_release", "logPaymentResult", "convertToPaymentSheetResult", "Lcom/stripe/android/paymentsheet/PaymentSheetResult;", "Args", "State", "Companion", "paymentsheet_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDefaultFlowController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultFlowController.kt\ncom/stripe/android/paymentsheet/flowcontroller/DefaultFlowController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,613:1\n1#2:614\n*E\n"})
public final class DefaultFlowController
implements PaymentSheet.FlowController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope viewModelScope;
    @NotNull
    private final LifecycleOwner lifecycleOwner;
    @NotNull
    private final PaymentOptionFactory paymentOptionFactory;
    @NotNull
    private final PaymentOptionCallback paymentOptionCallback;
    @NotNull
    private final PaymentSheetResultCallback paymentResultCallback;
    @NotNull
    private final Function1<PaymentSheet.CustomerConfiguration, PrefsRepository> prefsRepositoryFactory;
    @NotNull
    private final Context context;
    @NotNull
    private final EventReporter eventReporter;
    @NotNull
    private final FlowControllerViewModel viewModel;
    @NotNull
    private final ConfirmationHandler confirmationHandler;
    @NotNull
    private final LinkHandler linkHandler;
    private final boolean enableLogging;
    @NotNull
    private final Set<String> productUsage;
    @NotNull
    private final FlowControllerConfigurationHandler configurationHandler;
    @NotNull
    private final ErrorReporter errorReporter;
    private final boolean initializedViaCompose;
    @NotNull
    private final String paymentElementCallbackIdentifier;
    @NotNull
    private final ActivityResultLauncher<PaymentOptionContract.Args> paymentOptionActivityLauncher;
    @NotNull
    private final ActivityResultLauncher<SepaMandateContract.Args> sepaMandateActivityLauncher;
    public FlowControllerComponent flowControllerComponent;
    public static final int $stable = 8;

    @Inject
    public DefaultFlowController(@NotNull CoroutineScope viewModelScope, @NotNull LifecycleOwner lifecycleOwner, @NotNull PaymentOptionFactory paymentOptionFactory, @NotNull PaymentOptionCallback paymentOptionCallback, @NotNull PaymentSheetResultCallback paymentResultCallback, @NotNull Function1<PaymentSheet.CustomerConfiguration, PrefsRepository> prefsRepositoryFactory, @NotNull ActivityResultCaller activityResultCaller, @NotNull Context context, @NotNull EventReporter eventReporter, @NotNull FlowControllerViewModel viewModel, @NotNull ConfirmationHandler confirmationHandler, @NotNull LinkHandler linkHandler, @Named(value="enableLogging") boolean enableLogging, @Named(value="productUsage") @NotNull Set<String> productUsage, @NotNull FlowControllerConfigurationHandler configurationHandler, @NotNull ErrorReporter errorReporter, @InitializedViaCompose boolean initializedViaCompose, @PaymentElementCallbackIdentifier @NotNull String paymentElementCallbackIdentifier) {
        Intrinsics.checkNotNullParameter((Object)viewModelScope, (String)"viewModelScope");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)paymentOptionFactory, (String)"paymentOptionFactory");
        Intrinsics.checkNotNullParameter((Object)paymentOptionCallback, (String)"paymentOptionCallback");
        Intrinsics.checkNotNullParameter((Object)paymentResultCallback, (String)"paymentResultCallback");
        Intrinsics.checkNotNullParameter(prefsRepositoryFactory, (String)"prefsRepositoryFactory");
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)eventReporter, (String)"eventReporter");
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)confirmationHandler, (String)"confirmationHandler");
        Intrinsics.checkNotNullParameter((Object)linkHandler, (String)"linkHandler");
        Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
        Intrinsics.checkNotNullParameter((Object)configurationHandler, (String)"configurationHandler");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)paymentElementCallbackIdentifier, (String)"paymentElementCallbackIdentifier");
        this.viewModelScope = viewModelScope;
        this.lifecycleOwner = lifecycleOwner;
        this.paymentOptionFactory = paymentOptionFactory;
        this.paymentOptionCallback = paymentOptionCallback;
        this.paymentResultCallback = paymentResultCallback;
        this.prefsRepositoryFactory = prefsRepositoryFactory;
        this.context = context;
        this.eventReporter = eventReporter;
        this.viewModel = viewModel;
        this.confirmationHandler = confirmationHandler;
        this.linkHandler = linkHandler;
        this.enableLogging = enableLogging;
        this.productUsage = productUsage;
        this.configurationHandler = configurationHandler;
        this.errorReporter = errorReporter;
        this.initializedViaCompose = initializedViaCompose;
        this.paymentElementCallbackIdentifier = paymentElementCallbackIdentifier;
        this.confirmationHandler.register(activityResultCaller, this.lifecycleOwner);
        this.paymentOptionActivityLauncher = activityResultCaller.registerForActivityResult((ActivityResultContract)new PaymentOptionContract(), new ActivityResultCallback(){

            public final void onActivityResult(PaymentOptionResult p0) {
                DefaultFlowController.this.onPaymentOptionResult$paymentsheet_release(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)DefaultFlowController.this, DefaultFlowController.class, "onPaymentOptionResult", "onPaymentOptionResult$paymentsheet_release(Lcom/stripe/android/paymentsheet/PaymentOptionResult;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof ActivityResultCallback ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        this.sepaMandateActivityLauncher = activityResultCaller.registerForActivityResult((ActivityResultContract)new SepaMandateContract(), new ActivityResultCallback(){

            public final void onActivityResult(SepaMandateResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                DefaultFlowController.this.onSepaMandateResult$paymentsheet_release(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)DefaultFlowController.this, DefaultFlowController.class, "onSepaMandateResult", "onSepaMandateResult$paymentsheet_release(Lcom/stripe/android/paymentsheet/ui/SepaMandateResult;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof ActivityResultCallback ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        Object[] objectArray = new ActivityResultLauncher[]{this.paymentOptionActivityLauncher, this.sepaMandateActivityLauncher};
        final Set activityResultLaunchers = SetsKt.setOf((Object[])objectArray);
        this.lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(){

            public void onDestroy(LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Iterable $this$forEach$iv = activityResultLaunchers;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ActivityResultLauncher it = (ActivityResultLauncher)element$iv;
                    boolean bl = false;
                    it.unregister();
                }
                PaymentElementCallbackReferences.INSTANCE.remove(paymentElementCallbackIdentifier);
            }
        });
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)this.lifecycleOwner)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultFlowController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)((Flow)this.this$0.confirmationHandler.getState()), (Function2)((Function2)new Function2<ConfirmationHandler.State, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ DefaultFlowController this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ConfirmationHandler.State state2;
                                        ResultKt.throwOnFailure((Object)object);
                                        ConfirmationHandler.State state3 = state2 = (ConfirmationHandler.State)this.L$0;
                                        if (!(state3 instanceof ConfirmationHandler.State.Idle) && !(state3 instanceof ConfirmationHandler.State.Confirming)) {
                                            if (state3 instanceof ConfirmationHandler.State.Complete) {
                                                this.this$0.onIntentResult(((ConfirmationHandler.State.Complete)state2).getResult());
                                            } else {
                                                throw new NoWhenBranchMatchedException();
                                            }
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ConfirmationHandler.State p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final FlowControllerComponent getFlowControllerComponent() {
        FlowControllerComponent flowControllerComponent = this.flowControllerComponent;
        if (flowControllerComponent != null) {
            return flowControllerComponent;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"flowControllerComponent");
        return null;
    }

    public final void setFlowControllerComponent(@NotNull FlowControllerComponent flowControllerComponent) {
        Intrinsics.checkNotNullParameter((Object)flowControllerComponent, (String)"<set-?>");
        this.flowControllerComponent = flowControllerComponent;
    }

    private final PaymentElementLoader.InitializationMode getInitializationMode() {
        FlowControllerConfigurationHandler.ConfigureRequest configureRequest = this.viewModel.getPreviousConfigureRequest();
        return configureRequest != null ? configureRequest.getInitializationMode() : null;
    }

    @Override
    @Nullable
    public AddressDetails getShippingDetails() {
        Object object = this.viewModel.getState();
        return object != null && (object = ((State)object).getConfig()) != null ? ((PaymentSheet.Configuration)object).getShippingDetails() : null;
    }

    @Override
    public void setShippingDetails(@Nullable AddressDetails value) {
        State state2 = this.viewModel.getState();
        if (state2 != null) {
            this.viewModel.setState(State.copy$default(state2, null, PaymentSheet.Configuration.copy$paymentsheet_release$default(state2.getConfig(), null, null, null, null, null, value, false, false, null, null, null, null, false, null, null, null, null, null, null, 524255, null), 1, null));
        }
    }

    @Override
    public void configureWithPaymentIntent(@NotNull String paymentIntentClientSecret, @Nullable PaymentSheet.Configuration configuration, @NotNull PaymentSheet.FlowController.ConfigCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)paymentIntentClientSecret, (String)"paymentIntentClientSecret");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        PaymentElementLoader.InitializationMode initializationMode = new PaymentElementLoader.InitializationMode.PaymentIntent(paymentIntentClientSecret);
        PaymentSheet.Configuration configuration2 = configuration;
        if (configuration2 == null) {
            configuration2 = PaymentSheet.Configuration.Companion.default(this.context);
        }
        this.configure(initializationMode, configuration2, callback2);
    }

    @Override
    public void configureWithSetupIntent(@NotNull String setupIntentClientSecret, @Nullable PaymentSheet.Configuration configuration, @NotNull PaymentSheet.FlowController.ConfigCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)setupIntentClientSecret, (String)"setupIntentClientSecret");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        PaymentElementLoader.InitializationMode initializationMode = new PaymentElementLoader.InitializationMode.SetupIntent(setupIntentClientSecret);
        PaymentSheet.Configuration configuration2 = configuration;
        if (configuration2 == null) {
            configuration2 = PaymentSheet.Configuration.Companion.default(this.context);
        }
        this.configure(initializationMode, configuration2, callback2);
    }

    @Override
    public void configureWithIntentConfiguration(@NotNull PaymentSheet.IntentConfiguration intentConfiguration, @Nullable PaymentSheet.Configuration configuration, @NotNull PaymentSheet.FlowController.ConfigCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)intentConfiguration, (String)"intentConfiguration");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        PaymentElementLoader.InitializationMode initializationMode = new PaymentElementLoader.InitializationMode.DeferredIntent(intentConfiguration);
        PaymentSheet.Configuration configuration2 = configuration;
        if (configuration2 == null) {
            configuration2 = PaymentSheet.Configuration.Companion.default(this.context);
        }
        this.configure(initializationMode, configuration2, callback2);
    }

    private final void configure(PaymentElementLoader.InitializationMode mode, PaymentSheet.Configuration configuration, PaymentSheet.FlowController.ConfigCallback callback2) {
        FlowControllerConfigurationHandler flowControllerConfigurationHandler = this.configurationHandler;
        CoroutineScope coroutineScope = this.viewModelScope;
        boolean bl = this.initializedViaCompose;
        flowControllerConfigurationHandler.configure(coroutineScope, mode, configuration, bl, callback2);
    }

    @Override
    @Nullable
    public PaymentOption getPaymentOption() {
        PaymentOption paymentOption;
        PaymentSelection paymentSelection2 = this.viewModel.getPaymentSelection();
        if (paymentSelection2 != null) {
            PaymentSelection it = paymentSelection2;
            boolean bl = false;
            paymentOption = this.paymentOptionFactory.create(it);
        } else {
            paymentOption = null;
        }
        return paymentOption;
    }

    private final Object currentStateForPresenting-d1pmJ48() {
        State state2 = this.viewModel.getState();
        if (state2 == null) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalStateException("FlowController must be successfully initialized using configureWithPaymentIntent(), configureWithSetupIntent() or configureWithIntentConfiguration() before calling presentPaymentOptions().")));
        }
        State state3 = state2;
        if (!this.configurationHandler.isConfigured()) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalStateException("FlowController is not configured, or has a configuration update in flight.")));
        }
        return Result.constructor-impl((Object)state3);
    }

    @Override
    public void presentPaymentOptions() {
        Object stateResult;
        Object object = stateResult = this.currentStateForPresenting-d1pmJ48();
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            this.paymentResultCallback.onPaymentSheetResult(new PaymentSheetResult.Failed(it));
            return;
        }
        State it = (State)object;
        boolean bl = false;
        State state2 = it;
        PaymentOptionContract.Args args = new PaymentOptionContract.Args(PaymentSheetState.Full.copy$default(state2.getPaymentSheetState(), null, null, this.viewModel.getPaymentSelection(), null, null, 27, null), state2.getConfig(), this.enableLogging, this.productUsage, this.paymentElementCallbackIdentifier);
        ActivityOptionsCompat activityOptionsCompat = ActivityOptionsCompat.makeCustomAnimation((Context)((Context)this.viewModel.getApplication()), (int)AnimationConstants.INSTANCE.getFADE_IN(), (int)AnimationConstants.INSTANCE.getFADE_OUT());
        Intrinsics.checkNotNullExpressionValue((Object)activityOptionsCompat, (String)"makeCustomAnimation(...)");
        ActivityOptionsCompat options = activityOptionsCompat;
        try {
            this.paymentOptionActivityLauncher.launch((Object)args, options);
        }
        catch (IllegalStateException e) {
            String message = "The host activity is not in a valid state (" + this.lifecycleOwner.getLifecycle().getCurrentState() + ").";
            this.paymentResultCallback.onPaymentSheetResult(new PaymentSheetResult.Failed(new IllegalStateException(message, e)));
        }
    }

    @Override
    public void confirm() {
        State state2 = this.viewModel.getState();
        if (state2 == null) {
            throw new IllegalStateException("FlowController must be successfully initialized using configureWithPaymentIntent(), configureWithSetupIntent() or configureWithIntentConfiguration() before calling confirm().".toString());
        }
        State state3 = state2;
        if (!this.configurationHandler.isConfigured()) {
            IllegalStateException error = new IllegalStateException("FlowController.confirm() can only be called if the most recent call to configureWithPaymentIntent(), configureWithSetupIntent() or configureWithIntentConfiguration() has completed successfully.");
            DefaultFlowController.onPaymentResult$paymentsheet_release$default(this, (PaymentResult)new PaymentResult.Failed((Throwable)error), null, false, 6, null);
            return;
        }
        PaymentElementLoader.InitializationMode initializationMode = this.getInitializationMode();
        if (initializationMode == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        PaymentElementLoader.InitializationMode initializationMode2 = initializationMode;
        PaymentSelection paymentSelection2 = this.viewModel.getPaymentSelection();
        if (paymentSelection2 instanceof PaymentSelection.Link || paymentSelection2 instanceof PaymentSelection.New.LinkInline || paymentSelection2 instanceof PaymentSelection.GooglePay || paymentSelection2 instanceof PaymentSelection.ExternalPaymentMethod || paymentSelection2 instanceof PaymentSelection.CustomPaymentMethod || paymentSelection2 instanceof PaymentSelection.New || paymentSelection2 == null) {
            this.confirmPaymentSelection(paymentSelection2, state3.getPaymentSheetState(), state3.getConfig().getAppearance(), initializationMode2);
        } else if (paymentSelection2 instanceof PaymentSelection.Saved) {
            this.confirmSavedPaymentMethod((PaymentSelection.Saved)paymentSelection2, state3.getPaymentSheetState(), state3.getConfig().getAppearance(), initializationMode2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void confirmSavedPaymentMethod(PaymentSelection.Saved paymentSelection2, PaymentSheetState.Full state2, PaymentSheet.Appearance appearance, PaymentElementLoader.InitializationMode initializationMode) {
        if (paymentSelection2.getPaymentMethod().type == PaymentMethod.Type.SepaDebit) {
            PaymentSelection paymentSelection3 = this.viewModel.getPaymentSelection();
            boolean bl = paymentSelection3 != null ? !paymentSelection3.getHasAcknowledgedSepaMandate() : false;
            if (bl) {
                this.sepaMandateActivityLauncher.launch((Object)new SepaMandateContract.Args(state2.getConfig().getMerchantDisplayName()));
                return;
            }
        }
        this.confirmPaymentSelection(paymentSelection2, state2, appearance, initializationMode);
    }

    @VisibleForTesting
    public final void confirmPaymentSelection(@Nullable PaymentSelection paymentSelection2, @NotNull PaymentSheetState.Full state2, @NotNull PaymentSheet.Appearance appearance, @NotNull PaymentElementLoader.InitializationMode initializationMode) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)appearance, (String)"appearance");
        Intrinsics.checkNotNullParameter((Object)initializationMode, (String)"initializationMode");
        BuildersKt.launch$default((CoroutineScope)this.viewModelScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(paymentSelection2, state2, this, appearance, initializationMode, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PaymentSelection $paymentSelection;
            final /* synthetic */ PaymentSheetState.Full $state;
            final /* synthetic */ DefaultFlowController this$0;
            final /* synthetic */ PaymentSheet.Appearance $appearance;
            final /* synthetic */ PaymentElementLoader.InitializationMode $initializationMode;
            {
                this.$paymentSelection = $paymentSelection;
                this.$state = $state;
                this.this$0 = $receiver;
                this.$appearance = $appearance;
                this.$initializationMode = $initializationMode;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                block14: {
                    Object object2;
                    DefaultFlowController defaultFlowController;
                    PaymentSelection paymentSelection2;
                    block16: {
                        block15: {
                            CoroutineScope $this$launch;
                            Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ConfirmationHandler.Option confirmationOption2;
                                    ConfirmationHandler.Option option;
                                    ResultKt.throwOnFailure((Object)object);
                                    $this$launch = (CoroutineScope)this.L$0;
                                    PaymentSelection paymentSelection3 = this.$paymentSelection;
                                    if (paymentSelection3 != null) {
                                        LinkState linkState2 = this.$state.getPaymentMethodMetadata().getLinkState();
                                        option = ConfirmationOptionKtxKt.toConfirmationOption(paymentSelection3, this.$state.getConfig(), linkState2 != null ? linkState2.getConfiguration() : null);
                                    } else {
                                        option = null;
                                    }
                                    ConfirmationHandler.Option option2 = confirmationOption2 = option;
                                    if (option2 == null) break;
                                    ConfirmationHandler.Option option3 = option2;
                                    PaymentSheetState.Full full = this.$state;
                                    DefaultFlowController defaultFlowController2 = this.this$0;
                                    PaymentSheet.Appearance appearance = this.$appearance;
                                    PaymentElementLoader.InitializationMode initializationMode = this.$initializationMode;
                                    ConfirmationHandler.Option option4 = option3;
                                    boolean bl = false;
                                    StripeIntent stripeIntent = full.getStripeIntent();
                                    if (stripeIntent == null) {
                                        String string2 = "Required value was null.";
                                        throw new IllegalArgumentException(string2.toString());
                                    }
                                    StripeIntent stripeIntent2 = stripeIntent;
                                    AddressDetails addressDetails = full.getConfig().getShippingDetails();
                                    this.L$0 = $this$launch;
                                    this.label = 1;
                                    Object object4 = DefaultFlowController.access$getConfirmationHandler$p(defaultFlowController2).start(new ConfirmationHandler.Args(stripeIntent2, option4, appearance, initializationMode, addressDetails), (Continuation<? super Unit>)this);
                                    if (object4 == object3) {
                                        return object3;
                                    }
                                    break block14;
                                }
                                case 1: {
                                    void $result;
                                    boolean bl = false;
                                    CoroutineScope $this$launch2 = (CoroutineScope)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object4 = $result;
                                    break block14;
                                }
                            }
                            CoroutineScope coroutineScope = $this$launch;
                            paymentSelection2 = this.$paymentSelection;
                            defaultFlowController = this.this$0;
                            boolean bl = false;
                            object2 = paymentSelection2;
                            if (object2 == null) break block15;
                            PaymentSelection it = object2;
                            boolean bl2 = false;
                            String string3 = "Cannot confirm using a " + Reflection.getOrCreateKotlinClass(it.getClass()).getQualifiedName() + " payment selection!";
                            object2 = string3;
                            if (string3 != null) break block16;
                        }
                        object2 = "Cannot confirm without a payment selection!";
                    }
                    Object message = object2;
                    IllegalStateException exception = new IllegalStateException((String)message);
                    if (paymentSelection2 != null) {
                        boolean bl = false;
                        ErrorReporter.UnexpectedErrorEvent event = ErrorReporter.UnexpectedErrorEvent.FLOW_CONTROLLER_INVALID_PAYMENT_SELECTION_ON_CHECKOUT;
                        ErrorReporter.DefaultImpls.report$default((ErrorReporter)DefaultFlowController.access$getErrorReporter$p(defaultFlowController), (ErrorReporter.ErrorEvent)((ErrorReporter.ErrorEvent)event), (StripeException)StripeException.Companion.create((Throwable)exception), null, (int)4, null);
                    }
                    DefaultFlowController.access$onIntentResult(defaultFlowController, new ConfirmationHandler.Result.Failed(exception, ExceptionKtKt.stripeErrorMessage(exception), ConfirmationHandler.Result.Failed.ErrorType.Internal.INSTANCE));
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ void onPaymentOptionResult$paymentsheet_release(PaymentOptionResult paymentOptionResult) {
        Object object = paymentOptionResult;
        if (object != null && (object = ((PaymentOptionResult)object).getPaymentMethods()) != null) {
            State state2;
            State currentState;
            Object it = object;
            boolean bl = false;
            State state3 = currentState = this.viewModel.getState();
            if (state3 != null) {
                CustomerState customerState = currentState.getPaymentSheetState().getCustomer();
                state2 = State.copyPaymentSheetState$default(state3, null, customerState != null ? CustomerState.copy$default(customerState, null, null, null, (List)it, null, null, 55, null) : null, 1, null);
            } else {
                state2 = null;
            }
            this.viewModel.setState(state2);
        }
        PaymentOptionResult paymentOptionResult2 = paymentOptionResult;
        if (paymentOptionResult2 instanceof PaymentOptionResult.Succeeded) {
            PaymentSelection paymentSelection2 = ((PaymentOptionResult.Succeeded)paymentOptionResult).getPaymentSelection();
            paymentSelection2.setHasAcknowledgedSepaMandate(true);
            this.viewModel.setPaymentSelection(paymentSelection2);
            this.paymentOptionCallback.onPaymentOption(this.paymentOptionFactory.create(paymentSelection2));
        } else if (paymentOptionResult2 instanceof PaymentOptionResult.Failed) {
            PaymentOption paymentOption;
            PaymentOptionCallback paymentOptionCallback = this.paymentOptionCallback;
            PaymentSelection paymentSelection3 = this.viewModel.getPaymentSelection();
            if (paymentSelection3 != null) {
                void it;
                PaymentSelection bl = paymentSelection3;
                PaymentOptionCallback paymentOptionCallback2 = paymentOptionCallback;
                boolean bl2 = false;
                paymentOption = this.paymentOptionFactory.create((PaymentSelection)it);
                paymentOptionCallback = paymentOptionCallback2;
            } else {
                paymentOption = null;
            }
            paymentOptionCallback.onPaymentOption(paymentOption);
        } else if (paymentOptionResult2 instanceof PaymentOptionResult.Canceled) {
            PaymentOption paymentOption;
            PaymentSelection paymentSelection4 = ((PaymentOptionResult.Canceled)paymentOptionResult).getPaymentSelection();
            this.viewModel.setPaymentSelection(paymentSelection4);
            PaymentSelection paymentSelection5 = paymentSelection4;
            if (paymentSelection5 != null) {
                PaymentSelection it = paymentSelection5;
                boolean bl = false;
                paymentOption = this.paymentOptionFactory.create(it);
            } else {
                paymentOption = null;
            }
            PaymentOption paymentOption2 = paymentOption;
            this.paymentOptionCallback.onPaymentOption(paymentOption2);
        } else if (paymentOptionResult2 == null) {
            this.viewModel.setPaymentSelection(null);
            this.paymentOptionCallback.onPaymentOption(null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void onIntentResult(ConfirmationHandler.Result result2) {
        ConfirmationHandler.Result result3 = result2;
        if (result3 instanceof ConfirmationHandler.Result.Succeeded) {
            PaymentSelection paymentSelection2;
            PaymentSelection paymentSelection3;
            StripeIntent stripeIntent = ((ConfirmationHandler.Result.Succeeded)result2).getIntent();
            PaymentSelection currentSelection = this.viewModel.getPaymentSelection();
            PaymentElementLoader.InitializationMode currentInitializationMode = this.getInitializationMode();
            PaymentSelection paymentSelection4 = currentSelection;
            if (paymentSelection4 instanceof PaymentSelection.New) {
                PaymentSelection.Saved saved;
                PaymentMethod paymentMethod;
                PaymentMethod paymentMethod2;
                PaymentMethod it = paymentMethod2 = stripeIntent.getPaymentMethod();
                boolean bl = false;
                Object object = paymentMethod = currentInitializationMode != null && SelectionUtilsKt.canSave((PaymentSelection.New)currentSelection, currentInitializationMode) ? paymentMethod2 : null;
                if (paymentMethod != null) {
                    PaymentMethod method = paymentMethod;
                    boolean bl2 = false;
                    saved = new PaymentSelection.Saved(method, null, null, 6, null);
                } else {
                    saved = null;
                }
                paymentSelection3 = saved;
            } else if (paymentSelection4 instanceof PaymentSelection.Saved) {
                PaymentSelection.Saved.WalletType walletType = ((PaymentSelection.Saved)currentSelection).getWalletType();
                switch (walletType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[walletType.ordinal()]) {
                    case 1: {
                        paymentSelection3 = PaymentSelection.GooglePay.INSTANCE;
                        break;
                    }
                    case 2: {
                        paymentSelection3 = new PaymentSelection.Link(false, 1, null);
                        break;
                    }
                    default: {
                        paymentSelection3 = currentSelection;
                        break;
                    }
                }
            } else {
                paymentSelection3 = paymentSelection2 = currentSelection;
            }
            if (paymentSelection2 != null) {
                PaymentSelection it = paymentSelection2;
                boolean bl = false;
                Object object = this.viewModel.getState();
                ((PrefsRepository)this.prefsRepositoryFactory.invoke(object != null && (object = ((State)object).getConfig()) != null ? ((PaymentSheet.Configuration)object).getCustomer() : null)).savePaymentSelection(it);
            }
            this.eventReporter.onPaymentSuccess(this.viewModel.getPaymentSelection(), ((ConfirmationHandler.Result.Succeeded)result2).getDeferredIntentConfirmationType());
            this.onPaymentResult$paymentsheet_release((PaymentResult)PaymentResult.Completed.INSTANCE, ((ConfirmationHandler.Result.Succeeded)result2).getDeferredIntentConfirmationType(), false);
        } else if (result3 instanceof ConfirmationHandler.Result.Failed) {
            PaymentSheetConfirmationError error;
            PaymentSheetConfirmationError paymentSheetConfirmationError = error = ConfirmationReportingUtilsKt.toConfirmationError((ConfirmationHandler.Result.Failed)result2);
            if (paymentSheetConfirmationError != null) {
                PaymentSheetConfirmationError it = paymentSheetConfirmationError;
                boolean bl = false;
                this.eventReporter.onPaymentFailure(this.viewModel.getPaymentSelection(), it);
            }
            this.onPaymentResult$paymentsheet_release((PaymentResult)new PaymentResult.Failed(((ConfirmationHandler.Result.Failed)result2).getCause()), null, false);
        } else if (result3 instanceof ConfirmationHandler.Result.Canceled) {
            this.handleCancellation((ConfirmationHandler.Result.Canceled)result2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void handleCancellation(ConfirmationHandler.Result.Canceled canceled) {
        switch (WhenMappings.$EnumSwitchMapping$1[canceled.getAction().ordinal()]) {
            case 1: {
                this.onPaymentResult$paymentsheet_release((PaymentResult)PaymentResult.Canceled.INSTANCE, null, false);
                break;
            }
            case 2: {
                this.presentPaymentOptions();
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void onPaymentResult$paymentsheet_release(@NotNull PaymentResult paymentResult, @Nullable DeferredIntentConfirmationType deferredIntentConfirmationType, boolean shouldLog) {
        Intrinsics.checkNotNullParameter((Object)paymentResult, (String)"paymentResult");
        if (shouldLog) {
            this.logPaymentResult(paymentResult, deferredIntentConfirmationType);
        }
        PaymentSelection selection = this.viewModel.getPaymentSelection();
        if (paymentResult instanceof PaymentResult.Completed && selection != null && PaymentSelectionKt.isLink(selection)) {
            this.linkHandler.logOut();
        }
        if (paymentResult instanceof PaymentResult.Completed) {
            this.viewModel.setPaymentSelection(null);
            this.viewModel.setState(null);
        }
        BuildersKt.launch$default((CoroutineScope)this.viewModelScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, paymentResult, null){
            int label;
            final /* synthetic */ DefaultFlowController this$0;
            final /* synthetic */ PaymentResult $paymentResult;
            {
                this.this$0 = $receiver;
                this.$paymentResult = $paymentResult;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DefaultFlowController.access$getPaymentResultCallback$p(this.this$0).onPaymentSheetResult(DefaultFlowController.access$convertToPaymentSheetResult(this.this$0, this.$paymentResult));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void onPaymentResult$paymentsheet_release$default(DefaultFlowController defaultFlowController, PaymentResult paymentResult, DeferredIntentConfirmationType deferredIntentConfirmationType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            deferredIntentConfirmationType = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        defaultFlowController.onPaymentResult$paymentsheet_release(paymentResult, deferredIntentConfirmationType, bl);
    }

    public final void onSepaMandateResult$paymentsheet_release(@NotNull SepaMandateResult sepaMandateResult) {
        Intrinsics.checkNotNullParameter((Object)sepaMandateResult, (String)"sepaMandateResult");
        SepaMandateResult sepaMandateResult2 = sepaMandateResult;
        if (Intrinsics.areEqual((Object)sepaMandateResult2, (Object)SepaMandateResult.Acknowledged.INSTANCE)) {
            PaymentSelection paymentSelection2 = this.viewModel.getPaymentSelection();
            if (paymentSelection2 != null) {
                paymentSelection2.setHasAcknowledgedSepaMandate(true);
            }
            this.confirm();
        } else if (Intrinsics.areEqual((Object)sepaMandateResult2, (Object)SepaMandateResult.Canceled.INSTANCE)) {
            this.paymentResultCallback.onPaymentSheetResult(PaymentSheetResult.Canceled.INSTANCE);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void logPaymentResult(PaymentResult paymentResult, DeferredIntentConfirmationType deferredIntentConfirmationType) {
        PaymentResult paymentResult2 = paymentResult;
        if (paymentResult2 instanceof PaymentResult.Completed) {
            this.eventReporter.onPaymentSuccess(this.viewModel.getPaymentSelection(), deferredIntentConfirmationType);
        } else if (paymentResult2 instanceof PaymentResult.Failed) {
            this.eventReporter.onPaymentFailure(this.viewModel.getPaymentSelection(), new PaymentSheetConfirmationError.Stripe(((PaymentResult.Failed)paymentResult).getThrowable()));
        }
    }

    private final PaymentSheetResult convertToPaymentSheetResult(PaymentResult $this$convertToPaymentSheetResult) {
        PaymentSheetResult paymentSheetResult;
        PaymentResult paymentResult = $this$convertToPaymentSheetResult;
        if (paymentResult instanceof PaymentResult.Completed) {
            paymentSheetResult = PaymentSheetResult.Completed.INSTANCE;
        } else if (paymentResult instanceof PaymentResult.Canceled) {
            paymentSheetResult = PaymentSheetResult.Canceled.INSTANCE;
        } else if (paymentResult instanceof PaymentResult.Failed) {
            paymentSheetResult = new PaymentSheetResult.Failed(((PaymentResult.Failed)$this$convertToPaymentSheetResult).getThrowable());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return paymentSheetResult;
    }

    public static final /* synthetic */ ErrorReporter access$getErrorReporter$p(DefaultFlowController $this) {
        return $this.errorReporter;
    }

    public static final /* synthetic */ PaymentSheetResultCallback access$getPaymentResultCallback$p(DefaultFlowController $this) {
        return $this.paymentResultCallback;
    }

    public static final /* synthetic */ PaymentSheetResult access$convertToPaymentSheetResult(DefaultFlowController $this, PaymentResult $receiver) {
        return $this.convertToPaymentSheetResult($receiver);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0006\u0010\u000f\u001a\u00020\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/paymentsheet/flowcontroller/DefaultFlowController$Args;", "Landroid/os/Parcelable;", "clientSecret", "", "config", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "<init>", "(Ljava/lang/String;Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;)V", "getClientSecret", "()Ljava/lang/String;", "getConfig", "()Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Args
    implements Parcelable {
        @NotNull
        private final String clientSecret;
        @Nullable
        private final PaymentSheet.Configuration config;
        @NotNull
        public static final Parcelable.Creator<Args> CREATOR;
        public static final int $stable;

        public Args(@NotNull String clientSecret, @Nullable PaymentSheet.Configuration config) {
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            this.clientSecret = clientSecret;
            this.config = config;
        }

        @NotNull
        public final String getClientSecret() {
            return this.clientSecret;
        }

        @Nullable
        public final PaymentSheet.Configuration getConfig() {
            return this.config;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeString(this.clientSecret);
            PaymentSheet.Configuration configuration = this.config;
            if (configuration == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                configuration.writeToParcel(dest, flags);
            }
        }

        public final int describeContents() {
            return 0;
        }

        @NotNull
        public final String component1() {
            return this.clientSecret;
        }

        @Nullable
        public final PaymentSheet.Configuration component2() {
            return this.config;
        }

        @NotNull
        public final Args copy(@NotNull String clientSecret, @Nullable PaymentSheet.Configuration config) {
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            return new Args(clientSecret, config);
        }

        public static /* synthetic */ Args copy$default(Args args, String string2, PaymentSheet.Configuration configuration, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = args.clientSecret;
            }
            if ((n & 2) != 0) {
                configuration = args.config;
            }
            return args.copy(string2, configuration);
        }

        @NotNull
        public String toString() {
            return "Args(clientSecret=" + this.clientSecret + ", config=" + this.config + ")";
        }

        public int hashCode() {
            int result2 = this.clientSecret.hashCode();
            result2 = result2 * 31 + (this.config == null ? 0 : this.config.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            if (!Intrinsics.areEqual((Object)this.clientSecret, (Object)args.clientSecret)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.config, (Object)args.config);
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Args> {
                public final Args[] newArray(int size) {
                    return new Args[size];
                }

                public final Args createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Args(parcel.readString(), (PaymentSheet.Configuration)(parcel.readInt() == 0 ? null : PaymentSheet.Configuration.CREATOR.createFromParcel(parcel)));
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/paymentsheet/flowcontroller/DefaultFlowController$Companion;", "", "<init>", "()V", "getInstance", "Lcom/stripe/android/paymentsheet/PaymentSheet$FlowController;", "viewModelStoreOwner", "Landroidx/lifecycle/ViewModelStoreOwner;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "statusBarColor", "Lkotlin/Function0;", "", "paymentOptionCallback", "Lcom/stripe/android/paymentsheet/PaymentOptionCallback;", "paymentResultCallback", "Lcom/stripe/android/paymentsheet/PaymentSheetResultCallback;", "paymentElementCallbackIdentifier", "", "initializedViaCompose", "", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PaymentSheet.FlowController getInstance(@NotNull ViewModelStoreOwner viewModelStoreOwner, @NotNull LifecycleOwner lifecycleOwner, @NotNull ActivityResultCaller activityResultCaller, @NotNull Function0<Integer> statusBarColor, @NotNull PaymentOptionCallback paymentOptionCallback, @NotNull PaymentSheetResultCallback paymentResultCallback, @NotNull String paymentElementCallbackIdentifier, boolean initializedViaCompose) {
            Intrinsics.checkNotNullParameter((Object)viewModelStoreOwner, (String)"viewModelStoreOwner");
            Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
            Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
            Intrinsics.checkNotNullParameter(statusBarColor, (String)"statusBarColor");
            Intrinsics.checkNotNullParameter((Object)paymentOptionCallback, (String)"paymentOptionCallback");
            Intrinsics.checkNotNullParameter((Object)paymentResultCallback, (String)"paymentResultCallback");
            Intrinsics.checkNotNullParameter((Object)paymentElementCallbackIdentifier, (String)"paymentElementCallbackIdentifier");
            FlowControllerViewModel flowControllerViewModel = (FlowControllerViewModel)new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)new FlowControllerViewModel.Factory((Integer)statusBarColor.invoke(), paymentElementCallbackIdentifier)).get("FlowControllerViewModel(instance = " + paymentElementCallbackIdentifier + ")", FlowControllerViewModel.class);
            FlowControllerStateComponent flowControllerStateComponent = flowControllerViewModel.getFlowControllerStateComponent();
            FlowControllerComponent flowControllerComponent = flowControllerStateComponent.getFlowControllerComponentBuilder().lifeCycleOwner(lifecycleOwner).activityResultCaller(activityResultCaller).paymentOptionCallback(paymentOptionCallback).paymentResultCallback(paymentResultCallback).initializedViaCompose(initializedViaCompose).build();
            DefaultFlowController flowController = flowControllerComponent.getFlowController();
            flowController.setFlowControllerComponent(flowControllerComponent);
            return flowController;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0006\u0010\u0014\u001a\u00020\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lcom/stripe/android/paymentsheet/flowcontroller/DefaultFlowController$State;", "Landroid/os/Parcelable;", "paymentSheetState", "Lcom/stripe/android/paymentsheet/state/PaymentSheetState$Full;", "config", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "<init>", "(Lcom/stripe/android/paymentsheet/state/PaymentSheetState$Full;Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;)V", "getPaymentSheetState", "()Lcom/stripe/android/paymentsheet/state/PaymentSheetState$Full;", "getConfig", "()Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "copyPaymentSheetState", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "customer", "Lcom/stripe/android/paymentsheet/state/CustomerState;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class State
    implements Parcelable {
        @NotNull
        private final PaymentSheetState.Full paymentSheetState;
        @NotNull
        private final PaymentSheet.Configuration config;
        @NotNull
        public static final Parcelable.Creator<State> CREATOR;
        public static final int $stable;

        public State(@NotNull PaymentSheetState.Full paymentSheetState, @NotNull PaymentSheet.Configuration config) {
            Intrinsics.checkNotNullParameter((Object)paymentSheetState, (String)"paymentSheetState");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.paymentSheetState = paymentSheetState;
            this.config = config;
        }

        @NotNull
        public final PaymentSheetState.Full getPaymentSheetState() {
            return this.paymentSheetState;
        }

        @NotNull
        public final PaymentSheet.Configuration getConfig() {
            return this.config;
        }

        @NotNull
        public final State copyPaymentSheetState(@Nullable PaymentSelection paymentSelection2, @Nullable CustomerState customer2) {
            return State.copy$default(this, PaymentSheetState.Full.copy$default(this.paymentSheetState, null, customer2, paymentSelection2, null, null, 25, null), null, 2, null);
        }

        public static /* synthetic */ State copyPaymentSheetState$default(State state2, PaymentSelection paymentSelection2, CustomerState customerState, int n, Object object) {
            if ((n & 1) != 0) {
                paymentSelection2 = state2.paymentSheetState.getPaymentSelection();
            }
            if ((n & 2) != 0) {
                customerState = state2.paymentSheetState.getCustomer();
            }
            return state2.copyPaymentSheetState(paymentSelection2, customerState);
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            this.paymentSheetState.writeToParcel(dest, flags);
            this.config.writeToParcel(dest, flags);
        }

        public final int describeContents() {
            return 0;
        }

        @NotNull
        public final PaymentSheetState.Full component1() {
            return this.paymentSheetState;
        }

        @NotNull
        public final PaymentSheet.Configuration component2() {
            return this.config;
        }

        @NotNull
        public final State copy(@NotNull PaymentSheetState.Full paymentSheetState, @NotNull PaymentSheet.Configuration config) {
            Intrinsics.checkNotNullParameter((Object)paymentSheetState, (String)"paymentSheetState");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new State(paymentSheetState, config);
        }

        public static /* synthetic */ State copy$default(State state2, PaymentSheetState.Full full, PaymentSheet.Configuration configuration, int n, Object object) {
            if ((n & 1) != 0) {
                full = state2.paymentSheetState;
            }
            if ((n & 2) != 0) {
                configuration = state2.config;
            }
            return state2.copy(full, configuration);
        }

        @NotNull
        public String toString() {
            return "State(paymentSheetState=" + this.paymentSheetState + ", config=" + this.config + ")";
        }

        public int hashCode() {
            int result2 = this.paymentSheetState.hashCode();
            result2 = result2 * 31 + this.config.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state2 = (State)other;
            if (!Intrinsics.areEqual((Object)this.paymentSheetState, (Object)state2.paymentSheetState)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.config, (Object)state2.config);
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<State> {
                public final State[] newArray(int size) {
                    return new State[size];
                }

                public final State createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new State((PaymentSheetState.Full)PaymentSheetState.Full.CREATOR.createFromParcel(parcel), (PaymentSheet.Configuration)PaymentSheet.Configuration.CREATOR.createFromParcel(parcel));
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PaymentSelection.Saved.WalletType.values().length];
            try {
                nArray[PaymentSelection.Saved.WalletType.GooglePay.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentSelection.Saved.WalletType.Link.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ConfirmationHandler.Result.Canceled.Action.values().length];
            try {
                nArray[ConfirmationHandler.Result.Canceled.Action.InformCancellation.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfirmationHandler.Result.Canceled.Action.ModifyPaymentDetails.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfirmationHandler.Result.Canceled.Action.None.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

