/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.injection;

import android.app.Application;
import android.content.Context;
import androidx.lifecycle.SavedStateHandle;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.cards.CardAccountRangeRepository;
import com.stripe.android.cards.DefaultCardAccountRangeRepositoryFactory;
import com.stripe.android.common.di.ApplicationIdModule_ProvideApplicationIdFactory;
import com.stripe.android.core.Logger;
import com.stripe.android.core.injection.CoreCommonModule;
import com.stripe.android.core.injection.CoreCommonModule_ProvideLocaleFactory;
import com.stripe.android.core.injection.CoreCommonModule_ProvideLoggerFactory;
import com.stripe.android.core.injection.CoroutineContextModule;
import com.stripe.android.core.injection.CoroutineContextModule_ProvideWorkContextFactory;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.AnalyticsRequestV2Executor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor_Factory;
import com.stripe.android.core.utils.DurationProvider;
import com.stripe.android.core.utils.RealUserFacingLogger;
import com.stripe.android.core.utils.RealUserFacingLogger_Factory;
import com.stripe.android.link.LinkConfiguration;
import com.stripe.android.link.RealLinkConfigurationCoordinator;
import com.stripe.android.link.RealLinkConfigurationCoordinator_Factory;
import com.stripe.android.link.account.DefaultLinkAccountManager;
import com.stripe.android.link.account.DefaultLinkAccountManager_Factory;
import com.stripe.android.link.account.DefaultLinkAuth;
import com.stripe.android.link.account.DefaultLinkAuth_Factory;
import com.stripe.android.link.account.LinkAccountHolder;
import com.stripe.android.link.account.LinkAccountManager;
import com.stripe.android.link.account.LinkAuth;
import com.stripe.android.link.analytics.DefaultLinkEventsReporter;
import com.stripe.android.link.analytics.DefaultLinkEventsReporter_Factory;
import com.stripe.android.link.analytics.LinkEventsReporter;
import com.stripe.android.link.attestation.DefaultLinkAttestationCheck;
import com.stripe.android.link.attestation.DefaultLinkAttestationCheck_Factory;
import com.stripe.android.link.attestation.LinkAttestationCheck;
import com.stripe.android.link.gate.DefaultLinkGate;
import com.stripe.android.link.gate.DefaultLinkGate_Factory;
import com.stripe.android.link.gate.LinkGate;
import com.stripe.android.link.injection.LinkComponent;
import com.stripe.android.link.injection.LinkInlineSignupAssistedViewModelFactory;
import com.stripe.android.link.injection.LinkInlineSignupAssistedViewModelFactory_Impl;
import com.stripe.android.link.injection.LinkModule_Companion_ProvideConsumersApiServiceFactory;
import com.stripe.android.link.injection.LinkModule_Companion_ProvideIntegrityStandardRequestManagerFactory;
import com.stripe.android.link.repositories.LinkApiRepository;
import com.stripe.android.link.repositories.LinkApiRepository_Factory;
import com.stripe.android.link.repositories.LinkRepository;
import com.stripe.android.link.ui.inline.InlineSignupViewModel_Factory;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory_Factory;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeApiRepository_Factory;
import com.stripe.android.paymentelement.AnalyticEventCallback;
import com.stripe.android.payments.core.analytics.RealErrorReporter;
import com.stripe.android.payments.core.analytics.RealErrorReporter_Factory;
import com.stripe.android.payments.core.injection.StripeRepositoryModule_Companion_ProvidesAnalyticsRequestV2ExecutorFactory;
import com.stripe.android.paymentsheet.LinkHandler;
import com.stripe.android.paymentsheet.LinkHandler_Factory;
import com.stripe.android.paymentsheet.PaymentOptionContract;
import com.stripe.android.paymentsheet.PaymentOptionsViewModel;
import com.stripe.android.paymentsheet.analytics.DefaultEventReporter;
import com.stripe.android.paymentsheet.analytics.DefaultEventReporter_Factory;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.injection.PaymentOptionsViewModelFactoryComponent;
import com.stripe.android.paymentsheet.injection.PaymentOptionsViewModelModule;
import com.stripe.android.paymentsheet.injection.PaymentOptionsViewModelModule_ProvideEventReporterModeFactory;
import com.stripe.android.paymentsheet.injection.PaymentOptionsViewModelSubcomponent;
import com.stripe.android.paymentsheet.injection.PaymentSheetCommonModule_Companion_ProvideDurationProviderFactory;
import com.stripe.android.paymentsheet.injection.PaymentSheetCommonModule_Companion_ProvideEnabledLoggingFactory;
import com.stripe.android.paymentsheet.injection.PaymentSheetCommonModule_Companion_ProvidePaymentConfigurationFactory;
import com.stripe.android.paymentsheet.injection.PaymentSheetCommonModule_Companion_ProvidePublishableKeyFactory;
import com.stripe.android.paymentsheet.injection.PaymentSheetCommonModule_Companion_ProvideStripeAccountIdFactory;
import com.stripe.android.paymentsheet.injection.PaymentSheetCommonModule_Companion_ProvidesAnalyticEventCallbackFactory;
import com.stripe.android.paymentsheet.injection.PaymentSheetCommonModule_Companion_ProvidesLinkAccountHolderFactory;
import com.stripe.android.paymentsheet.repositories.CustomerApiRepository;
import com.stripe.android.paymentsheet.repositories.CustomerApiRepository_Factory;
import com.stripe.android.paymentsheet.repositories.CustomerRepository;
import com.stripe.android.repository.ConsumersApiService;
import com.stripe.android.ui.core.IsStripeCardScanAvailable;
import com.stripe.android.ui.core.di.CardScanModule_ProvidesIsStripeCardScanAvailableFactory;
import com.stripe.attestation.IntegrityRequestManager;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import java.util.Locale;
import java.util.Set;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;

@DaggerGenerated
public final class DaggerPaymentOptionsViewModelFactoryComponent {
    private DaggerPaymentOptionsViewModelFactoryComponent() {
    }

    public static PaymentOptionsViewModelFactoryComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements PaymentOptionsViewModelFactoryComponent.Builder {
        private Context context;
        private Application application;
        private SavedStateHandle savedStateHandle;
        private Set<String> productUsage;
        private String paymentElementCallbackIdentifier;

        private Builder() {
        }

        @Override
        public Builder context(Context context) {
            this.context = (Context)Preconditions.checkNotNull((Object)context);
            return this;
        }

        @Override
        public Builder application(Application application) {
            this.application = (Application)Preconditions.checkNotNull((Object)application);
            return this;
        }

        @Override
        public Builder savedStateHandle(SavedStateHandle handle) {
            this.savedStateHandle = (SavedStateHandle)Preconditions.checkNotNull((Object)handle);
            return this;
        }

        @Override
        public Builder productUsage(Set<String> productUsage) {
            this.productUsage = (Set)Preconditions.checkNotNull(productUsage);
            return this;
        }

        @Override
        public Builder paymentElementCallbackIdentifier(String paymentElementCallbackIdentifier) {
            this.paymentElementCallbackIdentifier = (String)Preconditions.checkNotNull((Object)paymentElementCallbackIdentifier);
            return this;
        }

        @Override
        public PaymentOptionsViewModelFactoryComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.context, Context.class);
            Preconditions.checkBuilderRequirement((Object)this.application, Application.class);
            Preconditions.checkBuilderRequirement((Object)this.savedStateHandle, SavedStateHandle.class);
            Preconditions.checkBuilderRequirement(this.productUsage, Set.class);
            Preconditions.checkBuilderRequirement((Object)this.paymentElementCallbackIdentifier, String.class);
            return new PaymentOptionsViewModelFactoryComponentImpl(new PaymentOptionsViewModelModule(), new CoroutineContextModule(), new CoreCommonModule(), this.context, this.application, this.savedStateHandle, this.productUsage, this.paymentElementCallbackIdentifier);
        }
    }

    private static final class PaymentOptionsViewModelFactoryComponentImpl
    implements PaymentOptionsViewModelFactoryComponent {
        private final SavedStateHandle savedStateHandle;
        private final Context context;
        private final Set<String> productUsage;
        private final PaymentOptionsViewModelFactoryComponentImpl paymentOptionsViewModelFactoryComponentImpl = this;
        private Provider<Context> contextProvider;
        private Provider<EventReporter.Mode> provideEventReporterModeProvider;
        private Provider<Boolean> provideEnabledLoggingProvider;
        private Provider<Logger> provideLoggerProvider;
        private Provider<CoroutineContext> provideWorkContextProvider;
        private Provider<DefaultAnalyticsRequestExecutor> defaultAnalyticsRequestExecutorProvider;
        private Provider<AnalyticsRequestV2Executor> providesAnalyticsRequestV2ExecutorProvider;
        private Provider<PaymentConfiguration> providePaymentConfigurationProvider;
        private Provider<Function0<String>> providePublishableKeyProvider;
        private Provider<Set<String>> productUsageProvider;
        private Provider<PaymentAnalyticsRequestFactory> paymentAnalyticsRequestFactoryProvider;
        private Provider<DurationProvider> provideDurationProvider;
        private Provider<String> paymentElementCallbackIdentifierProvider;
        private Provider<AnalyticEventCallback> providesAnalyticEventCallbackProvider;
        private Provider<RealUserFacingLogger> realUserFacingLoggerProvider;
        private Provider<DefaultEventReporter> defaultEventReporterProvider;
        private Provider<EventReporter> bindsEventReporterProvider;
        private Provider<StripeApiRepository> stripeApiRepositoryProvider;
        private Provider<RealErrorReporter> realErrorReporterProvider;
        private Provider<CustomerApiRepository> customerApiRepositoryProvider;
        private Provider<LinkComponent.Builder> linkComponentBuilderProvider;
        private Provider<RealLinkConfigurationCoordinator> realLinkConfigurationCoordinatorProvider;
        private Provider<LinkHandler> linkHandlerProvider;
        private Provider<SavedStateHandle> savedStateHandleProvider;
        private Provider<LinkAccountHolder> providesLinkAccountHolderProvider;
        private Provider<Application> applicationProvider;
        private Provider<Function0<String>> provideStripeAccountIdProvider;
        private Provider<Locale> provideLocaleProvider;

        private PaymentOptionsViewModelFactoryComponentImpl(PaymentOptionsViewModelModule paymentOptionsViewModelModuleParam, CoroutineContextModule coroutineContextModuleParam, CoreCommonModule coreCommonModuleParam, Context contextParam, Application applicationParam, SavedStateHandle savedStateHandleParam, Set<String> productUsageParam, String paymentElementCallbackIdentifierParam) {
            this.savedStateHandle = savedStateHandleParam;
            this.context = contextParam;
            this.productUsage = productUsageParam;
            this.initialize(paymentOptionsViewModelModuleParam, coroutineContextModuleParam, coreCommonModuleParam, contextParam, applicationParam, savedStateHandleParam, productUsageParam, paymentElementCallbackIdentifierParam);
            this.initialize2(paymentOptionsViewModelModuleParam, coroutineContextModuleParam, coreCommonModuleParam, contextParam, applicationParam, savedStateHandleParam, productUsageParam, paymentElementCallbackIdentifierParam);
        }

        private DefaultAnalyticsRequestExecutor defaultAnalyticsRequestExecutor() {
            return new DefaultAnalyticsRequestExecutor((Logger)this.provideLoggerProvider.get(), (CoroutineContext)this.provideWorkContextProvider.get());
        }

        private DefaultCardAccountRangeRepositoryFactory defaultCardAccountRangeRepositoryFactory() {
            return new DefaultCardAccountRangeRepositoryFactory(this.context, this.productUsage, (AnalyticsRequestExecutor)this.defaultAnalyticsRequestExecutor());
        }

        private void initialize(PaymentOptionsViewModelModule paymentOptionsViewModelModuleParam, CoroutineContextModule coroutineContextModuleParam, CoreCommonModule coreCommonModuleParam, Context contextParam, Application applicationParam, SavedStateHandle savedStateHandleParam, Set<String> productUsageParam, String paymentElementCallbackIdentifierParam) {
            this.contextProvider = InstanceFactory.create((Object)contextParam);
            this.provideEventReporterModeProvider = DoubleCheck.provider((Provider)PaymentOptionsViewModelModule_ProvideEventReporterModeFactory.create(paymentOptionsViewModelModuleParam));
            this.provideEnabledLoggingProvider = DoubleCheck.provider((Provider)PaymentSheetCommonModule_Companion_ProvideEnabledLoggingFactory.create());
            this.provideLoggerProvider = DoubleCheck.provider((Provider)CoreCommonModule_ProvideLoggerFactory.create((CoreCommonModule)coreCommonModuleParam, this.provideEnabledLoggingProvider));
            this.provideWorkContextProvider = DoubleCheck.provider((Provider)CoroutineContextModule_ProvideWorkContextFactory.create((CoroutineContextModule)coroutineContextModuleParam));
            this.defaultAnalyticsRequestExecutorProvider = DefaultAnalyticsRequestExecutor_Factory.create(this.provideLoggerProvider, this.provideWorkContextProvider);
            this.providesAnalyticsRequestV2ExecutorProvider = StripeRepositoryModule_Companion_ProvidesAnalyticsRequestV2ExecutorFactory.create(this.contextProvider, this.provideWorkContextProvider, this.provideLoggerProvider);
            this.providePaymentConfigurationProvider = PaymentSheetCommonModule_Companion_ProvidePaymentConfigurationFactory.create(this.contextProvider);
            this.providePublishableKeyProvider = PaymentSheetCommonModule_Companion_ProvidePublishableKeyFactory.create(this.providePaymentConfigurationProvider);
            this.productUsageProvider = InstanceFactory.create(productUsageParam);
            this.paymentAnalyticsRequestFactoryProvider = PaymentAnalyticsRequestFactory_Factory.create(this.contextProvider, this.providePublishableKeyProvider, this.productUsageProvider);
            this.provideDurationProvider = DoubleCheck.provider((Provider)PaymentSheetCommonModule_Companion_ProvideDurationProviderFactory.create());
            this.paymentElementCallbackIdentifierProvider = InstanceFactory.create((Object)paymentElementCallbackIdentifierParam);
            this.providesAnalyticEventCallbackProvider = PaymentSheetCommonModule_Companion_ProvidesAnalyticEventCallbackFactory.create(this.paymentElementCallbackIdentifierProvider);
            this.realUserFacingLoggerProvider = RealUserFacingLogger_Factory.create(this.contextProvider);
            this.defaultEventReporterProvider = DefaultEventReporter_Factory.create(this.contextProvider, this.provideEventReporterModeProvider, this.defaultAnalyticsRequestExecutorProvider, this.providesAnalyticsRequestV2ExecutorProvider, this.paymentAnalyticsRequestFactoryProvider, this.provideDurationProvider, this.providesAnalyticEventCallbackProvider, this.provideWorkContextProvider, (Provider<IsStripeCardScanAvailable>)CardScanModule_ProvidesIsStripeCardScanAvailableFactory.create(), this.realUserFacingLoggerProvider);
            this.bindsEventReporterProvider = DoubleCheck.provider(this.defaultEventReporterProvider);
            this.stripeApiRepositoryProvider = StripeApiRepository_Factory.create(this.contextProvider, this.providePublishableKeyProvider, this.provideWorkContextProvider, this.productUsageProvider, this.paymentAnalyticsRequestFactoryProvider, this.defaultAnalyticsRequestExecutorProvider, this.provideLoggerProvider);
            this.realErrorReporterProvider = RealErrorReporter_Factory.create(this.defaultAnalyticsRequestExecutorProvider, this.paymentAnalyticsRequestFactoryProvider);
            this.customerApiRepositoryProvider = DoubleCheck.provider((Provider)CustomerApiRepository_Factory.create(this.stripeApiRepositoryProvider, this.providePaymentConfigurationProvider, this.provideLoggerProvider, this.realErrorReporterProvider, this.provideWorkContextProvider, this.productUsageProvider));
            this.linkComponentBuilderProvider = new Provider<LinkComponent.Builder>(){

                public LinkComponent.Builder get() {
                    return new LinkComponentBuilder(paymentOptionsViewModelFactoryComponentImpl);
                }
            };
            this.realLinkConfigurationCoordinatorProvider = DoubleCheck.provider((Provider)RealLinkConfigurationCoordinator_Factory.create(this.linkComponentBuilderProvider));
            this.linkHandlerProvider = DoubleCheck.provider((Provider)LinkHandler_Factory.create(this.realLinkConfigurationCoordinatorProvider));
            this.savedStateHandleProvider = InstanceFactory.create((Object)savedStateHandleParam);
            this.providesLinkAccountHolderProvider = DoubleCheck.provider((Provider)PaymentSheetCommonModule_Companion_ProvidesLinkAccountHolderFactory.create(this.savedStateHandleProvider));
        }

        private void initialize2(PaymentOptionsViewModelModule paymentOptionsViewModelModuleParam, CoroutineContextModule coroutineContextModuleParam, CoreCommonModule coreCommonModuleParam, Context contextParam, Application applicationParam, SavedStateHandle savedStateHandleParam, Set<String> productUsageParam, String paymentElementCallbackIdentifierParam) {
            this.applicationProvider = InstanceFactory.create((Object)applicationParam);
            this.provideStripeAccountIdProvider = PaymentSheetCommonModule_Companion_ProvideStripeAccountIdFactory.create(this.providePaymentConfigurationProvider);
            this.provideLocaleProvider = DoubleCheck.provider((Provider)CoreCommonModule_ProvideLocaleFactory.create((CoreCommonModule)coreCommonModuleParam));
        }

        @Override
        public PaymentOptionsViewModelSubcomponent.Builder getPaymentOptionsViewModelSubcomponentBuilder() {
            return new PaymentOptionsViewModelSubcomponentBuilder(this.paymentOptionsViewModelFactoryComponentImpl);
        }
    }

    private static final class LinkComponentImpl
    extends LinkComponent {
        private final LinkConfiguration configuration;
        private final PaymentOptionsViewModelFactoryComponentImpl paymentOptionsViewModelFactoryComponentImpl;
        private final LinkComponentImpl linkComponentImpl = this;
        private Provider<LinkConfiguration> configurationProvider;
        private Provider<ConsumersApiService> provideConsumersApiServiceProvider;
        private Provider<LinkApiRepository> linkApiRepositoryProvider;
        private Provider<LinkRepository> bindLinkRepositoryProvider;
        private Provider<DefaultLinkEventsReporter> defaultLinkEventsReporterProvider;
        private Provider<LinkEventsReporter> bindLinkEventsReporterProvider;
        private Provider<DefaultLinkAccountManager> defaultLinkAccountManagerProvider;
        private Provider<LinkAccountManager> bindLinkAccountManagerProvider;
        private Provider<DefaultLinkGate> defaultLinkGateProvider;
        private Provider<LinkGate> bindsLinkGateProvider;
        private Provider<IntegrityRequestManager> provideIntegrityStandardRequestManagerProvider;
        private Provider<String> provideApplicationIdProvider;
        private Provider<DefaultLinkAuth> defaultLinkAuthProvider;
        private Provider<LinkAuth> bindsLinkAuthProvider;
        private Provider<DefaultLinkAttestationCheck> defaultLinkAttestationCheckProvider;
        private Provider<LinkAttestationCheck> bindsLinkAttestationCheckProvider;
        private InlineSignupViewModel_Factory inlineSignupViewModelProvider;
        private Provider<LinkInlineSignupAssistedViewModelFactory> linkInlineSignupAssistedViewModelFactoryProvider;

        private LinkComponentImpl(PaymentOptionsViewModelFactoryComponentImpl paymentOptionsViewModelFactoryComponentImpl, LinkConfiguration configurationParam) {
            this.paymentOptionsViewModelFactoryComponentImpl = paymentOptionsViewModelFactoryComponentImpl;
            this.configuration = configurationParam;
            this.initialize(configurationParam);
        }

        private void initialize(LinkConfiguration configurationParam) {
            this.configurationProvider = InstanceFactory.create((Object)configurationParam);
            this.provideConsumersApiServiceProvider = DoubleCheck.provider((Provider)LinkModule_Companion_ProvideConsumersApiServiceFactory.create(this.paymentOptionsViewModelFactoryComponentImpl.provideLoggerProvider, this.paymentOptionsViewModelFactoryComponentImpl.provideWorkContextProvider));
            this.linkApiRepositoryProvider = LinkApiRepository_Factory.create(this.paymentOptionsViewModelFactoryComponentImpl.applicationProvider, this.paymentOptionsViewModelFactoryComponentImpl.providePublishableKeyProvider, this.paymentOptionsViewModelFactoryComponentImpl.provideStripeAccountIdProvider, this.paymentOptionsViewModelFactoryComponentImpl.stripeApiRepositoryProvider, this.provideConsumersApiServiceProvider, this.paymentOptionsViewModelFactoryComponentImpl.provideWorkContextProvider, this.paymentOptionsViewModelFactoryComponentImpl.provideLocaleProvider, this.paymentOptionsViewModelFactoryComponentImpl.realErrorReporterProvider);
            this.bindLinkRepositoryProvider = DoubleCheck.provider(this.linkApiRepositoryProvider);
            this.defaultLinkEventsReporterProvider = DefaultLinkEventsReporter_Factory.create(this.paymentOptionsViewModelFactoryComponentImpl.defaultAnalyticsRequestExecutorProvider, this.paymentOptionsViewModelFactoryComponentImpl.paymentAnalyticsRequestFactoryProvider, this.paymentOptionsViewModelFactoryComponentImpl.realErrorReporterProvider, this.paymentOptionsViewModelFactoryComponentImpl.provideWorkContextProvider, this.paymentOptionsViewModelFactoryComponentImpl.provideLoggerProvider, this.paymentOptionsViewModelFactoryComponentImpl.provideDurationProvider);
            this.bindLinkEventsReporterProvider = DoubleCheck.provider(this.defaultLinkEventsReporterProvider);
            this.defaultLinkAccountManagerProvider = DefaultLinkAccountManager_Factory.create(this.paymentOptionsViewModelFactoryComponentImpl.providesLinkAccountHolderProvider, this.configurationProvider, this.bindLinkRepositoryProvider, this.bindLinkEventsReporterProvider, this.paymentOptionsViewModelFactoryComponentImpl.realErrorReporterProvider);
            this.bindLinkAccountManagerProvider = DoubleCheck.provider(this.defaultLinkAccountManagerProvider);
            this.defaultLinkGateProvider = DefaultLinkGate_Factory.create(this.configurationProvider);
            this.bindsLinkGateProvider = DoubleCheck.provider(this.defaultLinkGateProvider);
            this.provideIntegrityStandardRequestManagerProvider = DoubleCheck.provider((Provider)LinkModule_Companion_ProvideIntegrityStandardRequestManagerFactory.create(this.paymentOptionsViewModelFactoryComponentImpl.applicationProvider));
            this.provideApplicationIdProvider = ApplicationIdModule_ProvideApplicationIdFactory.create(this.paymentOptionsViewModelFactoryComponentImpl.applicationProvider);
            this.defaultLinkAuthProvider = DefaultLinkAuth_Factory.create(this.bindsLinkGateProvider, this.bindLinkAccountManagerProvider, this.provideIntegrityStandardRequestManagerProvider, this.paymentOptionsViewModelFactoryComponentImpl.realErrorReporterProvider, this.provideApplicationIdProvider);
            this.bindsLinkAuthProvider = DoubleCheck.provider(this.defaultLinkAuthProvider);
            this.defaultLinkAttestationCheckProvider = DefaultLinkAttestationCheck_Factory.create(this.bindsLinkGateProvider, this.bindsLinkAuthProvider, this.provideIntegrityStandardRequestManagerProvider, this.bindLinkAccountManagerProvider, this.configurationProvider, this.paymentOptionsViewModelFactoryComponentImpl.realErrorReporterProvider, this.paymentOptionsViewModelFactoryComponentImpl.provideWorkContextProvider);
            this.bindsLinkAttestationCheckProvider = DoubleCheck.provider(this.defaultLinkAttestationCheckProvider);
            this.inlineSignupViewModelProvider = InlineSignupViewModel_Factory.create(this.configurationProvider, this.bindLinkAccountManagerProvider, this.bindLinkEventsReporterProvider, this.paymentOptionsViewModelFactoryComponentImpl.provideLoggerProvider);
            this.linkInlineSignupAssistedViewModelFactoryProvider = LinkInlineSignupAssistedViewModelFactory_Impl.createFactoryProvider(this.inlineSignupViewModelProvider);
        }

        @Override
        public LinkAccountManager getLinkAccountManager$paymentsheet_release() {
            return (LinkAccountManager)this.bindLinkAccountManagerProvider.get();
        }

        @Override
        public LinkConfiguration getConfiguration$paymentsheet_release() {
            return this.configuration;
        }

        @Override
        public LinkGate getLinkGate$paymentsheet_release() {
            return (LinkGate)this.bindsLinkGateProvider.get();
        }

        @Override
        public LinkAttestationCheck getLinkAttestationCheck$paymentsheet_release() {
            return (LinkAttestationCheck)this.bindsLinkAttestationCheckProvider.get();
        }

        @Override
        public LinkInlineSignupAssistedViewModelFactory getInlineSignupViewModelFactory$paymentsheet_release() {
            return (LinkInlineSignupAssistedViewModelFactory)this.linkInlineSignupAssistedViewModelFactoryProvider.get();
        }
    }

    private static final class PaymentOptionsViewModelSubcomponentImpl
    implements PaymentOptionsViewModelSubcomponent {
        private final PaymentOptionContract.Args args;
        private final PaymentOptionsViewModelFactoryComponentImpl paymentOptionsViewModelFactoryComponentImpl;
        private final PaymentOptionsViewModelSubcomponentImpl paymentOptionsViewModelSubcomponentImpl = this;

        private PaymentOptionsViewModelSubcomponentImpl(PaymentOptionsViewModelFactoryComponentImpl paymentOptionsViewModelFactoryComponentImpl, Application applicationParam, PaymentOptionContract.Args argsParam) {
            this.paymentOptionsViewModelFactoryComponentImpl = paymentOptionsViewModelFactoryComponentImpl;
            this.args = argsParam;
        }

        @Override
        public PaymentOptionsViewModel getViewModel() {
            return new PaymentOptionsViewModel(this.args, (EventReporter)this.paymentOptionsViewModelFactoryComponentImpl.bindsEventReporterProvider.get(), (CustomerRepository)this.paymentOptionsViewModelFactoryComponentImpl.customerApiRepositoryProvider.get(), (CoroutineContext)this.paymentOptionsViewModelFactoryComponentImpl.provideWorkContextProvider.get(), this.paymentOptionsViewModelFactoryComponentImpl.savedStateHandle, (LinkHandler)this.paymentOptionsViewModelFactoryComponentImpl.linkHandlerProvider.get(), (CardAccountRangeRepository.Factory)this.paymentOptionsViewModelFactoryComponentImpl.defaultCardAccountRangeRepositoryFactory());
        }
    }

    private static final class LinkComponentBuilder
    implements LinkComponent.Builder {
        private final PaymentOptionsViewModelFactoryComponentImpl paymentOptionsViewModelFactoryComponentImpl;
        private LinkConfiguration configuration;

        private LinkComponentBuilder(PaymentOptionsViewModelFactoryComponentImpl paymentOptionsViewModelFactoryComponentImpl) {
            this.paymentOptionsViewModelFactoryComponentImpl = paymentOptionsViewModelFactoryComponentImpl;
        }

        @Override
        public LinkComponentBuilder configuration(LinkConfiguration configuration) {
            this.configuration = (LinkConfiguration)Preconditions.checkNotNull((Object)configuration);
            return this;
        }

        @Override
        public LinkComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.configuration, LinkConfiguration.class);
            return new LinkComponentImpl(this.paymentOptionsViewModelFactoryComponentImpl, this.configuration);
        }
    }

    private static final class PaymentOptionsViewModelSubcomponentBuilder
    implements PaymentOptionsViewModelSubcomponent.Builder {
        private final PaymentOptionsViewModelFactoryComponentImpl paymentOptionsViewModelFactoryComponentImpl;
        private Application application;
        private PaymentOptionContract.Args args;

        private PaymentOptionsViewModelSubcomponentBuilder(PaymentOptionsViewModelFactoryComponentImpl paymentOptionsViewModelFactoryComponentImpl) {
            this.paymentOptionsViewModelFactoryComponentImpl = paymentOptionsViewModelFactoryComponentImpl;
        }

        @Override
        public PaymentOptionsViewModelSubcomponentBuilder application(Application application) {
            this.application = (Application)Preconditions.checkNotNull((Object)application);
            return this;
        }

        @Override
        public PaymentOptionsViewModelSubcomponentBuilder args(PaymentOptionContract.Args args) {
            this.args = (PaymentOptionContract.Args)Preconditions.checkNotNull((Object)args);
            return this;
        }

        @Override
        public PaymentOptionsViewModelSubcomponent build() {
            Preconditions.checkBuilderRequirement((Object)this.application, Application.class);
            Preconditions.checkBuilderRequirement((Object)this.args, PaymentOptionContract.Args.class);
            return new PaymentOptionsViewModelSubcomponentImpl(this.paymentOptionsViewModelFactoryComponentImpl, this.application, this.args);
        }
    }
}

