/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.repositories;

import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.model.DeferredIntentParams;
import com.stripe.android.model.ElementsSessionParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentsheet.IntentConfigurationKtxKt;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.state.PaymentElementLoader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0002\u001aL\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\b*\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u000b*\u00020\u0006H\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a>\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0000\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00160\u00152\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u00150\u0018H\u0082\b\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"withoutWeChatPay", "Lcom/stripe/android/model/StripeIntent;", "toElementsSessionParams", "Lcom/stripe/android/model/ElementsSessionParams;", "Lcom/stripe/android/paymentsheet/state/PaymentElementLoader$InitializationMode;", "customer", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerConfiguration;", "customPaymentMethods", "", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomPaymentMethod;", "externalPaymentMethods", "", "savedPaymentMethodSelectionId", "mobileSessionId", "appId", "toElementSessionParam", "toStripeIntent", "Lcom/stripe/android/model/ElementsSessionParams$DeferredIntentType;", "options", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "getResultOrElse", "Lkotlin/Result;", "T", "transform", "Lkotlin/Function1;", "", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "paymentsheet_release"})
@SourceDebugExtension(value={"SMAP\nElementsSessionRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ElementsSessionRepository.kt\ncom/stripe/android/paymentsheet/repositories/ElementsSessionRepositoryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n774#2:226\n865#2,2:227\n1557#2:230\n1628#2,3:231\n1#3:229\n*S KotlinDebug\n*F\n+ 1 ElementsSessionRepository.kt\ncom/stripe/android/paymentsheet/repositories/ElementsSessionRepositoryKt\n*L\n116#1:226\n116#1:227,2\n174#1:230\n174#1:231,3\n*E\n"})
public final class ElementsSessionRepositoryKt {
    /*
     * WARNING - void declaration
     */
    private static final StripeIntent withoutWeChatPay(StripeIntent $this$withoutWeChatPay) {
        StripeIntent stripeIntent;
        Collection collection;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$withoutWeChatPay.getPaymentMethodTypes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)PaymentMethod.Type.WeChatPay.code))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection2 = (List)destination$iv$iv;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = CollectionsKt.listOf((Object)"card");
        } else {
            collection = collection2;
        }
        List filteredPaymentMethodTypes = (List)collection;
        collection2 = $this$withoutWeChatPay;
        if (collection2 instanceof PaymentIntent) {
            stripeIntent = (StripeIntent)PaymentIntent.copy$default((PaymentIntent)((PaymentIntent)$this$withoutWeChatPay), null, (List)filteredPaymentMethodTypes, null, (long)0L, null, null, null, null, null, (long)0L, null, null, (boolean)false, null, null, null, null, null, null, null, null, null, null, null, (int)0xFFFFFD, null);
        } else if (collection2 instanceof SetupIntent) {
            stripeIntent = (StripeIntent)SetupIntent.copy$default((SetupIntent)((SetupIntent)$this$withoutWeChatPay), null, null, (long)0L, null, null, null, (boolean)false, null, null, (List)filteredPaymentMethodTypes, null, null, null, null, null, null, null, (int)130559, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return stripeIntent;
    }

    @NotNull
    public static final ElementsSessionParams toElementsSessionParams(@NotNull PaymentElementLoader.InitializationMode $this$toElementsSessionParams, @Nullable PaymentSheet.CustomerConfiguration customer2, @NotNull List<PaymentSheet.CustomPaymentMethod> customPaymentMethods, @NotNull List<String> externalPaymentMethods, @Nullable String savedPaymentMethodSelectionId, @NotNull String mobileSessionId, @NotNull String appId) {
        ElementsSessionParams elementsSessionParams;
        Intrinsics.checkNotNullParameter((Object)$this$toElementsSessionParams, (String)"<this>");
        Intrinsics.checkNotNullParameter(customPaymentMethods, (String)"customPaymentMethods");
        Intrinsics.checkNotNullParameter(externalPaymentMethods, (String)"externalPaymentMethods");
        Intrinsics.checkNotNullParameter((Object)mobileSessionId, (String)"mobileSessionId");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        PaymentSheet.CustomerConfiguration customerConfiguration = customer2;
        String customerSessionClientSecret = customerConfiguration != null ? ElementsSessionRepositoryKt.toElementSessionParam(customerConfiguration) : null;
        List<String> customPaymentMethodIds = ElementsSessionRepositoryKt.toElementSessionParam(customPaymentMethods);
        PaymentElementLoader.InitializationMode initializationMode = $this$toElementsSessionParams;
        if (initializationMode instanceof PaymentElementLoader.InitializationMode.PaymentIntent) {
            String string2 = ((PaymentElementLoader.InitializationMode.PaymentIntent)$this$toElementsSessionParams).getClientSecret();
            elementsSessionParams = (ElementsSessionParams)new ElementsSessionParams.PaymentIntentType(string2, null, customerSessionClientSecret, savedPaymentMethodSelectionId, mobileSessionId, customPaymentMethodIds, externalPaymentMethods, appId, 2, null);
        } else if (initializationMode instanceof PaymentElementLoader.InitializationMode.SetupIntent) {
            String string3 = ((PaymentElementLoader.InitializationMode.SetupIntent)$this$toElementsSessionParams).getClientSecret();
            elementsSessionParams = (ElementsSessionParams)new ElementsSessionParams.SetupIntentType(string3, null, customerSessionClientSecret, savedPaymentMethodSelectionId, mobileSessionId, customPaymentMethodIds, externalPaymentMethods, appId, 2, null);
        } else if (initializationMode instanceof PaymentElementLoader.InitializationMode.DeferredIntent) {
            DeferredIntentParams deferredIntentParams = IntentConfigurationKtxKt.toDeferredIntentParams(((PaymentElementLoader.InitializationMode.DeferredIntent)$this$toElementsSessionParams).getIntentConfiguration());
            elementsSessionParams = (ElementsSessionParams)new ElementsSessionParams.DeferredIntentType(null, deferredIntentParams, customPaymentMethodIds, externalPaymentMethods, savedPaymentMethodSelectionId, customerSessionClientSecret, mobileSessionId, appId, 1, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return elementsSessionParams;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> toElementSessionParam(List<PaymentSheet.CustomPaymentMethod> $this$toElementSessionParam) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toElementSessionParam;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void customPaymentMethod;
            PaymentSheet.CustomPaymentMethod customPaymentMethod2 = (PaymentSheet.CustomPaymentMethod)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(customPaymentMethod.getId());
        }
        return (List)destination$iv$iv;
    }

    private static final String toElementSessionParam(PaymentSheet.CustomerConfiguration $this$toElementSessionParam) {
        String string2;
        PaymentSheet.CustomerAccessType customerAccessType = $this$toElementSessionParam.getAccessType$paymentsheet_release();
        if (customerAccessType instanceof PaymentSheet.CustomerAccessType.CustomerSession) {
            string2 = ((PaymentSheet.CustomerAccessType.CustomerSession)$this$toElementSessionParam.getAccessType$paymentsheet_release()).getCustomerSessionClientSecret();
        } else if (customerAccessType instanceof PaymentSheet.CustomerAccessType.LegacyCustomerEphemeralKey) {
            string2 = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private static final StripeIntent toStripeIntent(ElementsSessionParams.DeferredIntentType $this$toStripeIntent, ApiRequest.Options options) {
        StripeIntent stripeIntent;
        DeferredIntentParams deferredIntentParams = $this$toStripeIntent.getDeferredIntentParams();
        long now = Calendar.getInstance().getTimeInMillis();
        DeferredIntentParams.Mode deferredIntentMode = deferredIntentParams.getMode();
        if (deferredIntentMode instanceof DeferredIntentParams.Mode.Payment) {
            stripeIntent = (StripeIntent)new PaymentIntent(deferredIntentParams.getPaymentMethodConfigurationId(), deferredIntentParams.getPaymentMethodTypes(), Long.valueOf(((DeferredIntentParams.Mode.Payment)deferredIntentMode).getAmount()), 0L, null, null, $this$toStripeIntent.getClientSecret(), null, null, now, deferredIntentParams.getMode().getCurrency(), null, options.getApiKeyIsLiveMode(), null, null, null, null, null, null, null, CollectionsKt.emptyList(), null, null, null, 15722680, null);
        } else if (deferredIntentMode instanceof DeferredIntentParams.Mode.Setup) {
            String string2 = deferredIntentParams.getPaymentMethodConfigurationId();
            String string3 = $this$toStripeIntent.getClientSecret();
            boolean bl = options.getApiKeyIsLiveMode();
            List list = CollectionsKt.emptyList();
            List list2 = deferredIntentParams.getPaymentMethodTypes();
            List list3 = CollectionsKt.emptyList();
            stripeIntent = (StripeIntent)new SetupIntent(string2, null, now, null, string3, null, bl, null, null, list2, null, null, null, list3, list, null, null, 69760, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return stripeIntent;
    }

    private static final <T> Object getResultOrElse(Object $this$getResultOrElse, Function1<? super Throwable, ? extends Result<? extends T>> transform) {
        boolean $i$f$getResultOrElse = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)$this$getResultOrElse);
        return throwable != null ? ((Result)transform.invoke((Object)throwable)).unbox-impl() : $this$getResultOrElse;
    }

    public static final /* synthetic */ StripeIntent access$toStripeIntent(ElementsSessionParams.DeferredIntentType $receiver, ApiRequest.Options options) {
        return ElementsSessionRepositoryKt.toStripeIntent($receiver, options);
    }

    public static final /* synthetic */ StripeIntent access$withoutWeChatPay(StripeIntent $receiver) {
        return ElementsSessionRepositoryKt.withoutWeChatPay($receiver);
    }
}

