/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.state;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.StripeIntent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b1\u0018\u00002\u00020\u0001:\u0006\b\t\n\u000b\f\rB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0006\u000e\u000f\u0010\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException;", "", "<init>", "()V", "type", "", "getType", "()Ljava/lang/String;", "InvalidConfirmationMethod", "NoPaymentMethodTypesAvailable", "PaymentIntentInTerminalState", "SetupIntentInTerminalState", "MissingAmountOrCurrency", "Unknown", "Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException$InvalidConfirmationMethod;", "Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException$MissingAmountOrCurrency;", "Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException$NoPaymentMethodTypesAvailable;", "Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException$PaymentIntentInTerminalState;", "Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException$SetupIntentInTerminalState;", "Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException$Unknown;", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public abstract class PaymentSheetLoadingException
extends Throwable {
    public static final int $stable;

    private PaymentSheetLoadingException() {
    }

    @NotNull
    public abstract String getType();

    public /* synthetic */ PaymentSheetLoadingException(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0007H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException$InvalidConfirmationMethod;", "Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException;", "confirmationMethod", "Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod;", "<init>", "(Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod;)V", "type", "", "getType", "()Ljava/lang/String;", "message", "getMessage", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static final class InvalidConfirmationMethod
    extends PaymentSheetLoadingException {
        @NotNull
        private final PaymentIntent.ConfirmationMethod confirmationMethod;
        @NotNull
        private final String type;
        @NotNull
        private final String message;
        public static final int $stable;

        public InvalidConfirmationMethod(@NotNull PaymentIntent.ConfirmationMethod confirmationMethod) {
            Intrinsics.checkNotNullParameter((Object)confirmationMethod, (String)"confirmationMethod");
            super((DefaultConstructorMarker)null);
            this.confirmationMethod = confirmationMethod;
            this.type = "invalidConfirmationMethod";
            this.message = StringsKt.trimIndent((String)("\n            PaymentIntent with confirmation_method='automatic' is required.\n            The current PaymentIntent has confirmation_method '" + this.confirmationMethod + "'.\n            See https://stripe.com/docs/api/payment_intents/object#payment_intent_object-confirmation_method.\n        "));
        }

        @Override
        @NotNull
        public String getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        private final PaymentIntent.ConfirmationMethod component1() {
            return this.confirmationMethod;
        }

        @NotNull
        public final InvalidConfirmationMethod copy(@NotNull PaymentIntent.ConfirmationMethod confirmationMethod) {
            Intrinsics.checkNotNullParameter((Object)confirmationMethod, (String)"confirmationMethod");
            return new InvalidConfirmationMethod(confirmationMethod);
        }

        public static /* synthetic */ InvalidConfirmationMethod copy$default(InvalidConfirmationMethod invalidConfirmationMethod, PaymentIntent.ConfirmationMethod confirmationMethod, int n, Object object) {
            if ((n & 1) != 0) {
                confirmationMethod = invalidConfirmationMethod.confirmationMethod;
            }
            return invalidConfirmationMethod.copy(confirmationMethod);
        }

        @Override
        @NotNull
        public String toString() {
            return "InvalidConfirmationMethod(confirmationMethod=" + this.confirmationMethod + ")";
        }

        public int hashCode() {
            return this.confirmationMethod.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InvalidConfirmationMethod)) {
                return false;
            }
            InvalidConfirmationMethod invalidConfirmationMethod = (InvalidConfirmationMethod)other;
            return this.confirmationMethod == invalidConfirmationMethod.confirmationMethod;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException$MissingAmountOrCurrency;", "Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException;", "<init>", "()V", "type", "", "getType", "()Ljava/lang/String;", "message", "getMessage", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static final class MissingAmountOrCurrency
    extends PaymentSheetLoadingException {
        @NotNull
        public static final MissingAmountOrCurrency INSTANCE = new MissingAmountOrCurrency();
        @NotNull
        private static final String type = "missingAmountOrCurrency";
        @NotNull
        private static final String message = "PaymentIntent must contain amount and currency.";
        public static final int $stable;

        private MissingAmountOrCurrency() {
            super((DefaultConstructorMarker)null);
        }

        @Override
        @NotNull
        public String getType() {
            return type;
        }

        @Override
        @NotNull
        public String getMessage() {
            return message;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException$NoPaymentMethodTypesAvailable;", "Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException;", "requested", "", "<init>", "(Ljava/lang/String;)V", "type", "getType", "()Ljava/lang/String;", "message", "getMessage", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static final class NoPaymentMethodTypesAvailable
    extends PaymentSheetLoadingException {
        @NotNull
        private final String requested;
        @NotNull
        private final String type;
        public static final int $stable;

        public NoPaymentMethodTypesAvailable(@NotNull String requested) {
            Intrinsics.checkNotNullParameter((Object)requested, (String)"requested");
            super((DefaultConstructorMarker)null);
            this.requested = requested;
            this.type = "noPaymentMethodTypesAvailable";
        }

        @Override
        @NotNull
        public String getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getMessage() {
            return "None of the requested payment methods (" + this.requested + ") are supported.";
        }

        private final String component1() {
            return this.requested;
        }

        @NotNull
        public final NoPaymentMethodTypesAvailable copy(@NotNull String requested) {
            Intrinsics.checkNotNullParameter((Object)requested, (String)"requested");
            return new NoPaymentMethodTypesAvailable(requested);
        }

        public static /* synthetic */ NoPaymentMethodTypesAvailable copy$default(NoPaymentMethodTypesAvailable noPaymentMethodTypesAvailable, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = noPaymentMethodTypesAvailable.requested;
            }
            return noPaymentMethodTypesAvailable.copy(string2);
        }

        @Override
        @NotNull
        public String toString() {
            return "NoPaymentMethodTypesAvailable(requested=" + this.requested + ")";
        }

        public int hashCode() {
            return this.requested.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NoPaymentMethodTypesAvailable)) {
                return false;
            }
            NoPaymentMethodTypesAvailable noPaymentMethodTypesAvailable = (NoPaymentMethodTypesAvailable)other;
            return Intrinsics.areEqual((Object)this.requested, (Object)noPaymentMethodTypesAvailable.requested);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u0015\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0007H\u00d6\u0001R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException$PaymentIntentInTerminalState;", "Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException;", "status", "Lcom/stripe/android/model/StripeIntent$Status;", "<init>", "(Lcom/stripe/android/model/StripeIntent$Status;)V", "type", "", "getType", "()Ljava/lang/String;", "message", "getMessage", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static final class PaymentIntentInTerminalState
    extends PaymentSheetLoadingException {
        @Nullable
        private final StripeIntent.Status status;
        @NotNull
        private final String type;
        public static final int $stable;

        public PaymentIntentInTerminalState(@Nullable StripeIntent.Status status) {
            super((DefaultConstructorMarker)null);
            this.status = status;
            this.type = "paymentIntentInTerminalState";
        }

        @Override
        @NotNull
        public String getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getMessage() {
            return StringsKt.trimIndent((String)("\n                PaymentSheet cannot set up a PaymentIntent in status '" + this.status + "'.\n                See https://stripe.com/docs/api/payment_intents/object#payment_intent_object-status.\n            "));
        }

        private final StripeIntent.Status component1() {
            return this.status;
        }

        @NotNull
        public final PaymentIntentInTerminalState copy(@Nullable StripeIntent.Status status) {
            return new PaymentIntentInTerminalState(status);
        }

        public static /* synthetic */ PaymentIntentInTerminalState copy$default(PaymentIntentInTerminalState paymentIntentInTerminalState, StripeIntent.Status status, int n, Object object) {
            if ((n & 1) != 0) {
                status = paymentIntentInTerminalState.status;
            }
            return paymentIntentInTerminalState.copy(status);
        }

        @Override
        @NotNull
        public String toString() {
            return "PaymentIntentInTerminalState(status=" + this.status + ")";
        }

        public int hashCode() {
            return this.status == null ? 0 : this.status.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PaymentIntentInTerminalState)) {
                return false;
            }
            PaymentIntentInTerminalState paymentIntentInTerminalState = (PaymentIntentInTerminalState)other;
            return this.status == paymentIntentInTerminalState.status;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u0015\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0007H\u00d6\u0001R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException$SetupIntentInTerminalState;", "Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException;", "status", "Lcom/stripe/android/model/StripeIntent$Status;", "<init>", "(Lcom/stripe/android/model/StripeIntent$Status;)V", "type", "", "getType", "()Ljava/lang/String;", "message", "getMessage", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static final class SetupIntentInTerminalState
    extends PaymentSheetLoadingException {
        @Nullable
        private final StripeIntent.Status status;
        @NotNull
        private final String type;
        public static final int $stable;

        public SetupIntentInTerminalState(@Nullable StripeIntent.Status status) {
            super((DefaultConstructorMarker)null);
            this.status = status;
            this.type = "setupIntentInTerminalState";
        }

        @Override
        @NotNull
        public String getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getMessage() {
            return StringsKt.trimIndent((String)("\n                PaymentSheet cannot set up a SetupIntent in status '" + this.status + "'.\n                See https://stripe.com/docs/api/setup_intents/object#setup_intent_object-status.\n            "));
        }

        private final StripeIntent.Status component1() {
            return this.status;
        }

        @NotNull
        public final SetupIntentInTerminalState copy(@Nullable StripeIntent.Status status) {
            return new SetupIntentInTerminalState(status);
        }

        public static /* synthetic */ SetupIntentInTerminalState copy$default(SetupIntentInTerminalState setupIntentInTerminalState, StripeIntent.Status status, int n, Object object) {
            if ((n & 1) != 0) {
                status = setupIntentInTerminalState.status;
            }
            return setupIntentInTerminalState.copy(status);
        }

        @Override
        @NotNull
        public String toString() {
            return "SetupIntentInTerminalState(status=" + this.status + ")";
        }

        public int hashCode() {
            return this.status == null ? 0 : this.status.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SetupIntentInTerminalState)) {
                return false;
            }
            SetupIntentInTerminalState setupIntentInTerminalState = (SetupIntentInTerminalState)other;
            return this.status == setupIntentInTerminalState.status;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\tH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException$Unknown;", "Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException;", "cause", "", "<init>", "(Ljava/lang/Throwable;)V", "getCause", "()Ljava/lang/Throwable;", "type", "", "getType", "()Ljava/lang/String;", "message", "getMessage", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class Unknown
    extends PaymentSheetLoadingException {
        @NotNull
        private final Throwable cause;
        @Nullable
        private final String message;
        public static final int $stable = 8;

        public Unknown(@NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super((DefaultConstructorMarker)null);
            this.cause = cause;
            this.message = this.getCause().getMessage();
        }

        @Override
        @NotNull
        public Throwable getCause() {
            return this.cause;
        }

        @Override
        @NotNull
        public String getType() {
            return StripeException.Companion.create(this.getCause()).analyticsValue();
        }

        @Override
        @Nullable
        public String getMessage() {
            return this.message;
        }

        @NotNull
        public final Throwable component1() {
            return this.cause;
        }

        @NotNull
        public final Unknown copy(@NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            return new Unknown(cause);
        }

        public static /* synthetic */ Unknown copy$default(Unknown unknown, Throwable throwable, int n, Object object) {
            if ((n & 1) != 0) {
                throwable = unknown.cause;
            }
            return unknown.copy(throwable);
        }

        @Override
        @NotNull
        public String toString() {
            return "Unknown(cause=" + this.cause + ")";
        }

        public int hashCode() {
            return this.cause.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Unknown)) {
                return false;
            }
            Unknown unknown = (Unknown)other;
            return Intrinsics.areEqual((Object)this.cause, (Object)unknown.cause);
        }
    }
}

