/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.model.CardBrand;
import com.stripe.android.ui.core.R;
import com.stripe.android.uicore.elements.SingleChoiceDropdownItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\rH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/paymentsheet/ui/CardBrandChoice;", "Lcom/stripe/android/uicore/elements/SingleChoiceDropdownItem;", "brand", "Lcom/stripe/android/model/CardBrand;", "enabled", "", "<init>", "(Lcom/stripe/android/model/CardBrand;Z)V", "getBrand", "()Lcom/stripe/android/model/CardBrand;", "getEnabled", "()Z", "icon", "", "getIcon", "()Ljava/lang/Integer;", "label", "Lcom/stripe/android/core/strings/ResolvableString;", "getLabel", "()Lcom/stripe/android/core/strings/ResolvableString;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "toString", "", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class CardBrandChoice
implements SingleChoiceDropdownItem {
    @NotNull
    private final CardBrand brand;
    private final boolean enabled;
    public static final int $stable;

    public CardBrandChoice(@NotNull CardBrand brand, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)brand, (String)"brand");
        this.brand = brand;
        this.enabled = enabled;
    }

    @NotNull
    public final CardBrand getBrand() {
        return this.brand;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public Integer getIcon() {
        return this.brand.getIcon();
    }

    @NotNull
    public ResolvableString getLabel() {
        ResolvableString resolvableString;
        if (this.getEnabled()) {
            resolvableString = ResolvableStringUtilsKt.getResolvableString((String)this.brand.getDisplayName());
        } else {
            Object[] objectArray = new Object[]{this.brand.getDisplayName()};
            resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_card_brand_not_accepted_with_brand, (Object[])objectArray, null, (int)4, null);
        }
        return resolvableString;
    }

    @NotNull
    public final CardBrand component1() {
        return this.brand;
    }

    public final boolean component2() {
        return this.enabled;
    }

    @NotNull
    public final CardBrandChoice copy(@NotNull CardBrand brand, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)brand, (String)"brand");
        return new CardBrandChoice(brand, enabled);
    }

    public static /* synthetic */ CardBrandChoice copy$default(CardBrandChoice cardBrandChoice, CardBrand cardBrand, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            cardBrand = cardBrandChoice.brand;
        }
        if ((n & 2) != 0) {
            bl = cardBrandChoice.enabled;
        }
        return cardBrandChoice.copy(cardBrand, bl);
    }

    @NotNull
    public String toString() {
        return "CardBrandChoice(brand=" + this.brand + ", enabled=" + this.enabled + ")";
    }

    public int hashCode() {
        int result2 = this.brand.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.enabled);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CardBrandChoice)) {
            return false;
        }
        CardBrandChoice cardBrandChoice = (CardBrandChoice)other;
        if (this.brand != cardBrandChoice.brand) {
            return false;
        }
        return this.enabled == cardBrandChoice.enabled;
    }
}

