/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.paymentsheet.ui.CardBrandChoice;
import com.stripe.android.paymentsheet.ui.EditCardPayload;
import com.stripe.android.paymentsheet.ui.ExpiryDateState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\rJ\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/paymentsheet/ui/CardDetailsEntry;", "", "cardBrandChoice", "Lcom/stripe/android/paymentsheet/ui/CardBrandChoice;", "expiryDateState", "Lcom/stripe/android/paymentsheet/ui/ExpiryDateState;", "<init>", "(Lcom/stripe/android/paymentsheet/ui/CardBrandChoice;Lcom/stripe/android/paymentsheet/ui/ExpiryDateState;)V", "getCardBrandChoice", "()Lcom/stripe/android/paymentsheet/ui/CardBrandChoice;", "getExpiryDateState", "()Lcom/stripe/android/paymentsheet/ui/ExpiryDateState;", "hasChanged", "", "editCardPayload", "Lcom/stripe/android/paymentsheet/ui/EditCardPayload;", "originalCardBrandChoice", "isComplete", "expiryDateHasChanged", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class CardDetailsEntry {
    @NotNull
    private final CardBrandChoice cardBrandChoice;
    @NotNull
    private final ExpiryDateState expiryDateState;
    public static final int $stable;

    public CardDetailsEntry(@NotNull CardBrandChoice cardBrandChoice, @NotNull ExpiryDateState expiryDateState) {
        Intrinsics.checkNotNullParameter((Object)cardBrandChoice, (String)"cardBrandChoice");
        Intrinsics.checkNotNullParameter((Object)expiryDateState, (String)"expiryDateState");
        this.cardBrandChoice = cardBrandChoice;
        this.expiryDateState = expiryDateState;
    }

    @NotNull
    public final CardBrandChoice getCardBrandChoice() {
        return this.cardBrandChoice;
    }

    @NotNull
    public final ExpiryDateState getExpiryDateState() {
        return this.expiryDateState;
    }

    public final boolean hasChanged(@NotNull EditCardPayload editCardPayload, @NotNull CardBrandChoice originalCardBrandChoice) {
        Intrinsics.checkNotNullParameter((Object)editCardPayload, (String)"editCardPayload");
        Intrinsics.checkNotNullParameter((Object)originalCardBrandChoice, (String)"originalCardBrandChoice");
        return !Intrinsics.areEqual((Object)originalCardBrandChoice, (Object)this.cardBrandChoice) || this.expiryDateHasChanged(editCardPayload);
    }

    public final boolean isComplete() {
        if (!this.expiryDateState.getEnabled()) {
            return true;
        }
        return this.expiryDateState.getExpiryMonth() != null && this.expiryDateState.getExpiryYear() != null;
    }

    private final boolean expiryDateHasChanged(EditCardPayload editCardPayload) {
        return !Intrinsics.areEqual((Object)editCardPayload.getExpiryMonth(), (Object)this.expiryDateState.getExpiryMonth()) || !Intrinsics.areEqual((Object)editCardPayload.getExpiryYear(), (Object)this.expiryDateState.getExpiryYear());
    }

    @NotNull
    public final CardBrandChoice component1() {
        return this.cardBrandChoice;
    }

    @NotNull
    public final ExpiryDateState component2() {
        return this.expiryDateState;
    }

    @NotNull
    public final CardDetailsEntry copy(@NotNull CardBrandChoice cardBrandChoice, @NotNull ExpiryDateState expiryDateState) {
        Intrinsics.checkNotNullParameter((Object)cardBrandChoice, (String)"cardBrandChoice");
        Intrinsics.checkNotNullParameter((Object)expiryDateState, (String)"expiryDateState");
        return new CardDetailsEntry(cardBrandChoice, expiryDateState);
    }

    public static /* synthetic */ CardDetailsEntry copy$default(CardDetailsEntry cardDetailsEntry, CardBrandChoice cardBrandChoice, ExpiryDateState expiryDateState, int n, Object object) {
        if ((n & 1) != 0) {
            cardBrandChoice = cardDetailsEntry.cardBrandChoice;
        }
        if ((n & 2) != 0) {
            expiryDateState = cardDetailsEntry.expiryDateState;
        }
        return cardDetailsEntry.copy(cardBrandChoice, expiryDateState);
    }

    @NotNull
    public String toString() {
        return "CardDetailsEntry(cardBrandChoice=" + this.cardBrandChoice + ", expiryDateState=" + this.expiryDateState + ")";
    }

    public int hashCode() {
        int result2 = this.cardBrandChoice.hashCode();
        result2 = result2 * 31 + this.expiryDateState.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CardDetailsEntry)) {
            return false;
        }
        CardDetailsEntry cardDetailsEntry = (CardDetailsEntry)other;
        if (!Intrinsics.areEqual((Object)this.cardBrandChoice, (Object)cardDetailsEntry.cardBrandChoice)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.expiryDateState, (Object)cardDetailsEntry.expiryDateState);
    }
}

