/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.ui;

import androidx.compose.runtime.Immutable;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.paymentsheet.ui.EditCardPayload;
import com.stripe.android.paymentsheet.ui.ExpiryDateStateKt;
import com.stripe.android.ui.core.elements.CardDetailsUtil;
import com.stripe.android.uicore.elements.DateConfig;
import com.stripe.android.uicore.elements.FieldError;
import com.stripe.android.uicore.elements.IdentifierSpec;
import com.stripe.android.uicore.elements.TextFieldState;
import com.stripe.android.uicore.elements.TextFieldStateConstants;
import com.stripe.android.uicore.elements.TextFieldStateKt;
import com.stripe.android.uicore.forms.FormFieldEntry;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0081\b\u0018\u0000 ,2\u00020\u0001:\u0001,B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001a\u001a\u00020\u0005J\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0003J7\u0010\u001f\u001a\u0004\u0018\u00010\u0015*\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010#J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0007H\u00c2\u0003J'\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010(\u001a\u00020\u00052\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\u0015H\u00d6\u0001J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006-"}, d2={"Lcom/stripe/android/paymentsheet/ui/ExpiryDateState;", "", "text", "", "enabled", "", "dateConfig", "Lcom/stripe/android/uicore/elements/DateConfig;", "<init>", "(Ljava/lang/String;ZLcom/stripe/android/uicore/elements/DateConfig;)V", "getText", "()Ljava/lang/String;", "getEnabled", "()Z", "textFieldState", "Lcom/stripe/android/uicore/elements/TextFieldState;", "formFieldValues", "", "Lcom/stripe/android/uicore/elements/IdentifierSpec;", "Lcom/stripe/android/uicore/forms/FormFieldEntry;", "expiryMonth", "", "getExpiryMonth", "()Ljava/lang/Integer;", "expiryYear", "getExpiryYear", "shouldShowError", "sectionError", "Lcom/stripe/android/core/strings/ResolvableString;", "onDateChanged", "proposedValue", "toIntOrNull", "key", "min", "max", "(Ljava/util/Map;Lcom/stripe/android/uicore/elements/IdentifierSpec;II)Ljava/lang/Integer;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "Companion", "paymentsheet_release"})
@Immutable
@SourceDebugExtension(value={"SMAP\nExpiryDateState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpiryDateState.kt\ncom/stripe/android/paymentsheet/ui/ExpiryDateState\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,158:1\n18#2:159\n*S KotlinDebug\n*F\n+ 1 ExpiryDateState.kt\ncom/stripe/android/paymentsheet/ui/ExpiryDateState\n*L\n63#1:159\n*E\n"})
public final class ExpiryDateState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    private final boolean enabled;
    @NotNull
    private final DateConfig dateConfig;
    @NotNull
    private final TextFieldState textFieldState;
    @Nullable
    private final Map<IdentifierSpec, FormFieldEntry> formFieldValues;
    public static final int $stable;

    /*
     * WARNING - void declaration
     */
    public ExpiryDateState(@NotNull String text, boolean enabled, @NotNull DateConfig dateConfig) {
        void $this$formFieldValues_u24lambda_u241;
        ExpiryDateState $this$textFieldState_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)dateConfig, (String)"dateConfig");
        this.text = text;
        this.enabled = enabled;
        this.dateConfig = dateConfig;
        ExpiryDateState expiryDateState = this;
        ExpiryDateState expiryDateState2 = this;
        boolean bl = false;
        expiryDateState2.textFieldState = Intrinsics.areEqual((Object)$this$textFieldState_u24lambda_u240.text, (Object)"\u2022\u2022 / \u2022\u2022") ? (TextFieldState)TextFieldStateConstants.Error.Blank.INSTANCE : $this$textFieldState_u24lambda_u240.dateConfig.determineState($this$textFieldState_u24lambda_u240.text);
        $this$textFieldState_u24lambda_u240 = this;
        expiryDateState2 = this;
        boolean bl2 = false;
        expiryDateState2.formFieldValues = $this$formFieldValues_u24lambda_u241.textFieldState.isValid() ? CardDetailsUtil.INSTANCE.createExpiryDateFormFieldValues(new FormFieldEntry($this$formFieldValues_u24lambda_u241.text, false, 2, null)) : null;
    }

    public /* synthetic */ ExpiryDateState(String string2, boolean bl, DateConfig dateConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            dateConfig = new DateConfig();
        }
        this(string2, bl, dateConfig);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    @Nullable
    public final Integer getExpiryMonth() {
        Map<IdentifierSpec, FormFieldEntry> map2 = this.formFieldValues;
        return map2 != null ? this.toIntOrNull(map2, IdentifierSpec.Companion.getCardExpMonth(), 1, 12) : null;
    }

    @Nullable
    public final Integer getExpiryYear() {
        Map<IdentifierSpec, FormFieldEntry> map2 = this.formFieldValues;
        return map2 != null ? this.toIntOrNull(map2, IdentifierSpec.Companion.getCardExpYear(), 2000, 2100) : null;
    }

    public final boolean shouldShowError() {
        return this.textFieldState.shouldShowError(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final ResolvableString sectionError() {
        FieldError fieldError;
        boolean hasError = this.textFieldState.shouldShowError(true);
        FieldError fieldError2 = this.textFieldState.getError();
        if (fieldError2 == null) return null;
        FieldError it = fieldError = fieldError2;
        boolean bl = false;
        if (!hasError) return null;
        if (!this.enabled) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        FieldError fieldError3 = fieldError;
        FieldError fieldError4 = fieldError3;
        if (fieldError4 == null) return null;
        FieldError error = fieldError4;
        boolean bl3 = false;
        int n = error.getErrorMessage();
        Object[] $this$orEmpty$iv = error.getFormatArgs();
        boolean $i$f$orEmpty = false;
        Object[] objectArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            objectArray = new Object[]{};
        }
        Object[] objectArray2 = objectArray;
        ResolvableString resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)n, (Object[])Arrays.copyOf(objectArray2, objectArray2.length), null, (int)4, null);
        return resolvableString;
    }

    @NotNull
    public final ExpiryDateState onDateChanged(@NotNull String proposedValue) {
        Intrinsics.checkNotNullParameter((Object)proposedValue, (String)"proposedValue");
        boolean canAcceptInput = TextFieldStateKt.canAcceptInput((TextFieldState)this.textFieldState, (String)this.text, (String)proposedValue);
        if (!canAcceptInput) {
            return this;
        }
        return ExpiryDateState.copy$default(this, proposedValue, false, null, 6, null);
    }

    private final Integer toIntOrNull(Map<IdentifierSpec, FormFieldEntry> $this$toIntOrNull, IdentifierSpec key, int min, int max) {
        Object object;
        Object object2 = $this$toIntOrNull.get(key);
        if (object2 != null && (object2 = object2.getValue()) != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null) {
            Object object3 = object2;
            int it = ((Number)object3).intValue();
            boolean bl = false;
            object = (min <= it ? it <= max : false) ? object3 : null;
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    public final boolean component2() {
        return this.enabled;
    }

    private final DateConfig component3() {
        return this.dateConfig;
    }

    @NotNull
    public final ExpiryDateState copy(@NotNull String text, boolean enabled, @NotNull DateConfig dateConfig) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)dateConfig, (String)"dateConfig");
        return new ExpiryDateState(text, enabled, dateConfig);
    }

    public static /* synthetic */ ExpiryDateState copy$default(ExpiryDateState expiryDateState, String string2, boolean bl, DateConfig dateConfig, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = expiryDateState.text;
        }
        if ((n & 2) != 0) {
            bl = expiryDateState.enabled;
        }
        if ((n & 4) != 0) {
            dateConfig = expiryDateState.dateConfig;
        }
        return expiryDateState.copy(string2, bl, dateConfig);
    }

    @NotNull
    public String toString() {
        return "ExpiryDateState(text=" + this.text + ", enabled=" + this.enabled + ", dateConfig=" + this.dateConfig + ")";
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.enabled);
        result2 = result2 * 31 + this.dateConfig.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExpiryDateState)) {
            return false;
        }
        ExpiryDateState expiryDateState = (ExpiryDateState)other;
        if (!Intrinsics.areEqual((Object)this.text, (Object)expiryDateState.text)) {
            return false;
        }
        if (this.enabled != expiryDateState.enabled) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.dateConfig, (Object)expiryDateState.dateConfig);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/ui/ExpiryDateState$Companion;", "", "<init>", "()V", "create", "Lcom/stripe/android/paymentsheet/ui/ExpiryDateState;", "editPayload", "Lcom/stripe/android/paymentsheet/ui/EditCardPayload;", "enabled", "", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExpiryDateState create(@NotNull EditCardPayload editPayload, boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)editPayload, (String)"editPayload");
            String text = ExpiryDateStateKt.access$formattedExpiryDate(editPayload.getExpiryMonth(), editPayload.getExpiryYear(), enabled);
            return new ExpiryDateState(text, enabled, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

