/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.ui;

import androidx.annotation.DrawableRes;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.paymentdatacollection.ach.TransformToBankIcon;
import com.stripe.android.paymentsheet.ui.EditCardPayload;
import com.stripe.payments.model.R;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u001a'\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0001\u00a2\u0006\u0002\u0010\u0006\u001a)\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0001\u00a2\u0006\u0002\u0010\b\u001a'\u0010\u0000\u001a\u00020\u0001*\u00020\t2\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0001\u00a2\u0006\u0002\u0010\n\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\fH\u0001\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\fH\u0001\u001a\u001d\u0010\u000e\u001a\u00020\u0001*\u00020\f2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0001\u00a2\u0006\u0002\u0010\u000f\u001a\f\u0010\u0010\u001a\u00020\u0001*\u00020\fH\u0003\u001a\f\u0010\u0011\u001a\u00020\u0001*\u00020\fH\u0003\u001a\f\u0010\u0012\u001a\u00020\u0001*\u00020\fH\u0003\u001a\u0019\u0010\u0013\u001a\u00020\u00012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0001\u00a2\u0006\u0002\u0010\u0014\u001a\u0019\u0010\u0015\u001a\u00020\u00012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0001\u00a2\u0006\u0002\u0010\u0014\u001a5\u0010\u0016\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u0017\u001a\u00020\u00012\b\b\u0001\u0010\u0018\u001a\u00020\u00012\b\b\u0001\u0010\u0019\u001a\u00020\u0001H\u0003\u00a2\u0006\u0002\u0010\u001a\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u0002H\u0000\u001a\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u001e\u001a\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\b\u0010 \u001a\u0004\u0018\u00010!H\u0000\u00a8\u0006\""}, d2={"getSavedPaymentMethodIcon", "", "Lcom/stripe/android/model/PaymentMethod;", "forVerticalMode", "", "showNightIcon", "(Lcom/stripe/android/model/PaymentMethod;ZLjava/lang/Boolean;)I", "Lcom/stripe/android/model/PaymentMethod$Card;", "(Lcom/stripe/android/model/PaymentMethod$Card;ZLjava/lang/Boolean;)I", "Lcom/stripe/android/paymentsheet/ui/EditCardPayload;", "(Lcom/stripe/android/paymentsheet/ui/EditCardPayload;ZLjava/lang/Boolean;)I", "getCardBrandIcon", "Lcom/stripe/android/model/CardBrand;", "getCardBrandIconForVerticalMode", "getCardBrandIconForHorizontalMode", "(Lcom/stripe/android/model/CardBrand;Ljava/lang/Boolean;)I", "getCardBrandIconRef", "getNightIcon", "getDayIcon", "getLinkIcon", "(Ljava/lang/Boolean;)I", "getSepaIcon", "getOverridableIcon", "systemThemeAwareIconRef", "nightIcon", "dayIcon", "(Ljava/lang/Boolean;III)I", "getLabel", "Lcom/stripe/android/core/strings/ResolvableString;", "getLabelIcon", "(Lcom/stripe/android/model/PaymentMethod;)Ljava/lang/Integer;", "createCardLabel", "last4", "", "paymentsheet_release"})
@SourceDebugExtension(value={"SMAP\nPaymentMethodsUiExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentMethodsUiExtension.kt\ncom/stripe/android/paymentsheet/ui/PaymentMethodsUiExtensionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n1#2:205\n*E\n"})
public final class PaymentMethodsUiExtensionKt {
    @DrawableRes
    public static final int getSavedPaymentMethodIcon(@NotNull PaymentMethod $this$getSavedPaymentMethodIcon, boolean forVerticalMode, @Nullable Boolean showNightIcon) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$getSavedPaymentMethodIcon, (String)"<this>");
        PaymentMethod.Type type = $this$getSavedPaymentMethodIcon.type;
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                PaymentMethod.Card card = $this$getSavedPaymentMethodIcon.card;
                if (card != null) {
                    n = PaymentMethodsUiExtensionKt.getSavedPaymentMethodIcon(card, forVerticalMode, showNightIcon);
                    break;
                }
                n = null;
                break;
            }
            case 2: {
                n = PaymentMethodsUiExtensionKt.getSepaIcon(showNightIcon);
                break;
            }
            case 3: {
                Object object = $this$getSavedPaymentMethodIcon.usBankAccount;
                if (object != null && (object = object.bankName) != null) {
                    Object it = object;
                    boolean bl = false;
                    n = TransformToBankIcon.invoke$default(TransformToBankIcon.INSTANCE, (String)it, 0, 2, null);
                    break;
                }
                n = null;
                break;
            }
            default: {
                n = null;
            }
        }
        return n != null ? n : R.drawable.stripe_ic_paymentsheet_card_unknown_ref;
    }

    public static /* synthetic */ int getSavedPaymentMethodIcon$default(PaymentMethod paymentMethod, boolean bl, Boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = null;
        }
        return PaymentMethodsUiExtensionKt.getSavedPaymentMethodIcon(paymentMethod, bl, bl2);
    }

    @DrawableRes
    public static final int getSavedPaymentMethodIcon(@Nullable PaymentMethod.Card $this$getSavedPaymentMethodIcon, boolean forVerticalMode, @Nullable Boolean showNightIcon) {
        Object object;
        if ($this$getSavedPaymentMethodIcon != null) {
            CardBrand cardBrand;
            CardBrand it = cardBrand = CardBrand.Companion.fromCode($this$getSavedPaymentMethodIcon.displayBrand);
            boolean bl = false;
            object = it != CardBrand.Unknown ? cardBrand : null;
            if (object == null) {
                object = $this$getSavedPaymentMethodIcon.brand;
            }
        } else {
            object = CardBrand.Unknown;
        }
        CardBrand brand = object;
        return forVerticalMode ? PaymentMethodsUiExtensionKt.getCardBrandIconForVerticalMode(brand) : PaymentMethodsUiExtensionKt.getCardBrandIconForHorizontalMode(brand, showNightIcon);
    }

    public static /* synthetic */ int getSavedPaymentMethodIcon$default(PaymentMethod.Card card, boolean bl, Boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = null;
        }
        return PaymentMethodsUiExtensionKt.getSavedPaymentMethodIcon(card, bl, bl2);
    }

    @DrawableRes
    public static final int getSavedPaymentMethodIcon(@NotNull EditCardPayload $this$getSavedPaymentMethodIcon, boolean forVerticalMode, @Nullable Boolean showNightIcon) {
        Intrinsics.checkNotNullParameter((Object)$this$getSavedPaymentMethodIcon, (String)"<this>");
        return forVerticalMode ? PaymentMethodsUiExtensionKt.getCardBrandIconForVerticalMode($this$getSavedPaymentMethodIcon.getCardBrand()) : PaymentMethodsUiExtensionKt.getCardBrandIconForHorizontalMode($this$getSavedPaymentMethodIcon.getCardBrand(), showNightIcon);
    }

    public static /* synthetic */ int getSavedPaymentMethodIcon$default(EditCardPayload editCardPayload, boolean bl, Boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = null;
        }
        return PaymentMethodsUiExtensionKt.getSavedPaymentMethodIcon(editCardPayload, bl, bl2);
    }

    @DrawableRes
    public static final int getCardBrandIcon(@NotNull CardBrand $this$getCardBrandIcon) {
        Intrinsics.checkNotNullParameter((Object)$this$getCardBrandIcon, (String)"<this>");
        return PaymentMethodsUiExtensionKt.getCardBrandIconRef($this$getCardBrandIcon);
    }

    @DrawableRes
    public static final int getCardBrandIconForVerticalMode(@NotNull CardBrand $this$getCardBrandIconForVerticalMode) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getCardBrandIconForVerticalMode, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$getCardBrandIconForVerticalMode.ordinal()]) {
            case 1: {
                n = R.drawable.stripe_ic_visa_unpadded;
                break;
            }
            case 2: {
                n = R.drawable.stripe_ic_amex_unpadded;
                break;
            }
            case 3: {
                n = R.drawable.stripe_ic_discover_unpadded;
                break;
            }
            case 4: {
                n = R.drawable.stripe_ic_jcb_unpadded;
                break;
            }
            case 5: {
                n = R.drawable.stripe_ic_diners_unpadded;
                break;
            }
            case 6: {
                n = R.drawable.stripe_ic_mastercard_unpadded;
                break;
            }
            case 7: {
                n = R.drawable.stripe_ic_unionpay_unpadded;
                break;
            }
            case 8: {
                n = R.drawable.stripe_ic_cartes_bancaires_unpadded;
                break;
            }
            case 9: {
                n = R.drawable.stripe_ic_paymentsheet_card_unknown_ref;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @DrawableRes
    public static final int getCardBrandIconForHorizontalMode(@NotNull CardBrand $this$getCardBrandIconForHorizontalMode, @Nullable Boolean showNightIcon) {
        Intrinsics.checkNotNullParameter((Object)$this$getCardBrandIconForHorizontalMode, (String)"<this>");
        return PaymentMethodsUiExtensionKt.getOverridableIcon(showNightIcon, PaymentMethodsUiExtensionKt.getCardBrandIconRef($this$getCardBrandIconForHorizontalMode), PaymentMethodsUiExtensionKt.getNightIcon($this$getCardBrandIconForHorizontalMode), PaymentMethodsUiExtensionKt.getDayIcon($this$getCardBrandIconForHorizontalMode));
    }

    public static /* synthetic */ int getCardBrandIconForHorizontalMode$default(CardBrand cardBrand, Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = null;
        }
        return PaymentMethodsUiExtensionKt.getCardBrandIconForHorizontalMode(cardBrand, bl);
    }

    @DrawableRes
    private static final int getCardBrandIconRef(CardBrand $this$getCardBrandIconRef) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$getCardBrandIconRef.ordinal()]) {
            case 1: {
                n = R.drawable.stripe_ic_paymentsheet_card_visa_ref;
                break;
            }
            case 2: {
                n = R.drawable.stripe_ic_paymentsheet_card_amex_ref;
                break;
            }
            case 3: {
                n = R.drawable.stripe_ic_paymentsheet_card_discover_ref;
                break;
            }
            case 4: {
                n = R.drawable.stripe_ic_paymentsheet_card_jcb_ref;
                break;
            }
            case 5: {
                n = R.drawable.stripe_ic_paymentsheet_card_dinersclub_ref;
                break;
            }
            case 6: {
                n = R.drawable.stripe_ic_paymentsheet_card_mastercard_ref;
                break;
            }
            case 7: {
                n = R.drawable.stripe_ic_paymentsheet_card_unionpay_ref;
                break;
            }
            case 8: {
                n = R.drawable.stripe_ic_paymentsheet_card_cartes_bancaires_ref;
                break;
            }
            case 9: {
                n = R.drawable.stripe_ic_paymentsheet_card_unknown_ref;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @DrawableRes
    private static final int getNightIcon(CardBrand $this$getNightIcon) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$getNightIcon.ordinal()]) {
            case 1: {
                n = R.drawable.stripe_ic_paymentsheet_card_visa_night;
                break;
            }
            case 2: {
                n = R.drawable.stripe_ic_paymentsheet_card_amex_night;
                break;
            }
            case 3: {
                n = R.drawable.stripe_ic_paymentsheet_card_discover_night;
                break;
            }
            case 4: {
                n = R.drawable.stripe_ic_paymentsheet_card_jcb_night;
                break;
            }
            case 5: {
                n = R.drawable.stripe_ic_paymentsheet_card_dinersclub_night;
                break;
            }
            case 6: {
                n = R.drawable.stripe_ic_paymentsheet_card_mastercard_night;
                break;
            }
            case 7: {
                n = R.drawable.stripe_ic_paymentsheet_card_unionpay_night;
                break;
            }
            case 8: {
                n = R.drawable.stripe_ic_paymentsheet_card_cartes_bancaires_night;
                break;
            }
            case 9: {
                n = R.drawable.stripe_ic_paymentsheet_card_unknown_night;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @DrawableRes
    private static final int getDayIcon(CardBrand $this$getDayIcon) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$getDayIcon.ordinal()]) {
            case 1: {
                n = R.drawable.stripe_ic_paymentsheet_card_visa_day;
                break;
            }
            case 2: {
                n = R.drawable.stripe_ic_paymentsheet_card_amex_day;
                break;
            }
            case 3: {
                n = R.drawable.stripe_ic_paymentsheet_card_discover_day;
                break;
            }
            case 4: {
                n = R.drawable.stripe_ic_paymentsheet_card_jcb_day;
                break;
            }
            case 5: {
                n = R.drawable.stripe_ic_paymentsheet_card_dinersclub_day;
                break;
            }
            case 6: {
                n = R.drawable.stripe_ic_paymentsheet_card_mastercard_day;
                break;
            }
            case 7: {
                n = R.drawable.stripe_ic_paymentsheet_card_unionpay_day;
                break;
            }
            case 8: {
                n = R.drawable.stripe_ic_paymentsheet_card_cartes_bancaires_day;
                break;
            }
            case 9: {
                n = R.drawable.stripe_ic_paymentsheet_card_unknown_day;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @DrawableRes
    public static final int getLinkIcon(@Nullable Boolean showNightIcon) {
        return PaymentMethodsUiExtensionKt.getOverridableIcon(showNightIcon, R.drawable.stripe_ic_paymentsheet_link_ref, R.drawable.stripe_ic_paymentsheet_link_night, R.drawable.stripe_ic_paymentsheet_link_day);
    }

    public static /* synthetic */ int getLinkIcon$default(Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = null;
        }
        return PaymentMethodsUiExtensionKt.getLinkIcon(bl);
    }

    @DrawableRes
    public static final int getSepaIcon(@Nullable Boolean showNightIcon) {
        return PaymentMethodsUiExtensionKt.getOverridableIcon(showNightIcon, R.drawable.stripe_ic_paymentsheet_sepa_ref, R.drawable.stripe_ic_paymentsheet_sepa_night, R.drawable.stripe_ic_paymentsheet_sepa_day);
    }

    public static /* synthetic */ int getSepaIcon$default(Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = null;
        }
        return PaymentMethodsUiExtensionKt.getSepaIcon(bl);
    }

    @DrawableRes
    private static final int getOverridableIcon(Boolean showNightIcon, @DrawableRes int systemThemeAwareIconRef, @DrawableRes int nightIcon, @DrawableRes int dayIcon) {
        if (showNightIcon == null) {
            return systemThemeAwareIconRef;
        }
        if (showNightIcon.booleanValue()) {
            return nightIcon;
        }
        return dayIcon;
    }

    @Nullable
    public static final ResolvableString getLabel(@NotNull PaymentMethod $this$getLabel) {
        ResolvableString resolvableString;
        Intrinsics.checkNotNullParameter((Object)$this$getLabel, (String)"<this>");
        PaymentMethod.Type type = $this$getLabel.type;
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                PaymentMethod.Card card = $this$getLabel.card;
                resolvableString = PaymentMethodsUiExtensionKt.createCardLabel(card != null ? card.last4 : null);
                break;
            }
            case 2: {
                Object[] objectArray = new Object[1];
                PaymentMethod.SepaDebit sepaDebit = $this$getLabel.sepaDebit;
                objectArray[0] = sepaDebit != null ? sepaDebit.last4 : null;
                resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_paymentsheet_payment_method_item_card_number, (Object[])objectArray, null, (int)4, null);
                break;
            }
            case 3: {
                Object[] objectArray = new Object[1];
                PaymentMethod.USBankAccount uSBankAccount = $this$getLabel.usBankAccount;
                objectArray[0] = uSBankAccount != null ? uSBankAccount.last4 : null;
                resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_paymentsheet_payment_method_item_card_number, (Object[])objectArray, null, (int)4, null);
                break;
            }
            default: {
                resolvableString = null;
            }
        }
        return resolvableString;
    }

    @Nullable
    public static final Integer getLabelIcon(@NotNull PaymentMethod $this$getLabelIcon) {
        Intrinsics.checkNotNullParameter((Object)$this$getLabelIcon, (String)"<this>");
        PaymentMethod.Type type = $this$getLabelIcon.type;
        return (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) == 3 ? Integer.valueOf(R.drawable.stripe_ic_paymentsheet_bank) : null;
    }

    @Nullable
    public static final ResolvableString createCardLabel(@Nullable String last4) {
        ResolvableString resolvableString;
        String string2 = last4;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            Object[] objectArray = new Object[]{last4};
            resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_paymentsheet_payment_method_item_card_number, (Object[])objectArray, null, (int)4, null);
        } else {
            resolvableString = null;
        }
        return resolvableString;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PaymentMethod.Type.values().length];
            try {
                nArray[PaymentMethod.Type.Card.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.SepaDebit.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.USBankAccount.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CardBrand.values().length];
            try {
                nArray[CardBrand.Visa.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.AmericanExpress.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.Discover.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.JCB.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.DinersClub.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.MasterCard.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.UnionPay.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.CartesBancaires.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.Unknown.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

