/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.verticalmode;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.paymentsheet.DisplayableSavedPaymentMethod;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.SavedPaymentMethod;
import com.stripe.android.paymentsheet.ui.PaymentSheetTopBarState;
import com.stripe.android.paymentsheet.ui.PaymentSheetTopBarStateFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b`\u0018\u00002\u00020\u0001:\u0002\u000f\u0010J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\b\u0010\u000e\u001a\u00020\u000bH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor;", "", "isLiveMode", "", "()Z", "state", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$State;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "handleViewAction", "", "viewAction", "Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$ViewAction;", "close", "State", "ViewAction", "paymentsheet_release"})
public interface ManageScreenInteractor {
    public boolean isLiveMode();

    @NotNull
    public StateFlow<State> getState();

    public void handleViewAction(@NotNull ViewAction var1);

    public void close();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J9\u0010%\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010&\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001b\u0010\u0011\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018\u00a8\u0006,"}, d2={"Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$State;", "", "paymentMethods", "", "Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod;", "currentSelection", "isEditing", "", "canEdit", "<init>", "(Ljava/util/List;Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod;ZZ)V", "getPaymentMethods", "()Ljava/util/List;", "getCurrentSelection", "()Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod;", "()Z", "getCanEdit", "containsOnlyCards", "getContainsOnlyCards", "containsOnlyCards$delegate", "Lkotlin/Lazy;", "manageTitle", "Lcom/stripe/android/core/strings/ResolvableString;", "getManageTitle", "()Lcom/stripe/android/core/strings/ResolvableString;", "selectTitle", "getSelectTitle", "title", "getTitle", "topBarState", "Lcom/stripe/android/paymentsheet/ui/PaymentSheetTopBarState;", "interactor", "Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nManageScreenInteractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManageScreenInteractor.kt\ncom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$State\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1734#2,3:244\n*S KotlinDebug\n*F\n+ 1 ManageScreenInteractor.kt\ncom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$State\n*L\n43#1:244,3\n*E\n"})
    public static final class State {
        @NotNull
        private final List<DisplayableSavedPaymentMethod> paymentMethods;
        @Nullable
        private final DisplayableSavedPaymentMethod currentSelection;
        private final boolean isEditing;
        private final boolean canEdit;
        @NotNull
        private final Lazy containsOnlyCards$delegate;
        public static final int $stable = 8;

        public State(@NotNull List<DisplayableSavedPaymentMethod> paymentMethods, @Nullable DisplayableSavedPaymentMethod currentSelection, boolean isEditing, boolean canEdit) {
            Intrinsics.checkNotNullParameter(paymentMethods, (String)"paymentMethods");
            this.paymentMethods = paymentMethods;
            this.currentSelection = currentSelection;
            this.isEditing = isEditing;
            this.canEdit = canEdit;
            this.containsOnlyCards$delegate = LazyKt.lazy(() -> State.containsOnlyCards_delegate$lambda$1(this));
        }

        @NotNull
        public final List<DisplayableSavedPaymentMethod> getPaymentMethods() {
            return this.paymentMethods;
        }

        @Nullable
        public final DisplayableSavedPaymentMethod getCurrentSelection() {
            return this.currentSelection;
        }

        public final boolean isEditing() {
            return this.isEditing;
        }

        public final boolean getCanEdit() {
            return this.canEdit;
        }

        private final boolean getContainsOnlyCards() {
            Lazy lazy = this.containsOnlyCards$delegate;
            return (Boolean)lazy.getValue();
        }

        private final ResolvableString getManageTitle() {
            int title = this.getContainsOnlyCards() ? R.string.stripe_paymentsheet_manage_cards : R.string.stripe_paymentsheet_manage_payment_methods;
            return ResolvableStringUtilsKt.getResolvableString((int)title);
        }

        private final ResolvableString getSelectTitle() {
            int title = this.getContainsOnlyCards() ? R.string.stripe_paymentsheet_select_card : R.string.stripe_paymentsheet_select_payment_method;
            return ResolvableStringUtilsKt.getResolvableString((int)title);
        }

        @NotNull
        public final ResolvableString getTitle() {
            return this.isEditing ? this.getManageTitle() : this.getSelectTitle();
        }

        @NotNull
        public final PaymentSheetTopBarState topBarState(@NotNull ManageScreenInteractor interactor) {
            Intrinsics.checkNotNullParameter((Object)interactor, (String)"interactor");
            return PaymentSheetTopBarStateFactory.INSTANCE.create(interactor.isLiveMode(), new PaymentSheetTopBarState.Editable.Maybe(this.isEditing, this.canEdit, (Function0<Unit>)((Function0)() -> State.topBarState$lambda$2(interactor))));
        }

        @NotNull
        public final List<DisplayableSavedPaymentMethod> component1() {
            return this.paymentMethods;
        }

        @Nullable
        public final DisplayableSavedPaymentMethod component2() {
            return this.currentSelection;
        }

        public final boolean component3() {
            return this.isEditing;
        }

        public final boolean component4() {
            return this.canEdit;
        }

        @NotNull
        public final State copy(@NotNull List<DisplayableSavedPaymentMethod> paymentMethods, @Nullable DisplayableSavedPaymentMethod currentSelection, boolean isEditing, boolean canEdit) {
            Intrinsics.checkNotNullParameter(paymentMethods, (String)"paymentMethods");
            return new State(paymentMethods, currentSelection, isEditing, canEdit);
        }

        public static /* synthetic */ State copy$default(State state2, List list, DisplayableSavedPaymentMethod displayableSavedPaymentMethod, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                list = state2.paymentMethods;
            }
            if ((n & 2) != 0) {
                displayableSavedPaymentMethod = state2.currentSelection;
            }
            if ((n & 4) != 0) {
                bl = state2.isEditing;
            }
            if ((n & 8) != 0) {
                bl2 = state2.canEdit;
            }
            return state2.copy(list, displayableSavedPaymentMethod, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "State(paymentMethods=" + this.paymentMethods + ", currentSelection=" + this.currentSelection + ", isEditing=" + this.isEditing + ", canEdit=" + this.canEdit + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.paymentMethods).hashCode();
            result2 = result2 * 31 + (this.currentSelection == null ? 0 : this.currentSelection.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.isEditing);
            result2 = result2 * 31 + Boolean.hashCode(this.canEdit);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state2 = (State)other;
            if (!Intrinsics.areEqual(this.paymentMethods, state2.paymentMethods)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.currentSelection, (Object)state2.currentSelection)) {
                return false;
            }
            if (this.isEditing != state2.isEditing) {
                return false;
            }
            return this.canEdit == state2.canEdit;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean containsOnlyCards_delegate$lambda$1(State this$0) {
            DisplayableSavedPaymentMethod displayable;
            if (((Collection)this$0.paymentMethods).isEmpty()) return false;
            boolean bl = true;
            if (!bl) return false;
            Iterable $this$all$iv = this$0.paymentMethods;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                displayable = (DisplayableSavedPaymentMethod)element$iv;
                boolean bl2 = false;
            } while (displayable.getSavedPaymentMethod() instanceof SavedPaymentMethod.Card);
            return false;
        }

        private static final Unit topBarState$lambda$2(ManageScreenInteractor $interactor) {
            $interactor.handleViewAction(ViewAction.ToggleEdit.INSTANCE);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$ViewAction;", "", "<init>", "()V", "SelectPaymentMethod", "UpdatePaymentMethod", "ToggleEdit", "Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$ViewAction$SelectPaymentMethod;", "Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$ViewAction$ToggleEdit;", "Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$ViewAction$UpdatePaymentMethod;", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static abstract class ViewAction {
        public static final int $stable;

        private ViewAction() {
        }

        public /* synthetic */ ViewAction(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$ViewAction$SelectPaymentMethod;", "Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$ViewAction;", "paymentMethod", "Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod;", "<init>", "(Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod;)V", "getPaymentMethod", "()Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "paymentsheet_release"})
        @StabilityInferred(parameters=0)
        public static final class SelectPaymentMethod
        extends ViewAction {
            @NotNull
            private final DisplayableSavedPaymentMethod paymentMethod;
            public static final int $stable = 8;

            public SelectPaymentMethod(@NotNull DisplayableSavedPaymentMethod paymentMethod) {
                Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
                super(null);
                this.paymentMethod = paymentMethod;
            }

            @NotNull
            public final DisplayableSavedPaymentMethod getPaymentMethod() {
                return this.paymentMethod;
            }

            @NotNull
            public final DisplayableSavedPaymentMethod component1() {
                return this.paymentMethod;
            }

            @NotNull
            public final SelectPaymentMethod copy(@NotNull DisplayableSavedPaymentMethod paymentMethod) {
                Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
                return new SelectPaymentMethod(paymentMethod);
            }

            public static /* synthetic */ SelectPaymentMethod copy$default(SelectPaymentMethod selectPaymentMethod, DisplayableSavedPaymentMethod displayableSavedPaymentMethod, int n, Object object) {
                if ((n & 1) != 0) {
                    displayableSavedPaymentMethod = selectPaymentMethod.paymentMethod;
                }
                return selectPaymentMethod.copy(displayableSavedPaymentMethod);
            }

            @NotNull
            public String toString() {
                return "SelectPaymentMethod(paymentMethod=" + this.paymentMethod + ")";
            }

            public int hashCode() {
                return this.paymentMethod.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SelectPaymentMethod)) {
                    return false;
                }
                SelectPaymentMethod selectPaymentMethod = (SelectPaymentMethod)other;
                return Intrinsics.areEqual((Object)this.paymentMethod, (Object)selectPaymentMethod.paymentMethod);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$ViewAction$ToggleEdit;", "Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$ViewAction;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "paymentsheet_release"})
        @StabilityInferred(parameters=1)
        public static final class ToggleEdit
        extends ViewAction {
            @NotNull
            public static final ToggleEdit INSTANCE = new ToggleEdit();
            public static final int $stable;

            private ToggleEdit() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "ToggleEdit";
            }

            public int hashCode() {
                return -1354134144;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ToggleEdit)) {
                    return false;
                }
                ToggleEdit cfr_ignored_0 = (ToggleEdit)other;
                return true;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$ViewAction$UpdatePaymentMethod;", "Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor$ViewAction;", "paymentMethod", "Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod;", "<init>", "(Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod;)V", "getPaymentMethod", "()Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "paymentsheet_release"})
        @StabilityInferred(parameters=0)
        public static final class UpdatePaymentMethod
        extends ViewAction {
            @NotNull
            private final DisplayableSavedPaymentMethod paymentMethod;
            public static final int $stable = 8;

            public UpdatePaymentMethod(@NotNull DisplayableSavedPaymentMethod paymentMethod) {
                Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
                super(null);
                this.paymentMethod = paymentMethod;
            }

            @NotNull
            public final DisplayableSavedPaymentMethod getPaymentMethod() {
                return this.paymentMethod;
            }

            @NotNull
            public final DisplayableSavedPaymentMethod component1() {
                return this.paymentMethod;
            }

            @NotNull
            public final UpdatePaymentMethod copy(@NotNull DisplayableSavedPaymentMethod paymentMethod) {
                Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
                return new UpdatePaymentMethod(paymentMethod);
            }

            public static /* synthetic */ UpdatePaymentMethod copy$default(UpdatePaymentMethod updatePaymentMethod2, DisplayableSavedPaymentMethod displayableSavedPaymentMethod, int n, Object object) {
                if ((n & 1) != 0) {
                    displayableSavedPaymentMethod = updatePaymentMethod2.paymentMethod;
                }
                return updatePaymentMethod2.copy(displayableSavedPaymentMethod);
            }

            @NotNull
            public String toString() {
                return "UpdatePaymentMethod(paymentMethod=" + this.paymentMethod + ")";
            }

            public int hashCode() {
                return this.paymentMethod.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UpdatePaymentMethod)) {
                    return false;
                }
                UpdatePaymentMethod updatePaymentMethod2 = (UpdatePaymentMethod)other;
                return Intrinsics.areEqual((Object)this.paymentMethod, (Object)updatePaymentMethod2.paymentMethod);
            }
        }
    }
}

