/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import android.content.Context;
import android.util.Base64;
import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.Algorithm;
import com.stripe.android.stripe3ds2.security.DirectoryServer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/stripe3ds2/security/PublicKeyFactory;", "", "context", "Landroid/content/Context;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "<init>", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "create", "Ljava/security/PublicKey;", "directoryServerId", "", "generateCertificate", "Ljava/security/cert/Certificate;", "fileName", "generatePublicKey", "algorithm", "Lcom/stripe/android/stripe3ds2/security/Algorithm;", "readPublicKeyBytes", "", "keyFile", "readFile", "Ljava/io/InputStream;", "3ds2sdk_release"})
@SourceDebugExtension(value={"SMAP\nPublicKeyFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublicKeyFactory.kt\ncom/stripe/android/stripe3ds2/security/PublicKeyFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class PublicKeyFactory {
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    private final Context context;

    public PublicKeyFactory(@NotNull Context context, @NotNull ErrorReporter errorReporter) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        this.errorReporter = errorReporter;
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        this.context = context2;
    }

    @NotNull
    public final PublicKey create(@NotNull String directoryServerId) {
        PublicKey publicKey;
        Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
        DirectoryServer directoryServer = DirectoryServer.Companion.lookup(directoryServerId);
        if (directoryServer.isCertificate()) {
            PublicKey publicKey2 = this.generateCertificate(directoryServer.getFileName()).getPublicKey();
            Intrinsics.checkNotNull((Object)publicKey2);
            publicKey = publicKey2;
        } else {
            publicKey = this.generatePublicKey(directoryServer.getFileName(), directoryServer.getAlgorithm());
        }
        return publicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Certificate generateCertificate(String fileName) {
        Object $this$generateCertificate_u24lambda_u240;
        Object object = this;
        try {
            Certificate certificate;
            $this$generateCertificate_u24lambda_u240 = object;
            boolean bl = false;
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Closeable closeable = super.readFile(fileName);
            Throwable throwable = null;
            try {
                InputStream p0 = (InputStream)closeable;
                boolean bl2 = false;
                certificate = factory.generateCertificate(p0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$generateCertificate_u24lambda_u240 = Result.constructor-impl((Object)certificate);
        }
        catch (Throwable bl) {
            $this$generateCertificate_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$generateCertificate_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object it = $this$generateCertificate_u24lambda_u240 = throwable;
            boolean bl = false;
            this.errorReporter.reportError((Throwable)it);
        }
        Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
        if (throwable3 != null) {
            Throwable it = throwable3;
            boolean bl = false;
            throw new SDKRuntimeException(it);
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        return (Certificate)object2;
    }

    private final PublicKey generatePublicKey(String fileName, Algorithm algorithm) {
        Object $this$generatePublicKey_u24lambda_u243;
        Object object = this;
        try {
            $this$generatePublicKey_u24lambda_u243 = object;
            boolean bl = false;
            $this$generatePublicKey_u24lambda_u243 = Result.constructor-impl((Object)KeyFactory.getInstance(algorithm.toString()).generatePublic(new X509EncodedKeySpec(super.readPublicKeyBytes(fileName))));
        }
        catch (Throwable bl) {
            $this$generatePublicKey_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$generatePublicKey_u24lambda_u243;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object it = $this$generatePublicKey_u24lambda_u243 = throwable;
            boolean bl = false;
            this.errorReporter.reportError((Throwable)it);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            throw new SDKRuntimeException(it);
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        return (PublicKey)object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] readPublicKeyBytes(String keyFile) {
        Object $this$readPublicKeyBytes_u24lambda_u247;
        Object object = this;
        try {
            String string;
            $this$readPublicKeyBytes_u24lambda_u247 = object;
            boolean bl = false;
            Closeable closeable = super.readFile(keyFile);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                string = new Scanner(it).useDelimiter("\\A").next();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String publicKey = string;
            Intrinsics.checkNotNull((Object)publicKey);
            byte[] byArray = publicKey.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            $this$readPublicKeyBytes_u24lambda_u247 = Result.constructor-impl((Object)Base64.decode((byte[])byArray, (int)0));
        }
        catch (Throwable bl) {
            $this$readPublicKeyBytes_u24lambda_u247 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$readPublicKeyBytes_u24lambda_u247;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object it = $this$readPublicKeyBytes_u24lambda_u247 = throwable;
            boolean bl = false;
            this.errorReporter.reportError((Throwable)it);
        }
        Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
        if (throwable3 != null) {
            Throwable it = throwable3;
            boolean bl = false;
            throw new SDKRuntimeException(it);
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        return (byte[])object2;
    }

    private final InputStream readFile(String fileName) throws IOException {
        InputStream inputStream = this.context.getAssets().open(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
        return inputStream;
    }
}

