/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.service;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.init.AppInfoRepository;
import com.stripe.android.stripe3ds2.init.DefaultAppInfoRepository;
import com.stripe.android.stripe3ds2.init.DefaultSecurityChecker;
import com.stripe.android.stripe3ds2.init.DeviceDataFactory;
import com.stripe.android.stripe3ds2.init.DeviceDataFactoryImpl;
import com.stripe.android.stripe3ds2.init.DeviceParamNotAvailableFactory;
import com.stripe.android.stripe3ds2.init.DeviceParamNotAvailableFactoryImpl;
import com.stripe.android.stripe3ds2.init.SecurityChecker;
import com.stripe.android.stripe3ds2.init.Warning;
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization;
import com.stripe.android.stripe3ds2.observability.DefaultErrorReporter;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.EphemeralKeyPairGenerator;
import com.stripe.android.stripe3ds2.security.PublicKeyFactory;
import com.stripe.android.stripe3ds2.security.StripeEphemeralKeyPairGenerator;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2Service;
import com.stripe.android.stripe3ds2.transaction.DefaultAuthenticationRequestParametersFactory;
import com.stripe.android.stripe3ds2.transaction.DefaultTransactionFactory;
import com.stripe.android.stripe3ds2.transaction.Logger;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import com.stripe.android.stripe3ds2.transaction.Transaction;
import com.stripe.android.stripe3ds2.transaction.TransactionFactory;
import com.stripe.android.stripe3ds2.utils.ImageCache;
import com.stripe.android.stripe3ds2.views.Brand;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 92\u00020\u0001:\u00019B?\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010B#\b\u0017\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0017B+\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u000f\u0010\u001aB1\b\u0012\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u000f\u0010\u001bB1\b\u0012\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u000f\u0010\u001cBQ\b\u0012\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020 \u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010!\u001a\u00020\"\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u000f\u0010#JZ\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00192\b\u0010+\u001a\u0004\u0018\u00010\u00192\u0006\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\r2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u00192\u0006\u00103\u001a\u000204H\u0016JR\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020\u00192\b\u0010+\u001a\u0004\u0018\u00010\u00192\u0006\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00192\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\r2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u00192\u0006\u0010(\u001a\u00020)H\u0002J\b\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002012\u0006\u00108\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006:"}, d2={"Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2ServiceImpl;", "Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2Service;", "messageVersionRegistry", "Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;", "imageCache", "Lcom/stripe/android/stripe3ds2/utils/ImageCache;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "transactionFactory", "Lcom/stripe/android/stripe3ds2/transaction/TransactionFactory;", "publicKeyFactory", "Lcom/stripe/android/stripe3ds2/security/PublicKeyFactory;", "warnings", "", "Lcom/stripe/android/stripe3ds2/init/Warning;", "<init>", "(Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;Lcom/stripe/android/stripe3ds2/utils/ImageCache;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;Lcom/stripe/android/stripe3ds2/transaction/TransactionFactory;Lcom/stripe/android/stripe3ds2/security/PublicKeyFactory;Ljava/util/List;)V", "context", "Landroid/content/Context;", "enableLogging", "", "workContext", "Lkotlin/coroutines/CoroutineContext;", "(Landroid/content/Context;ZLkotlin/coroutines/CoroutineContext;)V", "sdkReferenceNumber", "", "(Landroid/content/Context;Ljava/lang/String;ZLkotlin/coroutines/CoroutineContext;)V", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/utils/ImageCache;Ljava/lang/String;ZLkotlin/coroutines/CoroutineContext;)V", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/utils/ImageCache;Ljava/lang/String;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;Lkotlin/coroutines/CoroutineContext;)V", "ephemeralKeyPairGenerator", "Lcom/stripe/android/stripe3ds2/security/EphemeralKeyPairGenerator;", "securityChecker", "Lcom/stripe/android/stripe3ds2/init/SecurityChecker;", "appInfoRepository", "Lcom/stripe/android/stripe3ds2/init/AppInfoRepository;", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/utils/ImageCache;Ljava/lang/String;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;Lcom/stripe/android/stripe3ds2/security/EphemeralKeyPairGenerator;Lcom/stripe/android/stripe3ds2/init/SecurityChecker;Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;Lcom/stripe/android/stripe3ds2/init/AppInfoRepository;Lkotlin/coroutines/CoroutineContext;)V", "getWarnings", "()Ljava/util/List;", "createTransaction", "Lcom/stripe/android/stripe3ds2/transaction/Transaction;", "sdkTransactionId", "Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "directoryServerID", "messageVersion", "isLiveMode", "directoryServerName", "rootCerts", "Ljava/security/cert/X509Certificate;", "dsPublicKey", "Ljava/security/PublicKey;", "keyId", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "cleanup", "", "getPublicKey", "directoryServerId", "Companion", "3ds2sdk_release"})
public final class StripeThreeDs2ServiceImpl
implements StripeThreeDs2Service {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageVersionRegistry messageVersionRegistry;
    @NotNull
    private final ImageCache imageCache;
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    private final TransactionFactory transactionFactory;
    @NotNull
    private final PublicKeyFactory publicKeyFactory;
    @NotNull
    private final List<Warning> warnings;
    @NotNull
    private static final String STRIPE_SDK_REFERENCE_NUMBER = "3DS_LOA_SDK_STIN_020200_00960";

    @VisibleForTesting
    public StripeThreeDs2ServiceImpl(@NotNull MessageVersionRegistry messageVersionRegistry, @NotNull ImageCache imageCache, @NotNull ErrorReporter errorReporter, @NotNull TransactionFactory transactionFactory, @NotNull PublicKeyFactory publicKeyFactory, @NotNull List<Warning> warnings) {
        Intrinsics.checkNotNullParameter((Object)messageVersionRegistry, (String)"messageVersionRegistry");
        Intrinsics.checkNotNullParameter((Object)imageCache, (String)"imageCache");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)transactionFactory, (String)"transactionFactory");
        Intrinsics.checkNotNullParameter((Object)publicKeyFactory, (String)"publicKeyFactory");
        Intrinsics.checkNotNullParameter(warnings, (String)"warnings");
        this.messageVersionRegistry = messageVersionRegistry;
        this.imageCache = imageCache;
        this.errorReporter = errorReporter;
        this.transactionFactory = transactionFactory;
        this.publicKeyFactory = publicKeyFactory;
        this.warnings = warnings;
    }

    @Override
    @NotNull
    public List<Warning> getWarnings() {
        return this.warnings;
    }

    @JvmOverloads
    public StripeThreeDs2ServiceImpl(@NotNull Context context, boolean enableLogging, @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this(context, STRIPE_SDK_REFERENCE_NUMBER, enableLogging, workContext);
    }

    public /* synthetic */ StripeThreeDs2ServiceImpl(Context context, boolean bl, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(context, bl, coroutineContext);
    }

    public StripeThreeDs2ServiceImpl(@NotNull Context context, @NotNull String sdkReferenceNumber, boolean enableLogging, @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkReferenceNumber, (String)"sdkReferenceNumber");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this(context, (ImageCache)ImageCache.Default.INSTANCE, sdkReferenceNumber, enableLogging, workContext);
    }

    public /* synthetic */ StripeThreeDs2ServiceImpl(Context context, String string, boolean bl, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(context, string, bl, coroutineContext);
    }

    private StripeThreeDs2ServiceImpl(Context context, ImageCache imageCache, String sdkReferenceNumber, boolean enableLogging, CoroutineContext workContext) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        this(context, imageCache, sdkReferenceNumber, new DefaultErrorReporter(context2, null, null, Logger.Companion.get(enableLogging), null, null, null, 0, 246, null), workContext);
    }

    private StripeThreeDs2ServiceImpl(Context context, ImageCache imageCache, String sdkReferenceNumber, ErrorReporter errorReporter, CoroutineContext workContext) {
        this(context, imageCache, sdkReferenceNumber, errorReporter, new StripeEphemeralKeyPairGenerator(errorReporter), new DefaultSecurityChecker(null, 1, null), new MessageVersionRegistry(), new DefaultAppInfoRepository(context, workContext), workContext);
    }

    private StripeThreeDs2ServiceImpl(Context context, ImageCache imageCache, String sdkReferenceNumber, ErrorReporter errorReporter, EphemeralKeyPairGenerator ephemeralKeyPairGenerator, SecurityChecker securityChecker, MessageVersionRegistry messageVersionRegistry, AppInfoRepository appInfoRepository, CoroutineContext workContext) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        DefaultTransactionFactory defaultTransactionFactory = new DefaultTransactionFactory(new DefaultAuthenticationRequestParametersFactory((DeviceDataFactory)new DeviceDataFactoryImpl(context2, appInfoRepository, messageVersionRegistry), (DeviceParamNotAvailableFactory)new DeviceParamNotAvailableFactoryImpl(), securityChecker, ephemeralKeyPairGenerator, appInfoRepository, messageVersionRegistry, sdkReferenceNumber, errorReporter, workContext), ephemeralKeyPairGenerator, sdkReferenceNumber);
        List<Warning> list = securityChecker.getWarnings();
        PublicKeyFactory publicKeyFactory = new PublicKeyFactory(context, errorReporter);
        this(messageVersionRegistry, imageCache, errorReporter, defaultTransactionFactory, publicKeyFactory, list);
    }

    @Override
    @NotNull
    public Transaction createTransaction(@NotNull SdkTransactionId sdkTransactionId, @NotNull String directoryServerID, @Nullable String messageVersion, boolean isLiveMode, @NotNull String directoryServerName, @NotNull List<? extends X509Certificate> rootCerts, @NotNull PublicKey dsPublicKey, @Nullable String keyId, @NotNull StripeUiCustomization uiCustomization) throws InvalidInputException, SDKRuntimeException {
        Intrinsics.checkNotNullParameter((Object)sdkTransactionId, (String)"sdkTransactionId");
        Intrinsics.checkNotNullParameter((Object)directoryServerID, (String)"directoryServerID");
        Intrinsics.checkNotNullParameter((Object)directoryServerName, (String)"directoryServerName");
        Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
        Intrinsics.checkNotNullParameter((Object)dsPublicKey, (String)"dsPublicKey");
        Intrinsics.checkNotNullParameter((Object)uiCustomization, (String)"uiCustomization");
        return this.createTransaction(directoryServerID, messageVersion, isLiveMode, directoryServerName, rootCerts, dsPublicKey, keyId, sdkTransactionId);
    }

    private final Transaction createTransaction(String directoryServerID, String messageVersion, boolean isLiveMode, String directoryServerName, List<? extends X509Certificate> rootCerts, PublicKey dsPublicKey, String keyId, SdkTransactionId sdkTransactionId) {
        if (!this.messageVersionRegistry.isSupported(messageVersion)) {
            String string2 = messageVersion;
            if (string2 == null) {
                string2 = "";
            }
            throw new InvalidInputException("Message version is unsupported: " + string2, null, 2, null);
        }
        return this.transactionFactory.create(directoryServerID, rootCerts, dsPublicKey, keyId, sdkTransactionId, isLiveMode, Brand.Companion.lookup$3ds2sdk_release(directoryServerName, this.errorReporter));
    }

    @Override
    public void cleanup() {
        this.imageCache.clear();
    }

    @Override
    @NotNull
    public PublicKey getPublicKey(@NotNull String directoryServerId) {
        Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
        return this.publicKeyFactory.create(directoryServerId);
    }

    @JvmOverloads
    public StripeThreeDs2ServiceImpl(@NotNull Context context, @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this(context, false, workContext, 2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2ServiceImpl$Companion;", "", "<init>", "()V", "STRIPE_SDK_REFERENCE_NUMBER", "", "3ds2sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

