/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import com.nimbusds.jose.JOSEException;
import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.EphemeralKeyPairGenerator;
import com.stripe.android.stripe3ds2.security.JweEcEncrypter;
import com.stripe.android.stripe3ds2.security.JweEncrypter;
import com.stripe.android.stripe3ds2.security.JweRsaEncrypter;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/stripe3ds2/security/DefaultJweEncrypter;", "Lcom/stripe/android/stripe3ds2/security/JweEncrypter;", "ephemeralKeyPairGenerator", "Lcom/stripe/android/stripe3ds2/security/EphemeralKeyPairGenerator;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "(Lcom/stripe/android/stripe3ds2/security/EphemeralKeyPairGenerator;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "jweRsaEncrypter", "Lcom/stripe/android/stripe3ds2/security/JweRsaEncrypter;", "jweEcEncrypter", "Lcom/stripe/android/stripe3ds2/security/JweEcEncrypter;", "(Lcom/stripe/android/stripe3ds2/security/JweRsaEncrypter;Lcom/stripe/android/stripe3ds2/security/JweEcEncrypter;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "encrypt", "", "payload", "acsPublicKey", "Ljava/security/PublicKey;", "directoryServerId", "keyId", "3ds2sdk_release"})
public final class DefaultJweEncrypter
implements JweEncrypter {
    @NotNull
    private final JweRsaEncrypter jweRsaEncrypter;
    @NotNull
    private final JweEcEncrypter jweEcEncrypter;
    @NotNull
    private final ErrorReporter errorReporter;

    private DefaultJweEncrypter(JweRsaEncrypter jweRsaEncrypter, JweEcEncrypter jweEcEncrypter, ErrorReporter errorReporter2) {
        this.jweRsaEncrypter = jweRsaEncrypter;
        this.jweEcEncrypter = jweEcEncrypter;
        this.errorReporter = errorReporter2;
    }

    public DefaultJweEncrypter(@NotNull EphemeralKeyPairGenerator ephemeralKeyPairGenerator, @NotNull ErrorReporter errorReporter2) {
        Intrinsics.checkNotNullParameter((Object)ephemeralKeyPairGenerator, (String)"ephemeralKeyPairGenerator");
        Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
        this(new JweRsaEncrypter(), new JweEcEncrypter(ephemeralKeyPairGenerator, errorReporter2), errorReporter2);
    }

    @Override
    @NotNull
    public String encrypt(@NotNull String payload, @NotNull PublicKey acsPublicKey, @NotNull String directoryServerId, @Nullable String keyId) throws JOSEException, ParseException {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)acsPublicKey, (String)"acsPublicKey");
        Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
        Object object = acsPublicKey;
        object = object instanceof RSAPublicKey ? Result.constructor-impl((Object)this.jweRsaEncrypter.encrypt(payload, (RSAPublicKey)acsPublicKey, keyId)) : (object instanceof ECPublicKey ? Result.constructor-impl((Object)this.jweEcEncrypter.encrypt(payload, (ECPublicKey)acsPublicKey, directoryServerId)) : Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new SDKRuntimeException(Intrinsics.stringPlus((String)"Unsupported public key algorithm: ", (Object)acsPublicKey.getAlgorithm()), null, 2, null))));
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            this.errorReporter.reportError(it);
        }
        ResultKt.throwOnFailure((Object)object);
        return (String)object;
    }
}

