/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import androidx.annotation.VisibleForTesting;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.DirectDecrypter;
import com.stripe.android.stripe3ds2.security.MessageTransformer;
import com.stripe.android.stripe3ds2.security.TransactionEncrypter;
import com.stripe.android.stripe3ds2.transactions.ChallengeResponseParseException;
import com.stripe.android.stripe3ds2.transactions.ProtocolError;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0080\b\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\t\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\n\u001a\u00020\u0006H\u00c2\u0003J\t\u0010\u000b\u001a\u00020\u0006H\u00c2\u0003J'\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001d\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\b\u0018J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0013\u0010\u001b\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\u001d\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0001\u00a2\u0006\u0002\b\"J\u001d\u0010#\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0001\u00a2\u0006\u0002\b$J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0010H\u00d6\u0001J\u0015\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b+R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/stripe/android/stripe3ds2/security/DefaultMessageTransformer;", "Lcom/stripe/android/stripe3ds2/security/MessageTransformer;", "isLiveMode", "", "(Z)V", "counterSdkToAcs", "", "counterAcsToSdk", "(ZBB)V", "component1", "component2", "component3", "copy", "createEncryptionHeader", "Lcom/nimbusds/jose/JWEHeader;", "keyId", "", "createEncryptionHeader$3ds2sdk_release", "decrypt", "Lorg/json/JSONObject;", "message", "secretKey", "Ljavax/crypto/SecretKey;", "decryptMessage", "decryptMessage$3ds2sdk_release", "encrypt", "challengeRequest", "equals", "other", "", "getDecryptionKey", "", "encryptionMethod", "Lcom/nimbusds/jose/EncryptionMethod;", "getDecryptionKey$3ds2sdk_release", "getEncryptionKey", "getEncryptionKey$3ds2sdk_release", "hashCode", "", "toString", "validateAcsToSdkCounter", "", "cres", "validateAcsToSdkCounter$3ds2sdk_release", "Companion", "3ds2sdk_release"})
public final class DefaultMessageTransformer
implements MessageTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isLiveMode;
    private byte counterSdkToAcs;
    private byte counterAcsToSdk;
    @NotNull
    public static final String FIELD_ACS_COUNTER_ACS_TO_SDK = "acsCounterAtoS";
    @NotNull
    public static final String FIELD_SDK_COUNTER_SDK_TO_ACS = "sdkCounterStoA";
    private static final EncryptionMethod ENCRYPTION_METHOD = EncryptionMethod.A128CBC_HS256;
    public static final int BITS_IN_BYTE = 8;

    @VisibleForTesting
    public DefaultMessageTransformer(boolean isLiveMode, byte counterSdkToAcs, byte counterAcsToSdk) {
        this.isLiveMode = isLiveMode;
        this.counterSdkToAcs = counterSdkToAcs;
        this.counterAcsToSdk = counterAcsToSdk;
    }

    public DefaultMessageTransformer(boolean isLiveMode) {
        this(isLiveMode, 0, 0);
    }

    @Override
    @NotNull
    public String encrypt(@NotNull JSONObject challengeRequest, @NotNull SecretKey secretKey) throws JOSEException, JSONException {
        Intrinsics.checkNotNullParameter((Object)challengeRequest, (String)"challengeRequest");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        String string = challengeRequest.getString("acsTransID");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"challengeRequest.getStri\u2026tData.FIELD_ACS_TRANS_ID)");
        JWEHeader header = this.createEncryptionHeader$3ds2sdk_release(string);
        Locale locale = Locale.ROOT;
        String string2 = "%03d";
        Object[] objectArray = new Object[]{this.counterSdkToAcs};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
        challengeRequest.put(FIELD_SDK_COUNTER_SDK_TO_ACS, (Object)string3);
        JWEObject jweObject = new JWEObject(header, new Payload(challengeRequest.toString()));
        locale = header.getEncryptionMethod();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"header.encryptionMethod");
        jweObject.encrypt((JWEEncrypter)new TransactionEncrypter(this.getEncryptionKey$3ds2sdk_release(secretKey, (EncryptionMethod)locale), this.counterSdkToAcs));
        byte by = this.counterSdkToAcs;
        this.counterSdkToAcs = (byte)(by + 1);
        if (!(this.counterSdkToAcs != 0)) {
            boolean bl = false;
            String string4 = "SDK to ACS counter is zero";
            throw new IllegalArgumentException(string4.toString());
        }
        String string5 = jweObject.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"jweObject.serialize()");
        return string5;
    }

    @Override
    @NotNull
    public JSONObject decrypt(@NotNull String message, @NotNull SecretKey secretKey) throws ParseException, JOSEException, JSONException, ChallengeResponseParseException {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        JSONObject challengeResponse = this.decryptMessage$3ds2sdk_release(message, secretKey);
        this.validateAcsToSdkCounter$3ds2sdk_release(challengeResponse);
        byte by = this.counterAcsToSdk;
        this.counterAcsToSdk = (byte)(by + 1);
        if (!(this.counterAcsToSdk != 0)) {
            boolean bl = false;
            String string = "ACS to SDK counter is zero";
            throw new IllegalArgumentException(string.toString());
        }
        return challengeResponse;
    }

    @VisibleForTesting
    public final void validateAcsToSdkCounter$3ds2sdk_release(@NotNull JSONObject cres) throws ChallengeResponseParseException, JSONException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)cres, (String)"cres");
        if (!this.isLiveMode) {
            return;
        }
        if (!cres.has(FIELD_ACS_COUNTER_ACS_TO_SDK)) {
            throw ChallengeResponseParseException.Companion.createRequiredDataElementMissing(FIELD_ACS_COUNTER_ACS_TO_SDK);
        }
        Object object2 = this;
        try {
            DefaultMessageTransformer $this$validateAcsToSdkCounter_u24lambda_u2d2 = object2;
            boolean bl = false;
            String string = cres.getString(FIELD_ACS_COUNTER_ACS_TO_SDK);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cres.getString(FIELD_ACS_COUNTER_ACS_TO_SDK)");
            object = Result.constructor-impl((Object)Byte.parseByte(string));
        }
        catch (Throwable $this$validateAcsToSdkCounter_u24lambda_u2d2) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$validateAcsToSdkCounter_u24lambda_u2d2));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw ChallengeResponseParseException.Companion.createInvalidDataElementFormat(FIELD_ACS_COUNTER_ACS_TO_SDK);
        }
        byte acsCounterAcsToSdk = ((Number)object2).byteValue();
        if (this.counterAcsToSdk != acsCounterAcsToSdk) {
            throw new ChallengeResponseParseException(ProtocolError.DataDecryptionFailure, "Counters are not equal. SDK counter: " + this.counterAcsToSdk + ", ACS counter: " + acsCounterAcsToSdk);
        }
    }

    @VisibleForTesting
    @NotNull
    public final JSONObject decryptMessage$3ds2sdk_release(@NotNull String message, @NotNull SecretKey secretKey) throws ParseException, JOSEException, JSONException {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        JWEObject jweObject = JWEObject.parse((String)message);
        EncryptionMethod encryptionMethod = jweObject.getHeader().getEncryptionMethod();
        Intrinsics.checkNotNullExpressionValue((Object)encryptionMethod, (String)"jweObject.header.encryptionMethod");
        byte[] key = this.getDecryptionKey$3ds2sdk_release(secretKey, encryptionMethod);
        jweObject.decrypt((JWEDecrypter)new DirectDecrypter(key));
        return new JSONObject(jweObject.getPayload().toString());
    }

    @VisibleForTesting
    @NotNull
    public final JWEHeader createEncryptionHeader$3ds2sdk_release(@NotNull String keyId) {
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        JWEHeader jWEHeader = new JWEHeader.Builder(JWEAlgorithm.DIR, ENCRYPTION_METHOD).keyID(keyId).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWEHeader, (String)"Builder(JWEAlgorithm.DIR\u2026yId)\n            .build()");
        return jWEHeader;
    }

    @VisibleForTesting
    @NotNull
    public final byte[] getDecryptionKey$3ds2sdk_release(@NotNull SecretKey secretKey, @NotNull EncryptionMethod encryptionMethod) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        Intrinsics.checkNotNullParameter((Object)encryptionMethod, (String)"encryptionMethod");
        byte[] encodedKey = secretKey.getEncoded();
        if (EncryptionMethod.A128GCM == encryptionMethod) {
            byte[] byArray2 = Arrays.copyOfRange(encodedKey, encodedKey.length - EncryptionMethod.A128GCM.cekBitLength() / 8, encodedKey.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n            Arrays.cop\u2026e\n            )\n        }");
            byArray = byArray2;
        } else {
            byte[] byArray3 = encodedKey;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"{\n            encodedKey\n        }");
            byArray = byArray3;
        }
        return byArray;
    }

    @VisibleForTesting
    @NotNull
    public final byte[] getEncryptionKey$3ds2sdk_release(@NotNull SecretKey secretKey, @NotNull EncryptionMethod encryptionMethod) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        Intrinsics.checkNotNullParameter((Object)encryptionMethod, (String)"encryptionMethod");
        byte[] encodedKey = secretKey.getEncoded();
        if (EncryptionMethod.A128GCM == encryptionMethod) {
            byte[] byArray2 = Arrays.copyOfRange(encodedKey, 0, EncryptionMethod.A128GCM.cekBitLength() / 8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n            Arrays.cop\u2026E\n            )\n        }");
            byArray = byArray2;
        } else {
            byte[] byArray3 = encodedKey;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"{\n            encodedKey\n        }");
            byArray = byArray3;
        }
        return byArray;
    }

    private final boolean component1() {
        return this.isLiveMode;
    }

    private final byte component2() {
        return this.counterSdkToAcs;
    }

    private final byte component3() {
        return this.counterAcsToSdk;
    }

    @NotNull
    public final DefaultMessageTransformer copy(boolean isLiveMode, byte counterSdkToAcs, byte counterAcsToSdk) {
        return new DefaultMessageTransformer(isLiveMode, counterSdkToAcs, counterAcsToSdk);
    }

    public static /* synthetic */ DefaultMessageTransformer copy$default(DefaultMessageTransformer defaultMessageTransformer, boolean bl, byte by, byte by2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = defaultMessageTransformer.isLiveMode;
        }
        if ((n & 2) != 0) {
            by = defaultMessageTransformer.counterSdkToAcs;
        }
        if ((n & 4) != 0) {
            by2 = defaultMessageTransformer.counterAcsToSdk;
        }
        return defaultMessageTransformer.copy(bl, by, by2);
    }

    @NotNull
    public String toString() {
        return "DefaultMessageTransformer(isLiveMode=" + this.isLiveMode + ", counterSdkToAcs=" + this.counterSdkToAcs + ", counterAcsToSdk=" + this.counterAcsToSdk + ')';
    }

    public int hashCode() {
        int n = this.isLiveMode ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result = n;
        result = result * 31 + Byte.hashCode(this.counterSdkToAcs);
        result = result * 31 + Byte.hashCode(this.counterAcsToSdk);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultMessageTransformer)) {
            return false;
        }
        DefaultMessageTransformer defaultMessageTransformer = (DefaultMessageTransformer)other;
        if (this.isLiveMode != defaultMessageTransformer.isLiveMode) {
            return false;
        }
        if (this.counterSdkToAcs != defaultMessageTransformer.counterSdkToAcs) {
            return false;
        }
        return this.counterAcsToSdk == defaultMessageTransformer.counterAcsToSdk;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/stripe3ds2/security/DefaultMessageTransformer$Companion;", "", "()V", "BITS_IN_BYTE", "", "ENCRYPTION_METHOD", "Lcom/nimbusds/jose/EncryptionMethod;", "kotlin.jvm.PlatformType", "FIELD_ACS_COUNTER_ACS_TO_SDK", "", "FIELD_SDK_COUNTER_SDK_TO_ACS", "3ds2sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

