/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.DirectEncrypter;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jwt.JWTClaimsSet;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.DiffieHellmanKeyGenerator;
import com.stripe.android.stripe3ds2.security.EphemeralKeyPairGenerator;
import com.stripe.android.stripe3ds2.security.StripeDiffieHellmanKeyGenerator;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.text.ParseException;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/stripe3ds2/security/JweEcEncrypter;", "", "ephemeralKeyPairGenerator", "Lcom/stripe/android/stripe3ds2/security/EphemeralKeyPairGenerator;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "(Lcom/stripe/android/stripe3ds2/security/EphemeralKeyPairGenerator;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "dhKeyGenerator", "Lcom/stripe/android/stripe3ds2/security/DiffieHellmanKeyGenerator;", "(Lcom/stripe/android/stripe3ds2/security/EphemeralKeyPairGenerator;Lcom/stripe/android/stripe3ds2/security/DiffieHellmanKeyGenerator;)V", "encrypt", "", "payload", "acsPublicKey", "Ljava/security/interfaces/ECPublicKey;", "directoryServerId", "3ds2sdk_release"})
public final class JweEcEncrypter {
    @NotNull
    private final EphemeralKeyPairGenerator ephemeralKeyPairGenerator;
    @NotNull
    private final DiffieHellmanKeyGenerator dhKeyGenerator;

    private JweEcEncrypter(EphemeralKeyPairGenerator ephemeralKeyPairGenerator, DiffieHellmanKeyGenerator dhKeyGenerator) {
        this.ephemeralKeyPairGenerator = ephemeralKeyPairGenerator;
        this.dhKeyGenerator = dhKeyGenerator;
    }

    public JweEcEncrypter(@NotNull EphemeralKeyPairGenerator ephemeralKeyPairGenerator, @NotNull ErrorReporter errorReporter2) {
        Intrinsics.checkNotNullParameter((Object)ephemeralKeyPairGenerator, (String)"ephemeralKeyPairGenerator");
        Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
        this(ephemeralKeyPairGenerator, new StripeDiffieHellmanKeyGenerator(errorReporter2));
    }

    @NotNull
    public final String encrypt(@NotNull String payload, @NotNull ECPublicKey acsPublicKey, @NotNull String directoryServerId) throws ParseException, JOSEException {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)acsPublicKey, (String)"acsPublicKey");
        Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
        JWTClaimsSet.parse((String)payload);
        KeyPair keyPair = this.ephemeralKeyPairGenerator.generate();
        PrivateKey privateKey = keyPair.getPrivate();
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPrivateKey");
        SecretKey secretKey = this.dhKeyGenerator.generate(acsPublicKey, (ECPrivateKey)privateKey, directoryServerId);
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        ECKey jwk = new ECKey.Builder(Curve.P_256, (ECPublicKey)publicKey).build();
        JWEHeader header = new JWEHeader.Builder(JWEAlgorithm.DIR, EncryptionMethod.A128CBC_HS256).ephemeralPublicKey((JWK)ECKey.parse((String)jwk.toJSONString())).build();
        JWEObject jweObject = new JWEObject(header, new Payload(payload));
        jweObject.encrypt((JWEEncrypter)new DirectEncrypter(secretKey));
        String string = jweObject.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize(...)");
        return string;
    }
}

