/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/core/ApiKeyValidator;", "", "()V", "requireValid", "", "apiKey", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class ApiKeyValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final ApiKeyValidator DEFAULT;

    @NotNull
    public final String requireValid(@Nullable String apiKey) {
        CharSequence charSequence = apiKey;
        if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)))) {
            boolean $i$a$-require-ApiKeyValidator$requireValid$32 = false;
            String $i$a$-require-ApiKeyValidator$requireValid$32 = "Invalid Publishable Key: You must use a valid Stripe API key to make a Stripe API request. For more info, see https://stripe.com/docs/keys";
            throw new IllegalArgumentException($i$a$-require-ApiKeyValidator$requireValid$32.toString());
        }
        if (!(!StringsKt.startsWith$default((String)apiKey, (String)"sk_", (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string = "Invalid Publishable Key: You are using a secret key instead of a publishable one. For more info, see https://stripe.com/docs/keys";
            throw new IllegalArgumentException(string.toString());
        }
        return apiKey;
    }

    @JvmStatic
    @NotNull
    public static final ApiKeyValidator get() {
        return Companion.get();
    }

    static {
        DEFAULT = new ApiKeyValidator();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/core/ApiKeyValidator$Companion;", "", "()V", "DEFAULT", "Lcom/stripe/android/core/ApiKeyValidator;", "get", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ApiKeyValidator get() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

