/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.networking.AnalyticsEvent;
import com.stripe.android.core.networking.AnalyticsRequest;
import com.stripe.android.core.networking.RequestHeadersFactory;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB?\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0010J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0010H\u0007J\u001a\u0010\u0018\u001a\u00020\u00192\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0010H\u0002J\u0018\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0010*\u00020\u0014H\u0002R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/core/networking/AnalyticsRequestFactory;", "", "packageManager", "Landroid/content/pm/PackageManager;", "packageInfo", "Landroid/content/pm/PackageInfo;", "packageName", "", "publishableKeyProvider", "Ljavax/inject/Provider;", "defaultProductUsageTokens", "", "(Landroid/content/pm/PackageManager;Landroid/content/pm/PackageInfo;Ljava/lang/String;Ljavax/inject/Provider;Ljava/util/Set;)V", "getDefaultProductUsageTokens$stripe_core_release", "()Ljava/util/Set;", "appDataParams", "", "appDataParams$stripe_core_release", "createParams", "event", "Lcom/stripe/android/core/networking/AnalyticsEvent;", "createRequest", "Lcom/stripe/android/core/networking/AnalyticsRequest;", "additionalParams", "getAppName", "", "standardParams", "params", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public class AnalyticsRequestFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PackageManager packageManager;
    @Nullable
    private final PackageInfo packageInfo;
    @NotNull
    private final String packageName;
    @NotNull
    private final Provider<String> publishableKeyProvider;
    @NotNull
    private final Set<String> defaultProductUsageTokens;
    public static final int $stable = 8;
    @NotNull
    private static final String ANALYTICS_PREFIX = "analytics";
    @NotNull
    private static final String ANALYTICS_NAME = "stripe_android";
    @NotNull
    private static final String ANALYTICS_VERSION = "1.0";
    @NotNull
    private static final String DEVICE_TYPE = Build.MANUFACTURER + '_' + Build.BRAND + '_' + Build.MODEL;
    @NotNull
    public static final String ANALYTICS_UA = "analytics.stripe_android-1.0";

    public AnalyticsRequestFactory(@Nullable PackageManager packageManager, @Nullable PackageInfo packageInfo, @NotNull String packageName, @NotNull Provider<String> publishableKeyProvider, @NotNull Set<String> defaultProductUsageTokens) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(publishableKeyProvider, (String)"publishableKeyProvider");
        Intrinsics.checkNotNullParameter(defaultProductUsageTokens, (String)"defaultProductUsageTokens");
        this.packageManager = packageManager;
        this.packageInfo = packageInfo;
        this.packageName = packageName;
        this.publishableKeyProvider = publishableKeyProvider;
        this.defaultProductUsageTokens = defaultProductUsageTokens;
    }

    public /* synthetic */ AnalyticsRequestFactory(PackageManager packageManager, PackageInfo packageInfo, String string, Provider provider, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            set = SetsKt.emptySet();
        }
        this(packageManager, packageInfo, string, (Provider<String>)provider, set);
    }

    @NotNull
    public final Set<String> getDefaultProductUsageTokens$stripe_core_release() {
        return this.defaultProductUsageTokens;
    }

    @NotNull
    public final AnalyticsRequest createRequest(@NotNull AnalyticsEvent event, @NotNull Map<String, ? extends Object> additionalParams) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(additionalParams, (String)"additionalParams");
        return new AnalyticsRequest(MapsKt.plus(this.createParams(event), additionalParams), RequestHeadersFactory.Analytics.INSTANCE.create());
    }

    @Deprecated(message="use {@link #createRequest(AnalyticsEvent, Map<String, Any>)}")
    @NotNull
    public final AnalyticsRequest createRequest(@NotNull String event, @NotNull Map<String, ? extends Object> additionalParams) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(additionalParams, (String)"additionalParams");
        return this.createRequest(new AnalyticsEvent(event){
            @NotNull
            private final String eventName;
            final /* synthetic */ String $event;
            {
                this.$event = $event;
                this.eventName = this.$event;
            }

            @NotNull
            public String getEventName() {
                return this.eventName;
            }
        }, additionalParams);
    }

    private final Map<String, Object> createParams(AnalyticsEvent event) {
        return MapsKt.plus((Map)MapsKt.plus(this.standardParams(), this.appDataParams$stripe_core_release()), this.params(event));
    }

    private final Map<String, String> params(AnalyticsEvent $this$params) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"event", (Object)$this$params.getEventName()));
    }

    private final Map<String, Object> standardParams() {
        Object object;
        Object object2;
        Pair[] pairArray = new Pair[8];
        pairArray[0] = TuplesKt.to((Object)"analytics_ua", (Object)ANALYTICS_UA);
        Object object3 = this;
        String string = "publishable_key";
        int n = 1;
        Pair[] pairArray2 = pairArray;
        try {
            AnalyticsRequestFactory $this$standardParams_u24lambda_u2d0 = object3;
            boolean bl = false;
            object2 = Result.constructor-impl((Object)((String)$this$standardParams_u24lambda_u2d0.publishableKeyProvider.get()));
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object3 = object = object2;
        object2 = "pk_undefined";
        pairArray2[n] = TuplesKt.to((Object)string, (Object)(Result.isFailure-impl((Object)object3) ? object2 : object3));
        pairArray[2] = TuplesKt.to((Object)"os_name", (Object)Build.VERSION.CODENAME);
        pairArray[3] = TuplesKt.to((Object)"os_release", (Object)Build.VERSION.RELEASE);
        pairArray[4] = TuplesKt.to((Object)"os_version", (Object)Build.VERSION.SDK_INT);
        pairArray[5] = TuplesKt.to((Object)"device_type", (Object)DEVICE_TYPE);
        pairArray[6] = TuplesKt.to((Object)"bindings_version", (Object)"20.1.0");
        pairArray[7] = TuplesKt.to((Object)"is_development", (Object)false);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Map<String, Object> appDataParams$stripe_core_release() {
        Map map;
        if (this.packageManager != null && this.packageInfo != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"app_name", (Object)this.getAppName(this.packageInfo, this.packageManager)), TuplesKt.to((Object)"app_version", (Object)this.packageInfo.versionCode)};
            map = MapsKt.mapOf((Pair[])pairArray);
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private final CharSequence getAppName(PackageInfo packageInfo, PackageManager packageManager) {
        CharSequence charSequence;
        CharSequence charSequence2;
        PackageInfo packageInfo2 = packageInfo;
        if (packageInfo2 == null) {
            charSequence2 = null;
        } else {
            ApplicationInfo applicationInfo = packageInfo2.applicationInfo;
            charSequence2 = applicationInfo == null ? null : applicationInfo.loadLabel(packageManager);
        }
        CharSequence it = charSequence = charSequence2;
        boolean bl = false;
        CharSequence charSequence3 = it;
        CharSequence charSequence4 = !(charSequence3 == null || StringsKt.isBlank((CharSequence)charSequence3)) ? charSequence : null;
        return charSequence4 == null ? (CharSequence)this.packageName : charSequence4;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/core/networking/AnalyticsRequestFactory$Companion;", "", "()V", "ANALYTICS_NAME", "", "ANALYTICS_PREFIX", "ANALYTICS_UA", "ANALYTICS_VERSION", "DEVICE_TYPE", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

