/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.exception.InvalidRequestException;
import com.stripe.android.core.networking.StripeConnection;
import com.stripe.android.core.networking.StripeRequest;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bg\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bJ\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH&\u00a8\u0006\f"}, d2={"Lcom/stripe/android/core/networking/ConnectionFactory;", "", "create", "Lcom/stripe/android/core/networking/StripeConnection;", "", "request", "Lcom/stripe/android/core/networking/StripeRequest;", "createForFile", "Ljava/io/File;", "outputFile", "Companion", "Default", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public interface ConnectionFactory {
    public static final /* synthetic */ Companion Companion;

    @NotNull
    public StripeConnection<String> create(@NotNull StripeRequest var1) throws IOException, InvalidRequestException;

    @NotNull
    public StripeConnection<File> createForFile(@NotNull StripeRequest var1, @NotNull File var2) throws IOException, InvalidRequestException;

    static {
        Companion = com.stripe.android.core.networking.ConnectionFactory$Companion.$$INSTANCE;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/stripe/android/core/networking/ConnectionFactory$Default;", "Lcom/stripe/android/core/networking/ConnectionFactory;", "()V", "create", "Lcom/stripe/android/core/networking/StripeConnection;", "", "request", "Lcom/stripe/android/core/networking/StripeRequest;", "createForFile", "Ljava/io/File;", "outputFile", "openConnectionAndApplyFields", "Ljava/net/HttpURLConnection;", "stripe-core_release"})
    @StabilityInferred(parameters=0)
    public static final class Default
    implements ConnectionFactory {
        @NotNull
        public static final Default INSTANCE = new Default();
        public static final int $stable;

        private Default() {
        }

        public /* synthetic */ StripeConnection create(StripeRequest request) throws IOException, InvalidRequestException {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            return new StripeConnection.Default(this.openConnectionAndApplyFields(request));
        }

        @Override
        @NotNull
        public StripeConnection<File> createForFile(@NotNull StripeRequest request, @NotNull File outputFile) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            return new StripeConnection.FileConnection(this.openConnectionAndApplyFields(request), outputFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final HttpURLConnection openConnectionAndApplyFields(StripeRequest request) {
            HttpURLConnection httpURLConnection;
            URLConnection uRLConnection = new URL(request.getUrl()).openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection $this$openConnectionAndApplyFields_u24lambda_u2d3 = httpURLConnection = (HttpURLConnection)uRLConnection;
            boolean bl = false;
            $this$openConnectionAndApplyFields_u24lambda_u2d3.setConnectTimeout(com.stripe.android.core.networking.ConnectionFactory$Companion.CONNECT_TIMEOUT);
            $this$openConnectionAndApplyFields_u24lambda_u2d3.setReadTimeout(com.stripe.android.core.networking.ConnectionFactory$Companion.READ_TIMEOUT);
            $this$openConnectionAndApplyFields_u24lambda_u2d3.setUseCaches(false);
            $this$openConnectionAndApplyFields_u24lambda_u2d3.setRequestMethod(request.getMethod().getCode());
            Map<String, String> $this$forEach$iv = request.getHeaders();
            boolean $i$f$forEach = false;
            Unit unit = $this$forEach$iv.entrySet().iterator();
            while (unit.hasNext()) {
                Map.Entry<String, String> entry;
                Map.Entry<String, String> $dstr$key$value = entry = unit.next();
                boolean bl2 = false;
                String key = $dstr$key$value.getKey();
                String value = $dstr$key$value.getValue();
                $this$openConnectionAndApplyFields_u24lambda_u2d3.setRequestProperty(key, value);
            }
            if (StripeRequest.Method.POST == request.getMethod()) {
                $this$openConnectionAndApplyFields_u24lambda_u2d3.setDoOutput(true);
                Map<String, String> map = request.getPostHeaders();
                if (map != null) {
                    Map<String, String> $this$forEach$iv2 = map;
                    boolean $i$f$forEach2 = false;
                    Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, String> element$iv2;
                        Map.Entry<String, String> $dstr$key$value = element$iv2 = iterator.next();
                        boolean bl3 = false;
                        String key = $dstr$key$value.getKey();
                        String value = $dstr$key$value.getValue();
                        $this$openConnectionAndApplyFields_u24lambda_u2d3.setRequestProperty(key, value);
                    }
                }
                Closeable closeable = $this$openConnectionAndApplyFields_u24lambda_u2d3.getOutputStream();
                Throwable throwable = null;
                try {
                    OutputStream output = (OutputStream)closeable;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
                    request.writePostBody(output);
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            return httpURLConnection;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/core/networking/ConnectionFactory$Companion;", "", "()V", "CONNECT_TIMEOUT", "", "READ_TIMEOUT", "stripe-core_release"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final int CONNECT_TIMEOUT;
        private static final int READ_TIMEOUT;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
            READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(80L);
        }
    }
}

