/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import androidx.annotation.RestrictTo;
import com.stripe.android.core.exception.InvalidSerializationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\u001a\u0016\u0010\u0000\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u0001*\u00020\u0003H\u0007\u001a\u0016\u0010\u0000\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u0001*\u00020\u0004H\u0007\u001a\u0010\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006*\u00020\u0007H\u0007\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\b*\u00020\u0003H\u0007\u00a8\u0006\t"}, d2={"toMap", "", "", "Lkotlinx/serialization/json/JsonElement;", "Lkotlinx/serialization/json/JsonObject;", "toPrimitives", "", "Lkotlinx/serialization/json/JsonArray;", "", "stripe-core_release"})
public final class JsonUtilsKt {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final Map<String, ?> toMap(@NotNull JsonElement $this$toMap) {
        Intrinsics.checkNotNullParameter((Object)$this$toMap, (String)"<this>");
        if (!($this$toMap instanceof JsonObject)) {
            String string = $this$toMap.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this::class.java.simpleName");
            throw new InvalidSerializationException(string);
        }
        return JsonUtilsKt.toMap((JsonObject)$this$toMap);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static final Object toPrimitives(@NotNull JsonElement $this$toPrimitives) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toPrimitives, (String)"<this>");
        JsonElement jsonElement = $this$toPrimitives;
        if (Intrinsics.areEqual((Object)jsonElement, (Object)JsonNull.INSTANCE)) {
            object = null;
        } else if (jsonElement instanceof JsonArray) {
            object = JsonUtilsKt.toPrimitives((JsonArray)$this$toPrimitives);
        } else if (jsonElement instanceof JsonObject) {
            object = JsonUtilsKt.toMap((JsonObject)$this$toPrimitives);
        } else if (jsonElement instanceof JsonPrimitive) {
            CharSequence charSequence = ((JsonPrimitive)$this$toPrimitives).getContent();
            Regex regex = new Regex("^\"|\"$");
            String string = "";
            object = regex.replace(charSequence, string);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final List<?> toPrimitives(@NotNull JsonArray $this$toPrimitives) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toPrimitives, (String)"<this>");
        Iterable $this$map$iv = (Iterable)$this$toPrimitives;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonElement jsonElement = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JsonUtilsKt.toPrimitives((JsonElement)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final Map<String, ?> toMap(@NotNull JsonObject $this$toMap) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toMap, (String)"<this>");
        Map $this$map$iv = (Map)$this$toMap;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), (Object)JsonUtilsKt.toPrimitives((JsonElement)it.getValue())));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }
}

