/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/core/networking/RetryDelaySupplier;", "", "()V", "incrementSeconds", "", "(J)V", "getDelayMillis", "maxRetries", "", "remainingRetries", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class RetryDelaySupplier {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final long incrementSeconds;
    public static final int $stable;
    @Deprecated
    private static final long DEFAULT_INCREMENT_SECONDS = 2L;

    public RetryDelaySupplier(long incrementSeconds) {
        this.incrementSeconds = incrementSeconds;
    }

    @Inject
    public RetryDelaySupplier() {
        this(2L);
    }

    public final long getDelayMillis(int maxRetries, int remainingRetries) {
        int retryAttempt = maxRetries - RangesKt.coerceIn((int)remainingRetries, (int)1, (int)maxRetries) + 1;
        return TimeUnit.SECONDS.toMillis((long)Math.pow(this.incrementSeconds, retryAttempt));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/core/networking/RetryDelaySupplier$Companion;", "", "()V", "DEFAULT_INCREMENT_SECONDS", "", "stripe-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

