/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.networking.RequestId;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0087\b\u0018\u0000 &*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001&B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u0007\u00a2\u0006\u0002\u0010\nJ\t\u0010\u001b\u001a\u00020\u0004H\u00c6\u0003J\u0010\u0010\u001c\u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u0007H\u00c6\u0003JF\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u00002\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\u0016\u0010\"\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\t2\u0006\u0010#\u001a\u00020\bJ\t\u0010$\u001a\u00020\u0004H\u00d6\u0001J\b\u0010%\u001a\u00020\bH\u0016R\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lcom/stripe/android/core/networking/StripeResponse;", "ResponseBody", "", "code", "", "body", "headers", "", "", "", "(ILjava/lang/Object;Ljava/util/Map;)V", "getBody", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getCode", "()I", "getHeaders", "()Ljava/util/Map;", "isError", "", "()Z", "isOk", "isRateLimited", "requestId", "Lcom/stripe/android/core/networking/RequestId;", "getRequestId", "()Lcom/stripe/android/core/networking/RequestId;", "component1", "component2", "component3", "copy", "(ILjava/lang/Object;Ljava/util/Map;)Lcom/stripe/android/core/networking/StripeResponse;", "equals", "other", "getHeaderValue", "key", "hashCode", "toString", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class StripeResponse<ResponseBody> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int code;
    @Nullable
    private final ResponseBody body;
    @NotNull
    private final Map<String, List<String>> headers;
    private final boolean isOk;
    private final boolean isError;
    private final boolean isRateLimited;
    @Nullable
    private final RequestId requestId;
    public static final int $stable = 8;
    @NotNull
    public static final String HEADER_REQUEST_ID = "Request-Id";

    public StripeResponse(int code, @Nullable ResponseBody body, @NotNull Map<String, ? extends List<String>> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.code = code;
        this.body = body;
        this.headers = headers;
        this.isOk = this.code == 200;
        this.isError = this.code < 200 || this.code >= 300;
        this.isRateLimited = this.code == 429;
        List<String> list = this.getHeaderValue(HEADER_REQUEST_ID);
        this.requestId = RequestId.Companion.fromString(list == null ? null : (String)CollectionsKt.firstOrNull(list));
    }

    public /* synthetic */ StripeResponse(int n, Object object, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        this(n, object, map);
    }

    public final int getCode() {
        return this.code;
    }

    @Nullable
    public final ResponseBody getBody() {
        return this.body;
    }

    @NotNull
    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public final boolean isOk() {
        return this.isOk;
    }

    public final boolean isError() {
        return this.isError;
    }

    public final boolean isRateLimited() {
        return this.isRateLimited;
    }

    @Nullable
    public final RequestId getRequestId() {
        return this.requestId;
    }

    @NotNull
    public String toString() {
        return "Request-Id: " + this.requestId + ", Status Code: " + this.code;
    }

    @Nullable
    public final List<String> getHeaderValue(@NotNull String key) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Iterable $this$firstOrNull$iv = this.headers.entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)((String)it.getKey()), (String)key, (boolean)true)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry == null ? null : (List)entry.getValue();
    }

    public final int component1() {
        return this.code;
    }

    @Nullable
    public final ResponseBody component2() {
        return this.body;
    }

    @NotNull
    public final Map<String, List<String>> component3() {
        return this.headers;
    }

    @NotNull
    public final StripeResponse<ResponseBody> copy(int code, @Nullable ResponseBody body, @NotNull Map<String, ? extends List<String>> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return new StripeResponse<ResponseBody>(code, body, headers);
    }

    public static /* synthetic */ StripeResponse copy$default(StripeResponse stripeResponse, int n, Object object, Map map, int n2, Object object2) {
        if ((n2 & 1) != 0) {
            n = stripeResponse.code;
        }
        if ((n2 & 2) != 0) {
            object = stripeResponse.body;
        }
        if ((n2 & 4) != 0) {
            map = stripeResponse.headers;
        }
        return stripeResponse.copy(n, object, map);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.code);
        result = result * 31 + (this.body == null ? 0 : this.body.hashCode());
        result = result * 31 + ((Object)this.headers).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StripeResponse)) {
            return false;
        }
        StripeResponse stripeResponse = (StripeResponse)other;
        if (this.code != stripeResponse.code) {
            return false;
        }
        if (!Intrinsics.areEqual(this.body, stripeResponse.body)) {
            return false;
        }
        return Intrinsics.areEqual(this.headers, stripeResponse.headers);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/core/networking/StripeResponse$Companion;", "", "()V", "HEADER_REQUEST_ID", "", "stripe-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

