/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.storage;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.storage.Storage;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0015H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/core/storage/SharedPreferencesStorage;", "Lcom/stripe/android/core/storage/Storage;", "context", "Landroid/content/Context;", "purpose", "", "(Landroid/content/Context;Ljava/lang/String;)V", "sharedPrefs", "Landroid/content/SharedPreferences;", "getSharedPrefs", "()Landroid/content/SharedPreferences;", "sharedPrefs$delegate", "Lkotlin/Lazy;", "clear", "", "getBoolean", "key", "defaultValue", "getFloat", "", "getInt", "", "getLong", "", "getString", "remove", "storeValue", "value", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class SharedPreferencesStorage
implements Storage {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String purpose;
    @NotNull
    private final Lazy sharedPrefs$delegate;
    public static final int $stable = 8;
    @Deprecated
    @NotNull
    private static final String logTag;

    public SharedPreferencesStorage(@NotNull Context context, @NotNull String purpose) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)purpose, (String)"purpose");
        this.context = context;
        this.purpose = purpose;
        this.sharedPrefs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SharedPreferences>(this){
            final /* synthetic */ SharedPreferencesStorage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final SharedPreferences invoke() {
                return SharedPreferencesStorage.access$getContext$p(this.this$0).getSharedPreferences("stripe_shared_prefs", 0);
            }
        }));
    }

    private final SharedPreferences getSharedPrefs() {
        Lazy lazy = this.sharedPrefs$delegate;
        return (SharedPreferences)lazy.getValue();
    }

    @Override
    public boolean storeValue(@NotNull String key, @NotNull String value) {
        boolean bl;
        Boolean bl2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences == null) {
            bl2 = null;
        } else {
            SharedPreferences $this$storeValue_u24lambda_u2d1 = sharedPreferences;
            boolean bl3 = false;
            SharedPreferences.Editor $this$storeValue_u24lambda_u2d1_u24lambda_u2d0 = $this$storeValue_u24lambda_u2d1.edit();
            boolean bl4 = false;
            $this$storeValue_u24lambda_u2d1_u24lambda_u2d0.putString(this.purpose + '_' + key, value);
            bl2 = $this$storeValue_u24lambda_u2d1_u24lambda_u2d0.commit();
        }
        Boolean bl5 = bl2;
        if (bl5 == null) {
            boolean bl6;
            boolean $this$storeValue_u24lambda_u2d2 = bl6 = false;
            boolean bl7 = false;
            Log.e((String)logTag, (String)("Shared preferences is unavailable to store " + value + " for " + key));
            bl = bl6;
        } else {
            bl = bl5;
        }
        return bl;
    }

    @Override
    public boolean storeValue(@NotNull String key, long value) {
        boolean bl;
        Boolean bl2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences == null) {
            bl2 = null;
        } else {
            SharedPreferences $this$storeValue_u24lambda_u2d4 = sharedPreferences;
            boolean bl3 = false;
            SharedPreferences.Editor $this$storeValue_u24lambda_u2d4_u24lambda_u2d3 = $this$storeValue_u24lambda_u2d4.edit();
            boolean bl4 = false;
            $this$storeValue_u24lambda_u2d4_u24lambda_u2d3.putLong(this.purpose + '_' + key, value);
            bl2 = $this$storeValue_u24lambda_u2d4_u24lambda_u2d3.commit();
        }
        Boolean bl5 = bl2;
        if (bl5 == null) {
            boolean bl6;
            boolean $this$storeValue_u24lambda_u2d5 = bl6 = false;
            boolean bl7 = false;
            Log.e((String)logTag, (String)("Shared preferences is unavailable to store " + value + " for " + key));
            bl = bl6;
        } else {
            bl = bl5;
        }
        return bl;
    }

    @Override
    public boolean storeValue(@NotNull String key, int value) {
        boolean bl;
        Boolean bl2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences == null) {
            bl2 = null;
        } else {
            SharedPreferences $this$storeValue_u24lambda_u2d7 = sharedPreferences;
            boolean bl3 = false;
            SharedPreferences.Editor $this$storeValue_u24lambda_u2d7_u24lambda_u2d6 = $this$storeValue_u24lambda_u2d7.edit();
            boolean bl4 = false;
            $this$storeValue_u24lambda_u2d7_u24lambda_u2d6.putInt(this.purpose + '_' + key, value);
            bl2 = $this$storeValue_u24lambda_u2d7_u24lambda_u2d6.commit();
        }
        Boolean bl5 = bl2;
        if (bl5 == null) {
            boolean bl6;
            boolean $this$storeValue_u24lambda_u2d8 = bl6 = false;
            boolean bl7 = false;
            Log.e((String)logTag, (String)("Shared preferences is unavailable to store " + value + " for " + key));
            bl = bl6;
        } else {
            bl = bl5;
        }
        return bl;
    }

    @Override
    public boolean storeValue(@NotNull String key, float value) {
        boolean bl;
        Boolean bl2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences == null) {
            bl2 = null;
        } else {
            SharedPreferences $this$storeValue_u24lambda_u2d10 = sharedPreferences;
            boolean bl3 = false;
            SharedPreferences.Editor $this$storeValue_u24lambda_u2d10_u24lambda_u2d9 = $this$storeValue_u24lambda_u2d10.edit();
            boolean bl4 = false;
            $this$storeValue_u24lambda_u2d10_u24lambda_u2d9.putFloat(this.purpose + '_' + key, value);
            bl2 = $this$storeValue_u24lambda_u2d10_u24lambda_u2d9.commit();
        }
        Boolean bl5 = bl2;
        if (bl5 == null) {
            boolean bl6;
            boolean $this$storeValue_u24lambda_u2d11 = bl6 = false;
            boolean bl7 = false;
            Log.e((String)logTag, (String)("Shared preferences is unavailable to store " + value + " for " + key));
            bl = bl6;
        } else {
            bl = bl5;
        }
        return bl;
    }

    @Override
    public boolean storeValue(@NotNull String key, boolean value) {
        boolean bl;
        Boolean bl2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences == null) {
            bl2 = null;
        } else {
            SharedPreferences $this$storeValue_u24lambda_u2d13 = sharedPreferences;
            boolean bl3 = false;
            SharedPreferences.Editor $this$storeValue_u24lambda_u2d13_u24lambda_u2d12 = $this$storeValue_u24lambda_u2d13.edit();
            boolean bl4 = false;
            $this$storeValue_u24lambda_u2d13_u24lambda_u2d12.putBoolean(this.purpose + '_' + key, value);
            bl2 = $this$storeValue_u24lambda_u2d13_u24lambda_u2d12.commit();
        }
        Boolean bl5 = bl2;
        if (bl5 == null) {
            boolean bl6;
            boolean $this$storeValue_u24lambda_u2d14 = bl6 = false;
            boolean bl7 = false;
            Log.e((String)logTag, (String)("Shared preferences is unavailable to store " + value + " for " + key));
            bl = bl6;
        } else {
            bl = bl5;
        }
        return bl;
    }

    @Override
    @NotNull
    public String getString(@NotNull String key, @NotNull String defaultValue) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        try {
            String string2;
            String string3;
            SharedPreferences sharedPreferences = this.getSharedPrefs();
            String string4 = string3 = sharedPreferences == null ? null : sharedPreferences.getString(this.purpose + '_' + key, defaultValue);
            if (string3 == null) {
                String string5;
                String $this$getString_u24lambda_u2d15 = string5 = defaultValue;
                boolean bl = false;
                Log.e((String)logTag, (String)Intrinsics.stringPlus((String)"Unable to retrieve a String for ", (Object)key));
                string2 = string5;
            } else {
                string2 = string3;
            }
            string = string2;
        }
        catch (Throwable t) {
            if (t instanceof ClassCastException) {
                Log.e((String)logTag, (String)Intrinsics.stringPlus((String)key, (Object)" is not a String"), (Throwable)t);
            } else {
                Log.d((String)logTag, (String)Intrinsics.stringPlus((String)"Error retrieving String for ", (Object)key), (Throwable)t);
            }
            string = defaultValue;
        }
        return string;
    }

    @Override
    public long getLong(@NotNull String key, long defaultValue) {
        long l;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            long l2;
            Long l3;
            SharedPreferences sharedPreferences = this.getSharedPrefs();
            Long l4 = l3 = sharedPreferences == null ? null : Long.valueOf(sharedPreferences.getLong(this.purpose + '_' + key, defaultValue));
            if (l3 == null) {
                long l5;
                long $this$getLong_u24lambda_u2d16 = l5 = defaultValue;
                boolean bl = false;
                Log.e((String)logTag, (String)Intrinsics.stringPlus((String)"Unable to retrieve a Long for ", (Object)key));
                l2 = l5;
            } else {
                l2 = l3;
            }
            l = l2;
        }
        catch (Throwable t) {
            if (t instanceof ClassCastException) {
                Log.e((String)logTag, (String)Intrinsics.stringPlus((String)key, (Object)" is not a Long"), (Throwable)t);
            } else {
                Log.d((String)logTag, (String)Intrinsics.stringPlus((String)"Error retrieving Long for ", (Object)key), (Throwable)t);
            }
            l = defaultValue;
        }
        return l;
    }

    @Override
    public int getInt(@NotNull String key, int defaultValue) {
        int n;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            int n2;
            Integer n3;
            SharedPreferences sharedPreferences = this.getSharedPrefs();
            Integer n4 = n3 = sharedPreferences == null ? null : Integer.valueOf(sharedPreferences.getInt(this.purpose + '_' + key, defaultValue));
            if (n3 == null) {
                int n5;
                int $this$getInt_u24lambda_u2d17 = n5 = defaultValue;
                boolean bl = false;
                Log.e((String)logTag, (String)Intrinsics.stringPlus((String)"Unable to retrieve an Int for ", (Object)key));
                n2 = n5;
            } else {
                n2 = n3;
            }
            n = n2;
        }
        catch (Throwable t) {
            if (t instanceof ClassCastException) {
                Log.e((String)logTag, (String)Intrinsics.stringPlus((String)key, (Object)" is not a Int"), (Throwable)t);
            } else {
                Log.d((String)logTag, (String)Intrinsics.stringPlus((String)"Error retrieving Int for ", (Object)key), (Throwable)t);
            }
            n = defaultValue;
        }
        return n;
    }

    @Override
    public float getFloat(@NotNull String key, float defaultValue) {
        float f;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            float f2;
            Float f3;
            SharedPreferences sharedPreferences = this.getSharedPrefs();
            Float f4 = f3 = sharedPreferences == null ? null : Float.valueOf(sharedPreferences.getFloat(this.purpose + '_' + key, defaultValue));
            if (f3 == null) {
                float f5;
                float $this$getFloat_u24lambda_u2d18 = f5 = defaultValue;
                boolean bl = false;
                Log.e((String)logTag, (String)Intrinsics.stringPlus((String)"Unable to retrieve a Float for ", (Object)key));
                f2 = f5;
            } else {
                f2 = f3.floatValue();
            }
            f = f2;
        }
        catch (Throwable t) {
            if (t instanceof ClassCastException) {
                Log.e((String)logTag, (String)Intrinsics.stringPlus((String)key, (Object)" is not a Float"), (Throwable)t);
            } else {
                Log.d((String)logTag, (String)Intrinsics.stringPlus((String)"Error retrieving Float for ", (Object)key), (Throwable)t);
            }
            f = defaultValue;
        }
        return f;
    }

    @Override
    public boolean getBoolean(@NotNull String key, boolean defaultValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            boolean bl2;
            Boolean bl3;
            SharedPreferences sharedPreferences = this.getSharedPrefs();
            Boolean bl4 = bl3 = sharedPreferences == null ? null : Boolean.valueOf(sharedPreferences.getBoolean(this.purpose + '_' + key, defaultValue));
            if (bl3 == null) {
                boolean bl5;
                boolean $this$getBoolean_u24lambda_u2d19 = bl5 = defaultValue;
                boolean bl6 = false;
                Log.e((String)logTag, (String)Intrinsics.stringPlus((String)"Unable to retrieve a Boolean for ", (Object)key));
                bl2 = bl5;
            } else {
                bl2 = bl3;
            }
            bl = bl2;
        }
        catch (Throwable t) {
            if (t instanceof ClassCastException) {
                Log.e((String)logTag, (String)Intrinsics.stringPlus((String)key, (Object)" is not a Boolean"), (Throwable)t);
            } else {
                Log.d((String)logTag, (String)Intrinsics.stringPlus((String)"Error retrieving Boolean for ", (Object)key), (Throwable)t);
            }
            bl = defaultValue;
        }
        return bl;
    }

    @Override
    public boolean remove(@NotNull String key) {
        boolean bl;
        Boolean bl2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences == null) {
            bl2 = null;
        } else {
            SharedPreferences $this$remove_u24lambda_u2d21 = sharedPreferences;
            boolean bl3 = false;
            SharedPreferences.Editor $this$remove_u24lambda_u2d21_u24lambda_u2d20 = $this$remove_u24lambda_u2d21.edit();
            boolean bl4 = false;
            $this$remove_u24lambda_u2d21_u24lambda_u2d20.remove(key);
            bl2 = $this$remove_u24lambda_u2d21_u24lambda_u2d20.commit();
        }
        Boolean bl5 = bl2;
        if (bl5 == null) {
            boolean bl6;
            boolean $this$remove_u24lambda_u2d22 = bl6 = false;
            boolean bl7 = false;
            Log.e((String)logTag, (String)"Shared preferences is unavailable to remove values");
            bl = bl6;
        } else {
            bl = bl5;
        }
        return bl;
    }

    @Override
    public boolean clear() {
        boolean bl;
        Boolean bl2;
        SharedPreferences sharedPreferences = this.getSharedPrefs();
        if (sharedPreferences == null) {
            bl2 = null;
        } else {
            SharedPreferences $this$clear_u24lambda_u2d24 = sharedPreferences;
            boolean bl3 = false;
            SharedPreferences.Editor $this$clear_u24lambda_u2d24_u24lambda_u2d23 = $this$clear_u24lambda_u2d24.edit();
            boolean bl4 = false;
            $this$clear_u24lambda_u2d24_u24lambda_u2d23.clear();
            bl2 = $this$clear_u24lambda_u2d24_u24lambda_u2d23.commit();
        }
        Boolean bl5 = bl2;
        if (bl5 == null) {
            boolean bl6;
            boolean $this$clear_u24lambda_u2d25 = bl6 = false;
            boolean bl7 = false;
            Log.e((String)logTag, (String)"Shared preferences is unavailable to clear values");
            bl = bl6;
        } else {
            bl = bl5;
        }
        return bl;
    }

    public static final /* synthetic */ Context access$getContext$p(SharedPreferencesStorage $this) {
        return $this.context;
    }

    static {
        String string = SharedPreferencesStorage.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SharedPreferencesStorage::class.java.simpleName");
        logTag = string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/core/storage/SharedPreferencesStorage$Companion;", "", "()V", "logTag", "", "getLogTag", "()Ljava/lang/String;", "stripe-core_release"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getLogTag() {
            return logTag;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

