/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.exception;

import androidx.annotation.RestrictTo;
import com.stripe.android.core.StripeError;
import com.stripe.android.core.exception.APIConnectionException;
import com.stripe.android.core.exception.APIException;
import com.stripe.android.core.exception.InvalidRequestException;
import java.io.IOException;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0006\b&\u0018\u0000 \u001d2\u00060\u0001j\u0002`\u0002:\u0001\u001dB?\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0000H\u0002R\u0016\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/stripe/android/core/exception/StripeException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "stripeError", "Lcom/stripe/android/core/StripeError;", "requestId", "", "statusCode", "", "cause", "", "message", "(Lcom/stripe/android/core/StripeError;Ljava/lang/String;ILjava/lang/Throwable;Ljava/lang/String;)V", "isClientError", "", "()Z", "getRequestId", "()Ljava/lang/String;", "getStatusCode", "()I", "getStripeError", "()Lcom/stripe/android/core/StripeError;", "equals", "other", "", "hashCode", "toString", "typedEquals", "ex", "Companion", "stripe-core_release"})
public abstract class StripeException
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final StripeError stripeError;
    @Nullable
    private final String requestId;
    private final int statusCode;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private final boolean isClientError;

    public StripeException(@Nullable StripeError stripeError, @Nullable String requestId, int statusCode, @Nullable Throwable cause, @Nullable String message) {
        super(message, cause);
        this.stripeError = stripeError;
        this.requestId = requestId;
        int n = this.statusCode = statusCode;
        this.isClientError = 400 <= n ? n < 500 : false;
    }

    public /* synthetic */ StripeException(StripeError stripeError, String string, int n, Throwable throwable, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            stripeError = null;
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            throwable = null;
        }
        if ((n2 & 0x10) != 0) {
            StripeError stripeError2 = stripeError;
            string2 = stripeError2 == null ? null : stripeError2.getMessage();
        }
        this(stripeError, string, n, throwable, string2);
    }

    @Nullable
    public final StripeError getStripeError() {
        return this.stripeError;
    }

    @Nullable
    public final String getRequestId() {
        return this.requestId;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final boolean isClientError() {
        return this.isClientError;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String toString() {
        String string;
        Object[] objectArray;
        Object[] objectArray2 = objectArray = new String[2];
        int n = 0;
        String string2 = this.requestId;
        if (string2 == null) {
            string = null;
        } else {
            void it;
            String string3 = string2;
            int n2 = n;
            Object[] objectArray3 = objectArray2;
            boolean bl = false;
            String string4 = Intrinsics.stringPlus((String)"Request-id: ", (Object)it);
            objectArray2 = objectArray3;
            n = n2;
            string = string4;
        }
        objectArray2[n] = string;
        objectArray[1] = super.toString();
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (other instanceof StripeException ? this.typedEquals((StripeException)other) : false);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.stripeError, this.requestId, this.statusCode, this.getMessage()};
        return Objects.hash(objectArray);
    }

    private final boolean typedEquals(StripeException ex) {
        return Intrinsics.areEqual((Object)this.stripeError, (Object)ex.stripeError) && Intrinsics.areEqual((Object)this.requestId, (Object)ex.requestId) && this.statusCode == ex.statusCode && Intrinsics.areEqual((Object)this.getMessage(), (Object)ex.getMessage());
    }

    public StripeException() {
        this(null, null, 0, null, null, 31, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/core/exception/StripeException$Companion;", "", "()V", "create", "Lcom/stripe/android/core/exception/StripeException;", "throwable", "", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StripeException create(@NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            Throwable throwable2 = throwable;
            return throwable2 instanceof StripeException ? (StripeException)throwable : (throwable2 instanceof JSONException ? (StripeException)new APIException(throwable) : (throwable2 instanceof IOException ? (StripeException)APIConnectionException.Companion.create$default(APIConnectionException.Companion, (IOException)throwable, null, 2, null) : (throwable2 instanceof IllegalArgumentException ? (StripeException)new InvalidRequestException(null, null, 0, throwable.getMessage(), throwable, 7, null) : (StripeException)new APIException(throwable))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

