/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.injection;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.core.injection.Injector;
import com.stripe.android.core.injection.InjectorKey;
import com.stripe.android.core.injection.InjectorRegistry;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0017J\u001a\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n2\b\b\u0001\u0010\u0015\u001a\u00020\u000bH\u0016J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u0017\u001a\u00020\u000bH\u0016R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R(\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/core/injection/WeakMapInjectorRegistry;", "Lcom/stripe/android/core/injection/InjectorRegistry;", "()V", "CURRENT_REGISTER_KEY", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCURRENT_REGISTER_KEY$annotations", "getCURRENT_REGISTER_KEY", "()Ljava/util/concurrent/atomic/AtomicInteger;", "staticCacheMap", "Ljava/util/WeakHashMap;", "Lcom/stripe/android/core/injection/Injector;", "", "getStaticCacheMap$annotations", "getStaticCacheMap", "()Ljava/util/WeakHashMap;", "clear", "", "nextKey", "prefix", "register", "injector", "key", "retrieve", "injectorKey", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class WeakMapInjectorRegistry
implements InjectorRegistry {
    @NotNull
    public static final WeakMapInjectorRegistry INSTANCE = new WeakMapInjectorRegistry();
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private static final WeakHashMap<Injector, String> staticCacheMap = new WeakHashMap();
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private static final AtomicInteger CURRENT_REGISTER_KEY = new AtomicInteger(0);

    private WeakMapInjectorRegistry() {
    }

    @NotNull
    public final WeakHashMap<Injector, String> getStaticCacheMap() {
        return staticCacheMap;
    }

    @VisibleForTesting
    public static /* synthetic */ void getStaticCacheMap$annotations() {
    }

    @NotNull
    public final AtomicInteger getCURRENT_REGISTER_KEY() {
        return CURRENT_REGISTER_KEY;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCURRENT_REGISTER_KEY$annotations() {
    }

    @Override
    public synchronized void register(@NotNull Injector injector, @InjectorKey @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)injector, (String)"injector");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ((Map)staticCacheMap).put(injector, key);
    }

    @Override
    @Nullable
    public synchronized Injector retrieve(@InjectorKey @NotNull String injectorKey) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)injectorKey, (String)"injectorKey");
            Set<Map.Entry<Injector, String>> set = staticCacheMap.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"staticCacheMap.entries");
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getValue(), (Object)injectorKey)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry == null ? null : (Injector)entry.getKey();
    }

    @Override
    @InjectorKey
    @NotNull
    public String nextKey(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return Intrinsics.stringPlus((String)prefix, (Object)CURRENT_REGISTER_KEY.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        WeakHashMap<Injector, String> weakHashMap = staticCacheMap;
        synchronized (weakHashMap) {
            boolean bl = false;
            INSTANCE.getStaticCacheMap().clear();
            Unit unit = Unit.INSTANCE;
        }
    }
}

