/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.core.Logger;
import com.stripe.android.core.exception.APIConnectionException;
import com.stripe.android.core.networking.ConnectionFactory;
import com.stripe.android.core.networking.RetryDelaySupplier;
import com.stripe.android.core.networking.StripeConnection;
import com.stripe.android.core.networking.StripeNetworkClient;
import com.stripe.android.core.networking.StripeRequest;
import com.stripe.android.core.networking.StripeResponse;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B9\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJI\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u000e0\u0014H\u0081@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ'\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001dH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J,\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0000\u0010\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u000f0$2\b\u0010%\u001a\u0004\u0018\u00010\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"Lcom/stripe/android/core/networking/DefaultStripeNetworkClient;", "Lcom/stripe/android/core/networking/StripeNetworkClient;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "connectionFactory", "Lcom/stripe/android/core/networking/ConnectionFactory;", "retryDelaySupplier", "Lcom/stripe/android/core/networking/RetryDelaySupplier;", "maxRetries", "", "logger", "Lcom/stripe/android/core/Logger;", "(Lkotlin/coroutines/CoroutineContext;Lcom/stripe/android/core/networking/ConnectionFactory;Lcom/stripe/android/core/networking/RetryDelaySupplier;ILcom/stripe/android/core/Logger;)V", "executeInternal", "Lcom/stripe/android/core/networking/StripeResponse;", "BodyType", "remainingRetries", "retryResponseCodes", "", "requester", "Lkotlin/Function0;", "executeInternal$stripe_core_release", "(ILjava/lang/Iterable;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeRequest", "", "request", "Lcom/stripe/android/core/networking/StripeRequest;", "(Lcom/stripe/android/core/networking/StripeRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeRequestForFile", "Ljava/io/File;", "outputFile", "(Lcom/stripe/android/core/networking/StripeRequest;Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "makeRequest", "makeRequestForFile", "parseResponse", "connection", "Lcom/stripe/android/core/networking/StripeConnection;", "baseUrl", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class DefaultStripeNetworkClient
implements StripeNetworkClient {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineContext workContext;
    @NotNull
    private final ConnectionFactory connectionFactory;
    @NotNull
    private final RetryDelaySupplier retryDelaySupplier;
    private final int maxRetries;
    @NotNull
    private final Logger logger;
    @Deprecated
    private static final int DEFAULT_MAX_RETRIES = 3;

    @JvmOverloads
    public DefaultStripeNetworkClient(@NotNull CoroutineContext workContext, @NotNull ConnectionFactory connectionFactory, @NotNull RetryDelaySupplier retryDelaySupplier, int maxRetries, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter((Object)retryDelaySupplier, (String)"retryDelaySupplier");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.workContext = workContext;
        this.connectionFactory = connectionFactory;
        this.retryDelaySupplier = retryDelaySupplier;
        this.maxRetries = maxRetries;
        this.logger = logger;
    }

    public /* synthetic */ DefaultStripeNetworkClient(CoroutineContext coroutineContext, ConnectionFactory connectionFactory, RetryDelaySupplier retryDelaySupplier, int n, Logger logger, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getIO();
        }
        if ((n2 & 2) != 0) {
            connectionFactory = ConnectionFactory.Default.INSTANCE;
        }
        if ((n2 & 4) != 0) {
            retryDelaySupplier = new RetryDelaySupplier();
        }
        if ((n2 & 8) != 0) {
            n = 3;
        }
        if ((n2 & 0x10) != 0) {
            logger = Logger.Companion.noop();
        }
        this(coroutineContext, connectionFactory, retryDelaySupplier, n, logger);
    }

    @Override
    @Nullable
    public Object executeRequest(@NotNull StripeRequest request, @NotNull Continuation<? super StripeResponse<String>> $completion) {
        return this.executeInternal$stripe_core_release(this.maxRetries, request.getRetryResponseCodes(), (Function0)new Function0<StripeResponse<String>>(this, request){
            final /* synthetic */ DefaultStripeNetworkClient this$0;
            final /* synthetic */ StripeRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(0);
            }

            @NotNull
            public final StripeResponse<String> invoke() {
                return DefaultStripeNetworkClient.access$makeRequest(this.this$0, this.$request);
            }
        }, $completion);
    }

    @Override
    @Nullable
    public Object executeRequestForFile(@NotNull StripeRequest request, @NotNull File outputFile, @NotNull Continuation<? super StripeResponse<File>> $completion) {
        return this.executeInternal$stripe_core_release(this.maxRetries, request.getRetryResponseCodes(), (Function0)new Function0<StripeResponse<File>>(this, request, outputFile){
            final /* synthetic */ DefaultStripeNetworkClient this$0;
            final /* synthetic */ StripeRequest $request;
            final /* synthetic */ File $outputFile;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$outputFile = $outputFile;
                super(0);
            }

            @NotNull
            public final StripeResponse<File> invoke() {
                return DefaultStripeNetworkClient.access$makeRequestForFile(this.this$0, this.$request, this.$outputFile);
            }
        }, $completion);
    }

    @VisibleForTesting
    @Nullable
    public final <BodyType> Object executeInternal$stripe_core_release(int remainingRetries, @NotNull Iterable<Integer> retryResponseCodes, @NotNull Function0<StripeResponse<BodyType>> requester, @NotNull Continuation<? super StripeResponse<BodyType>> $completion) {
        return BuildersKt.withContext((CoroutineContext)this.workContext, (Function2)new Function2<CoroutineScope, Continuation<? super StripeResponse<BodyType>>, Object>(requester, retryResponseCodes, remainingRetries, this, null){
            int label;
            final /* synthetic */ Function0<StripeResponse<BodyType>> $requester;
            final /* synthetic */ Iterable<Integer> $retryResponseCodes;
            final /* synthetic */ int $remainingRetries;
            final /* synthetic */ DefaultStripeNetworkClient this$0;
            {
                this.$requester = $requester;
                this.$retryResponseCodes = $retryResponseCodes;
                this.$remainingRetries = $remainingRetries;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block7: {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            stripeResponse = (StripeResponse)this.$requester.invoke();
                            if (!CollectionsKt.contains(this.$retryResponseCodes, (Object)Boxing.boxInt((int)stripeResponse.getCode())) || this.$remainingRetries <= 0) break;
                            DefaultStripeNetworkClient.access$getLogger$p(this.this$0).info("Request failed with code " + stripeResponse.getCode() + ". Retrying up to " + this.$remainingRetries + " more time(s).");
                            this.label = 1;
                            v0 = DelayKt.delay((long)DefaultStripeNetworkClient.access$getRetryDelaySupplier$p(this.this$0).getDelayMillis(3, this.$remainingRetries), (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            this.label = 2;
                            v1 = this.this$0.executeInternal$stripe_core_release(this.$remainingRetries - 1, this.$retryResponseCodes, this.$requester, (Continuation)this);
                            if (v1 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl24
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl24:
                            // 2 sources

                            v2 = (StripeResponse)v1;
                            break block7;
                        }
                    }
                    v2 = var2_3;
                }
                return v2;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super StripeResponse<BodyType>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final StripeResponse<String> makeRequest(StripeRequest request) {
        return this.parseResponse(this.connectionFactory.create(request), request.getUrl());
    }

    private final StripeResponse<File> makeRequestForFile(StripeRequest request, File outputFile) {
        return this.parseResponse(this.connectionFactory.createForFile(request, outputFile), request.getUrl());
    }

    private final <BodyType> StripeResponse<BodyType> parseResponse(StripeConnection<BodyType> connection, String baseUrl) {
        Object object;
        Object object2 = this;
        try {
            DefaultStripeNetworkClient $this$parseResponse_u24lambda_u2d0 = object2;
            boolean bl = false;
            StripeResponse<BodyType> stripeResponse = connection.getResponse();
            $this$parseResponse_u24lambda_u2d0.logger.info(stripeResponse.toString());
            object = Result.constructor-impl(stripeResponse);
        }
        catch (Throwable $this$parseResponse_u24lambda_u2d0) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$parseResponse_u24lambda_u2d0));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable error = throwable;
            boolean bl = false;
            this.logger.error("Exception while making Stripe API request", error);
            throw error instanceof IOException ? (Throwable)APIConnectionException.Companion.create((IOException)error, baseUrl) : error;
        }
        return (StripeResponse)object2;
    }

    @JvmOverloads
    public DefaultStripeNetworkClient(@NotNull CoroutineContext workContext, @NotNull ConnectionFactory connectionFactory, @NotNull RetryDelaySupplier retryDelaySupplier, int maxRetries) {
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter((Object)retryDelaySupplier, (String)"retryDelaySupplier");
        this(workContext, connectionFactory, retryDelaySupplier, maxRetries, null, 16, null);
    }

    @JvmOverloads
    public DefaultStripeNetworkClient(@NotNull CoroutineContext workContext, @NotNull ConnectionFactory connectionFactory, @NotNull RetryDelaySupplier retryDelaySupplier) {
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter((Object)retryDelaySupplier, (String)"retryDelaySupplier");
        this(workContext, connectionFactory, retryDelaySupplier, 0, null, 24, null);
    }

    @JvmOverloads
    public DefaultStripeNetworkClient(@NotNull CoroutineContext workContext, @NotNull ConnectionFactory connectionFactory) {
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        this(workContext, connectionFactory, null, 0, null, 28, null);
    }

    @JvmOverloads
    public DefaultStripeNetworkClient(@NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this(workContext, null, null, 0, null, 30, null);
    }

    @JvmOverloads
    public DefaultStripeNetworkClient() {
        this(null, null, null, 0, null, 31, null);
    }

    public static final /* synthetic */ StripeResponse access$makeRequest(DefaultStripeNetworkClient $this, StripeRequest request) {
        return $this.makeRequest(request);
    }

    public static final /* synthetic */ StripeResponse access$makeRequestForFile(DefaultStripeNetworkClient $this, StripeRequest request, File outputFile) {
        return $this.makeRequestForFile(request, outputFile);
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultStripeNetworkClient $this) {
        return $this.logger;
    }

    public static final /* synthetic */ RetryDelaySupplier access$getRetryDelaySupplier$p(DefaultStripeNetworkClient $this) {
        return $this.retryDelaySupplier;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/core/networking/DefaultStripeNetworkClient$Companion;", "", "()V", "DEFAULT_MAX_RETRIES", "", "stripe-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

