/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.core.networking.AnalyticsRequestV2;
import com.stripe.android.core.networking.AnalyticsRequestV2$;
import com.stripe.android.core.networking.AnalyticsRequestV2Kt;
import com.stripe.android.core.networking.JsonUtilsKt;
import com.stripe.android.core.networking.QueryStringFactory;
import com.stripe.android.core.networking.StripeRequest;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 N2\u00020\u0001:\u0003MNOB\u0099\u0001\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0014\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018B/\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020/0\u000eH\u0002J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\t\u00101\u001a\u00020\u0005H\u00c2\u0003J\t\u00102\u001a\u00020\u0005H\u00c2\u0003J\t\u00103\u001a\u00020\tH\u00c2\u0003J\t\u00104\u001a\u00020\u000bH\u00c6\u0003J;\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\b\u00106\u001a\u00020\u0005H\u0002J\u001a\u00107\u001a\f\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u00030\u000e2\u0006\u00108\u001a\u00020\u0003H\u0002J\"\u00109\u001a\u00020\u00052\u000e\u0010:\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e2\b\b\u0002\u0010;\u001a\u00020\u0003H\u0002J\u0013\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u0010?\u001a\u00020\u0003H\u00d6\u0001J\t\u0010@\u001a\u00020\u0005H\u00d6\u0001J\u000e\u0010A\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0003J&\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u00c1\u0001\u00a2\u0006\u0002\bIJ\u0010\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020LH\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00020\u000b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001c\u0010\f\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b(\u0010)\u001a\u0004\b*\u0010\u001bR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010\u0015\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001b\u00a8\u0006P"}, d2={"Lcom/stripe/android/core/networking/AnalyticsRequestV2;", "Lcom/stripe/android/core/networking/StripeRequest;", "seen1", "", "eventName", "", "clientId", "origin", "created", "", "params", "Lkotlinx/serialization/json/JsonElement;", "postParameters", "headers", "", "method", "Lcom/stripe/android/core/networking/StripeRequest$Method;", "mimeType", "Lcom/stripe/android/core/networking/StripeRequest$MimeType;", "retryResponseCodes", "", "url", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;DLkotlinx/serialization/json/JsonElement;Ljava/lang/String;Ljava/util/Map;Lcom/stripe/android/core/networking/StripeRequest$Method;Lcom/stripe/android/core/networking/StripeRequest$MimeType;Ljava/lang/Iterable;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;DLkotlinx/serialization/json/JsonElement;)V", "getEventName", "()Ljava/lang/String;", "getHeaders", "()Ljava/util/Map;", "getMethod", "()Lcom/stripe/android/core/networking/StripeRequest$Method;", "getMimeType", "()Lcom/stripe/android/core/networking/StripeRequest$MimeType;", "getParams", "()Lkotlinx/serialization/json/JsonElement;", "postBodyBytes", "", "getPostBodyBytes", "()[B", "getPostParameters$stripe_core_release$annotations", "()V", "getPostParameters$stripe_core_release", "getRetryResponseCodes", "()Ljava/lang/Iterable;", "getUrl", "analyticParams", "", "component1", "component2", "component3", "component4", "component5", "copy", "createPostParams", "createWorkManagerParams", "runAttemptCount", "encodeMapParam", "map", "level", "equals", "", "other", "hashCode", "toString", "withWorkManagerParams", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$stripe_core_release", "writePostBody", "outputStream", "Ljava/io/OutputStream;", "$serializer", "Companion", "Parameter", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nAnalyticsRequestV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsRequestV2.kt\ncom/stripe/android/core/networking/AnalyticsRequestV2\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,251:1\n215#2,2:252\n215#2,2:254\n*S KotlinDebug\n*F\n+ 1 AnalyticsRequestV2.kt\ncom/stripe/android/core/networking/AnalyticsRequestV2\n*L\n95#1:252,2\n116#1:254,2\n*E\n"})
public final class AnalyticsRequestV2
extends StripeRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String eventName;
    @NotNull
    private final String clientId;
    @NotNull
    private final String origin;
    private final double created;
    @NotNull
    private final JsonElement params;
    @NotNull
    private final String postParameters;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final StripeRequest.Method method;
    @NotNull
    private final StripeRequest.MimeType mimeType;
    @NotNull
    private final Iterable<Integer> retryResponseCodes;
    @NotNull
    private final String url;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;
    @NotNull
    public static final String ANALYTICS_HOST = "https://r.stripe.com/0";
    @NotNull
    public static final String HEADER_ORIGIN = "origin";
    @NotNull
    public static final String PARAM_CLIENT_ID = "client_id";
    @NotNull
    public static final String PARAM_CREATED = "created";
    @NotNull
    public static final String PARAM_EVENT_NAME = "event_name";
    @NotNull
    public static final String PARAM_EVENT_ID = "event_id";
    @NotNull
    private static final String PARAM_USES_WORK_MANAGER = "uses_work_manager";
    @NotNull
    private static final String PARAM_IS_RETRY = "is_retry";
    @NotNull
    private static final String PARAM_DELAYED = "delayed";
    @NotNull
    private static final String INDENTATION = "  ";

    private AnalyticsRequestV2(String eventName, String clientId, String origin, double created, JsonElement params) {
        this.eventName = eventName;
        this.clientId = clientId;
        this.origin = origin;
        this.created = created;
        this.params = params;
        this.postParameters = this.createPostParams();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)(StripeRequest.MimeType.Form.getCode() + "; charset=" + Charsets.UTF_8.name())), TuplesKt.to((Object)HEADER_ORIGIN, (Object)this.origin), TuplesKt.to((Object)"User-Agent", (Object)"Stripe/v1 android/20.48.6")};
        this.headers = MapsKt.mapOf((Pair[])pairArray);
        this.method = StripeRequest.Method.POST;
        this.mimeType = StripeRequest.MimeType.Form;
        this.retryResponseCodes = (Iterable)new IntRange(429, 429);
        this.url = ANALYTICS_HOST;
    }

    @VisibleForTesting
    @NotNull
    public final String getEventName() {
        return this.eventName;
    }

    @VisibleForTesting
    @NotNull
    public final JsonElement getParams() {
        return this.params;
    }

    @NotNull
    public final String getPostParameters$stripe_core_release() {
        return this.postParameters;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPostParameters$stripe_core_release$annotations() {
    }

    private final byte[] getPostBodyBytes() throws UnsupportedEncodingException {
        byte[] byArray = this.postParameters.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    private final String createPostParams() {
        Map postParams = MapsKt.plus(JsonUtilsKt.toMap(this.params), this.analyticParams());
        List paramList = new ArrayList();
        Map<String, Object> $this$forEach$iv = QueryStringFactory.INSTANCE.compactParams(postParams);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> element$iv;
            Map.Entry<String, Object> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                paramList.add(new Parameter(key, AnalyticsRequestV2.encodeMapParam$default(this, (Map)value, 0, 2, null)));
                continue;
            }
            paramList.add(new Parameter(key, value.toString()));
        }
        return CollectionsKt.joinToString$default((Iterable)paramList, (CharSequence)"&", null, null, (int)0, null, (Function1)createPostParams.2.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String encodeMapParam(Map<?, ?> map, int level) {
        void $this$forEach$iv;
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = false;
        first = true;
        StringBuilder stringBuilder2 = stringBuilder.append("{");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        Map map2 = MapsKt.toSortedMap(map, AnalyticsRequestV2::encodeMapParam$lambda$1);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object v = value;
            Object encodedValue = v instanceof Map ? this.encodeMapParam((Map)value, level + 1) : (v == null ? "" : "\"" + value + "\"");
            if (!(!StringsKt.isBlank((CharSequence)((CharSequence)encodedValue)))) continue;
            if (first) {
                stringBuilder.append(StringsKt.repeat((CharSequence)INDENTATION, (int)level)).append("  \"" + key + "\": " + (String)encodedValue);
                first = false;
                continue;
            }
            StringBuilder stringBuilder3 = stringBuilder.append(",");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            StringBuilder stringBuilder4 = stringBuilder3.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            stringBuilder4.append(StringsKt.repeat((CharSequence)INDENTATION, (int)level)).append("  \"" + key + "\": " + (String)encodedValue);
        }
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        stringBuilder.append(StringsKt.repeat((CharSequence)INDENTATION, (int)level)).append("}");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String encodeMapParam$default(AnalyticsRequestV2 analyticsRequestV2, Map map, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return analyticsRequestV2.encodeMapParam(map, n);
    }

    private final Map<String, Object> analyticParams() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PARAM_CLIENT_ID, (Object)this.clientId), TuplesKt.to((Object)PARAM_CREATED, (Object)this.created), TuplesKt.to((Object)PARAM_EVENT_NAME, (Object)this.eventName), TuplesKt.to((Object)PARAM_EVENT_ID, (Object)UUID.randomUUID().toString())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public void writePostBody(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        byte[] it = this.getPostBodyBytes();
        boolean bl = false;
        outputStream.write(it);
        outputStream.flush();
    }

    @Override
    @NotNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    @NotNull
    public StripeRequest.Method getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public StripeRequest.MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    @NotNull
    public Iterable<Integer> getRetryResponseCodes() {
        return this.retryResponseCodes;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @NotNull
    public final AnalyticsRequestV2 withWorkManagerParams(int runAttemptCount) {
        Map updatedParams = MapsKt.plus(JsonUtilsKt.toMap(this.params), this.createWorkManagerParams(runAttemptCount));
        return AnalyticsRequestV2.copy$default(this, null, null, null, 0.0, AnalyticsRequestV2Kt.access$toJsonElement(updatedParams), 15, null);
    }

    private final Map<String, ?> createWorkManagerParams(int runAttemptCount) {
        double currentTimeInSeconds = Duration.toDouble-impl((long)DurationKt.toDuration((long)System.currentTimeMillis(), (DurationUnit)DurationUnit.MILLISECONDS), (DurationUnit)DurationUnit.SECONDS);
        boolean wasDelayed = currentTimeInSeconds - this.created > 5.0;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PARAM_USES_WORK_MANAGER, (Object)true), TuplesKt.to((Object)PARAM_IS_RETRY, (Object)(runAttemptCount > 0 ? 1 : 0)), TuplesKt.to((Object)PARAM_DELAYED, (Object)wasDelayed)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final String component1() {
        return this.eventName;
    }

    private final String component2() {
        return this.clientId;
    }

    private final String component3() {
        return this.origin;
    }

    private final double component4() {
        return this.created;
    }

    @NotNull
    public final JsonElement component5() {
        return this.params;
    }

    @NotNull
    public final AnalyticsRequestV2 copy(@NotNull String eventName, @NotNull String clientId, @NotNull String origin, double created, @NotNull JsonElement params) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)origin, (String)HEADER_ORIGIN);
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return new AnalyticsRequestV2(eventName, clientId, origin, created, params);
    }

    public static /* synthetic */ AnalyticsRequestV2 copy$default(AnalyticsRequestV2 analyticsRequestV2, String string, String string2, String string3, double d, JsonElement jsonElement, int n, Object object) {
        if ((n & 1) != 0) {
            string = analyticsRequestV2.eventName;
        }
        if ((n & 2) != 0) {
            string2 = analyticsRequestV2.clientId;
        }
        if ((n & 4) != 0) {
            string3 = analyticsRequestV2.origin;
        }
        if ((n & 8) != 0) {
            d = analyticsRequestV2.created;
        }
        if ((n & 0x10) != 0) {
            jsonElement = analyticsRequestV2.params;
        }
        return analyticsRequestV2.copy(string, string2, string3, d, jsonElement);
    }

    @NotNull
    public String toString() {
        return "AnalyticsRequestV2(eventName=" + this.eventName + ", clientId=" + this.clientId + ", origin=" + this.origin + ", created=" + this.created + ", params=" + this.params + ")";
    }

    public int hashCode() {
        int result = this.eventName.hashCode();
        result = result * 31 + this.clientId.hashCode();
        result = result * 31 + this.origin.hashCode();
        result = result * 31 + Double.hashCode(this.created);
        result = result * 31 + this.params.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnalyticsRequestV2)) {
            return false;
        }
        AnalyticsRequestV2 analyticsRequestV2 = (AnalyticsRequestV2)other;
        if (!Intrinsics.areEqual((Object)this.eventName, (Object)analyticsRequestV2.eventName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clientId, (Object)analyticsRequestV2.clientId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.origin, (Object)analyticsRequestV2.origin)) {
            return false;
        }
        if (Double.compare(this.created, analyticsRequestV2.created) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.params, (Object)analyticsRequestV2.params);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$stripe_core_release(AnalyticsRequestV2 self, CompositeEncoder output, SerialDescriptor serialDesc) {
        boolean bl;
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeStringElement(serialDesc, 0, self.eventName);
        output.encodeStringElement(serialDesc, 1, self.clientId);
        output.encodeStringElement(serialDesc, 2, self.origin);
        output.encodeDoubleElement(serialDesc, 3, self.created);
        output.encodeSerializableElement(serialDesc, 4, (SerializationStrategy)JsonElementSerializer.INSTANCE, (Object)self.params);
        if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : !Intrinsics.areEqual((Object)self.postParameters, (Object)self.createPostParams())) {
            output.encodeStringElement(serialDesc, 5, self.postParameters);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 6)) {
            bl = true;
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)(StripeRequest.MimeType.Form.getCode() + "; charset=" + Charsets.UTF_8.name())), TuplesKt.to((Object)HEADER_ORIGIN, (Object)self.origin), TuplesKt.to((Object)"User-Agent", (Object)"Stripe/v1 android/20.48.6")};
            bl = !Intrinsics.areEqual(self.getHeaders(), (Object)MapsKt.mapOf((Pair[])pairArray));
        }
        if (bl) {
            output.encodeSerializableElement(serialDesc, 6, (SerializationStrategy)kSerializerArray[6], self.getHeaders());
        }
        if (output.shouldEncodeElementDefault(serialDesc, 7) ? true : self.getMethod() != StripeRequest.Method.POST) {
            output.encodeSerializableElement(serialDesc, 7, (SerializationStrategy)kSerializerArray[7], (Object)self.getMethod());
        }
        if (output.shouldEncodeElementDefault(serialDesc, 8) ? true : self.getMimeType() != StripeRequest.MimeType.Form) {
            output.encodeSerializableElement(serialDesc, 8, (SerializationStrategy)kSerializerArray[8], (Object)self.getMimeType());
        }
        if (output.shouldEncodeElementDefault(serialDesc, 9) ? true : !Intrinsics.areEqual(self.getRetryResponseCodes(), (Object)new IntRange(429, 429))) {
            output.encodeSerializableElement(serialDesc, 9, (SerializationStrategy)kSerializerArray[9], self.getRetryResponseCodes());
        }
        if (output.shouldEncodeElementDefault(serialDesc, 10) ? true : !Intrinsics.areEqual((Object)self.getUrl(), (Object)ANALYTICS_HOST)) {
            output.encodeStringElement(serialDesc, 10, self.getUrl());
        }
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ AnalyticsRequestV2(int seen1, String eventName, String clientId, String origin, double created, JsonElement params, @VisibleForTesting String postParameters, Map headers, StripeRequest.Method method, StripeRequest.MimeType mimeType, Iterable retryResponseCodes, String url, SerializationConstructorMarker serializationConstructorMarker) {
        if (31 != (0x1F & seen1)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)31, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.eventName = eventName;
        this.clientId = clientId;
        this.origin = origin;
        this.created = created;
        this.params = params;
        this.postParameters = (seen1 & 0x20) == 0 ? this.createPostParams() : postParameters;
        if ((seen1 & 0x40) == 0) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)(StripeRequest.MimeType.Form.getCode() + "; charset=" + Charsets.UTF_8.name())), TuplesKt.to((Object)HEADER_ORIGIN, (Object)this.origin), TuplesKt.to((Object)"User-Agent", (Object)"Stripe/v1 android/20.48.6")};
            this.headers = MapsKt.mapOf((Pair[])pairArray);
        } else {
            this.headers = headers;
        }
        this.method = (seen1 & 0x80) == 0 ? StripeRequest.Method.POST : method;
        this.mimeType = (seen1 & 0x100) == 0 ? StripeRequest.MimeType.Form : mimeType;
        this.retryResponseCodes = (seen1 & 0x200) == 0 ? (Iterable)new IntRange(429, 429) : retryResponseCodes;
        this.url = (seen1 & 0x400) == 0 ? ANALYTICS_HOST : url;
    }

    private static final int encodeMapParam$lambda$1(Object key1, Object key2) {
        return String.valueOf(key1).compareTo(String.valueOf(key2));
    }

    public /* synthetic */ AnalyticsRequestV2(String eventName, String clientId, String origin, double created, JsonElement params, DefaultConstructorMarker $constructor_marker) {
        this(eventName, clientId, origin, created, params);
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{null, null, null, null, null, null, new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE), EnumsKt.createSimpleEnumSerializer((String)"com.stripe.android.core.networking.StripeRequest.Method", (Enum[])StripeRequest.Method.values()), EnumsKt.createSimpleEnumSerializer((String)"com.stripe.android.core.networking.StripeRequest.MimeType", (Enum[])StripeRequest.MimeType.values()), new PolymorphicSerializer(Reflection.getOrCreateKotlinClass(Iterable.class), new Annotation[0]), null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0010\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u0014J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u00c6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/core/networking/AnalyticsRequestV2$Companion;", "", "()V", "ANALYTICS_HOST", "", "HEADER_ORIGIN", "INDENTATION", "PARAM_CLIENT_ID", "PARAM_CREATED", "PARAM_DELAYED", "PARAM_EVENT_ID", "PARAM_EVENT_NAME", "PARAM_IS_RETRY", "PARAM_USES_WORK_MANAGER", "create", "Lcom/stripe/android/core/networking/AnalyticsRequestV2;", "eventName", "clientId", "origin", "params", "", "serializer", "Lkotlinx/serialization/KSerializer;", "stripe-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnalyticsRequestV2 create(@NotNull String eventName, @NotNull String clientId, @NotNull String origin, @NotNull Map<String, ?> params) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)origin, (String)AnalyticsRequestV2.HEADER_ORIGIN);
            Intrinsics.checkNotNullParameter(params, (String)"params");
            Map initialParams = MapsKt.plus(params, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)AnalyticsRequestV2.PARAM_USES_WORK_MANAGER, (Object)false)));
            return new AnalyticsRequestV2(eventName, clientId, origin, Duration.toDouble-impl((long)DurationKt.toDuration((long)System.currentTimeMillis(), (DurationUnit)DurationUnit.MILLISECONDS), (DurationUnit)DurationUnit.SECONDS), AnalyticsRequestV2Kt.access$toJsonElement(initialParams), null);
        }

        @NotNull
        public final KSerializer<AnalyticsRequestV2> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0006\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\u001d\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/core/networking/AnalyticsRequestV2$Parameter;", "", "key", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "urlEncode", "str", "stripe-core_release"})
    private static final class Parameter {
        @NotNull
        private final String key;
        @NotNull
        private final String value;

        public Parameter(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.key = key;
            this.value = value;
        }

        @NotNull
        public String toString() {
            String encodedKey = this.urlEncode(this.key);
            String encodedValue = this.urlEncode(this.value);
            return encodedKey + "=" + encodedValue;
        }

        private final String urlEncode(String str) throws UnsupportedEncodingException {
            String string = URLEncoder.encode(str, Charsets.UTF_8.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
            return string;
        }

        private final String component1() {
            return this.key;
        }

        private final String component2() {
            return this.value;
        }

        @NotNull
        public final Parameter copy(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Parameter(key, value);
        }

        public static /* synthetic */ Parameter copy$default(Parameter parameter, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = parameter.key;
            }
            if ((n & 2) != 0) {
                string2 = parameter.value;
            }
            return parameter.copy(string, string2);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = result * 31 + this.value.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parameter)) {
                return false;
            }
            Parameter parameter = (Parameter)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)parameter.key)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)parameter.value);
        }
    }
}

