/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import androidx.annotation.RestrictTo;
import com.stripe.android.core.networking.AnalyticsRequestV2;
import com.stripe.android.core.utils.ContextUtils;
import com.stripe.android.core.utils.PluginDetector;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000fH\u0002R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/core/networking/AnalyticsRequestV2Factory;", "", "context", "Landroid/content/Context;", "clientId", "", "origin", "pluginType", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "appContext", "kotlin.jvm.PlatformType", "createRequest", "Lcom/stripe/android/core/networking/AnalyticsRequestV2;", "eventName", "additionalParams", "", "includeSDKParams", "", "getAppName", "", "sdkParams", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class AnalyticsRequestV2Factory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String clientId;
    @NotNull
    private final String origin;
    @NotNull
    private final String pluginType;
    private final Context appContext;
    @NotNull
    public static final String PLUGIN_NATIVE = "native";
    @NotNull
    public static final String PARAM_SDK_PLATFORM = "sdk_platform";
    @NotNull
    public static final String PARAM_SDK_VERSION = "sdk_version";
    @NotNull
    public static final String PARAM_PLUGIN_TYPE = "plugin_type";
    @NotNull
    public static final String PARAM_PLATFORM_INFO = "platform_info";
    @NotNull
    public static final String PARAM_PACKAGE_NAME = "package_name";

    public AnalyticsRequestV2Factory(@NotNull Context context, @NotNull String clientId, @NotNull String origin, @NotNull String pluginType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pluginType, (String)"pluginType");
        this.clientId = clientId;
        this.origin = origin;
        this.pluginType = pluginType;
        this.appContext = context.getApplicationContext();
    }

    public /* synthetic */ AnalyticsRequestV2Factory(Context context, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            String string4 = PluginDetector.INSTANCE.getPluginType();
            if (string4 == null) {
                string4 = PLUGIN_NATIVE;
            }
            string3 = string4;
        }
        this(context, string, string2, string3);
    }

    @NotNull
    public final AnalyticsRequestV2 createRequest(@NotNull String eventName, @NotNull Map<String, ? extends Object> additionalParams, boolean includeSDKParams) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter(additionalParams, (String)"additionalParams");
        return AnalyticsRequestV2.Companion.create(eventName, this.clientId, this.origin, includeSDKParams ? MapsKt.plus(additionalParams, this.sdkParams()) : additionalParams);
    }

    public static /* synthetic */ AnalyticsRequestV2 createRequest$default(AnalyticsRequestV2Factory analyticsRequestV2Factory, String string, Map map, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return analyticsRequestV2Factory.createRequest(string, map, bl);
    }

    private final Map<String, Object> sdkParams() {
        Pair[] pairArray = new Pair[8];
        pairArray[0] = TuplesKt.to((Object)"os_version", (Object)Build.VERSION.SDK_INT);
        pairArray[1] = TuplesKt.to((Object)PARAM_SDK_PLATFORM, (Object)"android");
        pairArray[2] = TuplesKt.to((Object)PARAM_SDK_VERSION, (Object)"20.48.6");
        pairArray[3] = TuplesKt.to((Object)"device_type", (Object)(Build.MANUFACTURER + "_" + Build.BRAND + "_" + Build.MODEL));
        pairArray[4] = TuplesKt.to((Object)"app_name", (Object)this.getAppName());
        Context context = this.appContext;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
        PackageInfo packageInfo = ContextUtils.INSTANCE.getPackageInfo(context);
        pairArray[5] = TuplesKt.to((Object)"app_version", (Object)(packageInfo != null ? Integer.valueOf(packageInfo.versionCode) : null));
        pairArray[6] = TuplesKt.to((Object)PARAM_PLUGIN_TYPE, (Object)this.pluginType);
        pairArray[7] = TuplesKt.to((Object)PARAM_PLATFORM_INFO, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_PACKAGE_NAME, (Object)this.appContext.getPackageName())));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final CharSequence getAppName() {
        CharSequence charSequence;
        CharSequence charSequence2;
        CharSequence charSequence3;
        Context context = this.appContext;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
        PackageInfo packageInfo = ContextUtils.INSTANCE.getPackageInfo(context);
        CharSequence it = charSequence3 = packageInfo != null && (packageInfo = packageInfo.applicationInfo) != null ? packageInfo.loadLabel(this.appContext.getPackageManager()) : null;
        boolean bl = false;
        CharSequence charSequence4 = it;
        CharSequence charSequence5 = charSequence2 = !(charSequence4 == null || StringsKt.isBlank((CharSequence)charSequence4)) ? charSequence3 : null;
        if (charSequence2 == null) {
            String string = this.appContext.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
            charSequence = string;
        } else {
            charSequence = charSequence2;
        }
        return charSequence;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/core/networking/AnalyticsRequestV2Factory$Companion;", "", "()V", "PARAM_PACKAGE_NAME", "", "PARAM_PLATFORM_INFO", "PARAM_PLUGIN_TYPE", "PARAM_SDK_PLATFORM", "PARAM_SDK_VERSION", "PLUGIN_NATIVE", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

