/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.strings.transformations;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import com.stripe.android.core.strings.transformations.TransformOperation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0006\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\u001d\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0019\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/core/strings/transformations/Replace;", "Lcom/stripe/android/core/strings/transformations/TransformOperation;", "original", "", "replacement", "(Ljava/lang/String;Ljava/lang/String;)V", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "transform", "value", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@Parcelize
public final class Replace
implements TransformOperation {
    @NotNull
    private final String original;
    @NotNull
    private final String replacement;
    @NotNull
    public static final Parcelable.Creator<Replace> CREATOR;

    public Replace(@NotNull String original, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        this.original = original;
        this.replacement = replacement;
    }

    @Override
    @NotNull
    public String transform(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return StringsKt.replace$default((String)value, (String)this.original, (String)this.replacement, (boolean)false, (int)4, null);
    }

    private final String component1() {
        return this.original;
    }

    private final String component2() {
        return this.replacement;
    }

    @NotNull
    public final Replace copy(@NotNull String original, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        return new Replace(original, replacement);
    }

    public static /* synthetic */ Replace copy$default(Replace replace, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = replace.original;
        }
        if ((n & 2) != 0) {
            string2 = replace.replacement;
        }
        return replace.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "Replace(original=" + this.original + ", replacement=" + this.replacement + ")";
    }

    public int hashCode() {
        int result = this.original.hashCode();
        result = result * 31 + this.replacement.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Replace)) {
            return false;
        }
        Replace replace = (Replace)other;
        if (!Intrinsics.areEqual((Object)this.original, (Object)replace.original)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.replacement, (Object)replace.replacement);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.original);
        out.writeString(this.replacement);
    }

    static {
        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<Replace> {
            @NotNull
            public final Replace[] newArray(int size) {
                return new Replace[size];
            }

            @NotNull
            public final Replace createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new Replace(parcel.readString(), parcel.readString());
            }
        }
        CREATOR = new Creator();
    }
}

