/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.exception;

import androidx.annotation.RestrictTo;
import com.stripe.android.core.StripeError;
import com.stripe.android.core.exception.APIConnectionException;
import com.stripe.android.core.exception.APIException;
import com.stripe.android.core.exception.GenericStripeException;
import com.stripe.android.core.exception.InvalidRequestException;
import java.io.IOException;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\b&\u0018\u0000 \u001f2\u00060\u0001j\u0002`\u0002:\u0001\u001fBA\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0017\u001a\u00020\u0006H\u0017J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\u0013\u0010\u0019\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0000H\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/stripe/android/core/exception/StripeException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "stripeError", "Lcom/stripe/android/core/StripeError;", "requestId", "", "statusCode", "", "cause", "", "message", "<init>", "(Lcom/stripe/android/core/StripeError;Ljava/lang/String;ILjava/lang/Throwable;Ljava/lang/String;)V", "getStripeError", "()Lcom/stripe/android/core/StripeError;", "getRequestId", "()Ljava/lang/String;", "getStatusCode", "()I", "isClientError", "", "()Z", "analyticsValue", "toString", "equals", "other", "", "hashCode", "typedEquals", "ex", "Companion", "stripe-core_release"})
@SourceDebugExtension(value={"SMAP\nStripeException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StripeException.kt\ncom/stripe/android/core/exception/StripeException\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public abstract class StripeException
extends Exception {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final StripeError stripeError;
    @Nullable
    private final String requestId;
    private final int statusCode;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private final boolean isClientError;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int DEFAULT_STATUS_CODE = 0;

    public StripeException(@Nullable StripeError stripeError, @Nullable String requestId, int statusCode, @Nullable Throwable cause, @Nullable String message) {
        super(message, cause);
        this.stripeError = stripeError;
        this.requestId = requestId;
        int n = this.statusCode = statusCode;
        this.isClientError = 400 <= n ? n < 500 : false;
    }

    public /* synthetic */ StripeException(StripeError stripeError, String string, int n, Throwable throwable, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            stripeError = null;
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            throwable = null;
        }
        if ((n2 & 0x10) != 0) {
            StripeError stripeError2 = stripeError;
            string2 = stripeError2 != null ? stripeError2.getMessage() : null;
        }
        this(stripeError, string, n, throwable, string2);
    }

    @Nullable
    public final StripeError getStripeError() {
        return this.stripeError;
    }

    @Nullable
    public final String getRequestId() {
        return this.requestId;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final boolean isClientError() {
        return this.isClientError;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public String analyticsValue() {
        return "stripeException";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String toString() {
        String string;
        Object[] objectArray;
        Object[] objectArray2 = objectArray = new String[2];
        int n = 0;
        String string2 = this.requestId;
        if (string2 != null) {
            void it;
            String string3 = string2;
            int n2 = n;
            Object[] objectArray3 = objectArray2;
            boolean bl = false;
            String string4 = "Request-id: " + (String)it;
            objectArray2 = objectArray3;
            n = n2;
            string = string4;
        } else {
            string = null;
        }
        objectArray2[n] = string;
        objectArray[1] = super.toString();
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (other instanceof StripeException ? this.typedEquals((StripeException)other) : false);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.stripeError, this.requestId, this.statusCode, this.getMessage()};
        return Objects.hash(objectArray);
    }

    private final boolean typedEquals(StripeException ex) {
        return Intrinsics.areEqual((Object)this.stripeError, (Object)ex.stripeError) && Intrinsics.areEqual((Object)this.requestId, (Object)ex.requestId) && this.statusCode == ex.statusCode && Intrinsics.areEqual((Object)this.getMessage(), (Object)ex.getMessage());
    }

    public StripeException() {
        this(null, null, 0, null, null, 31, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/core/exception/StripeException$Companion;", "", "<init>", "()V", "DEFAULT_STATUS_CODE", "", "create", "Lcom/stripe/android/core/exception/StripeException;", "throwable", "", "analyticsValueForThrowable", "", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StripeException create(@NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            Throwable throwable2 = throwable;
            return throwable2 instanceof StripeException ? (StripeException)throwable : (throwable2 instanceof JSONException ? (StripeException)new APIException(throwable) : (throwable2 instanceof IOException ? (StripeException)APIConnectionException.Companion.create$default(APIConnectionException.Companion, (IOException)throwable, null, 2, null) : (throwable2 instanceof IllegalArgumentException ? (StripeException)new InvalidRequestException(null, null, 0, throwable.getMessage(), throwable, 7, null) : (StripeException)new GenericStripeException(throwable, this.analyticsValueForThrowable(throwable)))));
        }

        private final String analyticsValueForThrowable(Throwable throwable) {
            block3: {
                Class<?> throwableClass;
                block2: {
                    throwableClass = throwable.getClass();
                    String string = throwableClass.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (StringsKt.startsWith$default((String)string, (String)"android.", (boolean)false, (int)2, null)) break block2;
                    String string2 = throwableClass.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    if (!StringsKt.startsWith$default((String)string2, (String)"java.", (boolean)false, (int)2, null)) break block3;
                }
                return throwableClass.getName();
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

