/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.model;

import androidx.annotation.RestrictTo;
import com.stripe.android.core.model.Country;
import com.stripe.android.core.model.CountryCode;
import com.stripe.android.core.model.CountryCodeKt;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0006H\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/stripe/android/core/model/CountryUtils;", "", "<init>", "()V", "supportedBillingCountries", "", "", "getSupportedBillingCountries", "()Ljava/util/Set;", "CARD_POSTAL_CODE_COUNTRIES", "localizedCountries", "", "Lcom/stripe/android/core/model/Country;", "currentLocale", "Ljava/util/Locale;", "getDisplayCountry", "countryCode", "Lcom/stripe/android/core/model/CountryCode;", "getCountryCodeByName", "countryName", "getCountryByCode", "getOrderedCountries", "doesCountryUsePostalCode", "", "cachedCountriesLocale", "cachedOrderedLocalizedCountries", "getSortedLocalizedCountries", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nCountryUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CountryUtils.kt\ncom/stripe/android/core/model/CountryUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1557#2:120\n1628#2,3:121\n295#2,2:124\n295#2,2:126\n295#2,2:128\n827#2:130\n855#2,2:131\n*S KotlinDebug\n*F\n+ 1 CountryUtils.kt\ncom/stripe/android/core/model/CountryUtils\n*L\n38#1:120\n38#1:121,3\n53#1:124,2\n58#1:126,2\n104#1:128,2\n109#1:130\n109#1:131,2\n*E\n"})
public final class CountryUtils {
    @NotNull
    public static final CountryUtils INSTANCE = new CountryUtils();
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private static final Set<String> supportedBillingCountries;
    @NotNull
    private static final Set<String> CARD_POSTAL_CODE_COUNTRIES;
    @Nullable
    private static volatile Locale cachedCountriesLocale;
    @NotNull
    private static volatile List<Country> cachedOrderedLocalizedCountries;

    private CountryUtils() {
    }

    @NotNull
    public final Set<String> getSupportedBillingCountries() {
        return supportedBillingCountries;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Country> localizedCountries(Locale currentLocale) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = supportedBillingCountries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void code;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CountryCode countryCode = CountryCode.Companion.create((String)code);
            String string2 = new Locale("", (String)code).getDisplayCountry(currentLocale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayCountry(...)");
            collection.add(new Country(countryCode, string2));
        }
        return (List)destination$iv$iv;
    }

    public final /* synthetic */ String getDisplayCountry(CountryCode countryCode, Locale currentLocale) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
        Object object = this.getCountryByCode(countryCode, currentLocale);
        if (object == null || (object = ((Country)object).getName()) == null) {
            String string = new Locale("", countryCode.getValue()).getDisplayCountry(currentLocale);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayCountry(...)");
        }
        return object;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final /* synthetic */ CountryCode getCountryCodeByName(String countryName, Locale currentLocale) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)countryName, (String)"countryName");
            Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
            Iterable $this$firstOrNull$iv = this.getSortedLocalizedCountries(currentLocale);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Country it = (Country)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)countryName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Country country = v0;
        return country != null ? country.getCode() : null;
    }

    public final /* synthetic */ Country getCountryByCode(CountryCode countryCode, Locale currentLocale) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
            Iterable $this$firstOrNull$iv = this.getSortedLocalizedCountries(currentLocale);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Country it = (Country)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCode(), (Object)countryCode)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final /* synthetic */ List getOrderedCountries(Locale currentLocale) {
        Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
        return this.getSortedLocalizedCountries(currentLocale);
    }

    @Deprecated(message="Use with parameter CountryCode", replaceWith=@ReplaceWith(expression="CountryUtils.doesCountryUsePostalCode(CountryCode.create(countryCode))", imports={"com.stripe.android.model.CountryCode"}))
    public final /* synthetic */ boolean doesCountryUsePostalCode(String countryCode) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        String string = countryCode.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return CARD_POSTAL_CODE_COUNTRIES.contains(string);
    }

    public final /* synthetic */ boolean doesCountryUsePostalCode(CountryCode countryCode) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        return CARD_POSTAL_CODE_COUNTRIES.contains(countryCode.getValue());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Country> getSortedLocalizedCountries(Locale currentLocale) {
        List<Country> list;
        if (Intrinsics.areEqual((Object)currentLocale, (Object)cachedCountriesLocale)) {
            list = cachedOrderedLocalizedCountries;
        } else {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            Object v1;
            Iterable $this$firstOrNull$iv;
            Collator collator;
            List<Country> localizedCountries;
            block4: {
                localizedCountries = this.localizedCountries(currentLocale);
                collator = Collator.getInstance(currentLocale);
                $this$firstOrNull$iv = localizedCountries;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Country it = (Country)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getCode(), (Object)CountryCodeKt.getCountryCode(currentLocale))) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            $this$firstOrNull$iv = localizedCountries;
            Collection collection = CollectionsKt.listOfNotNull(v1);
            boolean $i$f$filterNot = false;
            Iterator iterator = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Country it = (Country)element$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getCode(), (Object)CountryCodeKt.getCountryCode(currentLocale))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            cachedOrderedLocalizedCountries = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (arg_0, arg_1) -> CountryUtils.getSortedLocalizedCountries$lambda$6((arg_0, arg_1) -> CountryUtils.getSortedLocalizedCountries$lambda$5(collator, arg_0, arg_1), arg_0, arg_1)));
            cachedCountriesLocale = currentLocale;
            list = cachedOrderedLocalizedCountries;
        }
        return list;
    }

    private static final int getSortedLocalizedCountries$lambda$5(Collator $collator, Country c1, Country c2) {
        return $collator.compare(c1.getName(), c2.getName());
    }

    private static final int getSortedLocalizedCountries$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    static {
        Object[] objectArray = new String[]{"AD", "AE", "AF", "AG", "AI", "AL", "AM", "AO", "AQ", "AR", "AT", "AU", "AW", "AX", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN", "BO", "BQ", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CV", "CW", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM", "IN", "IO", "IQ", "IS", "IT", "JE", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MF", "MG", "MK", "ML", "MM", "MN", "MO", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "SS", "ST", "SV", "SX", "SZ", "TA", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VN", "VU", "WF", "WS", "XK", "YE", "YT", "ZA", "ZM", "ZW"};
        supportedBillingCountries = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"US", "GB", "CA"};
        CARD_POSTAL_CODE_COUNTRIES = SetsKt.setOf((Object[])objectArray);
        cachedOrderedLocalizedCountries = CollectionsKt.emptyList();
    }
}

