/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.RestrictTo;
import com.stripe.android.core.networking.AnalyticsRequestV2;
import com.stripe.android.core.utils.ContextUtils;
import com.stripe.android.core.utils.PluginDetector;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011H\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/core/networking/AnalyticsRequestV2Factory;", "", "context", "Landroid/content/Context;", "clientId", "", "origin", "pluginType", "<init>", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "appContext", "kotlin.jvm.PlatformType", "Landroid/content/Context;", "createRequest", "Lcom/stripe/android/core/networking/AnalyticsRequestV2;", "eventName", "additionalParams", "", "includeSDKParams", "", "sdkParams", "getAppName", "", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class AnalyticsRequestV2Factory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String clientId;
    @NotNull
    private final String origin;
    @NotNull
    private final String pluginType;
    private final Context appContext;
    @NotNull
    public static final String PLUGIN_NATIVE = "native";
    @NotNull
    public static final String PARAM_SDK_PLATFORM = "sdk_platform";
    @NotNull
    public static final String PARAM_SDK_VERSION = "sdk_version";
    @NotNull
    public static final String PARAM_PLUGIN_TYPE = "plugin_type";
    @NotNull
    public static final String PARAM_PLATFORM_INFO = "platform_info";
    @NotNull
    public static final String PARAM_PACKAGE_NAME = "package_name";

    public AnalyticsRequestV2Factory(@NotNull Context context, @NotNull String clientId, @NotNull String origin, @NotNull String pluginType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)pluginType, (String)"pluginType");
        this.clientId = clientId;
        this.origin = origin;
        this.pluginType = pluginType;
        this.appContext = context.getApplicationContext();
    }

    public /* synthetic */ AnalyticsRequestV2Factory(Context context, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            String string4 = PluginDetector.INSTANCE.getPluginType();
            if (string4 == null) {
                string4 = PLUGIN_NATIVE;
            }
            string3 = string4;
        }
        this(context, string, string2, string3);
    }

    @NotNull
    public final AnalyticsRequestV2 createRequest(@NotNull String eventName, @NotNull Map<String, ? extends Object> additionalParams, boolean includeSDKParams) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter(additionalParams, (String)"additionalParams");
        return AnalyticsRequestV2.Companion.create(eventName, this.clientId, this.origin, includeSDKParams ? MapsKt.plus(additionalParams, this.sdkParams()) : additionalParams);
    }

    public static /* synthetic */ AnalyticsRequestV2 createRequest$default(AnalyticsRequestV2Factory analyticsRequestV2Factory, String string, Map map, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return analyticsRequestV2Factory.createRequest(string, map, bl);
    }

    @SuppressLint(value={"HardwareIds"})
    private final Map<String, Object> sdkParams() {
        Pair[] pairArray = new Pair[9];
        pairArray[0] = TuplesKt.to((Object)"os_version", (Object)Build.VERSION.SDK_INT);
        pairArray[1] = TuplesKt.to((Object)PARAM_SDK_PLATFORM, (Object)"android");
        pairArray[2] = TuplesKt.to((Object)PARAM_SDK_VERSION, (Object)"21.12.0");
        pairArray[3] = TuplesKt.to((Object)"device_type", (Object)(Build.MANUFACTURER + "_" + Build.BRAND + "_" + Build.MODEL));
        pairArray[4] = TuplesKt.to((Object)"app_name", (Object)this.getAppName());
        Context context = this.appContext;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
        PackageInfo packageInfo = ContextUtils.INSTANCE.getPackageInfo(context);
        pairArray[5] = TuplesKt.to((Object)"app_version", (Object)(packageInfo != null ? Integer.valueOf(packageInfo.versionCode) : null));
        pairArray[6] = TuplesKt.to((Object)"device_id", (Object)Settings.Secure.getString((ContentResolver)this.appContext.getContentResolver(), (String)"android_id"));
        pairArray[7] = TuplesKt.to((Object)PARAM_PLUGIN_TYPE, (Object)this.pluginType);
        pairArray[8] = TuplesKt.to((Object)PARAM_PLATFORM_INFO, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)PARAM_PACKAGE_NAME, (Object)this.appContext.getPackageName())));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final CharSequence getAppName() {
        CharSequence charSequence;
        Context context = this.appContext;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
        PackageInfo packageInfo = ContextUtils.INSTANCE.getPackageInfo(context);
        CharSequence it = charSequence = packageInfo != null && (packageInfo = packageInfo.applicationInfo) != null ? packageInfo.loadLabel(this.appContext.getPackageManager()) : null;
        boolean bl = false;
        CharSequence charSequence2 = it;
        CharSequence charSequence3 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? charSequence : null;
        if (charSequence3 == null) {
            String string = this.appContext.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
            charSequence3 = string;
        }
        return charSequence3;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/core/networking/AnalyticsRequestV2Factory$Companion;", "", "<init>", "()V", "PLUGIN_NATIVE", "", "PARAM_SDK_PLATFORM", "PARAM_SDK_VERSION", "PARAM_PLUGIN_TYPE", "PARAM_PLATFORM_INFO", "PARAM_PACKAGE_NAME", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

