/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import com.stripe.android.core.ApiKeyValidator;
import com.stripe.android.core.ApiVersion;
import com.stripe.android.core.AppInfo;
import com.stripe.android.core.exception.InvalidRequestException;
import com.stripe.android.core.networking.NetworkConstantsKt;
import com.stripe.android.core.networking.QueryStringFactory;
import com.stripe.android.core.networking.RequestHeadersFactory;
import com.stripe.android.core.networking.StripeRequest;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0087\b\u0018\u0000 I2\u00020\u0001:\u0003GHIBa\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020\u0005H\u0016J\t\u00109\u001a\u00020\u0003H\u00c6\u0003J\t\u0010:\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0007H\u00c6\u0003J\t\u0010<\u001a\u00020\tH\u00c6\u0003J\u000b\u0010=\u001a\u0004\u0018\u00010\u000bH\u00c2\u0003J\t\u0010>\u001a\u00020\u0005H\u00c2\u0003J\t\u0010?\u001a\u00020\u0005H\u00c2\u0003J\t\u0010@\u001a\u00020\u000fH\u00c6\u0003Jl\u0010A\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c0\u0001\u00a2\u0006\u0002\bBJ\u0013\u0010C\u001a\u00020\u000f2\b\u0010D\u001a\u0004\u0018\u00010EH\u00d6\u0003J\t\u0010F\u001a\u00020)H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0015R \u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0017R(\u00100\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0017\"\u0004\b2\u00103\u00a8\u0006J"}, d2={"Lcom/stripe/android/core/networking/ApiRequest;", "Lcom/stripe/android/core/networking/StripeRequest;", "method", "Lcom/stripe/android/core/networking/StripeRequest$Method;", "baseUrl", "", "params", "", "options", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/core/AppInfo;", "apiVersion", "sdkVersion", "shouldCache", "", "<init>", "(Lcom/stripe/android/core/networking/StripeRequest$Method;Ljava/lang/String;Ljava/util/Map;Lcom/stripe/android/core/networking/ApiRequest$Options;Lcom/stripe/android/core/AppInfo;Ljava/lang/String;Ljava/lang/String;Z)V", "getMethod", "()Lcom/stripe/android/core/networking/StripeRequest$Method;", "getBaseUrl", "()Ljava/lang/String;", "getParams", "()Ljava/util/Map;", "getOptions", "()Lcom/stripe/android/core/networking/ApiRequest$Options;", "getShouldCache", "()Z", "query", "postBodyBytes", "", "getPostBodyBytes", "()[B", "headersFactory", "Lcom/stripe/android/core/networking/RequestHeadersFactory$Api;", "mimeType", "Lcom/stripe/android/core/networking/StripeRequest$MimeType;", "getMimeType", "()Lcom/stripe/android/core/networking/StripeRequest$MimeType;", "retryResponseCodes", "", "", "getRetryResponseCodes", "()Ljava/lang/Iterable;", "url", "getUrl", "headers", "getHeaders", "postHeaders", "getPostHeaders", "setPostHeaders", "(Ljava/util/Map;)V", "writePostBody", "", "outputStream", "Ljava/io/OutputStream;", "toString", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "copy$stripe_core_release", "equals", "other", "", "hashCode", "Options", "Factory", "Companion", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nApiRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiRequest.kt\ncom/stripe/android/core/networking/ApiRequest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n1#2:205\n*E\n"})
public final class ApiRequest
extends StripeRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StripeRequest.Method method;
    @NotNull
    private final String baseUrl;
    @Nullable
    private final Map<String, ?> params;
    @NotNull
    private final Options options;
    @Nullable
    private final AppInfo appInfo;
    @NotNull
    private final String apiVersion;
    @NotNull
    private final String sdkVersion;
    private final boolean shouldCache;
    @NotNull
    private final String query;
    @NotNull
    private final RequestHeadersFactory.Api headersFactory;
    @NotNull
    private final StripeRequest.MimeType mimeType;
    @NotNull
    private final Iterable<Integer> retryResponseCodes;
    @NotNull
    private final Map<String, String> headers;
    @Nullable
    private Map<String, String> postHeaders;
    @NotNull
    public static final String API_HOST = "https://api.stripe.com";

    public ApiRequest(@NotNull StripeRequest.Method method, @NotNull String baseUrl, @Nullable Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo, @NotNull String apiVersion, @NotNull String sdkVersion, boolean shouldCache) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        this.method = method;
        this.baseUrl = baseUrl;
        this.params = params;
        this.options = options;
        this.appInfo = appInfo;
        this.apiVersion = apiVersion;
        this.sdkVersion = sdkVersion;
        this.shouldCache = shouldCache;
        this.query = QueryStringFactory.INSTANCE.createFromParamsWithEmptyValues(this.params);
        this.headersFactory = new RequestHeadersFactory.Api(this.options, this.appInfo, null, this.apiVersion, this.sdkVersion, 4, null);
        this.mimeType = StripeRequest.MimeType.Form;
        this.retryResponseCodes = NetworkConstantsKt.getDEFAULT_RETRY_CODES();
        this.headers = this.headersFactory.create();
        this.postHeaders = this.headersFactory.createPostHeader();
    }

    public /* synthetic */ ApiRequest(StripeRequest.Method method, String string, Map map, Options options, AppInfo appInfo, String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = null;
        }
        if ((n & 0x10) != 0) {
            appInfo = null;
        }
        if ((n & 0x20) != 0) {
            string2 = ApiVersion.Companion.get().getCode();
        }
        if ((n & 0x40) != 0) {
            string3 = "AndroidBindings/21.12.0";
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        this(method, string, map, options, appInfo, string2, string3, bl);
    }

    @Override
    @NotNull
    public StripeRequest.Method getMethod() {
        return this.method;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @Nullable
    public final Map<String, ?> getParams() {
        return this.params;
    }

    @NotNull
    public final Options getOptions() {
        return this.options;
    }

    @Override
    public boolean getShouldCache() {
        return this.shouldCache;
    }

    private final byte[] getPostBodyBytes() throws UnsupportedEncodingException, InvalidRequestException {
        try {
            byte[] byArray = this.query.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return byArray;
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException(null, null, 0, "Unable to encode parameters to " + Charsets.UTF_8.name() + ". Please contact support@stripe.com for assistance.", e, 7, null);
        }
    }

    @Override
    @NotNull
    public StripeRequest.MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    @NotNull
    public Iterable<Integer> getRetryResponseCodes() {
        return this.retryResponseCodes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getUrl() {
        String string;
        if (StripeRequest.Method.GET == this.getMethod() || StripeRequest.Method.DELETE == this.getMethod()) {
            void it;
            String string2;
            Object[] objectArray = new String[2];
            objectArray[0] = this.baseUrl;
            String string3 = string2 = this.query;
            int n = 1;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            objectArray2[n] = bl2 ? string2 : null;
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)(StringsKt.contains$default((CharSequence)this.baseUrl, (CharSequence)"?", (boolean)false, (int)2, null) ? "&" : "?"), null, null, (int)0, null, null, (int)62, null);
        } else {
            string = this.baseUrl;
        }
        return string;
    }

    @Override
    @NotNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    @Nullable
    public Map<String, String> getPostHeaders() {
        return this.postHeaders;
    }

    @Override
    public void setPostHeaders(@Nullable Map<String, String> map) {
        this.postHeaders = map;
    }

    @Override
    public void writePostBody(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        byte[] it = this.getPostBodyBytes();
        boolean bl = false;
        outputStream.write(it);
        outputStream.flush();
    }

    @NotNull
    public String toString() {
        return this.getMethod().getCode() + " " + this.baseUrl;
    }

    @NotNull
    public final StripeRequest.Method component1() {
        return this.method;
    }

    @NotNull
    public final String component2() {
        return this.baseUrl;
    }

    @Nullable
    public final Map<String, ?> component3() {
        return this.params;
    }

    @NotNull
    public final Options component4() {
        return this.options;
    }

    private final AppInfo component5() {
        return this.appInfo;
    }

    private final String component6() {
        return this.apiVersion;
    }

    private final String component7() {
        return this.sdkVersion;
    }

    public final boolean component8() {
        return this.shouldCache;
    }

    @NotNull
    public final ApiRequest copy$stripe_core_release(@NotNull StripeRequest.Method method, @NotNull String baseUrl, @Nullable Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo, @NotNull String apiVersion, @NotNull String sdkVersion, boolean shouldCache) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        return new ApiRequest(method, baseUrl, params, options, appInfo, apiVersion, sdkVersion, shouldCache);
    }

    public static /* synthetic */ ApiRequest copy$stripe_core_release$default(ApiRequest apiRequest, StripeRequest.Method method, String string, Map map, Options options, AppInfo appInfo, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            method = apiRequest.method;
        }
        if ((n & 2) != 0) {
            string = apiRequest.baseUrl;
        }
        if ((n & 4) != 0) {
            map = apiRequest.params;
        }
        if ((n & 8) != 0) {
            options = apiRequest.options;
        }
        if ((n & 0x10) != 0) {
            appInfo = apiRequest.appInfo;
        }
        if ((n & 0x20) != 0) {
            string2 = apiRequest.apiVersion;
        }
        if ((n & 0x40) != 0) {
            string3 = apiRequest.sdkVersion;
        }
        if ((n & 0x80) != 0) {
            bl = apiRequest.shouldCache;
        }
        return apiRequest.copy$stripe_core_release(method, string, map, options, appInfo, string2, string3, bl);
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = result * 31 + this.baseUrl.hashCode();
        result = result * 31 + (this.params == null ? 0 : ((Object)this.params).hashCode());
        result = result * 31 + this.options.hashCode();
        result = result * 31 + (this.appInfo == null ? 0 : this.appInfo.hashCode());
        result = result * 31 + this.apiVersion.hashCode();
        result = result * 31 + this.sdkVersion.hashCode();
        result = result * 31 + Boolean.hashCode(this.shouldCache);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ApiRequest)) {
            return false;
        }
        ApiRequest apiRequest = (ApiRequest)other;
        if (this.method != apiRequest.method) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.baseUrl, (Object)apiRequest.baseUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.params, apiRequest.params)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.options, (Object)apiRequest.options)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.appInfo, (Object)apiRequest.appInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.apiVersion, (Object)apiRequest.apiVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sdkVersion, (Object)apiRequest.sdkVersion)) {
            return false;
        }
        return this.shouldCache == apiRequest.shouldCache;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/core/networking/ApiRequest$Companion;", "", "<init>", "()V", "API_HOST", "", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ6\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J6\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J,\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u000fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/core/networking/ApiRequest$Factory;", "", "appInfo", "Lcom/stripe/android/core/AppInfo;", "apiVersion", "", "sdkVersion", "<init>", "(Lcom/stripe/android/core/AppInfo;Ljava/lang/String;Ljava/lang/String;)V", "createGet", "Lcom/stripe/android/core/networking/ApiRequest;", "url", "options", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "params", "", "shouldCache", "", "createPost", "createDelete", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Factory {
        @Nullable
        private final AppInfo appInfo;
        @NotNull
        private final String apiVersion;
        @NotNull
        private final String sdkVersion;

        public Factory(@Nullable AppInfo appInfo, @NotNull String apiVersion, @NotNull String sdkVersion) {
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
            this.appInfo = appInfo;
            this.apiVersion = apiVersion;
            this.sdkVersion = sdkVersion;
        }

        public /* synthetic */ Factory(AppInfo appInfo, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                appInfo = null;
            }
            if ((n & 2) != 0) {
                string = ApiVersion.Companion.get().getCode();
            }
            if ((n & 4) != 0) {
                string2 = "AndroidBindings/21.12.0";
            }
            this(appInfo, string, string2);
        }

        @NotNull
        public final ApiRequest createGet(@NotNull String url, @NotNull Options options, @Nullable Map<String, ?> params, boolean shouldCache) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.GET, url, params, options, this.appInfo, this.apiVersion, this.sdkVersion, shouldCache);
        }

        public static /* synthetic */ ApiRequest createGet$default(Factory factory, String string, Options options, Map map, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                map = null;
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            return factory.createGet(string, options, map, bl);
        }

        @NotNull
        public final ApiRequest createPost(@NotNull String url, @NotNull Options options, @Nullable Map<String, ?> params, boolean shouldCache) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.POST, url, params, options, this.appInfo, this.apiVersion, this.sdkVersion, shouldCache);
        }

        public static /* synthetic */ ApiRequest createPost$default(Factory factory, String string, Options options, Map map, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                map = null;
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            return factory.createPost(string, options, map, bl);
        }

        @NotNull
        public final ApiRequest createDelete(@NotNull String url, @NotNull Options options, @Nullable Map<String, ?> params) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.DELETE, url, params, options, this.appInfo, this.apiVersion, this.sdkVersion, false, 128, null);
        }

        public static /* synthetic */ ApiRequest createDelete$default(Factory factory, String string, Options options, Map map, int n, Object object) {
            if ((n & 4) != 0) {
                map = null;
            }
            return factory.createDelete(string, options, map);
        }

        public Factory() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 &2\u00020\u0001:\u0001&B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B+\b\u0017\u0012\u000e\b\u0001\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\u0010\b\u0001\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0013\u0010\u001c\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u001bH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/stripe/android/core/networking/ApiRequest$Options;", "Landroid/os/Parcelable;", "apiKey", "", "stripeAccount", "idempotencyKey", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "publishableKeyProvider", "Lkotlin/Function0;", "stripeAccountIdProvider", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getApiKey", "()Ljava/lang/String;", "getStripeAccount", "getIdempotencyKey", "apiKeyIsUserKey", "", "getApiKeyIsUserKey", "()Z", "apiKeyIsLiveMode", "getApiKeyIsLiveMode", "component1", "component2", "component3", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Companion", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Parcelize
    public static final class Options
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String apiKey;
        @Nullable
        private final String stripeAccount;
        @Nullable
        private final String idempotencyKey;
        @NotNull
        public static final Parcelable.Creator<Options> CREATOR;
        @NotNull
        public static final String UNDEFINED_PUBLISHABLE_KEY = "pk_undefined";

        public Options(@NotNull String apiKey, @Nullable String stripeAccount, @Nullable String idempotencyKey) {
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            this.apiKey = apiKey;
            this.stripeAccount = stripeAccount;
            this.idempotencyKey = idempotencyKey;
            new ApiKeyValidator().requireValid(this.apiKey);
        }

        public /* synthetic */ Options(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @NotNull
        public final String getApiKey() {
            return this.apiKey;
        }

        @Nullable
        public final String getStripeAccount() {
            return this.stripeAccount;
        }

        @Nullable
        public final String getIdempotencyKey() {
            return this.idempotencyKey;
        }

        public final boolean getApiKeyIsUserKey() {
            return StringsKt.startsWith$default((String)this.apiKey, (String)"uk_", (boolean)false, (int)2, null);
        }

        public final boolean getApiKeyIsLiveMode() {
            return !StringsKt.contains$default((CharSequence)this.apiKey, (CharSequence)"test", (boolean)false, (int)2, null);
        }

        @Inject
        public Options(@Named(value="publishableKey") @NotNull Function0<String> publishableKeyProvider, @Named(value="stripeAccountId") @NotNull Function0<String> stripeAccountIdProvider) {
            Intrinsics.checkNotNullParameter(publishableKeyProvider, (String)"publishableKeyProvider");
            Intrinsics.checkNotNullParameter(stripeAccountIdProvider, (String)"stripeAccountIdProvider");
            this((String)publishableKeyProvider.invoke(), (String)stripeAccountIdProvider.invoke(), null, 4, null);
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeString(this.apiKey);
            dest.writeString(this.stripeAccount);
            dest.writeString(this.idempotencyKey);
        }

        public final int describeContents() {
            return 0;
        }

        @NotNull
        public final String component1() {
            return this.apiKey;
        }

        @Nullable
        public final String component2() {
            return this.stripeAccount;
        }

        @Nullable
        public final String component3() {
            return this.idempotencyKey;
        }

        @NotNull
        public final Options copy(@NotNull String apiKey, @Nullable String stripeAccount, @Nullable String idempotencyKey) {
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            return new Options(apiKey, stripeAccount, idempotencyKey);
        }

        public static /* synthetic */ Options copy$default(Options options, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = options.apiKey;
            }
            if ((n & 2) != 0) {
                string2 = options.stripeAccount;
            }
            if ((n & 4) != 0) {
                string3 = options.idempotencyKey;
            }
            return options.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Options(apiKey=" + this.apiKey + ", stripeAccount=" + this.stripeAccount + ", idempotencyKey=" + this.idempotencyKey + ")";
        }

        public int hashCode() {
            int result = this.apiKey.hashCode();
            result = result * 31 + (this.stripeAccount == null ? 0 : this.stripeAccount.hashCode());
            result = result * 31 + (this.idempotencyKey == null ? 0 : this.idempotencyKey.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Options)) {
                return false;
            }
            Options options = (Options)other;
            if (!Intrinsics.areEqual((Object)this.apiKey, (Object)options.apiKey)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stripeAccount, (Object)options.stripeAccount)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.idempotencyKey, (Object)options.idempotencyKey);
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Options> {
                public final Options[] newArray(int size) {
                    return new Options[size];
                }

                public final Options createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Options(parcel.readString(), parcel.readString(), parcel.readString());
                }
            }
            CREATOR = new Creator();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/core/networking/ApiRequest$Options$Companion;", "", "<init>", "()V", "UNDEFINED_PUBLISHABLE_KEY", "", "stripe-core_release"})
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

