/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.networking;

import android.os.Build;
import android.system.Os;
import androidx.annotation.RestrictTo;
import com.stripe.android.core.ApiVersion;
import com.stripe.android.core.AppInfo;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.core.networking.StripeClientUserAgentHeaderFactory;
import com.stripe.android.core.networking.StripeRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u001b2\u00020\u0001:\u0006\u0016\u0017\u0018\u0019\u001a\u001bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005J\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005J\u0016\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0015H\u0004R\u0012\u0010\b\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\r\"\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\n\u0082\u0001\u0003\u001c\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/core/networking/RequestHeadersFactory;", "", "<init>", "()V", "create", "", "", "createPostHeader", "userAgent", "getUserAgent", "()Ljava/lang/String;", "extraHeaders", "getExtraHeaders", "()Ljava/util/Map;", "postHeaders", "getPostHeaders", "setPostHeaders", "(Ljava/util/Map;)V", "xStripeUserAgent", "getXStripeUserAgent", "defaultXStripeUserAgentMap", "", "BaseApiHeadersFactory", "Api", "FileUpload", "FraudDetection", "Analytics", "Companion", "Lcom/stripe/android/core/networking/RequestHeadersFactory$Analytics;", "Lcom/stripe/android/core/networking/RequestHeadersFactory$BaseApiHeadersFactory;", "Lcom/stripe/android/core/networking/RequestHeadersFactory$FraudDetection;", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class RequestHeadersFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, String> postHeaders = MapsKt.emptyMap();
    @NotNull
    private static final String CHARSET;
    @NotNull
    public static final String UNDETERMINED_LANGUAGE = "und";
    @NotNull
    public static final String LANG = "lang";
    @NotNull
    public static final String KOTLIN = "kotlin";
    @NotNull
    public static final String TYPE = "type";
    @NotNull
    public static final String MODEL = "model";

    private RequestHeadersFactory() {
    }

    @NotNull
    public final Map<String, String> create() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"User-Agent", (Object)this.getUserAgent()), TuplesKt.to((Object)"Accept-Charset", (Object)CHARSET), TuplesKt.to((Object)"X-Stripe-User-Agent", (Object)this.getXStripeUserAgent())};
        return MapsKt.plus(this.getExtraHeaders(), (Map)MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public final Map<String, String> createPostHeader() {
        return this.getPostHeaders();
    }

    @NotNull
    protected abstract String getUserAgent();

    @NotNull
    protected abstract Map<String, String> getExtraHeaders();

    @NotNull
    protected Map<String, String> getPostHeaders() {
        return this.postHeaders;
    }

    protected void setPostHeaders(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.postHeaders = map;
    }

    @NotNull
    protected abstract String getXStripeUserAgent();

    @NotNull
    protected final Map<String, String> defaultXStripeUserAgentMap() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)LANG, (Object)KOTLIN), TuplesKt.to((Object)"bindings_version", (Object)"21.12.0"), TuplesKt.to((Object)"os_version", (Object)String.valueOf(Build.VERSION.SDK_INT)), TuplesKt.to((Object)TYPE, (Object)(Build.MANUFACTURER + "_" + Build.BRAND + "_" + Build.MODEL)), TuplesKt.to((Object)MODEL, (Object)Build.MODEL)};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    public /* synthetic */ RequestHeadersFactory(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        String string = Charsets.UTF_8.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        CHARSET = string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/core/networking/RequestHeadersFactory$Analytics;", "Lcom/stripe/android/core/networking/RequestHeadersFactory;", "<init>", "()V", "userAgent", "", "getUserAgent", "()Ljava/lang/String;", "extraHeaders", "", "getExtraHeaders", "()Ljava/util/Map;", "xStripeUserAgent", "getXStripeUserAgent", "equals", "", "other", "", "hashCode", "", "toString", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @SourceDebugExtension(value={"SMAP\nRequestHeadersFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestHeadersFactory.kt\ncom/stripe/android/core/networking/RequestHeadersFactory$Analytics\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,222:1\n126#2:223\n153#2,3:224\n*S KotlinDebug\n*F\n+ 1 RequestHeadersFactory.kt\ncom/stripe/android/core/networking/RequestHeadersFactory$Analytics\n*L\n200#1:223\n200#1:224,3\n*E\n"})
    public static final class Analytics
    extends RequestHeadersFactory {
        @NotNull
        public static final Analytics INSTANCE = new Analytics();
        @NotNull
        private static final String userAgent = Companion.getUserAgent("AndroidBindings/21.12.0");
        @NotNull
        private static final Map<String, String> extraHeaders = MapsKt.emptyMap();

        private Analytics() {
            super(null);
        }

        @Override
        @NotNull
        protected String getUserAgent() {
            return userAgent;
        }

        @Override
        @NotNull
        protected Map<String, String> getExtraHeaders() {
            return extraHeaders;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected String getXStripeUserAgent() {
            void $this$mapTo$iv$iv;
            Map<String, String> paramMap;
            Map<String, String> $this$map$iv = paramMap = this.defaultXStripeUserAgentMap();
            boolean $i$f$map = false;
            Map<String, String> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                collection.add("\"" + key + "\":\"" + value + "\"");
            }
            return "{" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "}";
        }

        @NotNull
        public String toString() {
            return "Analytics";
        }

        public int hashCode() {
            return -334358835;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Analytics)) {
                return false;
            }
            Analytics cfr_ignored_0 = (Analytics)other;
            return true;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fR&\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000eX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/core/networking/RequestHeadersFactory$Api;", "Lcom/stripe/android/core/networking/RequestHeadersFactory$BaseApiHeadersFactory;", "options", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/core/AppInfo;", "locale", "Ljava/util/Locale;", "apiVersion", "", "sdkVersion", "<init>", "(Lcom/stripe/android/core/networking/ApiRequest$Options;Lcom/stripe/android/core/AppInfo;Ljava/util/Locale;Ljava/lang/String;Ljava/lang/String;)V", "postHeaders", "", "getPostHeaders", "()Ljava/util/Map;", "setPostHeaders", "(Ljava/util/Map;)V", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Api
    extends BaseApiHeadersFactory {
        @NotNull
        private Map<String, String> postHeaders;

        public Api(@NotNull ApiRequest.Options options, @Nullable AppInfo appInfo, @NotNull Locale locale, @NotNull String apiVersion, @NotNull String sdkVersion) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
            super((Function0<ApiRequest.Options>)((Function0)() -> Api._init_$lambda$0(options)), appInfo, locale, apiVersion, sdkVersion);
            this.postHeaders = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)(StripeRequest.MimeType.Form.getCode() + "; charset=" + Companion.getCHARSET())));
        }

        public /* synthetic */ Api(ApiRequest.Options options, AppInfo appInfo, Locale locale, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                appInfo = null;
            }
            if ((n & 4) != 0) {
                locale = Locale.getDefault();
            }
            if ((n & 8) != 0) {
                string = ApiVersion.Companion.get().getCode();
            }
            if ((n & 0x10) != 0) {
                string2 = "AndroidBindings/21.12.0";
            }
            this(options, appInfo, locale, string, string2);
        }

        @Override
        @NotNull
        protected Map<String, String> getPostHeaders() {
            return this.postHeaders;
        }

        @Override
        protected void setPostHeaders(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.postHeaders = map;
        }

        private static final ApiRequest.Options _init_$lambda$0(ApiRequest.Options $options) {
            return $options;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B?\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00188TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/stripe/android/core/networking/RequestHeadersFactory$BaseApiHeadersFactory;", "Lcom/stripe/android/core/networking/RequestHeadersFactory;", "optionsProvider", "Lkotlin/Function0;", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/core/AppInfo;", "locale", "Ljava/util/Locale;", "apiVersion", "", "sdkVersion", "<init>", "(Lkotlin/jvm/functions/Function0;Lcom/stripe/android/core/AppInfo;Ljava/util/Locale;Ljava/lang/String;Ljava/lang/String;)V", "stripeClientUserAgentHeaderFactory", "Lcom/stripe/android/core/networking/StripeClientUserAgentHeaderFactory;", "languageTag", "getLanguageTag", "()Ljava/lang/String;", "userAgent", "getUserAgent", "xStripeUserAgent", "getXStripeUserAgent", "extraHeaders", "", "getExtraHeaders", "()Ljava/util/Map;", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @SourceDebugExtension(value={"SMAP\nRequestHeadersFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestHeadersFactory.kt\ncom/stripe/android/core/networking/RequestHeadersFactory$BaseApiHeadersFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,222:1\n1#2:223\n126#3:224\n153#3,3:225\n*S KotlinDebug\n*F\n+ 1 RequestHeadersFactory.kt\ncom/stripe/android/core/networking/RequestHeadersFactory$BaseApiHeadersFactory\n*L\n81#1:224\n81#1:225,3\n*E\n"})
    public static class BaseApiHeadersFactory
    extends RequestHeadersFactory {
        @NotNull
        private final Function0<ApiRequest.Options> optionsProvider;
        @Nullable
        private final AppInfo appInfo;
        @NotNull
        private final Locale locale;
        @NotNull
        private final String apiVersion;
        @NotNull
        private final String sdkVersion;
        @NotNull
        private final StripeClientUserAgentHeaderFactory stripeClientUserAgentHeaderFactory;

        public BaseApiHeadersFactory(@NotNull Function0<ApiRequest.Options> optionsProvider, @Nullable AppInfo appInfo, @NotNull Locale locale, @NotNull String apiVersion, @NotNull String sdkVersion) {
            Intrinsics.checkNotNullParameter(optionsProvider, (String)"optionsProvider");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
            super(null);
            this.optionsProvider = optionsProvider;
            this.appInfo = appInfo;
            this.locale = locale;
            this.apiVersion = apiVersion;
            this.sdkVersion = sdkVersion;
            this.stripeClientUserAgentHeaderFactory = new StripeClientUserAgentHeaderFactory(null, 1, null);
        }

        public /* synthetic */ BaseApiHeadersFactory(Function0 function0, AppInfo appInfo, Locale locale, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                appInfo = null;
            }
            if ((n & 4) != 0) {
                locale = Locale.getDefault();
            }
            if ((n & 8) != 0) {
                string = ApiVersion.Companion.get().getCode();
            }
            if ((n & 0x10) != 0) {
                string2 = "AndroidBindings/21.12.0";
            }
            this((Function0<ApiRequest.Options>)function0, appInfo, locale, string, string2);
        }

        private final String getLanguageTag() {
            String string;
            String it = string = this.locale.toLanguageTag();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            return !StringsKt.isBlank((CharSequence)it) && !Intrinsics.areEqual((Object)it, (Object)RequestHeadersFactory.UNDETERMINED_LANGUAGE) ? string : null;
        }

        @Override
        @NotNull
        protected String getUserAgent() {
            Object[] objectArray = new String[2];
            objectArray[0] = Companion.getUserAgent(this.sdkVersion);
            AppInfo appInfo = this.appInfo;
            objectArray[1] = appInfo != null ? appInfo.toUserAgent$stripe_core_release() : null;
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected String getXStripeUserAgent() {
            void $this$mapTo$iv$iv;
            Object it;
            Map<String, String> paramMap = this.defaultXStripeUserAgentMap();
            AppInfo appInfo = this.appInfo;
            if (appInfo != null) {
                it = appInfo;
                boolean bl = false;
                paramMap.putAll(((AppInfo)it).toParamMap$stripe_core_release());
            }
            Map<String, String> $this$map$iv = paramMap;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                collection.add("\"" + key + "\":\"" + value + "\"");
            }
            return "{" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "}";
        }

        @Override
        @NotNull
        protected Map<String, String> getExtraHeaders() {
            Map map;
            Map map2;
            Map map3;
            Map map4;
            Map map5;
            Map map6;
            String it;
            Map map7;
            Map map8;
            ApiRequest.Options apiRequestOptions = (ApiRequest.Options)this.optionsProvider.invoke();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Accept", (Object)"application/json"), TuplesKt.to((Object)"Stripe-Version", (Object)this.apiVersion), TuplesKt.to((Object)"Authorization", (Object)("Bearer " + apiRequestOptions.getApiKey()))};
            Map map9 = MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), this.stripeClientUserAgentHeaderFactory.create(this.appInfo));
            if (apiRequestOptions.getApiKeyIsUserKey()) {
                boolean isLiveMode = !Intrinsics.areEqual((Object)Os.getenv((String)"Stripe-Livemode"), (Object)"false");
                map8 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Stripe-Livemode", (Object)String.valueOf(isLiveMode)));
            } else {
                map8 = MapsKt.emptyMap();
            }
            Map map10 = MapsKt.plus((Map)map9, (Map)map8);
            String string = apiRequestOptions.getStripeAccount();
            if (string != null) {
                String string2 = string;
                map7 = map10;
                boolean bl = false;
                map6 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Stripe-Account", (Object)it));
                map10 = map7;
            } else {
                map6 = map5 = null;
            }
            if (map6 == null) {
                map5 = MapsKt.emptyMap();
            }
            Map map11 = MapsKt.plus((Map)map10, map5);
            String string3 = apiRequestOptions.getIdempotencyKey();
            if (string3 != null) {
                it = string3;
                map7 = map11;
                boolean bl = false;
                map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Idempotency-Key", (Object)it));
                map11 = map7;
            } else {
                map4 = map3 = null;
            }
            if (map4 == null) {
                map3 = MapsKt.emptyMap();
            }
            Map map12 = MapsKt.plus((Map)map11, map3);
            String string4 = this.getLanguageTag();
            if (string4 != null) {
                it = string4;
                map7 = map12;
                boolean bl = false;
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Accept-Language", (Object)it));
                map12 = map7;
            } else {
                map2 = map = null;
            }
            if (map2 == null) {
                map = MapsKt.emptyMap();
            }
            return MapsKt.plus((Map)map12, map);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/core/networking/RequestHeadersFactory$Companion;", "", "<init>", "()V", "getUserAgent", "", "sdkVersion", "CHARSET", "getCHARSET", "()Ljava/lang/String;", "UNDETERMINED_LANGUAGE", "LANG", "KOTLIN", "TYPE", "MODEL", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getUserAgent(@NotNull String sdkVersion) {
            Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
            return "Stripe/v1 " + sdkVersion;
        }

        public static /* synthetic */ String getUserAgent$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "AndroidBindings/21.12.0";
            }
            return companion.getUserAgent(string);
        }

        @NotNull
        public final String getCHARSET() {
            return CHARSET;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rR&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000fX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/core/networking/RequestHeadersFactory$FileUpload;", "Lcom/stripe/android/core/networking/RequestHeadersFactory$BaseApiHeadersFactory;", "options", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/core/AppInfo;", "locale", "Ljava/util/Locale;", "apiVersion", "", "sdkVersion", "boundary", "<init>", "(Lcom/stripe/android/core/networking/ApiRequest$Options;Lcom/stripe/android/core/AppInfo;Ljava/util/Locale;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "postHeaders", "", "getPostHeaders", "()Ljava/util/Map;", "setPostHeaders", "(Ljava/util/Map;)V", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class FileUpload
    extends BaseApiHeadersFactory {
        @NotNull
        private Map<String, String> postHeaders;

        public FileUpload(@NotNull ApiRequest.Options options, @Nullable AppInfo appInfo, @NotNull Locale locale, @NotNull String apiVersion, @NotNull String sdkVersion, @NotNull String boundary) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
            Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
            super((Function0<ApiRequest.Options>)((Function0)() -> FileUpload._init_$lambda$0(options)), appInfo, locale, apiVersion, sdkVersion);
            this.postHeaders = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)(StripeRequest.MimeType.MultipartForm.getCode() + "; boundary=" + boundary)));
        }

        public /* synthetic */ FileUpload(ApiRequest.Options options, AppInfo appInfo, Locale locale, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                appInfo = null;
            }
            if ((n & 4) != 0) {
                locale = Locale.getDefault();
            }
            if ((n & 8) != 0) {
                string = ApiVersion.Companion.get().getCode();
            }
            if ((n & 0x10) != 0) {
                string2 = "AndroidBindings/21.12.0";
            }
            this(options, appInfo, locale, string, string2, string3);
        }

        @Override
        @NotNull
        protected Map<String, String> getPostHeaders() {
            return this.postHeaders;
        }

        @Override
        protected void setPostHeaders(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.postHeaders = map;
        }

        private static final ApiRequest.Options _init_$lambda$0(ApiRequest.Options $options) {
            return $options;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\r\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR&\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/core/networking/RequestHeadersFactory$FraudDetection;", "Lcom/stripe/android/core/networking/RequestHeadersFactory;", "guid", "", "<init>", "(Ljava/lang/String;)V", "extraHeaders", "", "getExtraHeaders", "()Ljava/util/Map;", "userAgent", "getUserAgent", "()Ljava/lang/String;", "postHeaders", "getPostHeaders", "setPostHeaders", "(Ljava/util/Map;)V", "xStripeUserAgent", "getXStripeUserAgent", "Companion", "stripe-core_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @SourceDebugExtension(value={"SMAP\nRequestHeadersFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestHeadersFactory.kt\ncom/stripe/android/core/networking/RequestHeadersFactory$FraudDetection\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,222:1\n126#2:223\n153#2,3:224\n*S KotlinDebug\n*F\n+ 1 RequestHeadersFactory.kt\ncom/stripe/android/core/networking/RequestHeadersFactory$FraudDetection\n*L\n184#1:223\n184#1:224,3\n*E\n"})
    public static final class FraudDetection
    extends RequestHeadersFactory {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, String> extraHeaders;
        @NotNull
        private final String userAgent;
        @NotNull
        private Map<String, String> postHeaders;
        @NotNull
        public static final String HEADER_COOKIE = "Cookie";

        public FraudDetection(@NotNull String guid) {
            Intrinsics.checkNotNullParameter((Object)guid, (String)"guid");
            super(null);
            this.extraHeaders = MapsKt.mapOf((Pair)TuplesKt.to((Object)HEADER_COOKIE, (Object)("m=" + guid)));
            this.userAgent = Companion.getUserAgent("AndroidBindings/21.12.0");
            this.postHeaders = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)(StripeRequest.MimeType.Json.getCode() + "; charset=" + Companion.getCHARSET())));
        }

        @Override
        @NotNull
        protected Map<String, String> getExtraHeaders() {
            return this.extraHeaders;
        }

        @Override
        @NotNull
        protected String getUserAgent() {
            return this.userAgent;
        }

        @Override
        @NotNull
        protected Map<String, String> getPostHeaders() {
            return this.postHeaders;
        }

        @Override
        protected void setPostHeaders(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.postHeaders = map;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected String getXStripeUserAgent() {
            void $this$mapTo$iv$iv;
            Map<String, String> paramMap;
            Map<String, String> $this$map$iv = paramMap = this.defaultXStripeUserAgentMap();
            boolean $i$f$map = false;
            Map<String, String> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                collection.add("\"" + key + "\":\"" + value + "\"");
            }
            return "{" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "}";
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/core/networking/RequestHeadersFactory$FraudDetection$Companion;", "", "<init>", "()V", "HEADER_COOKIE", "", "stripe-core_release"})
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

