/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.strings;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0013\u0010\u0004\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c2\u0003J\u0016\u0010\u000e\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u00070\u0005H\u00c2\u0003J*\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0015\b\u0002\u0010\u0004\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u00070\u0005H\u00c6\u0001J\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0004\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/core/strings/StaticResolvableString;", "Lcom/stripe/android/core/strings/ResolvableString;", "value", "", "args", "", "", "Lkotlinx/parcelize/RawValue;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "resolve", "context", "Landroid/content/Context;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "stripe-core_release"})
@Parcelize
public final class StaticResolvableString
implements ResolvableString {
    @NotNull
    private final String value;
    @NotNull
    private final List<Object> args;
    @NotNull
    public static final Parcelable.Creator<StaticResolvableString> CREATOR;

    public StaticResolvableString(@NotNull String value, @NotNull List<? extends Object> args) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.value = value;
        this.args = args;
    }

    @Override
    @NotNull
    public String resolve(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = this.value;
        Object[] objectArray = ResolvableStringUtilsKt.resolveArgs(context, this.args);
        objectArray = Arrays.copyOf(objectArray, objectArray.length);
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public final void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeString(this.value);
        List<Object> list = this.args;
        dest.writeInt(list.size());
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            dest.writeValue(iterator.next());
        }
    }

    public final int describeContents() {
        return 0;
    }

    private final String component1() {
        return this.value;
    }

    private final List<Object> component2() {
        return this.args;
    }

    @NotNull
    public final StaticResolvableString copy(@NotNull String value, @NotNull List<? extends Object> args) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return new StaticResolvableString(value, args);
    }

    public static /* synthetic */ StaticResolvableString copy$default(StaticResolvableString staticResolvableString, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = staticResolvableString.value;
        }
        if ((n & 2) != 0) {
            list = staticResolvableString.args;
        }
        return staticResolvableString.copy(string, list);
    }

    @NotNull
    public String toString() {
        return "StaticResolvableString(value=" + this.value + ", args=" + this.args + ")";
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = result * 31 + ((Object)this.args).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StaticResolvableString)) {
            return false;
        }
        StaticResolvableString staticResolvableString = (StaticResolvableString)other;
        if (!Intrinsics.areEqual((Object)this.value, (Object)staticResolvableString.value)) {
            return false;
        }
        return Intrinsics.areEqual(this.args, staticResolvableString.args);
    }

    static {
        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<StaticResolvableString> {
            public final StaticResolvableString[] newArray(int size) {
                return new StaticResolvableString[size];
            }

            public final StaticResolvableString createFromParcel(Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n = parcel.readInt();
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                String string = parcel.readString();
                for (int i = 0; i != n; ++i) {
                    arrayList.add(parcel.readValue(StaticResolvableString.class.getClassLoader()));
                }
                List list = arrayList;
                String string2 = string;
                return new StaticResolvableString(string2, list);
            }
        }
        CREATOR = new Creator();
    }
}

