/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.core.utils;

import android.content.Context;
import androidx.annotation.RestrictTo;
import com.stripe.android.core.Logger;
import com.stripe.android.core.utils.UserFacingLogger;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/core/utils/RealUserFacingLogger;", "Lcom/stripe/android/core/utils/UserFacingLogger;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "isDebuggable", "", "isDebugBuild", "logger", "Lcom/stripe/android/core/Logger;", "logWarningWithoutPii", "", "message", "", "stripe-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class RealUserFacingLogger
implements UserFacingLogger {
    private final boolean isDebuggable;
    private final boolean isDebugBuild;
    @NotNull
    private final Logger logger;

    @Inject
    public RealUserFacingLogger(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.isDebuggable = (context.getApplicationInfo().flags & 2) != 0;
        this.logger = Logger.Companion.getInstance(this.isDebuggable || this.isDebugBuild);
    }

    @Override
    public void logWarningWithoutPii(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.warning(message);
    }
}

