/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeObject;
import com.stripe.util.Base64;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class APIResource
extends StripeObject {
    private static final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    private static String className(Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase().replace("$", "");
    }

    protected static String classURL(Class<?> clazz) {
        return String.format("%s/%ss", "https://api.stripe.com/v1", APIResource.className(clazz));
    }

    protected static String instanceURL(Class<?> clazz, String id) {
        return String.format("%s/%s", APIResource.classURL(clazz), id);
    }

    private static String base64(String in) {
        return new String(Base64.encodeToString(in.getBytes(), false));
    }

    private static String urlEncodePair(String k, String v) throws UnsupportedEncodingException {
        return String.format("%s=%s", URLEncoder.encode(k, "UTF-8"), URLEncoder.encode(v, "UTF-8"));
    }

    private static HttpUriRequest createGetRequest(String url, Map<String, String> flatParams) throws UnsupportedEncodingException {
        StringBuffer queryStringBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            queryStringBuffer.append("&");
            queryStringBuffer.append(APIResource.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        if (queryStringBuffer.length() > 0) {
            queryStringBuffer.deleteCharAt(0);
        }
        return new HttpGet(String.format("%s?%s", url, queryStringBuffer.toString()));
    }

    private static HttpUriRequest createPostRequest(String url, Map<String, String> flatParams) throws UnsupportedEncodingException {
        HttpPost request = new HttpPost(url);
        ArrayList<BasicNameValuePair> postParamList = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            postParamList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(postParamList, "UTF-8"));
        return request;
    }

    private static HttpUriRequest createDeleteRequest(String url) {
        return new HttpDelete(url);
    }

    private static Map<String, String> flattenParams(Map<String, Object> params) {
        if (params == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> flatParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                Map nestedMap = (Map)value;
                for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                    flatNestedMap.put(String.format("%s[%s]", key, nestedEntry.getKey()), nestedEntry.getValue());
                }
                flatParams.putAll(APIResource.flattenParams(flatNestedMap));
                continue;
            }
            if (value == null) continue;
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }

    private static DefaultHttpClient getHttpClient() throws AuthenticationException {
        if (Stripe.apiKey == null || Stripe.apiKey.isEmpty()) {
            throw new AuthenticationException("No API key provided. (HINT: set your API key using 'Stripe.apiKey = <API-KEY>'. You can generate API keys from the Stripe web interface. See https://stripe.com/api for details or email support@stripe.com if you have questions.");
        }
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            propertyMap.put(propertyName, System.getProperty(propertyName));
        }
        propertyMap.put("bindings.version", "1.0.0");
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "Stripe");
        Header[] requestHeaders = new Header[]{new BasicHeader("X-Stripe-Client-User-Agent", gson.toJson(propertyMap)), new BasicHeader("User-Agent", String.format("Stripe/v1 JavaBindings/%s", "1.0.0")), new BasicHeader("Authorization", String.format("Basic %s:", APIResource.base64(Stripe.apiKey)))};
        HttpParams httpParams = new SyncBasicHttpParams().setParameter("http.default-headers", Arrays.asList(requestHeaders)).setParameter("http.protocol.content-charset", (Object)"UTF-8").setParameter("http.connection.timeout", (Object)30000).setParameter("http.socket.timeout", (Object)80000);
        return new DefaultHttpClient(httpParams);
    }

    protected static <T> T request(Method method, String url, Map<String, Object> params, Class<T> clazz) throws StripeException {
        DefaultHttpClient client = APIResource.getHttpClient();
        Map<String, String> flatParams = APIResource.flattenParams(params);
        try {
            HttpUriRequest request = null;
            switch (method) {
                case GET: {
                    request = APIResource.createGetRequest(url, flatParams);
                    break;
                }
                case POST: {
                    request = APIResource.createPostRequest(url, flatParams);
                    break;
                }
                case DELETE: {
                    request = APIResource.createDeleteRequest(url);
                    break;
                }
                default: {
                    throw new APIConnectionException(String.format("Unrecognized HTTP method %s. This may indicate a bug in the Stripe bindings. Please contact support@stripe.com for assistance.", new Object[]{method}));
                }
            }
            HttpResponse response = client.execute(request);
            HttpEntity entity = response.getEntity();
            String rBody = EntityUtils.toString((HttpEntity)entity);
            EntityUtils.consume((HttpEntity)entity);
            int rCode = response.getStatusLine().getStatusCode();
            if (rCode < 200 || rCode >= 300) {
                APIResource.handleAPIError(rBody, rCode);
            }
            Object object = gson.fromJson(rBody, clazz);
            return (T)object;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("Could not connect to Stripe (%s). Please check your internet connection and try again. If this problem persists,you should check Stripe's service status at https://twitter.com/stripestatus, or let us know at support@stripe.com.", "https://api.stripe.com/v1"), e);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static void handleAPIError(String rBody, int rCode) throws StripeException {
        Error error = ((ErrorContainer)gson.fromJson(rBody, ErrorContainer.class)).error;
        switch (rCode) {
            case 400: {
                throw new InvalidRequestException(error.message, error.param, null);
            }
            case 404: {
                throw new InvalidRequestException(error.message, error.param, null);
            }
            case 401: {
                throw new AuthenticationException(error.message);
            }
            case 402: {
                throw new CardException(error.message, error.code, error.param, null);
            }
        }
        throw new APIException(error.message, null);
    }

    private static class Error {
        String type;
        String message;
        String code;
        String param;

        private Error() {
        }
    }

    private static class ErrorContainer {
        private Error error;

        private ErrorContainer() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Method {
        GET,
        POST,
        DELETE;

    }
}

