/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.stripe.model.Charge;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.EventData;
import com.stripe.model.Invoice;
import com.stripe.model.InvoiceItem;
import com.stripe.model.Plan;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.model.Token;
import com.stripe.net.APIResource;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDataDeserializer
implements JsonDeserializer<EventData> {
    static Map<String, Class> objectMap = new HashMap<String, Class>();

    public EventData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        EventData eventData = new EventData();
        JsonObject jsonObject = json.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if ("previous_attributes".equals(key)) {
                Type typeOfPrevAttrs = new TypeToken<Map<String, Object>>(){}.getType();
                eventData.setPreviousAttributes((Map)APIResource.gson.fromJson(element, typeOfPrevAttrs));
                continue;
            }
            if (!"object".equals(key)) continue;
            String type = element.getAsJsonObject().get("object").getAsString();
            Class cl = objectMap.get(type);
            StripeObject object = (StripeObject)APIResource.gson.fromJson((JsonElement)entry.getValue(), cl);
            eventData.setObject(object);
        }
        return eventData;
    }

    static {
        objectMap.put("charge", Charge.class);
        objectMap.put("discount", Discount.class);
        objectMap.put("customer", Customer.class);
        objectMap.put("invoice", Invoice.class);
        objectMap.put("invoiceitem", InvoiceItem.class);
        objectMap.put("plan", Plan.class);
        objectMap.put("subscription", Subscription.class);
        objectMap.put("token", Token.class);
    }
}

