/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.Card;
import com.stripe.model.CustomerCollection;
import com.stripe.model.DeletedCustomer;
import com.stripe.model.Discount;
import com.stripe.model.NextRecurringCharge;
import com.stripe.model.Subscription;
import com.stripe.net.APIResource;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Customer
extends APIResource {
    Long created;
    String id;
    Boolean livemode;
    Boolean deleted;
    String description;
    Card activeCard;
    String email;
    String plan;
    Long trialEnd;
    Discount discount;
    NextRecurringCharge nextRecurringCharge;
    Subscription subscription;
    Boolean delinquent;
    Integer accountBalance;

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Card getActiveCard() {
        return this.activeCard;
    }

    public void setActiveCard(Card activeCard) {
        this.activeCard = activeCard;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPlan() {
        return this.plan;
    }

    public void setPlan(String plan) {
        this.plan = plan;
    }

    public Long getTrialEnd() {
        return this.trialEnd;
    }

    public void setTrialEnd(Long trialEnd) {
        this.trialEnd = trialEnd;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    public NextRecurringCharge getNextRecurringCharge() {
        return this.nextRecurringCharge;
    }

    public void setNextRecurringCharge(NextRecurringCharge nextRecurringCharge) {
        this.nextRecurringCharge = nextRecurringCharge;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public Boolean getDelinquent() {
        return this.delinquent;
    }

    public void setDelinquent(Boolean delinquent) {
        this.delinquent = delinquent;
    }

    public Integer getAccountBalance() {
        return this.accountBalance;
    }

    public void setAccountBalance(Integer accountBalance) {
        this.accountBalance = accountBalance;
    }

    public static Customer create(Map<String, Object> params) throws StripeException {
        return Customer.request(APIResource.RequestMethod.POST, Customer.classURL(Customer.class), params, Customer.class);
    }

    public static Customer retrieve(String id) throws StripeException {
        return Customer.request(APIResource.RequestMethod.GET, Customer.instanceURL(Customer.class, id), null, Customer.class);
    }

    public static CustomerCollection all(Map<String, Object> params) throws StripeException {
        return Customer.request(APIResource.RequestMethod.GET, Customer.classURL(Customer.class), params, CustomerCollection.class);
    }

    public Customer update(Map<String, Object> params) throws StripeException {
        return Customer.request(APIResource.RequestMethod.POST, Customer.instanceURL(Customer.class, this.id), params, Customer.class);
    }

    public DeletedCustomer delete() throws StripeException {
        return Customer.request(APIResource.RequestMethod.DELETE, Customer.instanceURL(Customer.class, this.id), null, DeletedCustomer.class);
    }

    public Subscription updateSubscription(Map<String, Object> params) throws StripeException {
        return Customer.request(APIResource.RequestMethod.POST, String.format("%s/subscription", Customer.instanceURL(Customer.class, this.id)), params, Subscription.class);
    }

    public Subscription cancelSubscription() throws StripeException {
        return this.cancelSubscription(null);
    }

    public Subscription cancelSubscription(Map<String, Object> params) throws StripeException {
        return Customer.request(APIResource.RequestMethod.DELETE, String.format("%s/subscription", Customer.instanceURL(Customer.class, this.id)), params, Subscription.class);
    }
}

