/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeObject;
import com.stripe.net.StripeResponse;
import com.stripe.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class APIResource
extends StripeObject {
    public static final String CHARSET = "UTF-8";
    private static final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    private static String className(Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase().replace("$", "");
    }

    protected static String classURL(Class<?> clazz) {
        return String.format("%s/%ss", "https://api.stripe.com/v1", APIResource.className(clazz));
    }

    protected static String instanceURL(Class<?> clazz, String id) {
        return String.format("%s/%s", APIResource.classURL(clazz), id);
    }

    private static String base64(String in) {
        return new String(Base64.encodeToString(in.getBytes(), false));
    }

    private static String urlEncodePair(String k, String v) throws UnsupportedEncodingException {
        return String.format("%s=%s", URLEncoder.encode(k, CHARSET), URLEncoder.encode(v, CHARSET));
    }

    static Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", CHARSET);
        headers.put("User-Agent", String.format("Stripe/v1 JavaBindings/%s", "1.0.5"));
        headers.put("Authorization", String.format("Basic %s:", APIResource.base64(Stripe.apiKey)));
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            propertyMap.put(propertyName, System.getProperty(propertyName));
        }
        propertyMap.put("bindings.version", "1.0.5");
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "Stripe");
        headers.put("X-Stripe-Client-User-Agent", gson.toJson(propertyMap));
        return headers;
    }

    private static HttpsURLConnection createStripeConnection(String url) throws IOException {
        URL stripeURL = new URL(url);
        HttpsURLConnection conn = (HttpsURLConnection)stripeURL.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(80000);
        conn.setUseCaches(false);
        for (Map.Entry<String, String> header : APIResource.getHeaders().entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    private static HttpsURLConnection createGetConnection(String url, String query) throws IOException {
        String getURL = String.format("%s?%s", url, query);
        HttpsURLConnection conn = APIResource.createStripeConnection(getURL);
        conn.setRequestMethod("GET");
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpsURLConnection createPostConnection(String url, String query) throws IOException {
        HttpsURLConnection conn = APIResource.createStripeConnection(url);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", String.format("application/x-www-form-urlencoded;charset=%s", CHARSET));
        OutputStream output = null;
        try {
            output = conn.getOutputStream();
            output.write(query.getBytes(CHARSET));
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        return conn;
    }

    private static HttpsURLConnection createDeleteConnection(String url) throws IOException {
        HttpsURLConnection conn = APIResource.createStripeConnection(url);
        conn.setRequestMethod("DELETE");
        return conn;
    }

    private static String createQuery(Map<String, Object> params) throws UnsupportedEncodingException {
        Map<String, String> flatParams = APIResource.flattenParams(params);
        StringBuffer queryStringBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            queryStringBuffer.append("&");
            queryStringBuffer.append(APIResource.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        if (queryStringBuffer.length() > 0) {
            queryStringBuffer.deleteCharAt(0);
        }
        return queryStringBuffer.toString();
    }

    private static Map<String, String> flattenParams(Map<String, Object> params) {
        if (params == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> flatParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                Map nestedMap = (Map)value;
                for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                    flatNestedMap.put(String.format("%s[%s]", key, nestedEntry.getKey()), nestedEntry.getValue());
                }
                flatParams.putAll(APIResource.flattenParams(flatNestedMap));
                continue;
            }
            if (value == null) continue;
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        String rBody = new Scanner(responseStream, CHARSET).useDelimiter("\\A").next();
        responseStream.close();
        return rBody;
    }

    private static StripeResponse makeURLConnectionRequest(RequestMethod method, String url, String query) throws APIConnectionException {
        HttpURLConnection conn = null;
        try {
            switch (method) {
                case GET: {
                    conn = APIResource.createGetConnection(url, query);
                    break;
                }
                case POST: {
                    conn = APIResource.createPostConnection(url, query);
                    break;
                }
                case DELETE: {
                    conn = APIResource.createDeleteConnection(url);
                    break;
                }
                default: {
                    throw new APIConnectionException(String.format("Unrecognized HTTP method %s. This indicates a bug in the Stripe bindings. Please contact support@stripe.com for assistance.", new Object[]{method}));
                }
            }
            int rCode = conn.getResponseCode();
            String rBody = null;
            rBody = rCode >= 200 && rCode < 300 ? APIResource.getResponseBody(conn.getInputStream()) : APIResource.getResponseBody(conn.getErrorStream());
            StripeResponse stripeResponse = new StripeResponse(rCode, rBody);
            return stripeResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("Could not connect to Stripe (%s). Please check your internet connection and try again. If this problem persists,you should check Stripe's service status at https://twitter.com/stripestatus, or let us know at support@stripe.com.", "https://api.stripe.com/v1"), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    protected static <T> T request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz) throws StripeException {
        StripeResponse response;
        String query;
        if (Stripe.apiKey == null || Stripe.apiKey.isEmpty()) {
            throw new AuthenticationException("No API key provided. (HINT: set your API key using 'Stripe.apiKey = <API-KEY>'. You can generate API keys from the Stripe web interface. See https://stripe.com/api for details or email support@stripe.com if you have questions.");
        }
        try {
            query = APIResource.createQuery(params);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@stripe.com for assistance.", null, e);
        }
        try {
            response = APIResource.makeURLConnectionRequest(method, url, query);
        }
        catch (ClassCastException ce) {
            String appEngineEnv = System.getProperty("com.google.appengine.runtime.environment", null);
            if (appEngineEnv != null) {
                response = APIResource.makeAppEngineRequest(method, url, query);
            }
            throw ce;
        }
        int rCode = response.responseCode;
        String rBody = response.responseBody;
        if (rCode < 200 || rCode >= 300) {
            APIResource.handleAPIError(rBody, rCode);
        }
        return (T)gson.fromJson(rBody, clazz);
    }

    private static void handleAPIError(String rBody, int rCode) throws StripeException {
        Error error = ((ErrorContainer)gson.fromJson(rBody, ErrorContainer.class)).error;
        switch (rCode) {
            case 400: {
                throw new InvalidRequestException(error.message, error.param, null);
            }
            case 404: {
                throw new InvalidRequestException(error.message, error.param, null);
            }
            case 401: {
                throw new AuthenticationException(error.message);
            }
            case 402: {
                throw new CardException(error.message, error.code, error.param, null);
            }
        }
        throw new APIException(error.message, null);
    }

    private static StripeResponse makeAppEngineRequest(RequestMethod method, String url, String query) throws StripeException {
        String unknownErrorMessage = "Sorry, an unknown error occurred while trying to use the Google App Engine runtime. Please contact support@stripe.com for assistance.";
        try {
            if (method == RequestMethod.GET) {
                url = String.format("%s?%s", url, query);
            }
            URL fetchURL = new URL(url);
            Class<?> requestMethodClass = Class.forName("com.google.appengine.api.urlfetch.HTTPMethod");
            Object httpMethod = requestMethodClass.getDeclaredField(method.name()).get(null);
            Class<?> fetchOptionsBuilderClass = Class.forName("com.google.appengine.api.urlfetch.FetchOptions$Builder");
            Object fetchOptions = fetchOptionsBuilderClass.getDeclaredMethod("validateCertificate", new Class[0]).invoke(null, new Object[0]);
            Class<?> fetchOptionsClass = Class.forName("com.google.appengine.api.urlfetch.FetchOptions");
            Class<?> requestClass = Class.forName("com.google.appengine.api.urlfetch.HTTPRequest");
            Object request = requestClass.getDeclaredConstructor(URL.class, requestMethodClass, fetchOptionsClass).newInstance(fetchURL, httpMethod, fetchOptions);
            if (method == RequestMethod.POST) {
                requestClass.getDeclaredMethod("setPayload", byte[].class).invoke(request, new Object[]{query.getBytes()});
            }
            for (Map.Entry<String, String> header : APIResource.getHeaders().entrySet()) {
                Class<?> httpHeaderClass = Class.forName("com.google.appengine.api.urlfetch.HTTPHeader");
                Object reqHeader = httpHeaderClass.getDeclaredConstructor(String.class, String.class).newInstance(header.getKey(), header.getValue());
                requestClass.getDeclaredMethod("setHeader", httpHeaderClass).invoke(request, reqHeader);
            }
            Class<?> urlFetchFactoryClass = Class.forName("com.google.appengine.api.urlfetch.URLFetchServiceFactory");
            Object urlFetchService = urlFetchFactoryClass.getDeclaredMethod("getURLFetchService", new Class[0]).invoke(null, new Object[0]);
            Method fetchMethod = urlFetchService.getClass().getDeclaredMethod("fetch", requestClass);
            fetchMethod.setAccessible(true);
            Object response = fetchMethod.invoke(urlFetchService, request);
            int responseCode = (Integer)response.getClass().getDeclaredMethod("getResponseCode", new Class[0]).invoke(response, new Object[0]);
            String body = new String((byte[])response.getClass().getDeclaredMethod("getContent", new Class[0]).invoke(response, new Object[0]), CHARSET);
            return new StripeResponse(responseCode, body);
        }
        catch (InvocationTargetException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (MalformedURLException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (NoSuchFieldException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (SecurityException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (NoSuchMethodException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (ClassNotFoundException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (IllegalArgumentException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (IllegalAccessException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (InstantiationException e) {
            throw new APIException(unknownErrorMessage, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new APIException(unknownErrorMessage, e);
        }
    }

    private static class Error {
        String type;
        String message;
        String code;
        String param;

        private Error() {
        }
    }

    private static class ErrorContainer {
        private Error error;

        private ErrorContainer() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum RequestMethod {
        GET,
        POST,
        DELETE;

    }
}

