/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.stripe.model.Charge;
import com.stripe.model.Coupon;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.Dispute;
import com.stripe.model.EventData;
import com.stripe.model.Invoice;
import com.stripe.model.InvoiceItem;
import com.stripe.model.Plan;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.model.Token;
import com.stripe.model.Transfer;
import com.stripe.net.APIResource;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDataDeserializer
implements JsonDeserializer<EventData> {
    static Map<String, Class> objectMap = new HashMap<String, Class>();

    private Object deserializeJsonPrimitive(JsonPrimitive element) {
        if (element.isBoolean()) {
            return element.getAsBoolean();
        }
        if (element.isNumber()) {
            return element.getAsNumber();
        }
        return element.getAsString();
    }

    private Object[] deserializeJsonArray(JsonArray arr) {
        Object[] elems = new Object[arr.size()];
        Iterator elemIter = arr.iterator();
        int i = 0;
        while (elemIter.hasNext()) {
            JsonElement elem = (JsonElement)elemIter.next();
            elems[++i] = this.deserializeJsonElement(elem);
        }
        return elems;
    }

    private Object deserializeJsonElement(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonObject()) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            this.populateMapFromJSONObject(valueMap, element.getAsJsonObject());
            return valueMap;
        }
        if (element.isJsonPrimitive()) {
            return this.deserializeJsonPrimitive(element.getAsJsonPrimitive());
        }
        if (element.isJsonArray()) {
            return this.deserializeJsonArray(element.getAsJsonArray());
        }
        System.err.println("Unknown JSON element type for element " + element + ". " + "If you're seeing this messaage, it's probably a bug in the Stripe Java " + "library. Please contact us by email at support@stripe.com.");
        return null;
    }

    private void populateMapFromJSONObject(Map<String, Object> objMap, JsonObject jsonObject) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            objMap.put(key, this.deserializeJsonElement(element));
        }
    }

    public EventData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        EventData eventData = new EventData();
        JsonObject jsonObject = json.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if ("previous_attributes".equals(key)) {
                HashMap<String, Object> previousAttributes = new HashMap<String, Object>();
                this.populateMapFromJSONObject(previousAttributes, element.getAsJsonObject());
                eventData.setPreviousAttributes(previousAttributes);
                continue;
            }
            if (!"object".equals(key)) continue;
            String type = element.getAsJsonObject().get("object").getAsString();
            Class cl = objectMap.get(type);
            StripeObject object = (StripeObject)APIResource.gson.fromJson((JsonElement)entry.getValue(), cl);
            eventData.setObject(object);
        }
        return eventData;
    }

    static {
        objectMap.put("charge", Charge.class);
        objectMap.put("discount", Discount.class);
        objectMap.put("customer", Customer.class);
        objectMap.put("invoice", Invoice.class);
        objectMap.put("invoiceitem", InvoiceItem.class);
        objectMap.put("plan", Plan.class);
        objectMap.put("subscription", Subscription.class);
        objectMap.put("token", Token.class);
        objectMap.put("coupon", Coupon.class);
        objectMap.put("transfer", Transfer.class);
        objectMap.put("dispute", Dispute.class);
    }
}

