/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Card;
import com.stripe.net.APIResource;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomerCardCollection
extends APIResource {
    List<Card> data;
    Integer count;
    String url;

    public List<Card> getData() {
        return this.data;
    }

    public String getURL() {
        return this.url;
    }

    public Integer getCount() {
        return this.count;
    }

    public CustomerCardCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.all(params, null);
    }

    public CustomerCardCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s%s", "https://api.stripe.com", this.getURL());
        return CustomerCardCollection.request(APIResource.RequestMethod.GET, url, params, CustomerCardCollection.class, apiKey);
    }

    public CustomerCardCollection retrieve(String id, Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.retrieve(id, params, null);
    }

    public CustomerCardCollection retrieve(String id, Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s%s/%s", "https://api.stripe.com", this.getURL(), id);
        return CustomerCardCollection.request(APIResource.RequestMethod.GET, url, params, CustomerCardCollection.class, apiKey);
    }

    public CustomerCardCollection create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.create(params, null);
    }

    public CustomerCardCollection create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s%s", "https://api.stripe.com", this.getURL());
        return CustomerCardCollection.request(APIResource.RequestMethod.POST, url, params, CustomerCardCollection.class, apiKey);
    }
}

