/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Card;
import com.stripe.model.ChargeCollection;
import com.stripe.model.ChargeRefundCollection;
import com.stripe.model.Dispute;
import com.stripe.model.MetadataStore;
import com.stripe.net.APIResource;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Charge
extends APIResource
implements MetadataStore<Charge> {
    Integer amount;
    Long created;
    String currency;
    String id;
    Boolean livemode;
    Boolean paid;
    Boolean refunded;
    Boolean disputed;
    Boolean captured;
    String description;
    String failureMessage;
    String failureCode;
    Integer amountRefunded;
    String customer;
    String invoice;
    ChargeRefundCollection refunds;
    Card card;
    Dispute dispute;
    String balanceTransaction;
    Map<String, String> metadata;
    String receiptEmail;
    String receiptNumber;
    String statementDescription;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public Boolean getPaid() {
        return this.paid;
    }

    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    public Boolean getRefunded() {
        return this.refunded;
    }

    public void setRefunded(Boolean refunded) {
        this.refunded = refunded;
    }

    public Boolean getCaptured() {
        return this.captured;
    }

    public void setCaptured(Boolean captured) {
        this.captured = captured;
    }

    @Deprecated
    public Boolean getDisputed() {
        return this.disputed;
    }

    @Deprecated
    public void setDisputed(Boolean disputed) {
        this.disputed = disputed;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStatementDescription() {
        return this.statementDescription;
    }

    public void setStatementDescription(String statementDescription) {
        this.statementDescription = statementDescription;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public String getFailureCode() {
        return this.failureCode;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public Integer getAmountRefunded() {
        return this.amountRefunded;
    }

    public void setAmountRefunded(Integer amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public String getInvoice() {
        return this.invoice;
    }

    public void setInvoice(String invoice) {
        this.invoice = invoice;
    }

    public ChargeRefundCollection getRefunds() {
        if (this.refunds.getURL() == null) {
            this.refunds.setURL(String.format("/v1/charges/%s/refunds", this.getId()));
        }
        return this.refunds;
    }

    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public Dispute getDispute() {
        return this.dispute;
    }

    public void setDispute(Dispute dispute) {
        this.dispute = dispute;
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction;
    }

    public void setBalanceTransaction(String balanceTransaction) {
        this.balanceTransaction = balanceTransaction;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public String getReceiptEmail() {
        return this.receiptEmail;
    }

    public void setReceiptEmail(String receiptEmail) {
        this.receiptEmail = receiptEmail;
    }

    public static Charge create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.create(params, null);
    }

    public static Charge retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.retrieve(id, null);
    }

    public Charge update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (String)null);
    }

    public static ChargeCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.all(params, null);
    }

    public Charge refund() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(null, null);
    }

    public Charge capture() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.capture(null, null);
    }

    public Dispute updateDispute(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.updateDispute(params, null);
    }

    public Dispute closeDispute() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.closeDispute(null);
    }

    public Charge refund(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(params, null);
    }

    public Charge capture(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.capture(params, null);
    }

    public static Charge create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, Charge.classURL(Charge.class), params, Charge.class, apiKey);
    }

    public static Charge retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.GET, Charge.instanceURL(Charge.class, id), null, Charge.class, apiKey);
    }

    public Charge update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, Charge.instanceURL(Charge.class, this.id), params, Charge.class, apiKey);
    }

    public static ChargeCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.GET, Charge.classURL(Charge.class), params, ChargeCollection.class, apiKey);
    }

    public Charge refund(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(null, apiKey);
    }

    public Charge capture(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.capture(null, apiKey);
    }

    public Charge refund(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, String.format("%s/refund", Charge.instanceURL(Charge.class, this.getId())), params, Charge.class, apiKey);
    }

    public Charge capture(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, String.format("%s/capture", Charge.instanceURL(Charge.class, this.getId())), params, Charge.class, apiKey);
    }

    public Dispute updateDispute(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, String.format("%s/dispute", Charge.instanceURL(Charge.class, this.id)), params, Dispute.class, apiKey);
    }

    public Dispute closeDispute(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, String.format("%s/dispute/close", Charge.instanceURL(Charge.class, this.getId())), null, Dispute.class, apiKey);
    }
}

