/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.Stripe;

public class RequestOptions {
    private final String apiKey;
    private final String stripeVersion;

    public static RequestOptions getDefault() {
        return new RequestOptions(Stripe.apiKey, Stripe.apiVersion);
    }

    private RequestOptions(String apiKey, String stripeVersion) {
        this.apiKey = apiKey;
        this.stripeVersion = stripeVersion;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getStripeVersion() {
        return this.stripeVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestOptions that = (RequestOptions)o;
        return this.apiKey.equals(that.apiKey) && this.stripeVersion.equals(that.stripeVersion);
    }

    public int hashCode() {
        int result = this.apiKey.hashCode();
        result = 31 * result + this.stripeVersion.hashCode();
        return result;
    }

    public static RequestOptionsBuilder builder() {
        return new RequestOptionsBuilder();
    }

    public RequestOptionsBuilder toBuilder() {
        return new RequestOptionsBuilder().setApiKey(this.apiKey).setStripeVersion(this.stripeVersion);
    }

    private static String normalizeApiKey(String apiKey) {
        if (apiKey == null) {
            return null;
        }
        String normalized = apiKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty API key specified!");
        }
        return normalized;
    }

    private static String normalizeStripeVersion(String stripeVersion) {
        if (stripeVersion == null) {
            return null;
        }
        String normalized = stripeVersion.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty Stripe version specified!");
        }
        return normalized;
    }

    public static class InvalidRequestOptionsException
    extends RuntimeException {
        public InvalidRequestOptionsException(String message) {
            super(message);
        }
    }

    public static final class RequestOptionsBuilder {
        private String apiKey = Stripe.apiKey;
        private String stripeVersion = Stripe.apiVersion;

        public String getApiKey() {
            return this.apiKey;
        }

        public RequestOptionsBuilder setApiKey(String apiKey) {
            this.apiKey = RequestOptions.normalizeApiKey(apiKey);
            return this;
        }

        public RequestOptionsBuilder clearApiKey() {
            this.apiKey = null;
            return this;
        }

        public RequestOptionsBuilder setStripeVersion(String stripeVersion) {
            this.stripeVersion = RequestOptions.normalizeStripeVersion(stripeVersion);
            return this;
        }

        public RequestOptionsBuilder clearStripeVersion() {
            this.stripeVersion = null;
            return this;
        }

        public RequestOptions build() {
            return new RequestOptions(RequestOptions.normalizeApiKey(this.apiKey), RequestOptions.normalizeStripeVersion(this.stripeVersion));
        }
    }
}

