/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.Stripe;

public class RequestOptions {
    private final String apiKey;
    private final String stripeVersion;
    private final String idempotentRequest;

    public static RequestOptions getDefault() {
        return new RequestOptions(Stripe.apiKey, Stripe.apiVersion, null);
    }

    private RequestOptions(String apiKey, String stripeVersion, String idempotentRequest) {
        this.apiKey = apiKey;
        this.stripeVersion = stripeVersion;
        this.idempotentRequest = idempotentRequest;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getStripeVersion() {
        return this.stripeVersion;
    }

    public String getIdempotentRequest() {
        return this.idempotentRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestOptions that = (RequestOptions)o;
        if (this.apiKey != null ? !this.apiKey.equals(that.apiKey) : that.apiKey != null) {
            return false;
        }
        if (this.idempotentRequest != null ? !this.idempotentRequest.equals(that.idempotentRequest) : that.idempotentRequest != null) {
            return false;
        }
        return !(this.stripeVersion != null ? !this.stripeVersion.equals(that.stripeVersion) : that.stripeVersion != null);
    }

    public int hashCode() {
        int result = this.apiKey != null ? this.apiKey.hashCode() : 0;
        result = 31 * result + (this.stripeVersion != null ? this.stripeVersion.hashCode() : 0);
        result = 31 * result + (this.idempotentRequest != null ? this.idempotentRequest.hashCode() : 0);
        return result;
    }

    public static RequestOptionsBuilder builder() {
        return new RequestOptionsBuilder();
    }

    public RequestOptionsBuilder toBuilder() {
        return new RequestOptionsBuilder().setApiKey(this.apiKey).setStripeVersion(this.stripeVersion);
    }

    private static String normalizeApiKey(String apiKey) {
        if (apiKey == null) {
            return null;
        }
        String normalized = apiKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty API key specified!");
        }
        return normalized;
    }

    private static String normalizeStripeVersion(String stripeVersion) {
        if (stripeVersion == null) {
            return null;
        }
        String normalized = stripeVersion.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty Stripe version specified!");
        }
        return normalized;
    }

    private static String normalizeIdempotentRequest(String idempotentRequest) {
        if (idempotentRequest == null) {
            return null;
        }
        String normalized = idempotentRequest.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty Idempotent Request String Specified!");
        }
        if (normalized.length() > 255) {
            throw new InvalidRequestOptionsException(String.format("Idempotent Request length was %d, which is larger than the 255 character maximum!", normalized.length()));
        }
        return normalized;
    }

    public static class InvalidRequestOptionsException
    extends RuntimeException {
        public InvalidRequestOptionsException(String message) {
            super(message);
        }
    }

    public static final class RequestOptionsBuilder {
        private String apiKey = Stripe.apiKey;
        private String stripeVersion = Stripe.apiVersion;
        private String idempotentRequest;

        public String getApiKey() {
            return this.apiKey;
        }

        public RequestOptionsBuilder setApiKey(String apiKey) {
            this.apiKey = RequestOptions.normalizeApiKey(apiKey);
            return this;
        }

        public RequestOptionsBuilder clearApiKey() {
            this.apiKey = null;
            return this;
        }

        public RequestOptionsBuilder setStripeVersion(String stripeVersion) {
            this.stripeVersion = RequestOptions.normalizeStripeVersion(stripeVersion);
            return this;
        }

        public RequestOptionsBuilder clearStripeVersion() {
            this.stripeVersion = null;
            return this;
        }

        public RequestOptionsBuilder setIdempotentRequest(String idempotentRequest) {
            this.idempotentRequest = idempotentRequest;
            return this;
        }

        public RequestOptionsBuilder clearIdempotentRequest() {
            this.idempotentRequest = null;
            return this;
        }

        public String getIdempotentRequest() {
            return this.idempotentRequest;
        }

        public RequestOptions build() {
            return new RequestOptions(RequestOptions.normalizeApiKey(this.apiKey), RequestOptions.normalizeStripeVersion(this.stripeVersion), RequestOptions.normalizeIdempotentRequest(this.idempotentRequest));
        }
    }
}

